/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.project.service.impl;

import com.github.pagehelper.PageInfo;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.project.dao.PtElevatorMapper;
import com.yqbsoft.laser.service.project.domain.PtElevatorDomain;
import com.yqbsoft.laser.service.project.model.PtElevator;
import com.yqbsoft.laser.service.project.service.PtElevatorService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class PtElevatorServiceImpl
extends BaseServiceImpl
implements PtElevatorService {
    public static final String SYS_CODE = "pt.PROJECT.PtElevatorServiceImpl";
    private PtElevatorMapper ptElevatorMapper;

    public void setPtElevatorMapper(PtElevatorMapper ptElevatorMapper) {
        this.ptElevatorMapper = ptElevatorMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptElevatorMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtElevatorServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkElevator(PtElevatorDomain ptElevatorDomain) {
        if (ptElevatorDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setElevatorDefault(PtElevator ptElevator) {
        if (ptElevator == null) {
            return;
        }
        if (ptElevator.getDataState() == null) {
            ptElevator.setDataState(0);
        }
        if (ptElevator.getGmtCreate() == null) {
            ptElevator.setGmtCreate(this.getSysDate());
        }
        ptElevator.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ptElevator.getElevatorCode())) {
            int code = this.getElevatorMaxCode();
            ptElevator.setElevatorCode(this.makeMaxCode8(++code));
        }
    }

    private int getElevatorMaxCode() {
        int code = 0;
        try {
            return this.ptElevatorMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtElevatorServiceImpl.getElevatorMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setElevatorUpdataDefault(PtElevator ptElevator) {
        if (ptElevator == null) {
            return;
        }
        ptElevator.setGmtModified(this.getSysDate());
    }

    private void saveElevatorModel(PtElevator ptElevator) throws ApiException {
        if (ptElevator == null) {
            return;
        }
        try {
            this.ptElevatorMapper.insert(ptElevator);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtElevatorServiceImpl.saveElevatorModel.ex", (Throwable)e);
        }
    }

    private PtElevator getElevatorModelById(Integer elevatorId) {
        if (elevatorId == null) {
            return null;
        }
        try {
            return this.ptElevatorMapper.selectByPrimaryKey(elevatorId);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtElevatorServiceImpl.getElevatorModelById", (Throwable)e);
            return null;
        }
    }

    public PtElevator getElevatorModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptElevatorMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtElevatorServiceImpl.getElevatorModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delElevatorModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptElevatorMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtElevatorServiceImpl.delElevatorModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtElevatorServiceImpl.delElevatorModelByCode.num");
        }
    }

    private void deleteElevatorModel(Integer elevatorId) throws ApiException {
        if (elevatorId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.ptElevatorMapper.deleteByPrimaryKey(elevatorId);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtElevatorServiceImpl.deleteElevatorModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtElevatorServiceImpl.deleteElevatorModel.num");
        }
    }

    private int updateElevatorModel(PtElevator ptElevator) throws ApiException {
        if (ptElevator == null) {
            return 0;
        }
        try {
            return this.ptElevatorMapper.updateByPrimaryKeySelective(ptElevator);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtElevatorServiceImpl.updateElevatorModel.ex", (Throwable)e);
        }
    }

    private void updateStateElevatorModel(Integer elevatorId, Integer dataState, Integer oldDataState) throws ApiException {
        if (elevatorId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("elevatorId", elevatorId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ptElevatorMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtElevatorServiceImpl.updateStateElevatorModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.PROJECT.PtElevatorServiceImpl.updateStateElevatorModel.null");
        }
    }

    private PtElevator makeElevator(PtElevatorDomain ptElevatorDomain, PtElevator ptElevator) {
        if (ptElevatorDomain == null) {
            return null;
        }
        if (ptElevator == null) {
            ptElevator = new PtElevator();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptElevator, (Object)ptElevatorDomain);
            return ptElevator;
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtElevatorServiceImpl.makeElevator", (Throwable)e);
            return null;
        }
    }

    private List<PtElevator> queryElevatorModelPage(Map<String, Object> parammap) {
        try {
            return this.ptElevatorMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtElevatorServiceImpl.queryElevatorModel", (Throwable)e);
            return null;
        }
    }

    private int countElevator(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptElevatorMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtElevatorServiceImpl.countElevator", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveElevator(PtElevatorDomain ptElevatorDomain) throws ApiException {
        String msg = this.checkElevator(ptElevatorDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtElevatorServiceImpl.saveElevator.checkElevator", msg);
        }
        PtElevator ptElevator = this.makeElevator(ptElevatorDomain, null);
        this.setElevatorDefault(ptElevator);
        this.saveElevatorModel(ptElevator);
        return ptElevator.getElevatorCode();
    }

    @Override
    public void updateElevatorState(Integer elevatorId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateElevatorModel(elevatorId, dataState, oldDataState);
    }

    @Override
    public Boolean updateElevator(PtElevatorDomain ptElevatorDomain) throws ApiException {
        String msg = this.checkElevator(ptElevatorDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtElevatorServiceImpl.updateElevator.checkElevator", msg);
        }
        PtElevator oldPtElevator = this.getElevatorModelById(ptElevatorDomain.getElevatorId());
        if (oldPtElevator == null) {
            throw new ApiException("pt.PROJECT.PtElevatorServiceImpl.updateElevator.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtElevator ptElevator = this.makeElevator(ptElevatorDomain, oldPtElevator);
        this.setElevatorUpdataDefault(ptElevator);
        int i = this.updateElevatorModel(ptElevator);
        if (i > 0) {
            return true;
        }
        return false;
    }

    @Override
    public PtElevator getElevator(Integer elevatorId) {
        return this.getElevatorModelById(elevatorId);
    }

    @Override
    public void deleteElevator(Integer elevatorId) throws ApiException {
        this.deleteElevatorModel(elevatorId);
    }

    @Override
    public QueryResult<PtElevator> queryElevatorPage(Map<String, Object> map) {
        List<PtElevator> ptElevatorList = this.queryElevatorModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countElevator(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptElevatorList);
        return queryResult;
    }

    @Override
    public PtElevator getElevatorByCode(Map<String, Object> map) {
        return this.getElevatorModelByCode(map);
    }

    @Override
    public void delElevatorByCode(Map<String, Object> map) throws ApiException {
        this.delElevatorModelByCode(map);
    }

    @Override
    public QueryResult<Map<String, Object>> queryProjectElevator(Map<String, Object> map) {
        PageInfo<Map<String, Object>> projectElevatorList = this.queryProjectElevatorModel(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        long total = 0L;
        List list = null;
        if (projectElevatorList != null) {
            total = projectElevatorList.getTotal();
            list = projectElevatorList.getList();
        }
        pageTools.setRecordCount(Integer.valueOf(String.valueOf(total)).intValue());
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(list);
        return queryResult;
    }

    private PageInfo<Map<String, Object>> queryProjectElevatorModel(Map<String, Object> map) {
        try {
            this.startPage(map);
            List<Map<String, Object>> list = this.ptElevatorMapper.queryProjectElevator(map);
            return this.getPageInfo(list);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtElevatorServiceImpl.queryUnitElevatorInfoModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> queryProjectElevatorList(Map<String, Object> map) {
        PageInfo<Map<String, Object>> projectResult = this.queryProjectElevatorModel(map);
        List projectElevators = projectResult.getList();
        return projectElevators;
    }

    @Override
    public void taskChangeAgoraAPPID() {
        List<Map<String, Object>> projectElevators = this.getProjectHasElevatorModel();
        String APPID = DisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-agora-appID");
        for (Map<String, Object> temp : projectElevators) {
            HashMap<String, Object> contentMap = new HashMap<String, Object>();
            contentMap.put("content", "\u5b9a\u65f6\u63a8\u9001\u58f0\u7f51APPID\uff0c\u4fdd\u8bc1\u5f53\u524d\u7ec8\u7aef\u5b9e\u65f6\u68c0\u67e5");
            contentMap.put("APPID", APPID);
            this.sendMnsAgora((String)temp.get("project_code"), "\u9879\u76ee", (String)temp.get("tenant_Code"), contentMap);
        }
    }

    private List<Map<String, Object>> getProjectHasElevatorModel() {
        List<Map<String, Object>> i = null;
        try {
            i = this.ptElevatorMapper.getProjectHasElevator();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtElevatorServiceImpl.getProjectHasElevatorModel", (Throwable)e);
        }
        return i;
    }

    private void sendMnsAgora(String acceptCode, String acceptName, String tenantCode, Map<String, Object> contentMap) {
        contentMap.put("datetime", DateUtil.getDateStr((String)"yyyy-MM-dd HH:mm:ss"));
        ConcurrentHashMap<String, String> mnsMap = new ConcurrentHashMap<String, String>();
        String mnsconfigBusType = "3";
        mnsMap.put("mnslistSubject", "\u58f0\u7f51APPID\u66f4\u6362\u63a8\u9001");
        mnsMap.put("mnslistSource", "0");
        mnsMap.put("mnslistBusType", mnsconfigBusType);
        mnsMap.put("mnslistBusName", "\u58f0\u7f51APPID\u66f4\u6362\u63a8\u9001");
        mnsMap.put("mnslistExp", this.getMnslistExp(contentMap, "sys", "sys", acceptCode, acceptName, "1", "1", DateUtil.getDateStr((String)"yyyy-MM-dd HH:mm:ss"), mnsconfigBusType));
        mnsMap.put("tenantCode", tenantCode);
        ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
        sendMap.put("mnsMnslistDomainBean", JsonUtil.buildNormalBinder().toJson(mnsMap));
        this.inAsyncInvoke("mns.mns.saveSendMnslist", sendMap);
    }

    private String getMnslistExp(Map<String, Object> contentMap, String imsgSuserCode, String imsgSuserName, String acceptCode, String acceptName, String pushObjType, String pushmsgJpushType, String pushSendDate, String businessObject) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.putAll(contentMap);
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> parm = new HashMap<String, String>();
        parm.put("code", acceptCode);
        parm.put("name", acceptName);
        receiverList.add(parm);
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("receiverList", JsonUtil.buildNormalBinder().toJson(receiverList));
        expMap.put("pushmsgType", pushObjType);
        expMap.put("pushmsgJpushType", pushmsgJpushType);
        expMap.put("pushmsgSenddate", pushSendDate);
        expMap.put("imsgSuserCode", imsgSuserCode);
        expMap.put("imsgSuserName", imsgSuserName);
        expMap.put("mnsconfigBusType", businessObject);
        expMap.put("paramMap", JsonUtil.buildNormalBinder().toJson(paramMap));
        return JsonUtil.buildNonDefaultBinder().toJson(expMap);
    }

    @Override
    public String getDeviceStatusInfo(Integer pageindex, Integer pagesize, String regcodes, String devicestatus) {
        TreeMap<String, Object> param = new TreeMap<String, Object>();
        param.put("pageindex", String.valueOf(pageindex));
        param.put("pagesize", String.valueOf(pagesize));
        param.put("regcodes", regcodes);
        param.put("devicestatus", devicestatus);
        this.getAppkeySecret(param, "GetDeviceStatusInfo");
        Object inInvoke = this.getInternalRouter().inInvoke("pt.elevator.dataserver.getDeviceStatusInfo", "1.0", "0", param);
        String json = String.valueOf(inInvoke);
        this.logger.info("\u83b7\u53d6\u91c7\u96c6\u8bbe\u5907\u5217\u8868\u56de\u8c03\u7684json\u4e32\uff1a" + json);
        return json;
    }

    @Override
    public String getMediaAudiodataSystem(String deviceSerial, String tdSerial, Integer type) {
        String apiCode = "pt.elevator.dataserver.";
        if ("1".equals(String.valueOf(type))) {
            apiCode = String.valueOf(apiCode) + "getMediaDataSystem";
        } else if ("2".equals(String.valueOf(type))) {
            apiCode = String.valueOf(apiCode) + "getAudioDataSystem";
        } else {
            this.logger.error("pt.PROJECT.PtElevatorServiceImpl.getMediaAudiodataSystem", (Object)"\u672a\u77e5\u7684\u76ee\u6807\u8bbe\u5907\u7c7b\u578b");
            throw new ApiException("pt.PROJECT.PtElevatorServiceImpl.getMediaAudiodataSystem.error", "\u672a\u77e5\u7684\u76ee\u6807\u8bbe\u5907\u7c7b\u578b");
        }
        TreeMap<String, Object> param = new TreeMap<String, Object>();
        param.put("deviceSerial", deviceSerial);
        param.put("tdSerial", tdSerial);
        this.getAppkeySecret(param, "GetMediadataSystem");
        Object inInvoke = this.getInternalRouter().inInvoke(apiCode, "1.0", "0", param);
        String json = String.valueOf(inInvoke);
        this.logger.info("\u83b7\u53d6\u76ee\u6807\u8bbe\u5907\u56de\u8c03\u7684json\u4e32\uff1a" + json);
        return json;
    }

    private void getAppkeySecret(TreeMap<String, Object> param, String method) {
        String appkey = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-dtdevice-appkey");
        String appsecret = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-dtdevice-appsecret");
        param.put("timestamp", DateUtil.getDateStr((String)"yyyy-MM-dd HH:mm:ss"));
        param.put("appkey", appkey);
        param.put("appsecret", appsecret);
        param.put("method2", method);
    }

    @Override
    public Map<String, String> getFaultCodeData(List<String> list) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        if (ListUtil.isNotEmpty(list)) {
            TreeMap<String, Object> param = new TreeMap<String, Object>();
            this.getAppkeySecret(param, "GetFaultCodeData");
            for (String ctrltypeid : list) {
                param.put("ctrltypeid", ctrltypeid);
                Object inInvoke = this.getInternalRouter().inInvoke("pt.elevator.dataserver.getFaultCodeData", "1.0", "0", param);
                String json = String.valueOf(inInvoke);
                retMap.put(ctrltypeid, json);
            }
        }
        return retMap;
    }

    @Override
    public String getCtrlTypeList(Integer pageindex, Integer pagesize) {
        TreeMap<String, Object> param = new TreeMap<String, Object>();
        this.getAppkeySecret(param, "GetCtrlTypeList");
        param.put("pageindex", String.valueOf(pageindex));
        param.put("pagesize", String.valueOf(pagesize));
        Object inInvoke = this.getInternalRouter().inInvoke("pt.elevator.dataserver.getCtrlTypeList", "1.0", "0", param);
        String json = String.valueOf(inInvoke);
        return json;
    }

    @Override
    public List<Map<String, Object>> getUnitElevatorCount(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        List<Map<String, Object>> unitElevatorCounts = this.getUnitElevatorCountModel(map);
        return unitElevatorCounts;
    }

    private List<Map<String, Object>> getUnitElevatorCountModel(Map<String, Object> map) {
        List<Map<String, Object>> unitElevatorCount = this.ptElevatorMapper.getUnitElevatorCount(map);
        return unitElevatorCount;
    }
}

