/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.project.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.project.dao.PtFloorMapper;
import com.yqbsoft.laser.service.project.domain.PtFloorDomain;
import com.yqbsoft.laser.service.project.model.PtFloor;
import com.yqbsoft.laser.service.project.service.PtFloorService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PtFloorServiceImpl
extends BaseServiceImpl
implements PtFloorService {
    public static final String SYS_CODE = "pt.PROJECT.PtFloorServiceImpl";
    private PtFloorMapper ptFloorMapper;

    public void setPtFloorMapper(PtFloorMapper ptFloorMapper) {
        this.ptFloorMapper = ptFloorMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptFloorMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtFloorServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFloor(PtFloorDomain ptFloorDomain) {
        if (ptFloorDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFloorDefault(PtFloor ptFloor) {
        if (ptFloor == null) {
            return;
        }
        if (ptFloor.getDataState() == null) {
            ptFloor.setDataState(0);
        }
        if (ptFloor.getGmtCreate() == null) {
            ptFloor.setGmtCreate(this.getSysDate());
        }
        ptFloor.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ptFloor.getFloorCode())) {
            ptFloor.setFloorCode(this.createUUIDString());
        }
    }

    private int getFloorMaxCode() {
        int code = 0;
        try {
            return this.ptFloorMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtFloorServiceImpl.getFloorMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFloorUpdataDefault(PtFloor ptFloor) {
        if (ptFloor == null) {
            return;
        }
        ptFloor.setGmtModified(this.getSysDate());
    }

    private void saveFloorModel(PtFloor ptFloor) throws ApiException {
        if (ptFloor == null) {
            return;
        }
        try {
            this.ptFloorMapper.insert(ptFloor);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtFloorServiceImpl.saveFloorModel.ex", (Throwable)e);
        }
    }

    private PtFloor getFloorModelById(Integer floorId) {
        if (floorId == null) {
            return null;
        }
        try {
            return this.ptFloorMapper.selectByPrimaryKey(floorId);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtFloorServiceImpl.getFloorModelById", (Throwable)e);
            return null;
        }
    }

    public PtFloor getFloorModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptFloorMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtFloorServiceImpl.getFloorModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFloorModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptFloorMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtFloorServiceImpl.delFloorModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtFloorServiceImpl.delFloorModelByCode.num");
        }
    }

    private void deleteFloorModel(Integer floorId) throws ApiException {
        if (floorId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.ptFloorMapper.deleteByPrimaryKey(floorId);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtFloorServiceImpl.deleteFloorModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtFloorServiceImpl.deleteFloorModel.num");
        }
    }

    private void updateFloorModel(PtFloor ptFloor) throws ApiException {
        if (ptFloor == null) {
            return;
        }
        try {
            this.ptFloorMapper.updateByPrimaryKeySelective(ptFloor);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtFloorServiceImpl.updateFloorModel.ex", (Throwable)e);
        }
    }

    private void updateStateFloorModel(Integer floorId, Integer dataState, Integer oldDataState) throws ApiException {
        if (floorId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("floorId", floorId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ptFloorMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtFloorServiceImpl.updateStateFloorModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.PROJECT.PtFloorServiceImpl.updateStateFloorModel.null");
        }
    }

    private PtFloor makeFloor(PtFloorDomain ptFloorDomain, PtFloor ptFloor) {
        if (ptFloorDomain == null) {
            return null;
        }
        if (ptFloor == null) {
            ptFloor = new PtFloor();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptFloor, (Object)ptFloorDomain);
            return ptFloor;
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtFloorServiceImpl.makeFloor", (Throwable)e);
            return null;
        }
    }

    private List<PtFloor> queryFloorModelPage(Map<String, Object> parammap) {
        try {
            return this.ptFloorMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtFloorServiceImpl.queryFloorModel", (Throwable)e);
            return null;
        }
    }

    private int countFloor(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptFloorMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtFloorServiceImpl.countFloor", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveFloor(PtFloorDomain ptFloorDomain) throws ApiException {
        String msg = this.checkFloor(ptFloorDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtFloorServiceImpl.saveFloor.checkFloor", msg);
        }
        PtFloor ptFloor = this.makeFloor(ptFloorDomain, null);
        this.setFloorDefault(ptFloor);
        this.saveFloorModel(ptFloor);
    }

    @Override
    public void updateFloorState(Integer floorId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFloorModel(floorId, dataState, oldDataState);
    }

    @Override
    public void updateFloor(PtFloorDomain ptFloorDomain) throws ApiException {
        String msg = this.checkFloor(ptFloorDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtFloorServiceImpl.updateFloor.checkFloor", msg);
        }
        PtFloor oldPtFloor = this.getFloorModelById(ptFloorDomain.getFloorId());
        if (oldPtFloor == null) {
            throw new ApiException("pt.PROJECT.PtFloorServiceImpl.updateFloor.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtFloor ptFloor = this.makeFloor(ptFloorDomain, oldPtFloor);
        this.setFloorUpdataDefault(ptFloor);
        this.updateFloorModel(ptFloor);
    }

    @Override
    public PtFloor getFloor(Integer floorId) {
        return this.getFloorModelById(floorId);
    }

    @Override
    public void deleteFloor(Integer floorId) throws ApiException {
        this.deleteFloorModel(floorId);
    }

    @Override
    public QueryResult<PtFloor> queryFloorPage(Map<String, Object> map) {
        List<PtFloor> ptFloorList = this.queryFloorModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFloor(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptFloorList);
        return queryResult;
    }

    @Override
    public PtFloor getFloorByCode(Map<String, Object> map) {
        return this.getFloorModelByCode(map);
    }

    @Override
    public void delFloorByCode(Map<String, Object> map) throws ApiException {
        this.delFloorModelByCode(map);
    }

    @Override
    public PtFloor saveFloorRet(PtFloorDomain ptFloorDomain) throws ApiException {
        String msg = this.checkFloor(ptFloorDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtFloorServiceImpl.saveFloorRet.checkFloor", msg);
        }
        PtFloor ptFloor = this.makeFloor(ptFloorDomain, null);
        this.setFloorDefault(ptFloor);
        this.saveFloorModel(ptFloor);
        return ptFloor;
    }

    @Override
    public PtFloor updateFloorHouseNum(Map<String, Object> map) throws ApiException {
        this.updateFloorHouseNumModel(map);
        return null;
    }

    private int updateFloorHouseNumModel(Map<String, Object> map) throws ApiException {
        try {
            return this.ptFloorMapper.updateFloorHouseNum(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtFloorServiceImpl.updateFloorHouseNumModel.ex", (Throwable)e);
        }
    }
}

