/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.project.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.project.dao.PtHouseMapper;
import com.yqbsoft.laser.service.project.domain.PtHouseDomain;
import com.yqbsoft.laser.service.project.model.PtHouse;
import com.yqbsoft.laser.service.project.service.PtHouseService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class PtHouseServiceImpl
extends BaseServiceImpl
implements PtHouseService {
    public static final String SYS_CODE = "pt.PROJECT.PtHouseServiceImpl";
    private PtHouseMapper ptHouseMapper;

    public void setPtHouseMapper(PtHouseMapper ptHouseMapper) {
        this.ptHouseMapper = ptHouseMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptHouseMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtHouseServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkHouse(PtHouseDomain ptHouseDomain) {
        if (ptHouseDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setHouseDefault(PtHouse ptHouse) {
        if (ptHouse == null) {
            return;
        }
        if (ptHouse.getDataState() == null) {
            ptHouse.setDataState(0);
        }
        if (ptHouse.getGmtCreate() == null) {
            ptHouse.setGmtCreate(this.getSysDate());
        }
        ptHouse.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ptHouse.getHouseCode())) {
            ptHouse.setHouseCode(this.createUUIDString());
        }
    }

    private int getHouseMaxCode() {
        int code = 0;
        try {
            return this.ptHouseMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtHouseServiceImpl.getHouseMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setHouseUpdataDefault(PtHouse ptHouse) {
        if (ptHouse == null) {
            return;
        }
        ptHouse.setGmtModified(this.getSysDate());
    }

    private void saveHouseModel(PtHouse ptHouse) throws ApiException {
        if (ptHouse == null) {
            return;
        }
        try {
            this.ptHouseMapper.insert(ptHouse);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.saveHouseModel.ex", (Throwable)e);
        }
    }

    private PtHouse getHouseModelById(Integer houseId) {
        if (houseId == null) {
            return null;
        }
        try {
            return this.ptHouseMapper.selectByPrimaryKey(houseId);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtHouseServiceImpl.getHouseModelById", (Throwable)e);
            return null;
        }
    }

    public PtHouse getHouseModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptHouseMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtHouseServiceImpl.getHouseModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delHouseModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptHouseMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.delHouseModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.delHouseModelByCode.num");
        }
    }

    private void deleteHouseModel(Integer houseId) throws ApiException {
        if (houseId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.ptHouseMapper.deleteByPrimaryKey(houseId);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.deleteHouseModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.deleteHouseModel.num");
        }
    }

    private void updateHouseModel(PtHouse ptHouse) throws ApiException {
        if (ptHouse == null) {
            return;
        }
        try {
            this.ptHouseMapper.updateByPrimaryKeySelective(ptHouse);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.updateHouseModel.ex", (Throwable)e);
        }
    }

    private void updateStateHouseModel(Integer houseId, Integer dataState, Integer oldDataState) throws ApiException {
        if (houseId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("houseId", houseId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ptHouseMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.updateStateHouseModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.updateStateHouseModel.null");
        }
    }

    private PtHouse makeHouse(PtHouseDomain ptHouseDomain, PtHouse ptHouse) {
        if (ptHouseDomain == null) {
            return null;
        }
        if (ptHouse == null) {
            ptHouse = new PtHouse();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptHouse, (Object)ptHouseDomain);
            return ptHouse;
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtHouseServiceImpl.makeHouse", (Throwable)e);
            return null;
        }
    }

    private List<PtHouse> queryHouseModelPage(Map<String, Object> parammap) {
        try {
            return this.ptHouseMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtHouseServiceImpl.queryHouseModel", (Throwable)e);
            return null;
        }
    }

    private int countHouse(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptHouseMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtHouseServiceImpl.countHouse", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveHouse(PtHouseDomain ptHouseDomain) throws ApiException {
        String msg = this.checkHouse(ptHouseDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.saveHouse.checkHouse", msg);
        }
        PtHouse ptHouse = this.makeHouse(ptHouseDomain, null);
        this.setHouseDefault(ptHouse);
        this.saveHouseModel(ptHouse);
    }

    @Override
    public void updateHouseState(Integer houseId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateHouseModel(houseId, dataState, oldDataState);
    }

    @Override
    public void updateHouse(PtHouseDomain ptHouseDomain) throws ApiException {
        String msg = this.checkHouse(ptHouseDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.updateHouse.checkHouse", msg);
        }
        PtHouse oldPtHouse = this.getHouseModelById(ptHouseDomain.getHouseId());
        if (oldPtHouse == null) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.updateHouse.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtHouse ptHouse = this.makeHouse(ptHouseDomain, oldPtHouse);
        this.setHouseUpdataDefault(ptHouse);
        this.updateHouseModel(ptHouse);
    }

    @Override
    public PtHouse getHouse(Integer houseId) {
        return this.getHouseModelById(houseId);
    }

    @Override
    public void deleteHouse(Integer houseId) throws ApiException {
        this.deleteHouseModel(houseId);
    }

    @Override
    public QueryResult<PtHouse> queryHousePage(Map<String, Object> map) {
        List<PtHouse> ptHouseList = this.queryHouseModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countHouse(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptHouseList);
        return queryResult;
    }

    @Override
    public PtHouse getHouseByCode(Map<String, Object> map) {
        return this.getHouseModelByCode(map);
    }

    @Override
    public void delHouseByCode(Map<String, Object> map) throws ApiException {
        this.delHouseModelByCode(map);
    }

    @Override
    public List<PtHouse> getUnitFloorHouseInfo(Map<String, Object> map) throws ApiException {
        List<PtHouse> houses = this.getUnitFloorHouseInfoModel(map);
        return houses;
    }

    private List<PtHouse> getUnitFloorHouseInfoModel(Map<String, Object> map) {
        try {
            return this.ptHouseMapper.getUnitFloorHouseInfo(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.getUnitFloorHouseInfoModel.ex", (Throwable)e);
        }
    }

    @Override
    public boolean saveBatchHouse(List<PtHouseDomain> list) throws ApiException {
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList<PtHouse> ptHouses = new ArrayList<PtHouse>();
            for (PtHouseDomain ptHouseDomain : list) {
                PtHouse ptHouse = this.makeHouse(ptHouseDomain, null);
                this.setHouseDefault(ptHouse);
                ptHouses.add(ptHouse);
            }
            if (ptHouses.size() > 0) {
                this.saveHouseBatchModel(ptHouses);
                return true;
            }
        }
        return false;
    }

    private void saveHouseBatchModel(List<PtHouse> ptHouses) throws ApiException {
        if (ptHouses == null) {
            return;
        }
        try {
            this.ptHouseMapper.insertBatch(ptHouses);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.saveHouseBatchModel.ex", (Throwable)e);
        }
    }

    @Override
    public List<Map<String, Object>> getHouseSellPercent(Map<String, Object> map) {
        List<Map<String, Object>> percents = this.getHouseSellPercentModel(map);
        return percents;
    }

    private List<Map<String, Object>> getHouseSellPercentModel(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        try {
            return this.ptHouseMapper.getHouseSellPercent(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.saveHouseBatchModel.ex", (Throwable)e);
        }
    }

    @Override
    public void updateHouseByCode(Map<String, Object> map) {
        int i;
        if (map == null || map.get("dataState") == null) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.updateHouse.checkHouse", "\u4fee\u6539\u53c2\u6570\u4e3a\u7a7a");
        }
        PtHouse oldPtHouse = this.getHouseModelByCode(map);
        if (oldPtHouse == null) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.updateHouse.null", "\u623f\u6237\u6570\u636e\u4e3a\u7a7a");
        }
        if (map.get("manageUpdateNum") != null && map.get("averagePrice") != null && map.get("totalArea") != null && (oldPtHouse.getTotalPrice() == null || oldPtHouse.getTotalPrice().compareTo(BigDecimal.ZERO) == 0)) {
            String totalAreaStr = String.valueOf(map.get("totalArea"));
            String averagePriceStr = String.valueOf(map.get("averagePrice"));
            BigDecimal totalArea = new BigDecimal(totalAreaStr);
            BigDecimal averagePriceDecimal = new BigDecimal(averagePriceStr);
            map.put("totalPrice", totalArea.multiply(averagePriceDecimal));
        }
        if ((i = this.updateHouseByCondModel(map)) < 1) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.updateHouse.failure", "\u623f\u5c4b\u72b6\u6001\u4fee\u6539\u5931\u8d25");
        }
    }

    private int updateHouseByCondModel(Map<String, Object> map) throws ApiException {
        try {
            int i = this.ptHouseMapper.updateHouseByCond(map);
            return i;
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.updateHouseModel.ex", (Throwable)e);
        }
    }

    @Override
    public List<Map<String, Object>> queryUnSellStatistical(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        List<Map<String, Object>> list = this.queryUnSellStatisticalModel(map);
        return list;
    }

    private List<Map<String, Object>> queryUnSellStatisticalModel(Map<String, Object> map) {
        try {
            return this.ptHouseMapper.unSellStatistical(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtHouseServiceImpl.queryUnSellStatisticalModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> querySelledStatistical(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        List<Map<String, Object>> list = this.querySelledStatisticalModel(map);
        return list;
    }

    private List<Map<String, Object>> querySelledStatisticalModel(Map<String, Object> map) {
        try {
            return this.ptHouseMapper.selledStatistical(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtHouseServiceImpl.querySelledStatisticalModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> queryPreSellStatistical(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        List<Map<String, Object>> list = this.queryPreSellStatisticalModel(map);
        return list;
    }

    private List<Map<String, Object>> queryPreSellStatisticalModel(Map<String, Object> map) {
        try {
            return this.ptHouseMapper.preSellStatistical(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtHouseServiceImpl.queryPreSellStatisticalModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public int updateBatchHouse(List<PtHouseDomain> list) throws ApiException {
        int i = 0;
        if (CollectionUtils.isNotEmpty(list)) {
            for (PtHouseDomain ptHouseDomain : list) {
                PtHouse ptHouse = this.makeHouse(ptHouseDomain, null);
                ptHouse.setMemo("\u6279\u91cf\u5bfc\u5165\u4fee\u6539");
                ptHouse.setDataState(0);
                this.updateHousePriceModel(ptHouse);
                ++i;
            }
        }
        return i;
    }

    private int updateHousePriceModel(PtHouse ptHouse) {
        try {
            return this.ptHouseMapper.updateHousePrice(ptHouse);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.updatehouseBatchModel.ex", (Throwable)e);
        }
    }

    @Override
    public List<Map<String, Object>> queryStatisAllFinance(Map<String, Object> map) {
        return this.queryStatisAllFinanceModel(map);
    }

    @Override
    public List<Map<String, Object>> queryStatisUnSellFinance(Map<String, Object> map) {
        return this.queryStatisUnSellFinanceModel(map);
    }

    private List<Map<String, Object>> queryStatisAllFinanceModel(Map<String, Object> map) {
        try {
            return this.ptHouseMapper.statisAllFinance(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.queryStatisAllFinanceModel.ex", (Throwable)e);
        }
    }

    private List<Map<String, Object>> queryStatisUnSellFinanceModel(Map<String, Object> map) {
        try {
            return this.ptHouseMapper.statisUnSellFinance(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.queryStatisUnSellFinanceModel.ex", (Throwable)e);
        }
    }

    @Override
    public Boolean updateHouseHandoverDate(Map<String, Object> map) {
        if (map == null) {
            return false;
        }
        int index = this.updateHouseHandoverDateModel(map);
        if (index > 0) {
            return true;
        }
        return false;
    }

    private int updateHouseHandoverDateModel(Map<String, Object> map) {
        try {
            return this.ptHouseMapper.updateHouseHandoverDate(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtHouseServiceImpl.updateHouseHandoverDateModel.ex", (Throwable)e);
        }
    }
}

