/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.project.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.project.dao.PtProjectCpMapper;
import com.yqbsoft.laser.service.project.domain.PtProjectCpDomain;
import com.yqbsoft.laser.service.project.model.PtProjectCp;
import com.yqbsoft.laser.service.project.service.PtProjectCpService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PtProjectCpServiceImpl
extends BaseServiceImpl
implements PtProjectCpService {
    public static final String SYS_CODE = "pt.PROJECT.PtProjectCpServiceImpl";
    private PtProjectCpMapper ptProjectCpMapper;

    public void setPtProjectCpMapper(PtProjectCpMapper ptProjectCpMapper) {
        this.ptProjectCpMapper = ptProjectCpMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptProjectCpMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectCpServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProjectCp(PtProjectCpDomain ptProjectCpDomain) {
        if (ptProjectCpDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setProjectCpDefault(PtProjectCp ptProjectCp) {
        if (ptProjectCp == null) {
            return;
        }
        if (ptProjectCp.getDataState() == null) {
            ptProjectCp.setDataState(0);
        }
        if (ptProjectCp.getGmtCreate() == null) {
            ptProjectCp.setGmtCreate(this.getSysDate());
        }
        ptProjectCp.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ptProjectCp.getCpCode())) {
            ptProjectCp.setCpCode(this.createUUIDString());
        }
    }

    private int getProjectCpMaxCode() {
        int code = 0;
        try {
            return this.ptProjectCpMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectCpServiceImpl.getProjectCpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProjectCpUpdataDefault(PtProjectCp ptProjectCp) {
        if (ptProjectCp == null) {
            return;
        }
        ptProjectCp.setGmtModified(this.getSysDate());
    }

    private void saveProjectCpModel(PtProjectCp ptProjectCp) throws ApiException {
        if (ptProjectCp == null) {
            return;
        }
        try {
            this.ptProjectCpMapper.insert(ptProjectCp);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectCpServiceImpl.saveProjectCpModel.ex", (Throwable)e);
        }
    }

    private PtProjectCp getProjectCpModelById(Integer cpId) {
        if (cpId == null) {
            return null;
        }
        try {
            return this.ptProjectCpMapper.selectByPrimaryKey(cpId);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectCpServiceImpl.getProjectCpModelById", (Throwable)e);
            return null;
        }
    }

    public PtProjectCp getProjectCpModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptProjectCpMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectCpServiceImpl.getProjectCpModelByCode", (Throwable)e);
            return null;
        }
    }

    public Integer delProjectCpModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return 0;
        }
        int i = 0;
        try {
            i = this.ptProjectCpMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectCpServiceImpl.delProjectCpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtProjectCpServiceImpl.delProjectCpModelByCode.num");
        }
        return i;
    }

    public Integer delProjectCpModelByCompanyCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return 0;
        }
        int i = 0;
        try {
            i = this.ptProjectCpMapper.delProjectCpByCompanyCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectCpServiceImpl.delProjectCpModelByCompanyCode.ex", (Throwable)e);
        }
        return i;
    }

    private void deleteProjectCpModel(Integer cpId) throws ApiException {
        if (cpId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.ptProjectCpMapper.deleteByPrimaryKey(cpId);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectCpServiceImpl.deleteProjectCpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtProjectCpServiceImpl.deleteProjectCpModel.num");
        }
    }

    private void updateProjectCpModel(PtProjectCp ptProjectCp) throws ApiException {
        if (ptProjectCp == null) {
            return;
        }
        try {
            this.ptProjectCpMapper.updateByPrimaryKeySelective(ptProjectCp);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectCpServiceImpl.updateProjectCpModel.ex", (Throwable)e);
        }
    }

    private void updateStateProjectCpModel(Integer cpId, Integer dataState, Integer oldDataState) throws ApiException {
        if (cpId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cpId", cpId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ptProjectCpMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectCpServiceImpl.updateStateProjectCpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.PROJECT.PtProjectCpServiceImpl.updateStateProjectCpModel.null");
        }
    }

    private PtProjectCp makeProjectCp(PtProjectCpDomain ptProjectCpDomain, PtProjectCp ptProjectCp) {
        if (ptProjectCpDomain == null) {
            return null;
        }
        if (ptProjectCp == null) {
            ptProjectCp = new PtProjectCp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptProjectCp, (Object)ptProjectCpDomain);
            return ptProjectCp;
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectCpServiceImpl.makeProjectCp", (Throwable)e);
            return null;
        }
    }

    private List<PtProjectCp> queryProjectCpModelPage(Map<String, Object> parammap) {
        try {
            return this.ptProjectCpMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectCpServiceImpl.queryProjectCpModel", (Throwable)e);
            return null;
        }
    }

    private int countProjectCp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptProjectCpMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectCpServiceImpl.countProjectCp", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveProjectCp(PtProjectCpDomain ptProjectCpDomain) throws ApiException {
        String msg = this.checkProjectCp(ptProjectCpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtProjectCpServiceImpl.saveProjectCp.checkProjectCp", msg);
        }
        PtProjectCp ptProjectCp = this.makeProjectCp(ptProjectCpDomain, null);
        this.setProjectCpDefault(ptProjectCp);
        this.saveProjectCpModel(ptProjectCp);
        String cpCode = ptProjectCp.getCpCode();
        return cpCode;
    }

    @Override
    public void updateProjectCpState(Integer cpId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectCpModel(cpId, dataState, oldDataState);
    }

    @Override
    public void updateProjectCp(PtProjectCpDomain ptProjectCpDomain) throws ApiException {
        String msg = this.checkProjectCp(ptProjectCpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtProjectCpServiceImpl.updateProjectCp.checkProjectCp", msg);
        }
        PtProjectCp oldPtProjectCp = this.getProjectCpModelById(ptProjectCpDomain.getCpId());
        if (oldPtProjectCp == null) {
            throw new ApiException("pt.PROJECT.PtProjectCpServiceImpl.updateProjectCp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtProjectCp ptProjectCp = this.makeProjectCp(ptProjectCpDomain, oldPtProjectCp);
        this.setProjectCpUpdataDefault(ptProjectCp);
        this.updateProjectCpModel(ptProjectCp);
    }

    @Override
    public PtProjectCp getProjectCp(Integer cpId) {
        return this.getProjectCpModelById(cpId);
    }

    @Override
    public void deleteProjectCp(Integer cpId) throws ApiException {
        this.deleteProjectCpModel(cpId);
    }

    @Override
    public QueryResult<PtProjectCp> queryProjectCpPage(Map<String, Object> map) {
        List<PtProjectCp> ptProjectCpList = this.queryProjectCpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProjectCp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptProjectCpList);
        return queryResult;
    }

    @Override
    public PtProjectCp getProjectCpByCode(Map<String, Object> map) {
        return this.getProjectCpModelByCode(map);
    }

    @Override
    public Integer delProjectCpByCode(Map<String, Object> map) throws ApiException {
        if (map != null && map.get("companyCode") != null && map.get("cpCode") == null) {
            return this.delProjectCpModelByCompanyCode(map);
        }
        return this.delProjectCpModelByCode(map);
    }

    @Override
    public Integer saveProjectCpBatch(List<PtProjectCpDomain> list) throws ApiException {
        if (ListUtil.isEmpty(list)) {
            return 0;
        }
        ArrayList<PtProjectCp> projectCps = new ArrayList<PtProjectCp>();
        for (PtProjectCpDomain ptProjectCpDomain : list) {
            String msg = this.checkProjectCp(ptProjectCpDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException("pt.PROJECT.PtProjectCpServiceImpl.saveProjectCpBatch.checkProjectCp", msg);
            }
            PtProjectCp ptProjectCp = this.makeProjectCp(ptProjectCpDomain, null);
            this.setProjectCpDefault(ptProjectCp);
            projectCps.add(ptProjectCp);
        }
        if (ListUtil.isNotEmpty(projectCps)) {
            return this.saveProjectCpBatchModel(projectCps);
        }
        return 0;
    }

    private Integer saveProjectCpBatchModel(List<PtProjectCp> projectCps) throws ApiException {
        try {
            return this.ptProjectCpMapper.insertBatch(projectCps);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectCpServiceImpl.saveProjectCpBatchModel.ex", (Throwable)e);
        }
    }
}

