/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.project.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.project.dao.PtProjectRelationMapper;
import com.yqbsoft.laser.service.project.domain.PtProjectRelationDomain;
import com.yqbsoft.laser.service.project.model.PtProjectRelation;
import com.yqbsoft.laser.service.project.service.PtProjectRelationService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PtProjectRelationServiceImpl
extends BaseServiceImpl
implements PtProjectRelationService {
    public static final String SYS_CODE = "pt.PROJECT.PtProjectRelationServiceImpl";
    private PtProjectRelationMapper ptProjectRelationMapper;

    public void setPtProjectRelationMapper(PtProjectRelationMapper ptProjectRelationMapper) {
        this.ptProjectRelationMapper = ptProjectRelationMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptProjectRelationMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectRelationServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProjectRelation(PtProjectRelationDomain ptProjectRelationDomain) {
        if (ptProjectRelationDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setProjectRelationDefault(PtProjectRelation ptProjectRelation) {
        if (ptProjectRelation == null) {
            return;
        }
        if (ptProjectRelation.getDataState() == null) {
            ptProjectRelation.setDataState(0);
        }
        if (ptProjectRelation.getGmtCreate() == null) {
            ptProjectRelation.setGmtCreate(this.getSysDate());
        }
        ptProjectRelation.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ptProjectRelation.getRelationCode())) {
            ptProjectRelation.setRelationCode(this.createUUIDString());
        }
    }

    private int getProjectRelationMaxCode() {
        int code = 0;
        try {
            return this.ptProjectRelationMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectRelationServiceImpl.getProjectRelationMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProjectRelationUpdataDefault(PtProjectRelation ptProjectRelation) {
        if (ptProjectRelation == null) {
            return;
        }
        ptProjectRelation.setGmtModified(this.getSysDate());
    }

    private void saveProjectRelationModel(PtProjectRelation ptProjectRelation) throws ApiException {
        if (ptProjectRelation == null) {
            return;
        }
        try {
            this.ptProjectRelationMapper.insert(ptProjectRelation);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectRelationServiceImpl.saveProjectRelationModel.ex", (Throwable)e);
        }
    }

    private PtProjectRelation getProjectRelationModelById(Integer relationId) {
        if (relationId == null) {
            return null;
        }
        try {
            return this.ptProjectRelationMapper.selectByPrimaryKey(relationId);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectRelationServiceImpl.getProjectRelationModelById", (Throwable)e);
            return null;
        }
    }

    public PtProjectRelation getProjectRelationModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptProjectRelationMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectRelationServiceImpl.getProjectRelationModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delProjectRelationModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptProjectRelationMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectRelationServiceImpl.delProjectRelationModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtProjectRelationServiceImpl.delProjectRelationModelByCode.num");
        }
    }

    private void deleteProjectRelationModel(Integer relationId) throws ApiException {
        if (relationId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.ptProjectRelationMapper.deleteByPrimaryKey(relationId);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectRelationServiceImpl.deleteProjectRelationModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtProjectRelationServiceImpl.deleteProjectRelationModel.num");
        }
    }

    private void updateProjectRelationModel(PtProjectRelation ptProjectRelation) throws ApiException {
        if (ptProjectRelation == null) {
            return;
        }
        try {
            this.ptProjectRelationMapper.updateByPrimaryKeySelective(ptProjectRelation);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectRelationServiceImpl.updateProjectRelationModel.ex", (Throwable)e);
        }
    }

    private void updateStateProjectRelationModel(Integer relationId, Integer dataState, Integer oldDataState) throws ApiException {
        if (relationId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("relationId", relationId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ptProjectRelationMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectRelationServiceImpl.updateStateProjectRelationModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.PROJECT.PtProjectRelationServiceImpl.updateStateProjectRelationModel.null");
        }
    }

    private PtProjectRelation makeProjectRelation(PtProjectRelationDomain ptProjectRelationDomain, PtProjectRelation ptProjectRelation) {
        if (ptProjectRelationDomain == null) {
            return null;
        }
        if (ptProjectRelation == null) {
            ptProjectRelation = new PtProjectRelation();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptProjectRelation, (Object)ptProjectRelationDomain);
            return ptProjectRelation;
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectRelationServiceImpl.makeProjectRelation", (Throwable)e);
            return null;
        }
    }

    private List<PtProjectRelation> queryProjectRelationModelPage(Map<String, Object> parammap) {
        try {
            return this.ptProjectRelationMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectRelationServiceImpl.queryProjectRelationModel", (Throwable)e);
            return null;
        }
    }

    private int countProjectRelation(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptProjectRelationMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectRelationServiceImpl.countProjectRelation", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveProjectRelation(PtProjectRelationDomain ptProjectRelationDomain) throws ApiException {
        String msg = this.checkProjectRelation(ptProjectRelationDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtProjectRelationServiceImpl.saveProjectRelation.checkProjectRelation", msg);
        }
        PtProjectRelation ptProjectRelation = this.makeProjectRelation(ptProjectRelationDomain, null);
        this.setProjectRelationDefault(ptProjectRelation);
        this.saveProjectRelationModel(ptProjectRelation);
        return ptProjectRelation.getRelationCode();
    }

    @Override
    public void updateProjectRelationState(Integer relationId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectRelationModel(relationId, dataState, oldDataState);
    }

    @Override
    public void updateProjectRelation(PtProjectRelationDomain ptProjectRelationDomain) throws ApiException {
        String msg = this.checkProjectRelation(ptProjectRelationDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtProjectRelationServiceImpl.updateProjectRelation.checkProjectRelation", msg);
        }
        PtProjectRelation oldPtProjectRelation = this.getProjectRelationModelById(ptProjectRelationDomain.getRelationId());
        if (oldPtProjectRelation == null) {
            throw new ApiException("pt.PROJECT.PtProjectRelationServiceImpl.updateProjectRelation.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtProjectRelation ptProjectRelation = this.makeProjectRelation(ptProjectRelationDomain, oldPtProjectRelation);
        this.setProjectRelationUpdataDefault(ptProjectRelation);
        this.updateProjectRelationModel(ptProjectRelation);
    }

    @Override
    public PtProjectRelation getProjectRelation(Integer relationId) {
        return this.getProjectRelationModelById(relationId);
    }

    @Override
    public void deleteProjectRelation(Integer relationId) throws ApiException {
        this.deleteProjectRelationModel(relationId);
    }

    @Override
    public QueryResult<PtProjectRelation> queryProjectRelationPage(Map<String, Object> map) {
        List<PtProjectRelation> ptProjectRelationList = this.queryProjectRelationModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProjectRelation(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptProjectRelationList);
        return queryResult;
    }

    @Override
    public PtProjectRelation getProjectRelationByCode(Map<String, Object> map) {
        return this.getProjectRelationModelByCode(map);
    }

    @Override
    public void delProjectRelationByCode(Map<String, Object> map) throws ApiException {
        this.delProjectRelationModelByCode(map);
    }
}

