/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.project.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.project.dao.PtProjectMapper;
import com.yqbsoft.laser.service.project.domain.PtProjectDomain;
import com.yqbsoft.laser.service.project.model.PtProject;
import com.yqbsoft.laser.service.project.service.PtProjectService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PtProjectServiceImpl
extends BaseServiceImpl
implements PtProjectService {
    public static final String SYS_CODE = "pt.PROJECT.PtProjectServiceImpl";
    private PtProjectMapper ptProjectMapper;

    public void setPtProjectMapper(PtProjectMapper ptProjectMapper) {
        this.ptProjectMapper = ptProjectMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptProjectMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProject(PtProjectDomain ptProjectDomain) {
        if (ptProjectDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setProjectDefault(PtProject ptProject) {
        if (ptProject == null) {
            return;
        }
        if (ptProject.getDataState() == null) {
            ptProject.setDataState(0);
        }
        if (ptProject.getGmtCreate() == null) {
            ptProject.setGmtCreate(this.getSysDate());
        }
        ptProject.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ptProject.getProjectCode())) {
            ptProject.setProjectCode(this.createUUIDString());
        }
    }

    private int getProjectMaxCode() {
        int code = 0;
        try {
            return this.ptProjectMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectServiceImpl.getProjectMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProjectUpdataDefault(PtProject ptProject) {
        if (ptProject == null) {
            return;
        }
        ptProject.setGmtModified(this.getSysDate());
    }

    private void saveProjectModel(PtProject ptProject) throws ApiException {
        if (ptProject == null) {
            return;
        }
        try {
            this.ptProjectMapper.insert(ptProject);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectServiceImpl.saveProjectModel.ex", (Throwable)e);
        }
    }

    private PtProject getProjectModelById(Integer projectId) {
        if (projectId == null) {
            return null;
        }
        try {
            return this.ptProjectMapper.selectByPrimaryKey(projectId);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectServiceImpl.getProjectModelById", (Throwable)e);
            return null;
        }
    }

    public PtProject getProjectModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptProjectMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectServiceImpl.getProjectModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delProjectModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptProjectMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectServiceImpl.delProjectModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtProjectServiceImpl.delProjectModelByCode.num");
        }
    }

    private void deleteProjectModel(Integer projectId) throws ApiException {
        if (projectId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.ptProjectMapper.deleteByPrimaryKey(projectId);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectServiceImpl.deleteProjectModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtProjectServiceImpl.deleteProjectModel.num");
        }
    }

    private void updateProjectModel(PtProject ptProject) throws ApiException {
        if (ptProject == null) {
            return;
        }
        try {
            this.ptProjectMapper.updateByPrimaryKeySelective(ptProject);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectServiceImpl.updateProjectModel.ex", (Throwable)e);
        }
    }

    private void updateStateProjectModel(Integer projectId, Integer dataState, Integer oldDataState) throws ApiException {
        if (projectId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectId", projectId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ptProjectMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectServiceImpl.updateStateProjectModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.PROJECT.PtProjectServiceImpl.updateStateProjectModel.null");
        }
    }

    private PtProject makeProject(PtProjectDomain ptProjectDomain, PtProject ptProject) {
        if (ptProjectDomain == null) {
            return null;
        }
        if (ptProject == null) {
            ptProject = new PtProject();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptProject, (Object)ptProjectDomain);
            return ptProject;
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectServiceImpl.makeProject", (Throwable)e);
            return null;
        }
    }

    private List<PtProject> queryProjectModelPage(Map<String, Object> parammap) {
        try {
            return this.ptProjectMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectServiceImpl.queryProjectModel", (Throwable)e);
            return null;
        }
    }

    private int countProject(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptProjectMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectServiceImpl.countProject", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveProject(PtProjectDomain ptProjectDomain) throws ApiException {
        String msg = this.checkProject(ptProjectDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtProjectServiceImpl.saveProject.checkProject", msg);
        }
        PtProject ptProject = this.makeProject(ptProjectDomain, null);
        this.setProjectDefault(ptProject);
        this.saveProjectModel(ptProject);
        return ptProject.getProjectCode();
    }

    @Override
    public void updateProjectState(Integer projectId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectModel(projectId, dataState, oldDataState);
    }

    @Override
    public void updateProject(PtProjectDomain ptProjectDomain) throws ApiException {
        String msg = this.checkProject(ptProjectDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtProjectServiceImpl.updateProject.checkProject", msg);
        }
        PtProject oldPtProject = this.getProjectModelById(ptProjectDomain.getProjectId());
        if (oldPtProject == null) {
            throw new ApiException("pt.PROJECT.PtProjectServiceImpl.updateProject.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtProject ptProject = this.makeProject(ptProjectDomain, oldPtProject);
        this.setProjectUpdataDefault(ptProject);
        this.updateProjectModel(ptProject);
    }

    @Override
    public PtProject getProject(Integer projectId) {
        return this.getProjectModelById(projectId);
    }

    @Override
    public void deleteProject(Integer projectId) throws ApiException {
        this.deleteProjectModel(projectId);
    }

    @Override
    public QueryResult<PtProject> queryProjectPage(Map<String, Object> map) {
        List<PtProject> ptProjectList = this.queryProjectModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProject(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptProjectList);
        return queryResult;
    }

    @Override
    public PtProject getProjectByCode(Map<String, Object> map) {
        return this.getProjectModelByCode(map);
    }

    @Override
    public void delProjectByCode(Map<String, Object> map) throws ApiException {
        this.delProjectModelByCode(map);
    }

    @Override
    public QueryResult<Map<String, Object>> queryProjectRelationInfo(Map<String, Object> map) {
        List<Map<String, Object>> ptProjectList = this.queryProjectRelationInfoPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProjectRelationInfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptProjectList);
        return queryResult;
    }

    private List<Map<String, Object>> queryProjectRelationInfoPage(Map<String, Object> map) {
        try {
            return this.ptProjectMapper.queryProjectRelationInfo(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectServiceImpl.queryProjectRelationInfoPage", (Throwable)e);
            return null;
        }
    }

    private int countProjectRelationInfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptProjectMapper.countProjectRelationInfo(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectServiceImpl.countProjectRelationInfo", (Throwable)e);
        }
        return i;
    }
}

