/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.project.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.project.dao.PtProjectStMapper;
import com.yqbsoft.laser.service.project.domain.PtProjectStDomain;
import com.yqbsoft.laser.service.project.model.PtProjectSt;
import com.yqbsoft.laser.service.project.service.PtProjectStService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PtProjectStServiceImpl
extends BaseServiceImpl
implements PtProjectStService {
    public static final String SYS_CODE = "pt.PROJECT.PtProjectStServiceImpl";
    private PtProjectStMapper ptProjectStMapper;

    public void setPtProjectStMapper(PtProjectStMapper ptProjectStMapper) {
        this.ptProjectStMapper = ptProjectStMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptProjectStMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectStServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProjectSt(PtProjectStDomain ptProjectStDomain) {
        if (ptProjectStDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setProjectStDefault(PtProjectSt ptProjectSt) {
        if (ptProjectSt == null) {
            return;
        }
        if (ptProjectSt.getDataState() == null) {
            ptProjectSt.setDataState(0);
        }
        if (ptProjectSt.getGmtCreate() == null) {
            ptProjectSt.setGmtCreate(this.getSysDate());
        }
        ptProjectSt.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ptProjectSt.getStCode())) {
            ptProjectSt.setStCode(this.createUUIDString());
        }
    }

    private int getProjectStMaxCode() {
        int code = 0;
        try {
            return this.ptProjectStMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectStServiceImpl.getProjectStMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProjectStUpdataDefault(PtProjectSt ptProjectSt) {
        if (ptProjectSt == null) {
            return;
        }
        ptProjectSt.setGmtModified(this.getSysDate());
    }

    private void saveProjectStModel(PtProjectSt ptProjectSt) throws ApiException {
        if (ptProjectSt == null) {
            return;
        }
        try {
            this.ptProjectStMapper.insert(ptProjectSt);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectStServiceImpl.saveProjectStModel.ex", (Throwable)e);
        }
    }

    private PtProjectSt getProjectStModelById(Integer stId) {
        if (stId == null) {
            return null;
        }
        try {
            return this.ptProjectStMapper.selectByPrimaryKey(stId);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectStServiceImpl.getProjectStModelById", (Throwable)e);
            return null;
        }
    }

    public PtProjectSt getProjectStModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptProjectStMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectStServiceImpl.getProjectStModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delProjectStModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptProjectStMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectStServiceImpl.delProjectStModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtProjectStServiceImpl.delProjectStModelByCode.num");
        }
    }

    public void delProjectStModelByUserCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptProjectStMapper.delByUserCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectStServiceImpl.delProjectStModelByUserCode.ex", (Throwable)e);
        }
        if (i < 1) {
            throw new ApiException("pt.PROJECT.PtProjectStServiceImpl.delProjectStModelByUserCode.num");
        }
    }

    private void deleteProjectStModel(Integer stId) throws ApiException {
        if (stId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.ptProjectStMapper.deleteByPrimaryKey(stId);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectStServiceImpl.deleteProjectStModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtProjectStServiceImpl.deleteProjectStModel.num");
        }
    }

    private void updateProjectStModel(PtProjectSt ptProjectSt) throws ApiException {
        if (ptProjectSt == null) {
            return;
        }
        try {
            this.ptProjectStMapper.updateByPrimaryKeySelective(ptProjectSt);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectStServiceImpl.updateProjectStModel.ex", (Throwable)e);
        }
    }

    private void updateStateProjectStModel(Integer stId, Integer dataState, Integer oldDataState) throws ApiException {
        if (stId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stId", stId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ptProjectStMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectStServiceImpl.updateStateProjectStModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.PROJECT.PtProjectStServiceImpl.updateStateProjectStModel.null");
        }
    }

    private PtProjectSt makeProjectSt(PtProjectStDomain ptProjectStDomain, PtProjectSt ptProjectSt) {
        if (ptProjectStDomain == null) {
            return null;
        }
        if (ptProjectSt == null) {
            ptProjectSt = new PtProjectSt();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptProjectSt, (Object)ptProjectStDomain);
            return ptProjectSt;
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectStServiceImpl.makeProjectSt", (Throwable)e);
            return null;
        }
    }

    private List<PtProjectSt> queryProjectStModelPage(Map<String, Object> parammap) {
        try {
            return this.ptProjectStMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectStServiceImpl.queryProjectStModel", (Throwable)e);
            return null;
        }
    }

    private int countProjectSt(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptProjectStMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectStServiceImpl.countProjectSt", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveProjectSt(PtProjectStDomain ptProjectStDomain) throws ApiException {
        String msg = this.checkProjectSt(ptProjectStDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtProjectStServiceImpl.saveProjectSt.checkProjectSt", msg);
        }
        PtProjectSt ptProjectSt = this.makeProjectSt(ptProjectStDomain, null);
        this.setProjectStDefault(ptProjectSt);
        this.saveProjectStModel(ptProjectSt);
    }

    @Override
    public void updateProjectStState(Integer stId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectStModel(stId, dataState, oldDataState);
    }

    @Override
    public void updateProjectSt(PtProjectStDomain ptProjectStDomain) throws ApiException {
        String msg = this.checkProjectSt(ptProjectStDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtProjectStServiceImpl.updateProjectSt.checkProjectSt", msg);
        }
        PtProjectSt oldPtProjectSt = this.getProjectStModelById(ptProjectStDomain.getStId());
        if (oldPtProjectSt == null) {
            throw new ApiException("pt.PROJECT.PtProjectStServiceImpl.updateProjectSt.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtProjectSt ptProjectSt = this.makeProjectSt(ptProjectStDomain, oldPtProjectSt);
        this.setProjectStUpdataDefault(ptProjectSt);
        this.updateProjectStModel(ptProjectSt);
    }

    @Override
    public PtProjectSt getProjectSt(Integer stId) {
        return this.getProjectStModelById(stId);
    }

    @Override
    public void deleteProjectSt(Integer stId) throws ApiException {
        this.deleteProjectStModel(stId);
    }

    @Override
    public QueryResult<PtProjectSt> queryProjectStPage(Map<String, Object> map) {
        List<PtProjectSt> ptProjectStList = this.queryProjectStModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProjectSt(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptProjectStList);
        return queryResult;
    }

    @Override
    public PtProjectSt getProjectStByCode(Map<String, Object> map) {
        return this.getProjectStModelByCode(map);
    }

    @Override
    public void delProjectStByCode(Map<String, Object> map) throws ApiException {
        if (map != null && map.get("userCode") != null) {
            this.delProjectStModelByUserCode(map);
        } else {
            this.delProjectStModelByCode(map);
        }
    }

    @Override
    public List<Map<String, Object>> queryByUserCode(Map<String, Object> map) {
        List<Map<String, Object>> projects = null;
        if (!(map == null || (projects = this.queryByUserCodeModel(map)) != null && projects.size() != 0 || map.get("notQueryTeam") != null && !"".equals(map.get("notQueryTeam")))) {
            projects = this.queryByUserTeamModel(map);
        }
        return projects;
    }

    private List<Map<String, Object>> queryByUserCodeModel(Map<String, Object> parammap) {
        try {
            return this.ptProjectStMapper.queryByUserCode(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectStServiceImpl.queryByUserCodeModel", (Throwable)e);
            return null;
        }
    }

    private List<Map<String, Object>> queryByUserTeamModel(Map<String, Object> parammap) {
        try {
            return this.ptProjectStMapper.queryByTeamCode(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectStServiceImpl.queryByUserTeamModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> queryStforDefault(Map<String, Object> map) {
        return this.ptProjectStMapper.queryStforDefault(map);
    }

    @Override
    public Integer saveProjectStBatch(List<PtProjectStDomain> list) throws ApiException {
        if (ListUtil.isEmpty(list)) {
            return 0;
        }
        ArrayList<PtProjectSt> projectSts = new ArrayList<PtProjectSt>();
        for (PtProjectStDomain ptProjectStDomain : list) {
            String msg = this.checkProjectSt(ptProjectStDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException("pt.PROJECT.PtProjectStServiceImpl.saveProjectStBatch.checkProjectSt", msg);
            }
            PtProjectSt ptProjectSt = this.makeProjectSt(ptProjectStDomain, null);
            this.setProjectStDefault(ptProjectSt);
            projectSts.add(ptProjectSt);
        }
        if (ListUtil.isNotEmpty(projectSts)) {
            return this.saveProjectStBatchModel(projectSts);
        }
        return 0;
    }

    private Integer saveProjectStBatchModel(List<PtProjectSt> projectSts) throws ApiException {
        try {
            return this.ptProjectStMapper.insertBatch(projectSts);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectStServiceImpl.saveProjectStBatchModel.ex", (Throwable)e);
        }
    }
}

