/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.project.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.project.dao.PtProjectTmMapper;
import com.yqbsoft.laser.service.project.domain.PtProjectTmDomain;
import com.yqbsoft.laser.service.project.model.PtProjectTm;
import com.yqbsoft.laser.service.project.service.PtProjectTmService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PtProjectTmServiceImpl
extends BaseServiceImpl
implements PtProjectTmService {
    public static final String SYS_CODE = "pt.PROJECT.PtProjectTmServiceImpl";
    private PtProjectTmMapper ptProjectTmMapper;

    public void setPtProjectTmMapper(PtProjectTmMapper ptProjectTmMapper) {
        this.ptProjectTmMapper = ptProjectTmMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptProjectTmMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectTmServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProjectTm(PtProjectTmDomain ptProjectTmDomain) {
        if (ptProjectTmDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setProjectTmDefault(PtProjectTm ptProjectTm) {
        if (ptProjectTm == null) {
            return;
        }
        if (ptProjectTm.getDataState() == null) {
            ptProjectTm.setDataState(0);
        }
        if (ptProjectTm.getGmtCreate() == null) {
            ptProjectTm.setGmtCreate(this.getSysDate());
        }
        ptProjectTm.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ptProjectTm.getTmCode())) {
            ptProjectTm.setTmCode(this.createUUIDString());
        }
    }

    private int getProjectTmMaxCode() {
        int code = 0;
        try {
            return this.ptProjectTmMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectTmServiceImpl.getProjectTmMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProjectTmUpdataDefault(PtProjectTm ptProjectTm) {
        if (ptProjectTm == null) {
            return;
        }
        ptProjectTm.setGmtModified(this.getSysDate());
    }

    private void saveProjectTmModel(PtProjectTm ptProjectTm) throws ApiException {
        if (ptProjectTm == null) {
            return;
        }
        try {
            this.ptProjectTmMapper.insert(ptProjectTm);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectTmServiceImpl.saveProjectTmModel.ex", (Throwable)e);
        }
    }

    private PtProjectTm getProjectTmModelById(Integer tmId) {
        if (tmId == null) {
            return null;
        }
        try {
            return this.ptProjectTmMapper.selectByPrimaryKey(tmId);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectTmServiceImpl.getProjectTmModelById", (Throwable)e);
            return null;
        }
    }

    public PtProjectTm getProjectTmModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptProjectTmMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectTmServiceImpl.getProjectTmModelByCode", (Throwable)e);
            return null;
        }
    }

    public Integer delProjectTmModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return 0;
        }
        int i = 0;
        try {
            i = this.ptProjectTmMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectTmServiceImpl.delProjectTmModelByCode.ex", (Throwable)e);
        }
        return i;
    }

    public Integer delProjectTmModelByTeamCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return 0;
        }
        int i = 0;
        try {
            i = this.ptProjectTmMapper.delByTeamCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectTmServiceImpl.delProjectTmModelByTeamCode.ex", (Throwable)e);
        }
        return i;
    }

    private void deleteProjectTmModel(Integer tmId) throws ApiException {
        if (tmId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.ptProjectTmMapper.deleteByPrimaryKey(tmId);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectTmServiceImpl.deleteProjectTmModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtProjectTmServiceImpl.deleteProjectTmModel.num");
        }
    }

    private void updateProjectTmModel(PtProjectTm ptProjectTm) throws ApiException {
        if (ptProjectTm == null) {
            return;
        }
        try {
            this.ptProjectTmMapper.updateByPrimaryKeySelective(ptProjectTm);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectTmServiceImpl.updateProjectTmModel.ex", (Throwable)e);
        }
    }

    private void updateStateProjectTmModel(Integer tmId, Integer dataState, Integer oldDataState) throws ApiException {
        if (tmId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tmId", tmId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ptProjectTmMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectTmServiceImpl.updateStateProjectTmModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.PROJECT.PtProjectTmServiceImpl.updateStateProjectTmModel.null");
        }
    }

    private PtProjectTm makeProjectTm(PtProjectTmDomain ptProjectTmDomain, PtProjectTm ptProjectTm) {
        if (ptProjectTmDomain == null) {
            return null;
        }
        if (ptProjectTm == null) {
            ptProjectTm = new PtProjectTm();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptProjectTm, (Object)ptProjectTmDomain);
            return ptProjectTm;
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectTmServiceImpl.makeProjectTm", (Throwable)e);
            return null;
        }
    }

    private List<PtProjectTm> queryProjectTmModelPage(Map<String, Object> parammap) {
        try {
            return this.ptProjectTmMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectTmServiceImpl.queryProjectTmModel", (Throwable)e);
            return null;
        }
    }

    private int countProjectTm(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptProjectTmMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectTmServiceImpl.countProjectTm", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveProjectTm(PtProjectTmDomain ptProjectTmDomain) throws ApiException {
        String msg = this.checkProjectTm(ptProjectTmDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtProjectTmServiceImpl.saveProjectTm.checkProjectTm", msg);
        }
        PtProjectTm ptProjectTm = this.makeProjectTm(ptProjectTmDomain, null);
        this.setProjectTmDefault(ptProjectTm);
        this.saveProjectTmModel(ptProjectTm);
        String tmCode = ptProjectTm.getTmCode();
        return tmCode;
    }

    @Override
    public void updateProjectTmState(Integer tmId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectTmModel(tmId, dataState, oldDataState);
    }

    @Override
    public void updateProjectTm(PtProjectTmDomain ptProjectTmDomain) throws ApiException {
        String msg = this.checkProjectTm(ptProjectTmDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtProjectTmServiceImpl.updateProjectTm.checkProjectTm", msg);
        }
        PtProjectTm oldPtProjectTm = this.getProjectTmModelById(ptProjectTmDomain.getTmId());
        if (oldPtProjectTm == null) {
            throw new ApiException("pt.PROJECT.PtProjectTmServiceImpl.updateProjectTm.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtProjectTm ptProjectTm = this.makeProjectTm(ptProjectTmDomain, oldPtProjectTm);
        this.setProjectTmUpdataDefault(ptProjectTm);
        this.updateProjectTmModel(ptProjectTm);
    }

    @Override
    public PtProjectTm getProjectTm(Integer tmId) {
        return this.getProjectTmModelById(tmId);
    }

    @Override
    public void deleteProjectTm(Integer tmId) throws ApiException {
        this.deleteProjectTmModel(tmId);
    }

    @Override
    public QueryResult<PtProjectTm> queryProjectTmPage(Map<String, Object> map) {
        List<PtProjectTm> ptProjectTmList = this.queryProjectTmModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProjectTm(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptProjectTmList);
        return queryResult;
    }

    @Override
    public PtProjectTm getProjectTmByCode(Map<String, Object> map) {
        return this.getProjectTmModelByCode(map);
    }

    @Override
    public Integer delProjectTmByCode(Map<String, Object> map) throws ApiException {
        if (map != null && map.get("teamCode") != null && map.get("tmCode") == null) {
            return this.delProjectTmModelByTeamCode(map);
        }
        return this.delProjectTmModelByCode(map);
    }

    @Override
    public List<String> queryProjectCodeByTeamCode(String teamCode) {
        List<String> projectCode = this.queryProjectCodeByTeamCodeModel(teamCode);
        return projectCode;
    }

    public List<String> queryProjectCodeByTeamCodeModel(String teamCode) {
        try {
            return this.ptProjectTmMapper.queryProjectCodeByTeamCode(teamCode);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectTmServiceImpl.queryProjectCodeByTemaCodeModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> queryProjectCodeByUserCode(String userCode) {
        List<String> projectCode = this.queryProjectCodeByTeamCodeModel(userCode);
        return projectCode;
    }

    @Override
    public boolean queryProjectChoicePermiss(Map<String, Object> map) {
        boolean flag = this.queryProjectChoicePermissModel(map);
        return flag;
    }

    private boolean queryProjectChoicePermissModel(Map<String, Object> parammap) {
        try {
            return this.ptProjectTmMapper.queryProjectChoicePermiss(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectTmServiceImpl.queryProjectChoicePermissModel", (Throwable)e);
            throw new ApiException("pt.PROJECT.PtProjectTmServiceImpl.getTeamCodeByPhoneModel.ex", "\u83b7\u53d6\u56e2\u961f\u5f02\u5e381");
        }
    }

    @Override
    public List<Map<String, Object>> saveTmByOldTm(Map<String, Object> map) {
        List<Map<String, Object>> ptProjectTms = null;
        if (map != null) {
            ptProjectTms = this.saveTmByOldTmModel(map);
        }
        return ptProjectTms;
    }

    private List<Map<String, Object>> saveTmByOldTmModel(Map<String, Object> map) {
        ArrayList<Map<String, Object>> newTms = new ArrayList<Map<String, Object>>();
        try {
            List<PtProjectTm> ptProjectTms = this.queryProjectTmModelPage(map);
            for (PtProjectTm ptProjectTm : ptProjectTms) {
                HashMap<String, String> project = new HashMap<String, String>();
                PtProjectTmDomain pptd = new PtProjectTmDomain();
                pptd.setProjectCode(ptProjectTm.getProjectCode());
                pptd.setProjectName(ptProjectTm.getProjectName());
                pptd.setTeamCode((String)map.get("newTeamCode"));
                pptd.setTeamName((String)map.get("newTeamName"));
                pptd.setTenantCode((String)map.get("tenantCode"));
                this.saveProjectTm(pptd);
                project.put("projectCode", pptd.getProjectCode());
                project.put("projectName", pptd.getProjectName());
                newTms.add(project);
            }
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtProjectTmServiceImpl.saveTmByOldTmModel", (Throwable)e);
            throw new ApiException("pt.PROJECT.PtProjectTmServiceImpl.saveTmByOldTmModel.ex", "\u6dfb\u52a0\u56e2\u961f\u65f6\u5206\u914d\u9879\u76ee\u5f02\u5e38");
        }
        return newTms;
    }

    @Override
    public Integer saveProjectTmBatch(List<PtProjectTmDomain> list) throws ApiException {
        if (ListUtil.isEmpty(list)) {
            return 0;
        }
        ArrayList<PtProjectTm> projectTms = new ArrayList<PtProjectTm>();
        for (PtProjectTmDomain ptProjectTmDomain : list) {
            String msg = this.checkProjectTm(ptProjectTmDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException("pt.PROJECT.PtProjectTmServiceImpl.saveProjectTmBatch.checkProjectTm", msg);
            }
            PtProjectTm ptProjectTm = this.makeProjectTm(ptProjectTmDomain, null);
            this.setProjectTmDefault(ptProjectTm);
            projectTms.add(ptProjectTm);
        }
        if (ListUtil.isNotEmpty(projectTms)) {
            return this.saveProjectTmBatchModel(projectTms);
        }
        return 0;
    }

    private Integer saveProjectTmBatchModel(List<PtProjectTm> projectTms) throws ApiException {
        try {
            return this.ptProjectTmMapper.insertBatch(projectTms);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtProjectTmServiceImpl.saveProjectTmBatchModel.ex", (Throwable)e);
        }
    }
}

