/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.project.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.project.dao.PtUnitMapper;
import com.yqbsoft.laser.service.project.domain.PtUnitDomain;
import com.yqbsoft.laser.service.project.model.PtUnit;
import com.yqbsoft.laser.service.project.service.PtUnitService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PtUnitServiceImpl
extends BaseServiceImpl
implements PtUnitService {
    public static final String SYS_CODE = "pt.PROJECT.PtUnitServiceImpl";
    private PtUnitMapper ptUnitMapper;

    public void setPtUnitMapper(PtUnitMapper ptUnitMapper) {
        this.ptUnitMapper = ptUnitMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptUnitMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtUnitServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUnit(PtUnitDomain ptUnitDomain) {
        if (ptUnitDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setUnitDefault(PtUnit ptUnit) {
        if (ptUnit == null) {
            return;
        }
        if (ptUnit.getDataState() == null) {
            ptUnit.setDataState(0);
        }
        if (ptUnit.getGmtCreate() == null) {
            ptUnit.setGmtCreate(this.getSysDate());
        }
        ptUnit.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ptUnit.getUnitCode())) {
            ptUnit.setUnitCode(this.createUUIDString());
        }
    }

    private int getUnitMaxCode() {
        int code = 0;
        try {
            return this.ptUnitMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtUnitServiceImpl.getUnitMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUnitUpdataDefault(PtUnit ptUnit) {
        if (ptUnit == null) {
            return;
        }
        ptUnit.setGmtModified(this.getSysDate());
    }

    private void saveUnitModel(PtUnit ptUnit) throws ApiException {
        if (ptUnit == null) {
            return;
        }
        try {
            this.ptUnitMapper.insert(ptUnit);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtUnitServiceImpl.saveUnitModel.ex", (Throwable)e);
        }
    }

    private PtUnit getUnitModelById(Integer unitId) {
        if (unitId == null) {
            return null;
        }
        try {
            return this.ptUnitMapper.selectByPrimaryKey(unitId);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtUnitServiceImpl.getUnitModelById", (Throwable)e);
            return null;
        }
    }

    public PtUnit getUnitModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptUnitMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtUnitServiceImpl.getUnitModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delUnitModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptUnitMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtUnitServiceImpl.delUnitModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtUnitServiceImpl.delUnitModelByCode.num");
        }
    }

    private void deleteUnitModel(Integer unitId) throws ApiException {
        if (unitId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.ptUnitMapper.deleteByPrimaryKey(unitId);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtUnitServiceImpl.deleteUnitModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtUnitServiceImpl.deleteUnitModel.num");
        }
    }

    private void updateUnitModel(PtUnit ptUnit) throws ApiException {
        if (ptUnit == null) {
            return;
        }
        try {
            this.ptUnitMapper.updateByPrimaryKeySelective(ptUnit);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtUnitServiceImpl.updateUnitModel.ex", (Throwable)e);
        }
    }

    private void updateStateUnitModel(Integer unitId, Integer dataState, Integer oldDataState) throws ApiException {
        if (unitId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("unitId", unitId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ptUnitMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtUnitServiceImpl.updateStateUnitModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.PROJECT.PtUnitServiceImpl.updateStateUnitModel.null");
        }
    }

    private PtUnit makeUnit(PtUnitDomain ptUnitDomain, PtUnit ptUnit) {
        if (ptUnitDomain == null) {
            return null;
        }
        if (ptUnit == null) {
            ptUnit = new PtUnit();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptUnit, (Object)ptUnitDomain);
            return ptUnit;
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtUnitServiceImpl.makeUnit", (Throwable)e);
            return null;
        }
    }

    private List<PtUnit> queryUnitModelPage(Map<String, Object> parammap) {
        try {
            return this.ptUnitMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtUnitServiceImpl.queryUnitModel", (Throwable)e);
            return null;
        }
    }

    private int countUnit(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptUnitMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtUnitServiceImpl.countUnit", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveUnit(PtUnitDomain ptUnitDomain) throws ApiException {
        String msg = this.checkUnit(ptUnitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtUnitServiceImpl.saveUnit.checkUnit", msg);
        }
        PtUnit ptUnit = this.makeUnit(ptUnitDomain, null);
        this.setUnitDefault(ptUnit);
        this.saveUnitModel(ptUnit);
    }

    @Override
    public void updateUnitState(Integer unitId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUnitModel(unitId, dataState, oldDataState);
    }

    @Override
    public void updateUnit(PtUnitDomain ptUnitDomain) throws ApiException {
        String msg = this.checkUnit(ptUnitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtUnitServiceImpl.updateUnit.checkUnit", msg);
        }
        PtUnit oldPtUnit = this.getUnitModelById(ptUnitDomain.getUnitId());
        if (oldPtUnit == null) {
            throw new ApiException("pt.PROJECT.PtUnitServiceImpl.updateUnit.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtUnit ptUnit = this.makeUnit(ptUnitDomain, oldPtUnit);
        this.setUnitUpdataDefault(ptUnit);
        this.updateUnitModel(ptUnit);
    }

    @Override
    public PtUnit getUnit(Integer unitId) {
        return this.getUnitModelById(unitId);
    }

    @Override
    public void deleteUnit(Integer unitId) throws ApiException {
        this.deleteUnitModel(unitId);
    }

    @Override
    public QueryResult<PtUnit> queryUnitPage(Map<String, Object> map) {
        List<PtUnit> ptUnitList = this.queryUnitModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUnit(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptUnitList);
        return queryResult;
    }

    @Override
    public PtUnit getUnitByCode(Map<String, Object> map) {
        return this.getUnitModelByCode(map);
    }

    @Override
    public void delUnitByCode(Map<String, Object> map) throws ApiException {
        this.delUnitModelByCode(map);
    }

    @Override
    public PtUnit saveUnitRet(PtUnitDomain ptUnitDomain) throws ApiException {
        String msg = this.checkUnit(ptUnitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtUnitServiceImpl.saveUnitRet.checkUnit", msg);
        }
        PtUnit ptUnit = this.makeUnit(ptUnitDomain, null);
        this.setUnitDefault(ptUnit);
        this.saveUnitModel(ptUnit);
        return ptUnit;
    }

    @Override
    public void updateUnitFloorNum(Map<String, Object> map) throws ApiException {
        this.updateUnitFloorNumModel(map);
    }

    private int updateUnitFloorNumModel(Map<String, Object> map) throws ApiException {
        try {
            return this.ptUnitMapper.updateUnitFloorNum(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtUnitServiceImpl.updateUnitFloorNumModel.ex", (Throwable)e);
        }
    }

    @Override
    public List<Map<String, String>> queryUnitByBuildingProject(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return null;
        }
        return this.queryUnitByBuildingProjectModel(map);
    }

    private List<Map<String, String>> queryUnitByBuildingProjectModel(Map<String, Object> map) {
        return this.ptUnitMapper.queryUnitByBuildingProject(map);
    }
}

