/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.project.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.project.dao.PtWarnerMapper;
import com.yqbsoft.laser.service.project.domain.PtWarnerDomain;
import com.yqbsoft.laser.service.project.model.PtWarner;
import com.yqbsoft.laser.service.project.service.PtWarnerService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PtWarnerServiceImpl
extends BaseServiceImpl
implements PtWarnerService {
    public static final String SYS_CODE = "pt.PROJECT.PtWarnerServiceImpl";
    private PtWarnerMapper ptWarnerMapper;

    public void setPtWarnerMapper(PtWarnerMapper ptWarnerMapper) {
        this.ptWarnerMapper = ptWarnerMapper;
    }

    private Date getSysDate() {
        try {
            return this.ptWarnerMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtWarnerServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkWarner(PtWarnerDomain ptWarnerDomain) {
        if (ptWarnerDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setWarnerDefault(PtWarner ptWarner) {
        if (ptWarner == null) {
            return;
        }
        if (ptWarner.getDataState() == null) {
            ptWarner.setDataState(0);
        }
        if (ptWarner.getGmtCreate() == null) {
            ptWarner.setGmtCreate(this.getSysDate());
        }
        ptWarner.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ptWarner.getWarnerCode())) {
            ptWarner.setWarnerCode(this.createUUIDString());
        }
    }

    private int getWarnerMaxCode() {
        int code = 0;
        try {
            return this.ptWarnerMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtWarnerServiceImpl.getWarnerMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setWarnerUpdataDefault(PtWarner ptWarner) {
        if (ptWarner == null) {
            return;
        }
        ptWarner.setGmtModified(this.getSysDate());
    }

    private void saveWarnerModel(PtWarner ptWarner) throws ApiException {
        if (ptWarner == null) {
            return;
        }
        try {
            this.ptWarnerMapper.insert(ptWarner);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtWarnerServiceImpl.saveWarnerModel.ex", (Throwable)e);
        }
    }

    private PtWarner getWarnerModelById(Integer warnerId) {
        if (warnerId == null) {
            return null;
        }
        try {
            return this.ptWarnerMapper.selectByPrimaryKey(warnerId);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtWarnerServiceImpl.getWarnerModelById", (Throwable)e);
            return null;
        }
    }

    public PtWarner getWarnerModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.ptWarnerMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtWarnerServiceImpl.getWarnerModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delWarnerModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ptWarnerMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtWarnerServiceImpl.delWarnerModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtWarnerServiceImpl.delWarnerModelByCode.num");
        }
    }

    private void deleteWarnerModel(Integer warnerId) throws ApiException {
        if (warnerId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.ptWarnerMapper.deleteByPrimaryKey(warnerId);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtWarnerServiceImpl.deleteWarnerModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pt.PROJECT.PtWarnerServiceImpl.deleteWarnerModel.num");
        }
    }

    private void updateWarnerModel(PtWarner ptWarner) throws ApiException {
        if (ptWarner == null) {
            return;
        }
        try {
            this.ptWarnerMapper.updateByPrimaryKeySelective(ptWarner);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtWarnerServiceImpl.updateWarnerModel.ex", (Throwable)e);
        }
    }

    private void updateStateWarnerModel(Integer warnerId, Integer dataState, Integer oldDataState) throws ApiException {
        if (warnerId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("warnerId", warnerId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ptWarnerMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtWarnerServiceImpl.updateStateWarnerModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pt.PROJECT.PtWarnerServiceImpl.updateStateWarnerModel.null");
        }
    }

    private PtWarner makeWarner(PtWarnerDomain ptWarnerDomain, PtWarner ptWarner) {
        if (ptWarnerDomain == null) {
            return null;
        }
        if (ptWarner == null) {
            ptWarner = new PtWarner();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ptWarner, (Object)ptWarnerDomain);
            return ptWarner;
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtWarnerServiceImpl.makeWarner", (Throwable)e);
            return null;
        }
    }

    private List<PtWarner> queryWarnerModelPage(Map<String, Object> parammap) {
        try {
            return this.ptWarnerMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtWarnerServiceImpl.queryWarnerModel", (Throwable)e);
            return null;
        }
    }

    private int countWarner(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ptWarnerMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pt.PROJECT.PtWarnerServiceImpl.countWarner", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveWarner(PtWarnerDomain ptWarnerDomain) throws ApiException {
        String msg = this.checkWarner(ptWarnerDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtWarnerServiceImpl.saveWarner.checkWarner", msg);
        }
        PtWarner ptWarner = this.makeWarner(ptWarnerDomain, null);
        this.setWarnerDefault(ptWarner);
        this.saveWarnerModel(ptWarner);
        return ptWarner.getWarnerCode();
    }

    @Override
    public void updateWarnerState(Integer warnerId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateWarnerModel(warnerId, dataState, oldDataState);
    }

    @Override
    public void updateWarner(PtWarnerDomain ptWarnerDomain) throws ApiException {
        String msg = this.checkWarner(ptWarnerDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pt.PROJECT.PtWarnerServiceImpl.updateWarner.checkWarner", msg);
        }
        PtWarner oldPtWarner = this.getWarnerModelById(ptWarnerDomain.getWarnerId());
        if (oldPtWarner == null) {
            throw new ApiException("pt.PROJECT.PtWarnerServiceImpl.updateWarner.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        PtWarner ptWarner = this.makeWarner(ptWarnerDomain, oldPtWarner);
        this.setWarnerUpdataDefault(ptWarner);
        this.updateWarnerModel(ptWarner);
    }

    @Override
    public PtWarner getWarner(Integer warnerId) {
        return this.getWarnerModelById(warnerId);
    }

    @Override
    public void deleteWarner(Integer warnerId) throws ApiException {
        this.deleteWarnerModel(warnerId);
    }

    @Override
    public QueryResult<PtWarner> queryWarnerPage(Map<String, Object> map) {
        List<PtWarner> ptWarnerList = this.queryWarnerModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countWarner(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ptWarnerList);
        return queryResult;
    }

    @Override
    public PtWarner getWarnerByCode(Map<String, Object> map) {
        return this.getWarnerModelByCode(map);
    }

    @Override
    public void delWarnerByCode(Map<String, Object> map) throws ApiException {
        this.delWarnerModelByCode(map);
    }

    @Override
    public Integer saveWarnerBatch(List<PtWarnerDomain> list) throws ApiException {
        if (ListUtil.isNotEmpty(list)) {
            ArrayList<PtWarner> entitys = new ArrayList<PtWarner>();
            for (PtWarnerDomain ptWarnerDomain : list) {
                String msg = this.checkWarner(ptWarnerDomain);
                if (StringUtils.isNotBlank((String)msg)) {
                    throw new ApiException("pt.PROJECT.PtWarnerServiceImpl.saveWarnerBatch.checkWarner", msg);
                }
                PtWarner ptWarner = this.makeWarner(ptWarnerDomain, null);
                this.setWarnerDefault(ptWarner);
                this.saveWarnerModel(ptWarner);
                entitys.add(ptWarner);
            }
            if (ListUtil.isNotEmpty(entitys)) {
                return this.saveWarnerBatchModel(entitys);
            }
        }
        return 0;
    }

    private int saveWarnerBatchModel(List<PtWarner> ptWarner) throws ApiException {
        try {
            return this.ptWarnerMapper.insertBatch(ptWarner);
        }
        catch (Exception e) {
            throw new ApiException("pt.PROJECT.PtWarnerServiceImpl.saveWarnerBatchModel.ex", (Throwable)e);
        }
    }
}

