/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.project.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.project.dao.ProProinfoMapper;
import com.yqbsoft.laser.service.project.domain.ProProinfoDomain;
import com.yqbsoft.laser.service.project.domain.ProProinfoReDomain;
import com.yqbsoft.laser.service.project.model.ProProinfo;
import com.yqbsoft.laser.service.project.service.ProProinfoService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProProinfoServiceImpl
extends BaseServiceImpl
implements ProProinfoService {
    private static final String SYS_CODE = "pro.ProProinfoServiceImpl";
    private ProProinfoMapper proProinfoMapper;

    public void setProProinfoMapper(ProProinfoMapper proProinfoMapper) {
        this.proProinfoMapper = proProinfoMapper;
    }

    private Date getSysDate() {
        try {
            return this.proProinfoMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pro.ProProinfoServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkproinfo(ProProinfoDomain proProinfoDomain) {
        if (null == proProinfoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)proProinfoDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setproinfoDefault(ProProinfo proProinfo) {
        if (null == proProinfo) {
            return;
        }
        if (null == proProinfo.getDataState()) {
            proProinfo.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == proProinfo.getGmtCreate()) {
            proProinfo.setGmtCreate(date);
        }
        proProinfo.setGmtModified(date);
        if (StringUtils.isBlank((String)proProinfo.getProinfoCode())) {
            proProinfo.setProinfoCode(this.getNo(null, "ProProinfo", "proProinfo", proProinfo.getTenantCode()));
        }
    }

    private int getproinfoMaxCode() {
        int code = 0;
        try {
            return this.proProinfoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pro.ProProinfoServiceImpl.getproinfoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setproinfoUpdataDefault(ProProinfo proProinfo) {
        if (null == proProinfo) {
            return;
        }
        proProinfo.setGmtModified(this.getSysDate());
    }

    private void saveproinfoModel(ProProinfo proProinfo) throws ApiException {
        if (null == proProinfo) {
            return;
        }
        try {
            this.proProinfoMapper.insert(proProinfo);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProinfoServiceImpl.saveproinfoModel.ex", (Throwable)e);
        }
    }

    private void saveproinfoBatchModel(List<ProProinfo> proProinfoList) throws ApiException {
        if (null == proProinfoList || proProinfoList.isEmpty()) {
            return;
        }
        try {
            this.proProinfoMapper.insertBatch(proProinfoList);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProinfoServiceImpl.saveproinfoBatchModel.ex", (Throwable)e);
        }
    }

    private ProProinfo getproinfoModelById(Integer proinfoId) {
        if (null == proinfoId) {
            return null;
        }
        try {
            return this.proProinfoMapper.selectByPrimaryKey(proinfoId);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProinfoServiceImpl.getproinfoModelById", (Throwable)e);
            return null;
        }
    }

    private ProProinfo getproinfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.proProinfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProinfoServiceImpl.getproinfoModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delproinfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.proProinfoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProinfoServiceImpl.delproinfoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProinfoServiceImpl.delproinfoModelByCode.num");
        }
    }

    private void deleteproinfoModel(Integer proinfoId) throws ApiException {
        if (null == proinfoId) {
            return;
        }
        int i = 0;
        try {
            i = this.proProinfoMapper.deleteByPrimaryKey(proinfoId);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProinfoServiceImpl.deleteproinfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProinfoServiceImpl.deleteproinfoModel.num");
        }
    }

    private void updateproinfoModel(ProProinfo proProinfo) throws ApiException {
        if (null == proProinfo) {
            return;
        }
        int i = 0;
        try {
            i = this.proProinfoMapper.updateByPrimaryKey(proProinfo);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProinfoServiceImpl.updateproinfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProinfoServiceImpl.updateproinfoModel.num");
        }
    }

    private void updateStateproinfoModel(Integer proinfoId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == proinfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proinfoId", proinfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.proProinfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProinfoServiceImpl.updateStateproinfoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pro.ProProinfoServiceImpl.updateStateproinfoModel.null");
        }
    }

    private void updateStateproinfoModelByCode(String tenantCode, String proinfoCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)proinfoCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("proinfoCode", proinfoCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.proProinfoMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProinfoServiceImpl.updateStateproinfoModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pro.ProProinfoServiceImpl.updateStateproinfoModelByCode.null");
        }
    }

    private ProProinfo makeproinfo(ProProinfoDomain proProinfoDomain, ProProinfo proProinfo) {
        if (null == proProinfoDomain) {
            return null;
        }
        if (null == proProinfo) {
            proProinfo = new ProProinfo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)proProinfo, (Object)proProinfoDomain);
            return proProinfo;
        }
        catch (Exception e) {
            this.logger.error("pro.ProProinfoServiceImpl.makeproinfo", (Throwable)e);
            return null;
        }
    }

    private ProProinfoReDomain makeProProinfoReDomain(ProProinfo proProinfo) {
        if (null == proProinfo) {
            return null;
        }
        ProProinfoReDomain proProinfoReDomain = new ProProinfoReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)proProinfoReDomain, (Object)proProinfo);
            return proProinfoReDomain;
        }
        catch (Exception e) {
            this.logger.error("pro.ProProinfoServiceImpl.makeProProinfoReDomain", (Throwable)e);
            return null;
        }
    }

    private List<ProProinfo> queryproinfoModelPage(Map<String, Object> parammap) {
        try {
            return this.proProinfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProinfoServiceImpl.queryproinfoModel", (Throwable)e);
            return null;
        }
    }

    private int countproinfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.proProinfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProinfoServiceImpl.countproinfo", (Throwable)e);
        }
        return i;
    }

    private ProProinfo createProProinfo(ProProinfoDomain proProinfoDomain) {
        String msg = this.checkproinfo(proProinfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pro.ProProinfoServiceImpl.saveproinfo.checkproinfo", msg);
        }
        ProProinfo proProinfo = this.makeproinfo(proProinfoDomain, null);
        this.setproinfoDefault(proProinfo);
        return proProinfo;
    }

    @Override
    public String saveproinfo(ProProinfoDomain proProinfoDomain) throws ApiException {
        ProProinfo proProinfo = this.createProProinfo(proProinfoDomain);
        this.saveproinfoModel(proProinfo);
        return proProinfo.getProinfoCode();
    }

    @Override
    public String saveproinfoBatch(List<ProProinfoDomain> proProinfoDomainList) throws ApiException {
        if (null == proProinfoDomainList || proProinfoDomainList.isEmpty()) {
            return null;
        }
        ArrayList<ProProinfo> proProinfoList = new ArrayList<ProProinfo>();
        String code = "";
        for (ProProinfoDomain proProinfoDomain : proProinfoDomainList) {
            ProProinfo proProinfo = this.createProProinfo(proProinfoDomain);
            code = proProinfo.getProinfoCode();
            proProinfoList.add(proProinfo);
        }
        this.saveproinfoBatchModel(proProinfoList);
        return code;
    }

    @Override
    public void updateproinfoState(Integer proinfoId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == proinfoId) {
            return;
        }
        this.updateStateproinfoModel(proinfoId, dataState, oldDataState, map);
    }

    @Override
    public void updateproinfoStateByCode(String tenantCode, String proinfoCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)proinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateproinfoModelByCode(tenantCode, proinfoCode, dataState, oldDataState, map);
    }

    @Override
    public void updateproinfo(ProProinfoDomain proProinfoDomain) throws ApiException {
        String msg = this.checkproinfo(proProinfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pro.ProProinfoServiceImpl.updateproinfo.checkproinfo", msg);
        }
        ProProinfo oldProProinfo = this.getproinfoModelById(proProinfoDomain.getProinfoId());
        if (null == oldProProinfo) {
            throw new ApiException("pro.ProProinfoServiceImpl.updateproinfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ProProinfo proProinfo = this.makeproinfo(proProinfoDomain, oldProProinfo);
        this.setproinfoUpdataDefault(proProinfo);
        this.updateproinfoModel(proProinfo);
    }

    @Override
    public ProProinfo getproinfo(Integer proinfoId) {
        if (null == proinfoId) {
            return null;
        }
        return this.getproinfoModelById(proinfoId);
    }

    @Override
    public void deleteproinfo(Integer proinfoId) throws ApiException {
        if (null == proinfoId) {
            return;
        }
        this.deleteproinfoModel(proinfoId);
    }

    @Override
    public QueryResult<ProProinfo> queryproinfoPage(Map<String, Object> map) {
        List<ProProinfo> proProinfoList = this.queryproinfoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countproinfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(proProinfoList);
        return queryResult;
    }

    @Override
    public ProProinfo getproinfoByCode(String tenantCode, String proinfoCode) throws ApiException {
        if (StringUtils.isBlank((String)proinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("proinfoCode", proinfoCode);
        return this.getproinfoModelByCode(map);
    }

    @Override
    public void deleteproinfoByCode(String tenantCode, String proinfoCode) throws ApiException {
        if (StringUtils.isBlank((String)proinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("proinfoCode", proinfoCode);
        this.delproinfoModelByCode(map);
    }
}

