/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.project.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.project.dao.ProProjectCskuMapper;
import com.yqbsoft.laser.service.project.domain.CtCustrel;
import com.yqbsoft.laser.service.project.domain.OcReorderDomain;
import com.yqbsoft.laser.service.project.domain.OrgCompany;
import com.yqbsoft.laser.service.project.domain.ProProjectCskuDomain;
import com.yqbsoft.laser.service.project.domain.ProProjectCskuReDomain;
import com.yqbsoft.laser.service.project.domain.ProProjectCustrelDomain;
import com.yqbsoft.laser.service.project.model.ProProject;
import com.yqbsoft.laser.service.project.model.ProProjectCsku;
import com.yqbsoft.laser.service.project.model.ProProjectCustrel;
import com.yqbsoft.laser.service.project.service.ProProjectCskuService;
import com.yqbsoft.laser.service.project.service.ProProjectCustrelService;
import com.yqbsoft.laser.service.project.service.ProProjectService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProProjectCskuServiceImpl
extends BaseServiceImpl
implements ProProjectCskuService {
    private static final String SYS_CODE = "pro.ProProjectCskuServiceImpl";
    private ProProjectCskuMapper proProjectCskuMapper;
    private ProProjectCustrelService proProjectCustrelService;
    private ProProjectService proProjectService;

    public void setProProjectCskuMapper(ProProjectCskuMapper proProjectCskuMapper) {
        this.proProjectCskuMapper = proProjectCskuMapper;
    }

    public void setProProjectCustrelService(ProProjectCustrelService proProjectCustrelService) {
        this.proProjectCustrelService = proProjectCustrelService;
    }

    public void setProProjectService(ProProjectService proProjectService) {
        this.proProjectService = proProjectService;
    }

    private Date getSysDate() {
        try {
            return this.proProjectCskuMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectCskuServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProjectCsku(ProProjectCskuDomain proProjectCskuDomain) {
        if (null == proProjectCskuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)proProjectCskuDomain.getMemberCode())) {
            msg = msg + "MemberCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)proProjectCskuDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setProjectCskuDefault(ProProjectCsku proProjectCsku) {
        OrgCompany orgCompany;
        String json;
        if (null == proProjectCsku) {
            return;
        }
        if (null == proProjectCsku.getDataState()) {
            proProjectCsku.setDataState(0);
        }
        if (null == proProjectCsku.getGmtCreate()) {
            proProjectCsku.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)proProjectCsku.getCompanyCode()) && StringUtils.isNotBlank((String)(json = DisUtil.getMap((String)"OrgCompany-all", (String)(proProjectCsku.getMemberCode() + "-" + proProjectCsku.getTenantCode())))) && null != (orgCompany = (OrgCompany)JsonUtil.buildNormalBinder().getJsonToObject(json, OrgCompany.class))) {
            proProjectCsku.setCompanyCode(orgCompany.getCompanyCode());
            proProjectCsku.setCompanyShortname(orgCompany.getCompanyShortname());
        }
        proProjectCsku.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)proProjectCsku.getProjectCskuCode())) {
            proProjectCsku.setProjectCskuCode(this.createUUIDString());
        }
    }

    private int getProjectCskuMaxCode() {
        int code = 0;
        try {
            return this.proProjectCskuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectCskuServiceImpl.getProjectCskuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProjectCskuUpdataDefault(ProProjectCsku proProjectCsku) {
        if (null == proProjectCsku) {
            return;
        }
        proProjectCsku.setGmtModified(this.getSysDate());
    }

    private void saveProjectCskuModel(ProProjectCsku proProjectCsku) throws ApiException {
        if (null == proProjectCsku) {
            return;
        }
        try {
            this.proProjectCskuMapper.insert(proProjectCsku);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.saveProjectCskuModel.ex", (Throwable)e);
        }
    }

    private void saveProjectCskuBatchModel(List<ProProjectCsku> proProjectCskuList) throws ApiException {
        if (null == proProjectCskuList || proProjectCskuList.isEmpty()) {
            return;
        }
        try {
            this.proProjectCskuMapper.insertBatch(proProjectCskuList);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.saveProjectCskuBatchModel.ex", (Throwable)e);
        }
    }

    private ProProjectCsku getProjectCskuModelById(Integer projectCskuId) {
        if (null == projectCskuId) {
            return null;
        }
        try {
            return this.proProjectCskuMapper.selectByPrimaryKey(projectCskuId);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectCskuServiceImpl.getProjectCskuModelById", (Throwable)e);
            return null;
        }
    }

    private ProProjectCsku getProjectCskuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.proProjectCskuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectCskuServiceImpl.getProjectCskuModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delProjectCskuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectCskuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.delProjectCskuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.delProjectCskuModelByCode.num");
        }
    }

    private void deleteProjectCskuModel(Integer projectCskuId) throws ApiException {
        if (null == projectCskuId) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectCskuMapper.deleteByPrimaryKey(projectCskuId);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.deleteProjectCskuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.deleteProjectCskuModel.num");
        }
    }

    private void updateProjectCskuModel(ProProjectCsku proProjectCsku) throws ApiException {
        if (null == proProjectCsku) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectCskuMapper.updateByPrimaryKeySelective(proProjectCsku);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.updateProjectCskuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.updateProjectCskuModel.num");
        }
    }

    private void updateStateProjectCskuModel(Integer projectCskuId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == projectCskuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectCskuId", projectCskuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.proProjectCskuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.updateStateProjectCskuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.updateStateProjectCskuModel.null");
        }
    }

    private void updateStateProjectCskuModelByCode(String tenantCode, String projectCskuCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)projectCskuCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectCskuCode", projectCskuCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.proProjectCskuMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.updateStateProjectCskuModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.updateStateProjectCskuModelByCode.null");
        }
    }

    private ProProjectCsku makeProjectCsku(ProProjectCskuDomain proProjectCskuDomain, ProProjectCsku proProjectCsku) {
        if (null == proProjectCskuDomain) {
            return null;
        }
        if (null == proProjectCsku) {
            proProjectCsku = new ProProjectCsku();
        }
        try {
            BeanUtils.copyAllPropertys((Object)proProjectCsku, (Object)proProjectCskuDomain);
            return proProjectCsku;
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectCskuServiceImpl.makeProjectCsku", (Throwable)e);
            return null;
        }
    }

    private ProProjectCskuReDomain makeProProjectCskuReDomain(ProProjectCsku proProjectCsku) {
        if (null == proProjectCsku) {
            return null;
        }
        ProProjectCskuReDomain proProjectCskuReDomain = new ProProjectCskuReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)proProjectCskuReDomain, (Object)proProjectCsku);
            return proProjectCskuReDomain;
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectCskuServiceImpl.makeProProjectCskuReDomain", (Throwable)e);
            return null;
        }
    }

    private List<ProProjectCsku> queryProjectCskuModelPage(Map<String, Object> parammap) {
        try {
            return this.proProjectCskuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectCskuServiceImpl.queryProjectCskuModel", (Throwable)e);
            return null;
        }
    }

    private int countProjectCsku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.proProjectCskuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectCskuServiceImpl.countProjectCsku", (Throwable)e);
        }
        return i;
    }

    private ProProjectCsku createProProjectCsku(ProProjectCskuDomain proProjectCskuDomain) {
        String msg = this.checkProjectCsku(proProjectCskuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.saveProjectCsku.checkProjectCsku", msg);
        }
        ProProjectCsku proProjectCsku = this.makeProjectCsku(proProjectCskuDomain, null);
        this.setProjectCskuDefault(proProjectCsku);
        if (StringUtils.isBlank((String)proProjectCsku.getCustrelCode())) {
            this.saveCusetrel(proProjectCsku);
        }
        this.saveCustrel(proProjectCskuDomain);
        return proProjectCsku;
    }

    private ProProjectCustrelDomain makeCustrel(ProProjectCskuDomain proProjectCskuDomain, ProProjectCustrel proProjectCustrel) {
        if (null == proProjectCskuDomain) {
            return null;
        }
        ProProjectCustrelDomain proProjectCustrelDomain = new ProProjectCustrelDomain();
        if (null != proProjectCustrel) {
            try {
                BeanUtils.copyAllPropertys((Object)proProjectCustrelDomain, (Object)proProjectCustrel);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        proProjectCustrelDomain.setCompanyCode(proProjectCskuDomain.getCompanyCode());
        proProjectCustrelDomain.setCustrelCode(proProjectCskuDomain.getCustrelCode());
        proProjectCustrelDomain.setCustrelName(proProjectCskuDomain.getCustrelName());
        proProjectCustrelDomain.setEmployeeCode(proProjectCskuDomain.getEmployeeCode());
        proProjectCustrelDomain.setEmployeeName(proProjectCskuDomain.getEmployeeName());
        proProjectCustrelDomain.setProjectCode(proProjectCskuDomain.getGoodsNo());
        ProProject proProject = this.proProjectService.getProjectByCode(proProjectCskuDomain.getTenantCode(), proProjectCskuDomain.getGoodsNo());
        if (null == proProject) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.makeCustrel.proProject");
        }
        proProjectCustrelDomain.setProjectName(proProject.getProjectName());
        proProjectCustrelDomain.setTenantCode(proProjectCskuDomain.getTenantCode());
        return proProjectCustrelDomain;
    }

    private void saveCusetrel(ProProjectCsku proProjectCsku) {
        if (null == proProjectCsku || StringUtils.isBlank((String)proProjectCsku.getCompanyCode())) {
            return;
        }
        String apiCode = "ct.custrel.saveCustrelByUserinfoCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", proProjectCsku.getMemberBcode());
        paramMap.put("employeeCode", proProjectCsku.getEmployeeCode());
        paramMap.put("companyCode", proProjectCsku.getCompanyCode());
        paramMap.put("tenantCode", proProjectCsku.getTenantCode());
        String json = this.internalInvoke(apiCode, paramMap);
        if (StringUtils.isBlank((String)json)) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.saveCusetrel.json");
        }
        CtCustrel ctCustrel = (CtCustrel)JsonUtil.buildNormalBinder().getJsonToObject(json, CtCustrel.class);
        if (null == ctCustrel) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.saveCusetrel.ctCustrel");
        }
        proProjectCsku.setCustrelCode(ctCustrel.getCustrelCode());
        proProjectCsku.setCustrelName(ctCustrel.getCustrelName());
        proProjectCsku.setMemberContactPhone(ctCustrel.getCustrelConPhone());
        proProjectCsku.setMemberContactQq(ctCustrel.getCustrelConQq());
    }

    @Override
    public String saveProjectCsku(ProProjectCskuDomain proProjectCskuDomain) throws ApiException {
        ProProjectCsku proProjectCsku = this.createProProjectCsku(proProjectCskuDomain);
        this.saveProjectCskuModel(proProjectCsku);
        return proProjectCsku.getProjectCskuCode();
    }

    @Override
    public String saveProjectCskuBatch(List<ProProjectCskuDomain> proProjectCskuDomainList) throws ApiException {
        if (null == proProjectCskuDomainList || proProjectCskuDomainList.isEmpty()) {
            return null;
        }
        ArrayList<ProProjectCsku> proProjectCskuList = new ArrayList<ProProjectCsku>();
        String code = "";
        for (ProProjectCskuDomain proProjectCskuDomain : proProjectCskuDomainList) {
            this.logger.error("proProjectCskuDomain+++++++++" + JsonUtil.buildNonDefaultBinder().toJson((Object)proProjectCskuDomain));
            ProProjectCsku proProjectCsku = this.createProProjectCsku(proProjectCskuDomain);
            code = proProjectCsku.getProjectCskuCode();
            proProjectCskuList.add(proProjectCsku);
        }
        this.saveProjectCskuBatchModel(proProjectCskuList);
        return code;
    }

    @Override
    public void updateProjectCskuState(Integer projectCskuId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectCskuModel(projectCskuId, dataState, oldDataState);
    }

    @Override
    public void updateProjectCskuStateByCode(String tenantCode, String projectCskuCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectCskuModelByCode(tenantCode, projectCskuCode, dataState, oldDataState);
    }

    @Override
    public void updateProjectCsku(ProProjectCskuDomain proProjectCskuDomain) throws ApiException {
        String msg = this.checkProjectCsku(proProjectCskuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.updateProjectCsku.checkProjectCsku", msg);
        }
        ProProjectCsku oldProProjectCsku = this.getProjectCskuModelById(proProjectCskuDomain.getProjectCskuId());
        if (null == oldProProjectCsku) {
            throw new ApiException("pro.ProProjectCskuServiceImpl.updateProjectCsku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ProProjectCsku proProjectCsku = this.makeProjectCsku(proProjectCskuDomain, oldProProjectCsku);
        this.saveCusetrel(proProjectCsku);
        this.setProjectCskuUpdataDefault(proProjectCsku);
        this.updateProjectCskuModel(proProjectCsku);
        this.saveCustrel(proProjectCskuDomain);
    }

    private void saveCustrel(ProProjectCskuDomain proProjectCskuDomain) {
        if (null == proProjectCskuDomain || StringUtils.isBlank((String)proProjectCskuDomain.getCompanyCode())) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("companyCode", proProjectCskuDomain.getCompanyCode());
        paramMap.put("custrelCode", proProjectCskuDomain.getCustrelCode());
        paramMap.put("projectCode", proProjectCskuDomain.getGoodsNo());
        paramMap.put("tenantCode", proProjectCskuDomain.getTenantCode());
        QueryResult<ProProjectCustrel> qlist = this.proProjectCustrelService.queryProjectCustrelPage(paramMap);
        this.logger.error("qlist+++" + JsonUtil.buildNonDefaultBinder().toJson(qlist));
        if (null == qlist || null == qlist.getRows() || qlist.getRows().isEmpty()) {
            ProProjectCustrelDomain proProjectCustrelDomain = this.makeCustrel(proProjectCskuDomain, null);
            this.proProjectCustrelService.saveProjectCustrel(proProjectCustrelDomain);
        } else {
            ProProjectCustrelDomain proProjectCustrelDomain = this.makeCustrel(proProjectCskuDomain, (ProProjectCustrel)qlist.getList().get(0));
            this.logger.error("proProjectCustrelDomain+++" + JsonUtil.buildNonDefaultBinder().toJson((Object)proProjectCustrelDomain));
            this.proProjectCustrelService.updateProjectCustrel(proProjectCustrelDomain);
        }
    }

    @Override
    public ProProjectCsku getProjectCsku(Integer projectCskuId) {
        return this.getProjectCskuModelById(projectCskuId);
    }

    @Override
    public void deleteProjectCsku(Integer projectCskuId) throws ApiException {
        this.deleteProjectCskuModel(projectCskuId);
    }

    @Override
    public QueryResult<ProProjectCsku> queryProjectCskuPage(Map<String, Object> map) {
        List<ProProjectCsku> proProjectCskuList = this.queryProjectCskuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProjectCsku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(proProjectCskuList);
        return queryResult;
    }

    @Override
    public ProProjectCsku getProjectCskuByCode(String tenantCode, String projectCskuCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectCskuCode", projectCskuCode);
        return this.getProjectCskuModelByCode(map);
    }

    @Override
    public void deleteProjectCskuByCode(String tenantCode, String projectCskuCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectCskuCode", projectCskuCode);
        this.delProjectCskuModelByCode(map);
    }

    @Override
    public OcReorderDomain saveProjectCskuBatchByCon(List<ProProjectCskuDomain> proProjectCskuDomainList) throws ApiException {
        String code = this.saveProjectCskuBatch(proProjectCskuDomainList);
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        ocReorderDomain.setContractBillcode(proProjectCskuDomainList.get(0).getContractBillcode());
        ocReorderDomain.setReorderCode(code);
        ocReorderDomain.setTenantCode(proProjectCskuDomainList.get(0).getTenantCode());
        if (StringUtils.isBlank((String)code)) {
            ocReorderDomain.setOrderState("3");
        } else {
            ocReorderDomain.setOrderState("2");
        }
        return ocReorderDomain;
    }
}

