/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.project.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.project.dao.ProProjectCskuMapper;
import com.yqbsoft.laser.service.project.dao.ProProjectCustrelMapper;
import com.yqbsoft.laser.service.project.dao.ProProjectFileMapper;
import com.yqbsoft.laser.service.project.dao.ProProjectMapper;
import com.yqbsoft.laser.service.project.dao.ProProjectSpecMapper;
import com.yqbsoft.laser.service.project.dao.ProProjectValueMapper;
import com.yqbsoft.laser.service.project.domain.ActCommonDomain;
import com.yqbsoft.laser.service.project.domain.ProProjectCskuDomain;
import com.yqbsoft.laser.service.project.domain.ProProjectCustrelDomain;
import com.yqbsoft.laser.service.project.domain.ProProjectDomain;
import com.yqbsoft.laser.service.project.domain.ProProjectFileDomain;
import com.yqbsoft.laser.service.project.domain.ProProjectFileReDomain;
import com.yqbsoft.laser.service.project.domain.ProProjectReDomain;
import com.yqbsoft.laser.service.project.domain.ProProjectSpecDomain;
import com.yqbsoft.laser.service.project.domain.ProProjectSpecReDomain;
import com.yqbsoft.laser.service.project.domain.ProProjectValueDomain;
import com.yqbsoft.laser.service.project.domain.ProProjectValueReDomain;
import com.yqbsoft.laser.service.project.model.ProProject;
import com.yqbsoft.laser.service.project.model.ProProjectCsku;
import com.yqbsoft.laser.service.project.model.ProProjectCustrel;
import com.yqbsoft.laser.service.project.model.ProProjectFile;
import com.yqbsoft.laser.service.project.model.ProProjectSpec;
import com.yqbsoft.laser.service.project.model.ProProjectValue;
import com.yqbsoft.laser.service.project.service.ProProjectService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProProjectServiceImpl
extends BaseServiceImpl
implements ProProjectService {
    private static final String SYS_CODE = "pro.ProProjectServiceImpl";
    private ProProjectMapper proProjectMapper;
    private ProProjectFileMapper proProjectFileMapper;
    private ProProjectSpecMapper proProjectSpecMapper;
    private ProProjectValueMapper proProjectValueMapper;
    private ProProjectCskuMapper proProjectCskuMapper;
    private ProProjectCustrelMapper proProjectCustrelMapper;

    public void setProProjectMapper(ProProjectMapper proProjectMapper) {
        this.proProjectMapper = proProjectMapper;
    }

    public void setProProjectFileMapper(ProProjectFileMapper proProjectFileMapper) {
        this.proProjectFileMapper = proProjectFileMapper;
    }

    public void setProProjectSpecMapper(ProProjectSpecMapper proProjectSpecMapper) {
        this.proProjectSpecMapper = proProjectSpecMapper;
    }

    public void setProProjectValueMapper(ProProjectValueMapper proProjectValueMapper) {
        this.proProjectValueMapper = proProjectValueMapper;
    }

    public void setProProjectCskuMapper(ProProjectCskuMapper proProjectCskuMapper) {
        this.proProjectCskuMapper = proProjectCskuMapper;
    }

    public void setProProjectCustrelMapper(ProProjectCustrelMapper proProjectCustrelMapper) {
        this.proProjectCustrelMapper = proProjectCustrelMapper;
    }

    private Date getSysDate() {
        try {
            return this.proProjectMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkProject(ProProjectDomain proProjectDomain) {
        if (null == proProjectDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)proProjectDomain.getCompanyCode())) {
            msg = msg + "CompanyCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)proProjectDomain.getProjectOcode())) {
            msg = msg + "ProjectOcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)proProjectDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setProjectDefault(ProProject proProject) {
        if (null == proProject) {
            return;
        }
        if (null == proProject.getDataState()) {
            proProject.setDataState(2);
        }
        if (null == proProject.getGmtCreate()) {
            proProject.setGmtCreate(this.getSysDate());
        }
        proProject.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)proProject.getProjectCode())) {
            proProject.setProjectCode(this.createUUIDString());
        }
    }

    private int getProjectMaxCode() {
        int code = 0;
        try {
            return this.proProjectMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.getProjectMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProjectUpdataDefault(ProProject proProject) {
        if (null == proProject) {
            return;
        }
        proProject.setGmtModified(this.getSysDate());
    }

    private void saveProjectModel(ProProject proProject) throws ApiException {
        if (null == proProject) {
            return;
        }
        try {
            this.proProjectMapper.insert(proProject);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.saveProjectModel.ex", (Throwable)e);
        }
    }

    private void saveProjectBatchModel(List<ProProject> proProjectList) throws ApiException {
        if (null == proProjectList || proProjectList.isEmpty()) {
            return;
        }
        try {
            this.proProjectMapper.insertBatch(proProjectList);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.saveProjectBatchModel.ex", (Throwable)e);
        }
    }

    private ProProject getProjectModelById(Integer projectId) {
        if (null == projectId) {
            return null;
        }
        try {
            return this.proProjectMapper.selectByPrimaryKey(projectId);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.getProjectModelById", (Throwable)e);
            return null;
        }
    }

    private ProProject getProjectModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.proProjectMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.getProjectModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delProjectModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.delProjectModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectServiceImpl.delProjectModelByCode.num");
        }
    }

    private void deleteProjectModel(Integer projectId) throws ApiException {
        if (null == projectId) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectMapper.deleteByPrimaryKey(projectId);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.deleteProjectModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectServiceImpl.deleteProjectModel.num");
        }
    }

    private void updateProjectModel(ProProject proProject) throws ApiException {
        if (null == proProject) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectMapper.updateByPrimaryKeySelective(proProject);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.updateProjectModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectServiceImpl.updateProjectModel.num");
        }
    }

    private void updateStateProjectModel(Integer projectId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == projectId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectId", projectId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.proProjectMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.updateStateProjectModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pro.ProProjectServiceImpl.updateStateProjectModel.null");
        }
    }

    private void updateStateProjectModelByCode(String tenantCode, String projectCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)projectCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectCode", projectCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.proProjectMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.updateStateProjectModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pro.ProProjectServiceImpl.updateStateProjectModelByCode.null");
        }
    }

    private void updateReleaseProjectModelByCode(String tenantCode, String projectCode, Integer projectState, Integer oldProjectState) throws ApiException {
        if (StringUtils.isBlank((String)projectCode) || null == projectState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectCode", projectCode);
        map.put("projectState", projectState);
        map.put("oldProjectState", oldProjectState);
        int i = 0;
        try {
            i = this.proProjectMapper.updateReleaseByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.updateReleaseProjectModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pro.ProProjectServiceImpl.updateReleaseProjectModelByCode.null");
        }
    }

    private ProProject makeProject(ProProjectDomain proProjectDomain, ProProject proProject) {
        if (null == proProjectDomain) {
            return null;
        }
        if (null == proProject) {
            proProject = new ProProject();
        }
        try {
            BeanUtils.copyAllPropertys((Object)proProject, (Object)proProjectDomain);
            return proProject;
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.makeProject", (Throwable)e);
            return null;
        }
    }

    private ProProjectReDomain makeProProjectReDomain(ProProject proProject) {
        if (null == proProject) {
            return null;
        }
        ProProjectReDomain proProjectReDomain = new ProProjectReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)proProjectReDomain, (Object)proProject);
            return proProjectReDomain;
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.makeProProjectReDomain", (Throwable)e);
            return null;
        }
    }

    private List<ProProject> queryProjectModelPage(Map<String, Object> parammap) {
        try {
            return this.proProjectMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.queryProjectModel", (Throwable)e);
            return null;
        }
    }

    private int countProject(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.proProjectMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.countProject", (Throwable)e);
        }
        return i;
    }

    private ProProject createProProject(ProProjectDomain proProjectDomain) {
        String msg = this.checkProject(proProjectDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pro.ProProjectServiceImpl.saveProject.checkProject", msg);
        }
        ProProject proProject = this.makeProject(proProjectDomain, null);
        this.setProjectDefault(proProject);
        return proProject;
    }

    private String checkProjectFile(ProProjectFileDomain proProjectFileDomain) {
        if (null == proProjectFileDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)proProjectFileDomain.getProjectCode())) {
            msg = msg + "ProjectCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)proProjectFileDomain.getProjectFileUrl())) {
            msg = msg + "ProjectFileUrl\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)proProjectFileDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setProjectFileDefault(ProProjectFile proProjectFile) {
        if (null == proProjectFile) {
            return;
        }
        if (null == proProjectFile.getDataState()) {
            proProjectFile.setDataState(0);
        }
        if (null == proProjectFile.getGmtCreate()) {
            proProjectFile.setGmtCreate(this.getSysDate());
        }
        proProjectFile.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)proProjectFile.getProjectFileCode())) {
            proProjectFile.setProjectFileCode(this.createUUIDString());
        }
    }

    private int getProjectFileMaxCode() {
        int code = 0;
        try {
            return this.proProjectFileMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.getProjectFileMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProjectFileUpdataDefault(ProProjectFile proProjectFile) {
        if (null == proProjectFile) {
            return;
        }
        proProjectFile.setGmtModified(this.getSysDate());
    }

    private void saveProjectFileModel(ProProjectFile proProjectFile) throws ApiException {
        if (null == proProjectFile) {
            return;
        }
        try {
            this.proProjectFileMapper.insert(proProjectFile);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.saveProjectFileModel.ex", (Throwable)e);
        }
    }

    private void saveProjectFileBatchModel(List<ProProjectFile> proProjectFileList) throws ApiException {
        if (null == proProjectFileList || proProjectFileList.isEmpty()) {
            return;
        }
        try {
            this.proProjectFileMapper.insertBatch(proProjectFileList);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.saveProjectFileBatchModel.ex", (Throwable)e);
        }
    }

    private ProProjectFile getProjectFileModelById(Integer projectFileId) {
        if (null == projectFileId) {
            return null;
        }
        try {
            return this.proProjectFileMapper.selectByPrimaryKey(projectFileId);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.getProjectFileModelById", (Throwable)e);
            return null;
        }
    }

    private ProProjectFile getProjectFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.proProjectFileMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.getProjectFileModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delProjectFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectFileMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.delProjectFileModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectServiceImpl.delProjectFileModelByCode.num");
        }
    }

    private void deleteProjectFileModel(Integer projectFileId) throws ApiException {
        if (null == projectFileId) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectFileMapper.deleteByPrimaryKey(projectFileId);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.deleteProjectFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectServiceImpl.deleteProjectFileModel.num");
        }
    }

    private void updateProjectFileModel(ProProjectFile proProjectFile) throws ApiException {
        if (null == proProjectFile) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectFileMapper.updateByPrimaryKeySelective(proProjectFile);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.updateProjectFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectServiceImpl.updateProjectFileModel.num");
        }
    }

    private void updateStateProjectFileModel(Integer projectFileId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == projectFileId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectFileId", projectFileId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.proProjectFileMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.updateStateProjectFileModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pro.ProProjectServiceImpl.updateStateProjectFileModel.null");
        }
    }

    private void updateStateProjectFileModelByCode(String tenantCode, String projectFileCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)projectFileCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectFileCode", projectFileCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.proProjectFileMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.updateStateProjectFileModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pro.ProProjectServiceImpl.updateStateProjectFileModelByCode.null");
        }
    }

    private ProProjectFile makeProjectFile(ProProjectFileDomain proProjectFileDomain, ProProjectFile proProjectFile) {
        if (null == proProjectFileDomain) {
            return null;
        }
        if (null == proProjectFile) {
            proProjectFile = new ProProjectFile();
        }
        try {
            BeanUtils.copyAllPropertys((Object)proProjectFile, (Object)proProjectFileDomain);
            return proProjectFile;
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.makeProjectFile", (Throwable)e);
            return null;
        }
    }

    private ProProjectFileReDomain makeProProjectFileReDomain(ProProjectFile proProjectFile) {
        if (null == proProjectFile) {
            return null;
        }
        ProProjectFileReDomain proProjectFileReDomain = new ProProjectFileReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)proProjectFileReDomain, (Object)proProjectFile);
            return proProjectFileReDomain;
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.makeProProjectFileReDomain", (Throwable)e);
            return null;
        }
    }

    private List<ProProjectFile> queryProjectFileModelPage(Map<String, Object> parammap) {
        try {
            return this.proProjectFileMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.queryProjectFileModel", (Throwable)e);
            return null;
        }
    }

    private int countProjectFile(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.proProjectFileMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.countProjectFile", (Throwable)e);
        }
        return i;
    }

    private ProProjectFile createProProjectFile(ProProjectFileDomain proProjectFileDomain) {
        String msg = this.checkProjectFile(proProjectFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pro.ProProjectServiceImpl.saveProjectFile.checkProjectFile", msg);
        }
        ProProjectFile proProjectFile = this.makeProjectFile(proProjectFileDomain, null);
        this.setProjectFileDefault(proProjectFile);
        return proProjectFile;
    }

    private String checkProjectSpec(ProProjectSpecDomain proProjectSpecDomain) {
        if (null == proProjectSpecDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)proProjectSpecDomain.getProjectCode())) {
            msg = msg + "ProjectCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)proProjectSpecDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setProjectSpecDefault(ProProjectSpec proProjectSpec) {
        if (null == proProjectSpec) {
            return;
        }
        if (null == proProjectSpec.getDataState()) {
            proProjectSpec.setDataState(0);
        }
        if (null == proProjectSpec.getGmtCreate()) {
            proProjectSpec.setGmtCreate(this.getSysDate());
        }
        proProjectSpec.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)proProjectSpec.getProjectSpecCode())) {
            proProjectSpec.setProjectSpecCode(this.createUUIDString());
        }
    }

    private int getProjectSpecMaxCode() {
        int code = 0;
        try {
            return this.proProjectSpecMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.getProjectSpecMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProjectSpecUpdataDefault(ProProjectSpec proProjectSpec) {
        if (null == proProjectSpec) {
            return;
        }
        proProjectSpec.setGmtModified(this.getSysDate());
    }

    private void saveProjectSpecModel(ProProjectSpec proProjectSpec) throws ApiException {
        if (null == proProjectSpec) {
            return;
        }
        try {
            this.proProjectSpecMapper.insert(proProjectSpec);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.saveProjectSpecModel.ex", (Throwable)e);
        }
    }

    private void saveProjectSpecBatchModel(List<ProProjectSpec> proProjectSpecList) throws ApiException {
        if (null == proProjectSpecList || proProjectSpecList.isEmpty()) {
            return;
        }
        try {
            this.proProjectSpecMapper.insertBatch(proProjectSpecList);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.saveProjectSpecBatchModel.ex", (Throwable)e);
        }
    }

    private ProProjectSpec getProjectSpecModelById(Integer projectSpecId) {
        if (null == projectSpecId) {
            return null;
        }
        try {
            return this.proProjectSpecMapper.selectByPrimaryKey(projectSpecId);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.getProjectSpecModelById", (Throwable)e);
            return null;
        }
    }

    private ProProjectSpec getProjectSpecModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.proProjectSpecMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.getProjectSpecModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delProjectSpecModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectSpecMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.delProjectSpecModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectServiceImpl.delProjectSpecModelByCode.num");
        }
    }

    private void deleteProjectSpecModel(Integer projectSpecId) throws ApiException {
        if (null == projectSpecId) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectSpecMapper.deleteByPrimaryKey(projectSpecId);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.deleteProjectSpecModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectServiceImpl.deleteProjectSpecModel.num");
        }
    }

    private void updateProjectSpecModel(ProProjectSpec proProjectSpec) throws ApiException {
        if (null == proProjectSpec) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectSpecMapper.updateByPrimaryKeySelective(proProjectSpec);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.updateProjectSpecModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectServiceImpl.updateProjectSpecModel.num");
        }
    }

    private void updateStateProjectSpecModel(Integer projectSpecId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == projectSpecId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectSpecId", projectSpecId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.proProjectSpecMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.updateStateProjectSpecModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pro.ProProjectServiceImpl.updateStateProjectSpecModel.null");
        }
    }

    private void updateStateProjectSpecModelByCode(String tenantCode, String projectSpecCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)projectSpecCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectSpecCode", projectSpecCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.proProjectSpecMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.updateStateProjectSpecModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pro.ProProjectServiceImpl.updateStateProjectSpecModelByCode.null");
        }
    }

    private ProProjectSpec makeProjectSpec(ProProjectSpecDomain proProjectSpecDomain, ProProjectSpec proProjectSpec) {
        if (null == proProjectSpecDomain) {
            return null;
        }
        if (null == proProjectSpec) {
            proProjectSpec = new ProProjectSpec();
        }
        try {
            BeanUtils.copyAllPropertys((Object)proProjectSpec, (Object)proProjectSpecDomain);
            return proProjectSpec;
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.makeProjectSpec", (Throwable)e);
            return null;
        }
    }

    private ProProjectSpecReDomain makeProProjectSpecReDomain(ProProjectSpec proProjectSpec) {
        if (null == proProjectSpec) {
            return null;
        }
        ProProjectSpecReDomain proProjectSpecReDomain = new ProProjectSpecReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)proProjectSpecReDomain, (Object)proProjectSpec);
            return proProjectSpecReDomain;
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.makeProProjectSpecReDomain", (Throwable)e);
            return null;
        }
    }

    private List<ProProjectSpec> queryProjectSpecModelPage(Map<String, Object> parammap) {
        try {
            return this.proProjectSpecMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.queryProjectSpecModel", (Throwable)e);
            return null;
        }
    }

    private int countProjectSpec(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.proProjectSpecMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.countProjectSpec", (Throwable)e);
        }
        return i;
    }

    private ProProjectSpec createProProjectSpec(ProProjectSpecDomain proProjectSpecDomain) {
        String msg = this.checkProjectSpec(proProjectSpecDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pro.ProProjectServiceImpl.saveProjectSpec.checkProjectSpec", msg);
        }
        ProProjectSpec proProjectSpec = this.makeProjectSpec(proProjectSpecDomain, null);
        this.setProjectSpecDefault(proProjectSpec);
        return proProjectSpec;
    }

    private String checkProjectValue(ProProjectValueDomain proProjectValueDomain) {
        if (null == proProjectValueDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)proProjectValueDomain.getProjectCode())) {
            msg = msg + "ProjectCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)proProjectValueDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setProjectValueDefault(ProProjectValue proProjectValue) {
        if (null == proProjectValue) {
            return;
        }
        if (null == proProjectValue.getDataState()) {
            proProjectValue.setDataState(0);
        }
        if (null == proProjectValue.getGmtCreate()) {
            proProjectValue.setGmtCreate(this.getSysDate());
        }
        proProjectValue.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)proProjectValue.getProjectValueCode())) {
            proProjectValue.setProjectValueCode(this.createUUIDString());
        }
    }

    private int getProjectValueMaxCode() {
        int code = 0;
        try {
            return this.proProjectValueMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.getProjectValueMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setProjectValueUpdataDefault(ProProjectValue proProjectValue) {
        if (null == proProjectValue) {
            return;
        }
        proProjectValue.setGmtModified(this.getSysDate());
    }

    private void saveProjectValueModel(ProProjectValue proProjectValue) throws ApiException {
        if (null == proProjectValue) {
            return;
        }
        try {
            this.proProjectValueMapper.insert(proProjectValue);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.saveProjectValueModel.ex", (Throwable)e);
        }
    }

    private void saveProjectValueBatchModel(List<ProProjectValue> proProjectValueList) throws ApiException {
        if (null == proProjectValueList || proProjectValueList.isEmpty()) {
            return;
        }
        try {
            this.proProjectValueMapper.insertBatch(proProjectValueList);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.saveProjectValueBatchModel.ex", (Throwable)e);
        }
    }

    private ProProjectValue getProjectValueModelById(Integer projectValueId) {
        if (null == projectValueId) {
            return null;
        }
        try {
            return this.proProjectValueMapper.selectByPrimaryKey(projectValueId);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.getProjectValueModelById", (Throwable)e);
            return null;
        }
    }

    private ProProjectValue getProjectValueModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.proProjectValueMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.getProjectValueModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delProjectValueModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectValueMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.delProjectValueModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectServiceImpl.delProjectValueModelByCode.num");
        }
    }

    private void delProjectValueModelByProjectCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.proProjectValueMapper.delByProjectCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.delProjectValueModelByProjectCode.ex", (Throwable)e);
        }
    }

    private void delProjectFileModelByProjectCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.proProjectFileMapper.delByProjectCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.delProjectFileModelByProjectCode.ex", (Throwable)e);
        }
    }

    private void delProjectSpecModelByProjectCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.proProjectSpecMapper.delByProjectCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.delProjectSpecModelByProjectCode.ex", (Throwable)e);
        }
    }

    private void deleteProjectValueModel(Integer projectValueId) throws ApiException {
        if (null == projectValueId) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectValueMapper.deleteByPrimaryKey(projectValueId);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.deleteProjectValueModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectServiceImpl.deleteProjectValueModel.num");
        }
    }

    private void updateProjectValueModel(ProProjectValue proProjectValue) throws ApiException {
        if (null == proProjectValue) {
            return;
        }
        int i = 0;
        try {
            i = this.proProjectValueMapper.updateByPrimaryKeySelective(proProjectValue);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.updateProjectValueModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("pro.ProProjectServiceImpl.updateProjectValueModel.num");
        }
    }

    private void updateStateProjectValueModel(Integer projectValueId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == projectValueId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectValueId", projectValueId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.proProjectValueMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.updateStateProjectValueModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pro.ProProjectServiceImpl.updateStateProjectValueModel.null");
        }
    }

    private void updateStateProjectValueModelByCode(String tenantCode, String projectValueCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)projectValueCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectValueCode", projectValueCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.proProjectValueMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("pro.ProProjectServiceImpl.updateStateProjectValueModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("pro.ProProjectServiceImpl.updateStateProjectValueModelByCode.null");
        }
    }

    private ProProjectValue makeProjectValue(ProProjectValueDomain proProjectValueDomain, ProProjectValue proProjectValue) {
        if (null == proProjectValueDomain) {
            return null;
        }
        if (null == proProjectValue) {
            proProjectValue = new ProProjectValue();
        }
        try {
            BeanUtils.copyAllPropertys((Object)proProjectValue, (Object)proProjectValueDomain);
            return proProjectValue;
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.makeProjectValue", (Throwable)e);
            return null;
        }
    }

    private ProProjectValueReDomain makeProProjectValueReDomain(ProProjectValue proProjectValue) {
        if (null == proProjectValue) {
            return null;
        }
        ProProjectValueReDomain proProjectValueReDomain = new ProProjectValueReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)proProjectValueReDomain, (Object)proProjectValue);
            return proProjectValueReDomain;
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.makeProProjectValueReDomain", (Throwable)e);
            return null;
        }
    }

    private List<ProProjectCsku> queryProProjectCskuPage(Map<String, Object> parammap) {
        try {
            return this.proProjectCskuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.queryProjectValueModel", (Throwable)e);
            return null;
        }
    }

    private List<ProProjectCustrel> queryProProjectCustrelPage(Map<String, Object> parammap) {
        try {
            return this.proProjectCustrelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.queryProjectValueModel", (Throwable)e);
            return null;
        }
    }

    private List<ProProjectValue> queryProjectValueModelPage(Map<String, Object> parammap) {
        try {
            return this.proProjectValueMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.queryProjectValueModel", (Throwable)e);
            return null;
        }
    }

    private int countProjectValue(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.proProjectValueMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("pro.ProProjectServiceImpl.countProjectValue", (Throwable)e);
        }
        return i;
    }

    private ProProjectValue createProProjectValue(ProProjectValueDomain proProjectValueDomain) {
        String msg = this.checkProjectValue(proProjectValueDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pro.ProProjectServiceImpl.saveProjectValue.checkProjectValue", msg);
        }
        ProProjectValue proProjectValue = this.makeProjectValue(proProjectValueDomain, null);
        this.setProjectValueDefault(proProjectValue);
        return proProjectValue;
    }

    private void saveValueList(ProProject proProject, List<ProProjectValueDomain> proProjectValueDomainList) {
        if (null == proProject || null == proProjectValueDomainList || proProjectValueDomainList.isEmpty()) {
            return;
        }
        for (ProProjectValueDomain proProjectValueDomain : proProjectValueDomainList) {
            proProjectValueDomain.setProjectCode(proProject.getProjectCode());
            proProjectValueDomain.setTenantCode(proProject.getTenantCode());
            proProjectValueDomain.setAppmanageIcode(proProject.getAppmanageIcode());
        }
        this.saveProjectValueBatch(proProjectValueDomainList);
    }

    private void saveSpecList(ProProject proProject, List<ProProjectSpecDomain> proProjectSpecDomainList) {
        if (null == proProject || null == proProjectSpecDomainList || proProjectSpecDomainList.isEmpty()) {
            return;
        }
        for (ProProjectSpecDomain proProjectSpecDomain : proProjectSpecDomainList) {
            proProjectSpecDomain.setProjectCode(proProject.getProjectCode());
            proProjectSpecDomain.setTenantCode(proProject.getTenantCode());
            proProjectSpecDomain.setAppmanageIcode(proProject.getAppmanageIcode());
        }
        this.saveProjectSpecBatch(proProjectSpecDomainList);
    }

    private void saveFileList(ProProject proProject, List<ProProjectFileDomain> proProjectFileDomainList) {
        if (null == proProject || null == proProjectFileDomainList || proProjectFileDomainList.isEmpty()) {
            return;
        }
        for (ProProjectFileDomain proProjectFileDomain : proProjectFileDomainList) {
            proProjectFileDomain.setProjectCode(proProject.getProjectCode());
            proProjectFileDomain.setTenantCode(proProject.getTenantCode());
            proProjectFileDomain.setAppmanageIcode(proProject.getAppmanageIcode());
        }
        this.saveProjectFileBatch(proProjectFileDomainList);
    }

    private void updateValueList(ProProject proProject, List<ProProjectValueDomain> proProjectValueDomainList) {
        if (null == proProject) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectCode", proProject.getProjectCode());
        map.put("tenantCode", proProject.getTenantCode());
        this.delProjectValueModelByProjectCode(map);
        if (null == proProjectValueDomainList || proProjectValueDomainList.isEmpty()) {
            return;
        }
        for (ProProjectValueDomain proProjectValueDomain : proProjectValueDomainList) {
            proProjectValueDomain.setProjectCode(proProject.getProjectCode());
            proProjectValueDomain.setTenantCode(proProject.getTenantCode());
            proProjectValueDomain.setAppmanageIcode(proProject.getAppmanageIcode());
        }
        this.saveProjectValueBatch(proProjectValueDomainList);
    }

    private void updateSpecList(ProProject proProject, List<ProProjectSpecDomain> proProjectSpecDomainList) {
        if (null == proProject) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectCode", proProject.getProjectCode());
        map.put("tenantCode", proProject.getTenantCode());
        this.delProjectSpecModelByProjectCode(map);
        if (null == proProjectSpecDomainList || proProjectSpecDomainList.isEmpty()) {
            return;
        }
        for (ProProjectSpecDomain proProjectSpecDomain : proProjectSpecDomainList) {
            proProjectSpecDomain.setProjectCode(proProject.getProjectCode());
            proProjectSpecDomain.setTenantCode(proProject.getTenantCode());
            proProjectSpecDomain.setAppmanageIcode(proProject.getAppmanageIcode());
        }
        this.saveProjectSpecBatch(proProjectSpecDomainList);
    }

    private void updateFileList(ProProject proProject, List<ProProjectFileDomain> proProjectFileDomainList) {
        if (null == proProject) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectCode", proProject.getProjectCode());
        map.put("tenantCode", proProject.getTenantCode());
        this.delProjectFileModelByProjectCode(map);
        if (null == proProjectFileDomainList || proProjectFileDomainList.isEmpty()) {
            return;
        }
        for (ProProjectFileDomain proProjectFileDomain : proProjectFileDomainList) {
            proProjectFileDomain.setProjectCode(proProject.getProjectCode());
            proProjectFileDomain.setTenantCode(proProject.getTenantCode());
            proProjectFileDomain.setAppmanageIcode(proProject.getAppmanageIcode());
        }
        this.saveProjectFileBatch(proProjectFileDomainList);
    }

    @Override
    public String saveProject(ProProjectDomain proProjectDomain) throws ApiException {
        ProProject proProject = this.createProProject(proProjectDomain);
        this.saveProjectModel(proProject);
        this.saveValueList(proProject, proProjectDomain.getProProjectValueDomainList());
        this.saveSpecList(proProject, proProjectDomain.getProProjectSpecDomainList());
        this.saveFileList(proProject, proProjectDomain.getProProjectFileDomainList());
        return proProject.getProjectCode();
    }

    @Override
    public String auditCallBackApply(Map<String, Object> map) throws ApiException {
        this.logger.error("log >>> desc: sendActivity params{\u9879\u76ee\u62a5\u5907\u7533\u8bf7\u5ba1\u6279\u6d41\u56de\u8c03\u5f00\u59cb}=====");
        this.logger.error("log >>> desc: sendActivity params{map}=====", map);
        String auditStatus = map.get("auditStatus").toString();
        int projectState = 1;
        if (auditStatus.equals("NO")) {
            projectState = -1;
        }
        this.updateProjectState(Integer.valueOf(map.get("projectId").toString()), projectState, null);
        this.logger.error("log >>> desc: sendActivity params{\u9879\u76ee\u62a5\u5907\u7533\u8bf7\u5ba1\u6279\u6d41\u56de\u8c03\u7ed3\u675f}=====");
        return "success";
    }

    private void sendActivity(Integer projectId, Map<String, Object> map) {
        this.logger.error("log >>> desc: sendActivity params{\u9879\u76ee\u62a5\u5907\u6fc0\u6d3b\u5ba1\u6279\u6d41\u5f00\u59cb} =====");
        ProProjectReDomain proProjectDomain = this.getProjectReDomain(projectId);
        HashMap<String, String> actParamMap = new HashMap<String, String>();
        HashMap<String, Object> sendparamMap = new HashMap<String, Object>();
        ActCommonDomain actCommonDomain = new ActCommonDomain();
        actCommonDomain.setTenantCode(proProjectDomain.getTenantCode());
        actCommonDomain.setBusinessKey(proProjectDomain.getProjectCode());
        if ("0".equals(proProjectDomain.getProjectType())) {
            actCommonDomain.setInterfaceType("ProjectRemark");
        } else {
            actCommonDomain.setInterfaceType("ProjectSale");
        }
        actCommonDomain.setCallUrl("pro.project.auditCallBackApply");
        actCommonDomain.setParamMap(sendparamMap);
        actCommonDomain.setStartUserType("2");
        actCommonDomain.setStartUser(proProjectDomain.getEmployeeName());
        actCommonDomain.setEmployeeCode(proProjectDomain.getEmployeeCode());
        actCommonDomain.setStartName(proProjectDomain.getEmployeeName());
        actCommonDomain.setUserCode(proProjectDomain.getEmployeeCode());
        actCommonDomain.setDepartCode(proProjectDomain.getDepartCode());
        sendparamMap.put("projectId", projectId);
        sendparamMap.put("proProjectDomain", proProjectDomain);
        sendparamMap.put("title", proProjectDomain.getProjectCode() + "-" + proProjectDomain.getProjectName());
        actParamMap.put("actCommonDomain", JsonUtil.buildNormalBinder().toJson((Object)actCommonDomain));
        this.internalInvoke("act.actCommonService.activateProcess", actParamMap);
        this.logger.error("log >>> desc: sendActivity params{\u9879\u76ee\u62a5\u5907\u6fc0\u6d3b\u5ba1\u6279\u6d41\u5f00\u59cb}=====");
    }

    @Override
    public String saveProjectBatch(List<ProProjectDomain> proProjectDomainList) throws ApiException {
        if (null == proProjectDomainList || proProjectDomainList.isEmpty()) {
            return null;
        }
        ArrayList<ProProject> proProjectList = new ArrayList<ProProject>();
        String code = "";
        for (ProProjectDomain proProjectDomain : proProjectDomainList) {
            ProProject proProject = this.createProProject(proProjectDomain);
            code = proProject.getProjectCode();
            proProjectList.add(proProject);
        }
        this.saveProjectBatchModel(proProjectList);
        return code;
    }

    @Override
    public void updateProjectState(Integer projectId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectModel(projectId, dataState, oldDataState);
        if (dataState == 0) {
            this.sendActivity(projectId, null);
        }
    }

    @Override
    public void updateProjectStateByCode(String tenantCode, String projectCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectModelByCode(tenantCode, projectCode, dataState, oldDataState);
    }

    @Override
    public void updateProject(ProProjectDomain proProjectDomain) throws ApiException {
        String msg = this.checkProject(proProjectDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pro.ProProjectServiceImpl.updateProject.checkProject", msg);
        }
        ProProject oldProProject = this.getProjectModelById(proProjectDomain.getProjectId());
        if (null == oldProProject) {
            throw new ApiException("pro.ProProjectServiceImpl.updateProject.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ProProject proProject = this.makeProject(proProjectDomain, oldProProject);
        this.setProjectUpdataDefault(proProject);
        this.updateProjectModel(proProject);
        this.updateValueList(proProject, proProjectDomain.getProProjectValueDomainList());
        this.updateSpecList(proProject, proProjectDomain.getProProjectSpecDomainList());
        this.updateFileList(proProject, proProjectDomain.getProProjectFileDomainList());
    }

    @Override
    public ProProject getProject(Integer projectId) {
        return this.getProjectModelById(projectId);
    }

    @Override
    public ProProjectReDomain getProjectReDomain(Integer projectId) {
        ProProject proProject = this.getProjectModelById(projectId);
        return this.makeReDomain(proProject);
    }

    private ProProjectReDomain makeReDomain(ProProject proProject) {
        if (null == proProject) {
            return null;
        }
        ProProjectReDomain proProjectReDomain = new ProProjectReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)proProjectReDomain, (Object)proProject);
        }
        catch (Exception e) {
            return null;
        }
        this.makeDomainList(proProjectReDomain);
        return proProjectReDomain;
    }

    private void makeDomainList(ProProjectReDomain proProjectReDomain) {
        List<ProProjectCustrel> custrelList;
        List<ProProjectCsku> cskuList;
        List<ProProjectValue> valueList;
        List<ProProjectSpec> specList;
        if (null == proProjectReDomain) {
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("projectCode", proProjectReDomain.getProjectCode());
        parammap.put("tenantCode", proProjectReDomain.getTenantCode());
        List<ProProjectFile> fileList = this.queryProjectFileModelPage(parammap);
        if (null != fileList && !fileList.isEmpty()) {
            proProjectReDomain.setProProjectFileDomainList(this.makeFileListDomain(fileList));
        }
        if (null != (specList = this.queryProjectSpecModelPage(parammap)) && !specList.isEmpty()) {
            proProjectReDomain.setProProjectSpecDomainList(this.makeSpecListDomain(specList));
        }
        if (null != (valueList = this.queryProjectValueModelPage(parammap)) && !valueList.isEmpty()) {
            proProjectReDomain.setProProjectValueDomainList(this.makeValueListDomain(valueList));
        }
        if (null != (cskuList = this.queryProProjectCskuPage(parammap)) && !cskuList.isEmpty()) {
            proProjectReDomain.setProProjectCskuDomainList(this.makeCskuListDomain(cskuList));
        }
        if (null != (custrelList = this.queryProProjectCustrelPage(parammap)) && !custrelList.isEmpty()) {
            proProjectReDomain.setProProjectCustrelDomainList(this.makeCutrelListDomain(custrelList));
        }
    }

    private List<ProProjectCskuDomain> makeCskuListDomain(List<ProProjectCsku> cskuList) {
        if (null == cskuList || cskuList.isEmpty()) {
            return null;
        }
        ArrayList<ProProjectCskuDomain> proProjectValueDomainList = new ArrayList<ProProjectCskuDomain>();
        for (ProProjectCsku proProjectCsku : cskuList) {
            proProjectValueDomainList.add(this.makeValueDomain(proProjectCsku));
        }
        return proProjectValueDomainList;
    }

    private ProProjectCskuDomain makeValueDomain(ProProjectCsku proProjectValue) {
        if (null == proProjectValue) {
            return null;
        }
        ProProjectCskuDomain proProjectValueDomain = new ProProjectCskuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)proProjectValueDomain, (Object)proProjectValue);
        }
        catch (Exception e) {
            return null;
        }
        return proProjectValueDomain;
    }

    private List<ProProjectCustrelDomain> makeCutrelListDomain(List<ProProjectCustrel> custrelList) {
        if (null == custrelList || custrelList.isEmpty()) {
            return null;
        }
        ArrayList<ProProjectCustrelDomain> proProjectValueDomainList = new ArrayList<ProProjectCustrelDomain>();
        for (ProProjectCustrel proProjectCustrel : custrelList) {
            proProjectValueDomainList.add(this.makeValueDomain(proProjectCustrel));
        }
        return proProjectValueDomainList;
    }

    private ProProjectCustrelDomain makeValueDomain(ProProjectCustrel proProjectValue) {
        if (null == proProjectValue) {
            return null;
        }
        ProProjectCustrelDomain proProjectValueDomain = new ProProjectCustrelDomain();
        try {
            BeanUtils.copyAllPropertys((Object)proProjectValueDomain, (Object)proProjectValue);
        }
        catch (Exception e) {
            return null;
        }
        return proProjectValueDomain;
    }

    private List<ProProjectValueDomain> makeValueListDomain(List<ProProjectValue> valueList) {
        if (null == valueList || valueList.isEmpty()) {
            return null;
        }
        ArrayList<ProProjectValueDomain> proProjectValueDomainList = new ArrayList<ProProjectValueDomain>();
        for (ProProjectValue proProjectValue : valueList) {
            proProjectValueDomainList.add(this.makeValueDomain(proProjectValue));
        }
        return proProjectValueDomainList;
    }

    private ProProjectValueDomain makeValueDomain(ProProjectValue proProjectValue) {
        if (null == proProjectValue) {
            return null;
        }
        ProProjectValueDomain proProjectValueDomain = new ProProjectValueDomain();
        try {
            BeanUtils.copyAllPropertys((Object)proProjectValueDomain, (Object)proProjectValue);
        }
        catch (Exception e) {
            return null;
        }
        return proProjectValueDomain;
    }

    private List<ProProjectSpecDomain> makeSpecListDomain(List<ProProjectSpec> specList) {
        if (null == specList || specList.isEmpty()) {
            return null;
        }
        ArrayList<ProProjectSpecDomain> proProjectSpecDomainList = new ArrayList<ProProjectSpecDomain>();
        for (ProProjectSpec proProjectSpec : specList) {
            proProjectSpecDomainList.add(this.makeSpecDomain(proProjectSpec));
        }
        return proProjectSpecDomainList;
    }

    private ProProjectSpecDomain makeSpecDomain(ProProjectSpec proProjectSpec) {
        if (null == proProjectSpec) {
            return null;
        }
        ProProjectSpecDomain proProjectSpecDomain = new ProProjectSpecDomain();
        try {
            BeanUtils.copyAllPropertys((Object)proProjectSpecDomain, (Object)proProjectSpec);
        }
        catch (Exception e) {
            return null;
        }
        return proProjectSpecDomain;
    }

    private List<ProProjectFileDomain> makeFileListDomain(List<ProProjectFile> fileList) {
        if (null == fileList || fileList.isEmpty()) {
            return null;
        }
        ArrayList<ProProjectFileDomain> proProjectFileDomainList = new ArrayList<ProProjectFileDomain>();
        for (ProProjectFile proProjectFile : fileList) {
            proProjectFileDomainList.add(this.makeFileDomain(proProjectFile));
        }
        return proProjectFileDomainList;
    }

    private ProProjectFileDomain makeFileDomain(ProProjectFile proProjectFile) {
        if (null == proProjectFile) {
            return null;
        }
        ProProjectFileDomain proProjectFileDomain = new ProProjectFileDomain();
        try {
            BeanUtils.copyAllPropertys((Object)proProjectFileDomain, (Object)proProjectFile);
        }
        catch (Exception e) {
            return null;
        }
        return proProjectFileDomain;
    }

    @Override
    public void deleteProject(Integer projectId) throws ApiException {
        this.deleteProjectModel(projectId);
    }

    @Override
    public QueryResult<ProProject> queryProjectPage(Map<String, Object> map) {
        List<ProProject> proProjectList = this.queryProjectModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProject(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(proProjectList);
        return queryResult;
    }

    @Override
    public ProProject getProjectByCode(String tenantCode, String projectCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectCode", projectCode);
        return this.getProjectModelByCode(map);
    }

    @Override
    public ProProjectReDomain getProjectReDomainByCode(String tenantCode, String projectCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectCode", projectCode);
        ProProject proProject = this.getProjectModelByCode(map);
        return this.makeReDomain(proProject);
    }

    @Override
    public void deleteProjectByCode(String tenantCode, String projectCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectCode", projectCode);
        this.delProjectModelByCode(map);
    }

    @Override
    public String saveProjectFile(ProProjectFileDomain proProjectFileDomain) throws ApiException {
        ProProjectFile proProjectFile = this.createProProjectFile(proProjectFileDomain);
        this.saveProjectFileModel(proProjectFile);
        return proProjectFile.getProjectFileCode();
    }

    @Override
    public String saveProjectFileBatch(List<ProProjectFileDomain> proProjectFileDomainList) throws ApiException {
        if (null == proProjectFileDomainList || proProjectFileDomainList.isEmpty()) {
            return null;
        }
        ArrayList<ProProjectFile> proProjectFileList = new ArrayList<ProProjectFile>();
        String code = "";
        for (ProProjectFileDomain proProjectFileDomain : proProjectFileDomainList) {
            ProProjectFile proProjectFile = this.createProProjectFile(proProjectFileDomain);
            code = proProjectFile.getProjectFileCode();
            proProjectFileList.add(proProjectFile);
        }
        this.saveProjectFileBatchModel(proProjectFileList);
        return code;
    }

    @Override
    public void updateProjectFileState(Integer projectFileId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectFileModel(projectFileId, dataState, oldDataState);
    }

    @Override
    public void updateProjectFileStateByCode(String tenantCode, String projectFileCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectFileModelByCode(tenantCode, projectFileCode, dataState, oldDataState);
    }

    @Override
    public void updateProjectFile(ProProjectFileDomain proProjectFileDomain) throws ApiException {
        String msg = this.checkProjectFile(proProjectFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pro.ProProjectServiceImpl.updateProjectFile.checkProjectFile", msg);
        }
        ProProjectFile oldProProjectFile = this.getProjectFileModelById(proProjectFileDomain.getProjectFileId());
        if (null == oldProProjectFile) {
            throw new ApiException("pro.ProProjectServiceImpl.updateProjectFile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ProProjectFile proProjectFile = this.makeProjectFile(proProjectFileDomain, oldProProjectFile);
        this.setProjectFileUpdataDefault(proProjectFile);
        this.updateProjectFileModel(proProjectFile);
    }

    @Override
    public ProProjectFile getProjectFile(Integer projectFileId) {
        return this.getProjectFileModelById(projectFileId);
    }

    @Override
    public void deleteProjectFile(Integer projectFileId) throws ApiException {
        this.deleteProjectFileModel(projectFileId);
    }

    @Override
    public QueryResult<ProProjectFile> queryProjectFilePage(Map<String, Object> map) {
        List<ProProjectFile> proProjectFileList = this.queryProjectFileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProjectFile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(proProjectFileList);
        return queryResult;
    }

    @Override
    public ProProjectFile getProjectFileByCode(String tenantCode, String projectFileCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectFileCode", projectFileCode);
        return this.getProjectFileModelByCode(map);
    }

    @Override
    public void deleteProjectFileByCode(String tenantCode, String projectFileCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectFileCode", projectFileCode);
        this.delProjectFileModelByCode(map);
    }

    @Override
    public String saveProjectSpec(ProProjectSpecDomain proProjectSpecDomain) throws ApiException {
        ProProjectSpec proProjectSpec = this.createProProjectSpec(proProjectSpecDomain);
        this.saveProjectSpecModel(proProjectSpec);
        return proProjectSpec.getProjectSpecCode();
    }

    @Override
    public String saveProjectSpecBatch(List<ProProjectSpecDomain> proProjectSpecDomainList) throws ApiException {
        if (null == proProjectSpecDomainList || proProjectSpecDomainList.isEmpty()) {
            return null;
        }
        ArrayList<ProProjectSpec> proProjectSpecList = new ArrayList<ProProjectSpec>();
        String code = "";
        for (ProProjectSpecDomain proProjectSpecDomain : proProjectSpecDomainList) {
            ProProjectSpec proProjectSpec = this.createProProjectSpec(proProjectSpecDomain);
            code = proProjectSpec.getProjectSpecCode();
            proProjectSpecList.add(proProjectSpec);
        }
        this.saveProjectSpecBatchModel(proProjectSpecList);
        return code;
    }

    @Override
    public void updateProjectSpecState(Integer projectSpecId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectSpecModel(projectSpecId, dataState, oldDataState);
    }

    @Override
    public void updateProjectSpecStateByCode(String tenantCode, String projectSpecCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectSpecModelByCode(tenantCode, projectSpecCode, dataState, oldDataState);
    }

    @Override
    public void updateProjectSpec(ProProjectSpecDomain proProjectSpecDomain) throws ApiException {
        String msg = this.checkProjectSpec(proProjectSpecDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pro.ProProjectServiceImpl.updateProjectSpec.checkProjectSpec", msg);
        }
        ProProjectSpec oldProProjectSpec = this.getProjectSpecModelById(proProjectSpecDomain.getProjectSpecId());
        if (null == oldProProjectSpec) {
            throw new ApiException("pro.ProProjectServiceImpl.updateProjectSpec.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ProProjectSpec proProjectSpec = this.makeProjectSpec(proProjectSpecDomain, oldProProjectSpec);
        this.setProjectSpecUpdataDefault(proProjectSpec);
        this.updateProjectSpecModel(proProjectSpec);
    }

    @Override
    public ProProjectSpec getProjectSpec(Integer projectSpecId) {
        return this.getProjectSpecModelById(projectSpecId);
    }

    @Override
    public void deleteProjectSpec(Integer projectSpecId) throws ApiException {
        this.deleteProjectSpecModel(projectSpecId);
    }

    @Override
    public QueryResult<ProProjectSpec> queryProjectSpecPage(Map<String, Object> map) {
        List<ProProjectSpec> proProjectSpecList = this.queryProjectSpecModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProjectSpec(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(proProjectSpecList);
        return queryResult;
    }

    @Override
    public ProProjectSpec getProjectSpecByCode(String tenantCode, String projectSpecCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectSpecCode", projectSpecCode);
        return this.getProjectSpecModelByCode(map);
    }

    @Override
    public void deleteProjectSpecByCode(String tenantCode, String projectSpecCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectSpecCode", projectSpecCode);
        this.delProjectSpecModelByCode(map);
    }

    @Override
    public String saveProjectValue(ProProjectValueDomain proProjectValueDomain) throws ApiException {
        ProProjectValue proProjectValue = this.createProProjectValue(proProjectValueDomain);
        this.saveProjectValueModel(proProjectValue);
        return proProjectValue.getProjectValueCode();
    }

    @Override
    public String saveProjectValueBatch(List<ProProjectValueDomain> proProjectValueDomainList) throws ApiException {
        if (null == proProjectValueDomainList || proProjectValueDomainList.isEmpty()) {
            return null;
        }
        ArrayList<ProProjectValue> proProjectValueList = new ArrayList<ProProjectValue>();
        String code = "";
        for (ProProjectValueDomain proProjectValueDomain : proProjectValueDomainList) {
            ProProjectValue proProjectValue = this.createProProjectValue(proProjectValueDomain);
            code = proProjectValue.getProjectValueCode();
            proProjectValueList.add(proProjectValue);
        }
        this.logger.error("proProjectValueList++++" + JsonUtil.buildNonDefaultBinder().toJson(proProjectValueList));
        this.saveProjectValueBatchModel(proProjectValueList);
        return code;
    }

    @Override
    public void updateProjectValueState(Integer projectValueId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectValueModel(projectValueId, dataState, oldDataState);
    }

    @Override
    public void updateProjectValueStateByCode(String tenantCode, String projectValueCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateProjectValueModelByCode(tenantCode, projectValueCode, dataState, oldDataState);
    }

    @Override
    public void updateProjectValue(ProProjectValueDomain proProjectValueDomain) throws ApiException {
        String msg = this.checkProjectValue(proProjectValueDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("pro.ProProjectServiceImpl.updateProjectValue.checkProjectValue", msg);
        }
        ProProjectValue oldProProjectValue = this.getProjectValueModelById(proProjectValueDomain.getProjectValueId());
        if (null == oldProProjectValue) {
            throw new ApiException("pro.ProProjectServiceImpl.updateProjectValue.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ProProjectValue proProjectValue = this.makeProjectValue(proProjectValueDomain, oldProProjectValue);
        this.setProjectValueUpdataDefault(proProjectValue);
        this.updateProjectValueModel(proProjectValue);
    }

    @Override
    public void updateProjectEmployee(Map<String, Object> map) throws ApiException {
        this.proProjectMapper.updateEmployee(map);
    }

    @Override
    public ProProjectValue getProjectValue(Integer projectValueId) {
        return this.getProjectValueModelById(projectValueId);
    }

    @Override
    public void deleteProjectValue(Integer projectValueId) throws ApiException {
        this.deleteProjectValueModel(projectValueId);
    }

    @Override
    public QueryResult<ProProjectValue> queryProjectValuePage(Map<String, Object> map) {
        List<ProProjectValue> proProjectValueList = this.queryProjectValueModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countProjectValue(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(proProjectValueList);
        return queryResult;
    }

    @Override
    public ProProjectValue getProjectValueByCode(String tenantCode, String projectValueCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectValueCode", projectValueCode);
        return this.getProjectValueModelByCode(map);
    }

    @Override
    public void deleteProjectValueByCode(String tenantCode, String projectValueCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("projectValueCode", projectValueCode);
        this.delProjectValueModelByCode(map);
    }

    @Override
    public void updateProjectReleaseByCode(String tenantCode, String projectCode, Integer projectState, Integer oldProjectState) throws ApiException {
        this.updateReleaseProjectModelByCode(tenantCode, projectCode, projectState, oldProjectState);
    }

    @Override
    public void auditProject(Integer projectId, Integer type) throws ApiException {
        ProProject proProject = this.getProject(projectId);
        this.updateProjectFileState(projectId, 1, proProject.getDataState());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, Object> sendparamMap = new HashMap<String, Object>();
        ActCommonDomain actCommonDomain = new ActCommonDomain();
        actCommonDomain.setTenantCode(proProject.getTenantCode());
        actCommonDomain.setBusinessKey(proProject.getProjectCode());
        actCommonDomain.setInterfaceType("");
        actCommonDomain.setCallUrl("pro.project.updateAuditCall");
        actCommonDomain.setParamMap(sendparamMap);
        actCommonDomain.setStartUserType("2");
        actCommonDomain.setStartUser(proProject.getEmployeeCode());
        actCommonDomain.setStartName(proProject.getEmployeeName());
        actCommonDomain.setUserCode(proProject.getEmployeeCode());
        actCommonDomain.setEmployeeCode(proProject.getEmployeeCode());
        sendparamMap.put("proProject", proProject);
        sendparamMap.put("title", proProject.getProjectCode() + "" + proProject.getProjectName());
        paramMap.put("actCommonDomain", JsonUtil.buildNormalBinder().toJson((Object)actCommonDomain));
        this.internalInvoke("act.actCommonService.activateProcess", paramMap);
    }

    @Override
    public void updateAuditCall(Map<String, Object> map) throws ApiException {
        this.logger.error("pro.ProProjectServiceImpl.updateAuditCall:\u4f20\u5165\u53c2\u6570-", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (map.get("auditStatus") == null) {
            throw new ApiException("pro.ProProjectServiceImpl.updateAuditCall.ex", "\u5ba1\u6279\u53c2\u6570\u9519\u8bef\uff01");
        }
        String auditStatus = map.get("auditStatus").toString();
        ProProject proProject = (ProProject)JsonUtil.buildNormalBinder().getJsonToObject(map.get("proProject").toString(), ProProject.class);
        if ("YES".equals(auditStatus)) {
            this.updateProjectFileState(proProject.getProjectId(), 2, proProject.getDataState());
        } else {
            this.updateProjectFileState(proProject.getProjectId(), 0, proProject.getDataState());
        }
    }
}

