/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.quest.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.quest.dao.QtRecruitMapper;
import com.yqbsoft.laser.service.quest.domain.QtRecruitDomain;
import com.yqbsoft.laser.service.quest.domain.QtRecruitReDomain;
import com.yqbsoft.laser.service.quest.model.QtRecruit;
import com.yqbsoft.laser.service.quest.service.QtRecruitService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QtRecruitServiceImpl
extends BaseServiceImpl
implements QtRecruitService {
    private static final String SYS_CODE = "qt.QtRecruitServiceImpl";
    private QtRecruitMapper qtRecruitMapper;

    public void setQtRecruitMapper(QtRecruitMapper qtRecruitMapper) {
        this.qtRecruitMapper = qtRecruitMapper;
    }

    private Date getSysDate() {
        try {
            return this.qtRecruitMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("qt.QtRecruitServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkrecruit(QtRecruitDomain qtRecruitDomain) {
        if (null == qtRecruitDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)qtRecruitDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setrecruitDefault(QtRecruit qtRecruit) {
        if (null == qtRecruit) {
            return;
        }
        if (null == qtRecruit.getDataState()) {
            qtRecruit.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == qtRecruit.getGmtCreate()) {
            qtRecruit.setGmtCreate(date);
        }
        qtRecruit.setGmtModified(date);
        if (StringUtils.isBlank((String)qtRecruit.getRecruitCode())) {
            qtRecruit.setRecruitCode(this.getNo(null, "QtRecruit", "qtRecruit", qtRecruit.getTenantCode()));
        }
    }

    private int getrecruitMaxCode() {
        int code = 0;
        try {
            return this.qtRecruitMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("qt.QtRecruitServiceImpl.getrecruitMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setrecruitUpdataDefault(QtRecruit qtRecruit) {
        if (null == qtRecruit) {
            return;
        }
        qtRecruit.setGmtModified(this.getSysDate());
    }

    private void saverecruitModel(QtRecruit qtRecruit) throws ApiException {
        if (null == qtRecruit) {
            return;
        }
        try {
            this.qtRecruitMapper.insert(qtRecruit);
        }
        catch (Exception e) {
            throw new ApiException("qt.QtRecruitServiceImpl.saverecruitModel.ex", (Throwable)e);
        }
    }

    private void saverecruitBatchModel(List<QtRecruit> qtRecruitList) throws ApiException {
        if (null == qtRecruitList || qtRecruitList.isEmpty()) {
            return;
        }
        try {
            this.qtRecruitMapper.insertBatch(qtRecruitList);
        }
        catch (Exception e) {
            throw new ApiException("qt.QtRecruitServiceImpl.saverecruitBatchModel.ex", (Throwable)e);
        }
    }

    private QtRecruit getrecruitModelById(Integer recruitId) {
        if (null == recruitId) {
            return null;
        }
        try {
            return this.qtRecruitMapper.selectByPrimaryKey(recruitId);
        }
        catch (Exception e) {
            this.logger.error("qt.QtRecruitServiceImpl.getrecruitModelById", (Throwable)e);
            return null;
        }
    }

    private QtRecruit getrecruitModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.qtRecruitMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("qt.QtRecruitServiceImpl.getrecruitModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delrecruitModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.qtRecruitMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("qt.QtRecruitServiceImpl.delrecruitModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("qt.QtRecruitServiceImpl.delrecruitModelByCode.num");
        }
    }

    private void deleterecruitModel(Integer recruitId) throws ApiException {
        if (null == recruitId) {
            return;
        }
        int i = 0;
        try {
            i = this.qtRecruitMapper.deleteByPrimaryKey(recruitId);
        }
        catch (Exception e) {
            throw new ApiException("qt.QtRecruitServiceImpl.deleterecruitModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("qt.QtRecruitServiceImpl.deleterecruitModel.num");
        }
    }

    private void updaterecruitModel(QtRecruit qtRecruit) throws ApiException {
        if (null == qtRecruit) {
            return;
        }
        int i = 0;
        try {
            i = this.qtRecruitMapper.updateByPrimaryKey(qtRecruit);
        }
        catch (Exception e) {
            throw new ApiException("qt.QtRecruitServiceImpl.updaterecruitModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("qt.QtRecruitServiceImpl.updaterecruitModel.num");
        }
    }

    private void updateStaterecruitModel(Integer recruitId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == recruitId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recruitId", recruitId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.qtRecruitMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("qt.QtRecruitServiceImpl.updateStaterecruitModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("qt.QtRecruitServiceImpl.updateStaterecruitModel.null");
        }
    }

    private void updateStaterecruitModelByCode(String tenantCode, String recruitCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)recruitCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitCode", recruitCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.qtRecruitMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("qt.QtRecruitServiceImpl.updateStaterecruitModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("qt.QtRecruitServiceImpl.updateStaterecruitModelByCode.null");
        }
    }

    private QtRecruit makerecruit(QtRecruitDomain qtRecruitDomain, QtRecruit qtRecruit) {
        if (null == qtRecruitDomain) {
            return null;
        }
        if (null == qtRecruit) {
            qtRecruit = new QtRecruit();
        }
        try {
            BeanUtils.copyAllPropertys((Object)qtRecruit, (Object)qtRecruitDomain);
            return qtRecruit;
        }
        catch (Exception e) {
            this.logger.error("qt.QtRecruitServiceImpl.makerecruit", (Throwable)e);
            return null;
        }
    }

    private QtRecruitReDomain makeQtRecruitReDomain(QtRecruit qtRecruit) {
        if (null == qtRecruit) {
            return null;
        }
        QtRecruitReDomain qtRecruitReDomain = new QtRecruitReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)qtRecruitReDomain, (Object)qtRecruit);
            return qtRecruitReDomain;
        }
        catch (Exception e) {
            this.logger.error("qt.QtRecruitServiceImpl.makeQtRecruitReDomain", (Throwable)e);
            return null;
        }
    }

    private List<QtRecruit> queryrecruitModelPage(Map<String, Object> parammap) {
        try {
            return this.qtRecruitMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("qt.QtRecruitServiceImpl.queryrecruitModel", (Throwable)e);
            return null;
        }
    }

    private int countrecruit(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.qtRecruitMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("qt.QtRecruitServiceImpl.countrecruit", (Throwable)e);
        }
        return i;
    }

    private QtRecruit createQtRecruit(QtRecruitDomain qtRecruitDomain) {
        String msg = this.checkrecruit(qtRecruitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("qt.QtRecruitServiceImpl.saverecruit.checkrecruit", msg);
        }
        QtRecruit qtRecruit = this.makerecruit(qtRecruitDomain, null);
        this.setrecruitDefault(qtRecruit);
        return qtRecruit;
    }

    @Override
    public String saverecruit(QtRecruitDomain qtRecruitDomain) throws ApiException {
        QtRecruit qtRecruit = this.createQtRecruit(qtRecruitDomain);
        this.saverecruitModel(qtRecruit);
        return qtRecruit.getRecruitCode();
    }

    @Override
    public String saverecruitBatch(List<QtRecruitDomain> qtRecruitDomainList) throws ApiException {
        if (null == qtRecruitDomainList || qtRecruitDomainList.isEmpty()) {
            return null;
        }
        ArrayList<QtRecruit> qtRecruitList = new ArrayList<QtRecruit>();
        String code = "";
        for (QtRecruitDomain qtRecruitDomain : qtRecruitDomainList) {
            QtRecruit qtRecruit = this.createQtRecruit(qtRecruitDomain);
            code = qtRecruit.getRecruitCode();
            qtRecruitList.add(qtRecruit);
        }
        this.saverecruitBatchModel(qtRecruitList);
        return code;
    }

    @Override
    public void updaterecruitState(Integer recruitId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == recruitId) {
            return;
        }
        this.updateStaterecruitModel(recruitId, dataState, oldDataState, map);
    }

    @Override
    public void updaterecruitStateByCode(String tenantCode, String recruitCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)recruitCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStaterecruitModelByCode(tenantCode, recruitCode, dataState, oldDataState, map);
    }

    @Override
    public void updaterecruit(QtRecruitDomain qtRecruitDomain) throws ApiException {
        String msg = this.checkrecruit(qtRecruitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("qt.QtRecruitServiceImpl.updaterecruit.checkrecruit", msg);
        }
        QtRecruit oldQtRecruit = this.getrecruitModelById(qtRecruitDomain.getRecruitId());
        if (null == oldQtRecruit) {
            throw new ApiException("qt.QtRecruitServiceImpl.updaterecruit.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        QtRecruit qtRecruit = this.makerecruit(qtRecruitDomain, oldQtRecruit);
        this.setrecruitUpdataDefault(qtRecruit);
        this.updaterecruitModel(qtRecruit);
    }

    @Override
    public QtRecruit getrecruit(Integer recruitId) {
        if (null == recruitId) {
            return null;
        }
        return this.getrecruitModelById(recruitId);
    }

    @Override
    public void deleterecruit(Integer recruitId) throws ApiException {
        if (null == recruitId) {
            return;
        }
        this.deleterecruitModel(recruitId);
    }

    @Override
    public QueryResult<QtRecruit> queryrecruitPage(Map<String, Object> map) {
        List<QtRecruit> qtRecruitList = this.queryrecruitModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countrecruit(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(qtRecruitList);
        return queryResult;
    }

    @Override
    public QtRecruit getrecruitByCode(String tenantCode, String recruitCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitCode", recruitCode);
        return this.getrecruitModelByCode(map);
    }

    @Override
    public void deleterecruitByCode(String tenantCode, String recruitCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitCode", recruitCode);
        this.delrecruitModelByCode(map);
    }
}

