/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.random.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.random.dao.RdRandomConfigMapper;
import com.yqbsoft.laser.service.random.domain.RdRandomConfigDomain;
import com.yqbsoft.laser.service.random.model.RdRandomConfig;
import com.yqbsoft.laser.service.random.service.RdRandomConfigService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RdRandomConfigServiceImpl
extends BaseServiceImpl
implements RdRandomConfigService {
    public static final String SYS_CODE = "rd.RANDOM.RdRandomConfigServiceImpl";
    private RdRandomConfigMapper rdRandomConfigMapper;

    public void setRdRandomConfigMapper(RdRandomConfigMapper rdRandomConfigMapper) {
        this.rdRandomConfigMapper = rdRandomConfigMapper;
    }

    private Date getSysDate() {
        try {
            return this.rdRandomConfigMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rd.RANDOM.RdRandomConfigServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRandomConfig(RdRandomConfigDomain rdRandomConfigDomain) {
        if (null == rdRandomConfigDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setRandomConfigDefault(RdRandomConfig rdRandomConfig) {
        if (null == rdRandomConfig) {
            return;
        }
        if (null == rdRandomConfig.getDataState()) {
            rdRandomConfig.setDataState(0);
        }
        if (null == rdRandomConfig.getGmtCreate()) {
            rdRandomConfig.setGmtCreate(this.getSysDate());
        }
        rdRandomConfig.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rdRandomConfig.getRandomconfigCode())) {
            int code = this.getRandomConfigMaxCode();
            rdRandomConfig.setRandomconfigCode(this.makeMaxCode8(++code));
        }
    }

    private int getRandomConfigMaxCode() {
        int code = 0;
        try {
            return this.rdRandomConfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rd.RANDOM.RdRandomConfigServiceImpl.getRandomConfigMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRandomConfigUpdataDefault(RdRandomConfig rdRandomConfig) {
        if (null == rdRandomConfig) {
            return;
        }
        rdRandomConfig.setGmtModified(this.getSysDate());
    }

    private void saveRandomConfigModel(RdRandomConfig rdRandomConfig) throws ApiException {
        if (null == rdRandomConfig) {
            return;
        }
        try {
            this.rdRandomConfigMapper.insert(rdRandomConfig);
        }
        catch (Exception e) {
            throw new ApiException("rd.RANDOM.RdRandomConfigServiceImpl.saveRandomConfigModel.ex", (Throwable)e);
        }
    }

    private RdRandomConfig getRandomConfigModelById(Integer randomconfigId) {
        if (null == randomconfigId) {
            return null;
        }
        try {
            return this.rdRandomConfigMapper.selectByPrimaryKey(randomconfigId);
        }
        catch (Exception e) {
            this.logger.error("rd.RANDOM.RdRandomConfigServiceImpl.getRandomConfigModelById", (Throwable)e);
            return null;
        }
    }

    public RdRandomConfig getRandomConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rdRandomConfigMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rd.RANDOM.RdRandomConfigServiceImpl.getRandomConfigModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRandomConfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rdRandomConfigMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rd.RANDOM.RdRandomConfigServiceImpl.delRandomConfigModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rd.RANDOM.RdRandomConfigServiceImpl.delRandomConfigModelByCode.num");
        }
    }

    private void deleteRandomConfigModel(Integer randomconfigId) throws ApiException {
        if (null == randomconfigId) {
            return;
        }
        int i = 0;
        try {
            i = this.rdRandomConfigMapper.deleteByPrimaryKey(randomconfigId);
        }
        catch (Exception e) {
            throw new ApiException("rd.RANDOM.RdRandomConfigServiceImpl.deleteRandomConfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rd.RANDOM.RdRandomConfigServiceImpl.deleteRandomConfigModel.num");
        }
    }

    private void updateRandomConfigModel(RdRandomConfig rdRandomConfig) throws ApiException {
        if (null == rdRandomConfig) {
            return;
        }
        try {
            this.rdRandomConfigMapper.updateByPrimaryKeySelective(rdRandomConfig);
        }
        catch (Exception e) {
            throw new ApiException("rd.RANDOM.RdRandomConfigServiceImpl.updateRandomConfigModel.ex", (Throwable)e);
        }
    }

    private void updateStateRandomConfigModel(Integer randomconfigId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == randomconfigId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("randomconfigId", randomconfigId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rdRandomConfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rd.RANDOM.RdRandomConfigServiceImpl.updateStateRandomConfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rd.RANDOM.RdRandomConfigServiceImpl.updateStateRandomConfigModel.null");
        }
    }

    private RdRandomConfig makeRandomConfig(RdRandomConfigDomain rdRandomConfigDomain, RdRandomConfig rdRandomConfig) {
        if (null == rdRandomConfigDomain) {
            return null;
        }
        if (null == rdRandomConfig) {
            rdRandomConfig = new RdRandomConfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rdRandomConfig, (Object)rdRandomConfigDomain);
            return rdRandomConfig;
        }
        catch (Exception e) {
            this.logger.error("rd.RANDOM.RdRandomConfigServiceImpl.makeRandomConfig", (Throwable)e);
            return null;
        }
    }

    private List<RdRandomConfig> queryRandomConfigModelPage(Map<String, Object> parammap) {
        try {
            return this.rdRandomConfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rd.RANDOM.RdRandomConfigServiceImpl.queryRandomConfigModel", (Throwable)e);
            return null;
        }
    }

    private int countRandomConfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rdRandomConfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rd.RANDOM.RdRandomConfigServiceImpl.countRandomConfig", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveRandomConfig(RdRandomConfigDomain rdRandomConfigDomain) throws ApiException {
        String msg = this.checkRandomConfig(rdRandomConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rd.RANDOM.RdRandomConfigServiceImpl.saveRandomConfig.checkRandomConfig", msg);
        }
        RdRandomConfig rdRandomConfig = this.makeRandomConfig(rdRandomConfigDomain, null);
        this.setRandomConfigDefault(rdRandomConfig);
        this.saveRandomConfigModel(rdRandomConfig);
    }

    @Override
    public void updateRandomConfigState(Integer randomconfigId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRandomConfigModel(randomconfigId, dataState, oldDataState);
    }

    @Override
    public void updateRandomConfig(RdRandomConfigDomain rdRandomConfigDomain) throws ApiException {
        String msg = this.checkRandomConfig(rdRandomConfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rd.RANDOM.RdRandomConfigServiceImpl.updateRandomConfig.checkRandomConfig", msg);
        }
        RdRandomConfig oldRdRandomConfig = this.getRandomConfigModelById(rdRandomConfigDomain.getRandomconfigId());
        if (null == oldRdRandomConfig) {
            throw new ApiException("rd.RANDOM.RdRandomConfigServiceImpl.updateRandomConfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RdRandomConfig rdRandomConfig = this.makeRandomConfig(rdRandomConfigDomain, oldRdRandomConfig);
        this.setRandomConfigUpdataDefault(rdRandomConfig);
        this.updateRandomConfigModel(rdRandomConfig);
    }

    @Override
    public RdRandomConfig getRandomConfig(Integer randomconfigId) {
        return this.getRandomConfigModelById(randomconfigId);
    }

    @Override
    public void deleteRandomConfig(Integer randomconfigId) throws ApiException {
        this.deleteRandomConfigModel(randomconfigId);
    }

    @Override
    public QueryResult<RdRandomConfig> queryRandomConfigPage(Map<String, Object> map) {
        List<RdRandomConfig> rdRandomConfigList = this.queryRandomConfigModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRandomConfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rdRandomConfigList);
        return queryResult;
    }

    @Override
    public RdRandomConfig getRandomConfigByCode(Map<String, Object> map) {
        return this.getRandomConfigModelByCode(map);
    }

    @Override
    public void delRandomConfigByCode(Map<String, Object> map) throws ApiException {
        this.delRandomConfigModelByCode(map);
    }
}

