/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.random.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.router.LocalCache;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.random.dao.RdRandomListMapper;
import com.yqbsoft.laser.service.random.domain.RdRandomListDomain;
import com.yqbsoft.laser.service.random.model.RdRandomConfig;
import com.yqbsoft.laser.service.random.model.RdRandomList;
import com.yqbsoft.laser.service.random.service.RdRandomListService;
import com.yqbsoft.laser.service.suppercore.router.AppProperty;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MD5Util;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;

public class RdRandomListServiceImpl
extends BaseServiceImpl
implements RdRandomListService {
    public static final String SYS_CODE = "rd.RANDOM.RdRandomListServiceImpl";
    private RdRandomListMapper rdRandomListMapper;
    private String cacheKey = "RdRandomConfig_randomconfigBustype";

    public void setRdRandomListMapper(RdRandomListMapper rdRandomListMapper) {
        this.rdRandomListMapper = rdRandomListMapper;
    }

    private Date getSysDate() {
        try {
            return this.rdRandomListMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rd.RANDOM.RdRandomListServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRandomList(RdRandomListDomain rdRandomListDomain) {
        if (null == rdRandomListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rdRandomListDomain.getRandomlistRandom())) {
            msg = msg + "RandomlistRandom\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rdRandomListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRandomListDefault(RdRandomList rdRandomList) {
        if (null == rdRandomList) {
            return;
        }
        if (null == rdRandomList.getDataState()) {
            rdRandomList.setDataState(0);
        }
        if (null == rdRandomList.getGmtCreate()) {
            rdRandomList.setGmtCreate(this.getSysDate());
        }
        rdRandomList.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rdRandomList.getRandomlistCode())) {
            rdRandomList.setRandomlistCode(this.createUUIDString());
        }
    }

    private void setRandomListUpdataDefault(RdRandomList rdRandomList) {
        if (null == rdRandomList) {
            return;
        }
        rdRandomList.setGmtModified(this.getSysDate());
    }

    private void saveRandomListModel(RdRandomList rdRandomList) throws ApiException {
        if (null == rdRandomList) {
            return;
        }
        try {
            this.rdRandomListMapper.insert(rdRandomList);
        }
        catch (Exception e) {
            throw new ApiException("rd.RANDOM.RdRandomListServiceImpl.saveRandomListModel.ex", (Throwable)e);
        }
    }

    private RdRandomList getRandomListModelById(Integer randomlistId) {
        if (null == randomlistId) {
            return null;
        }
        try {
            return this.rdRandomListMapper.selectByPrimaryKey(randomlistId);
        }
        catch (Exception e) {
            this.logger.error("rd.RANDOM.RdRandomListServiceImpl.getRandomListModelById", (Throwable)e);
            return null;
        }
    }

    public RdRandomList getRandomListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rdRandomListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rd.RANDOM.RdRandomListServiceImpl.getRandomListModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRandomListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rdRandomListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rd.RANDOM.RdRandomListServiceImpl.delRandomListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rd.RANDOM.RdRandomListServiceImpl.delRandomListModelByCode.num");
        }
    }

    private void deleteRandomListModel(Integer randomlistId) throws ApiException {
        if (null == randomlistId) {
            return;
        }
        int i = 0;
        try {
            i = this.rdRandomListMapper.deleteByPrimaryKey(randomlistId);
        }
        catch (Exception e) {
            throw new ApiException("rd.RANDOM.RdRandomListServiceImpl.deleteRandomListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rd.RANDOM.RdRandomListServiceImpl.deleteRandomListModel.num");
        }
    }

    private void updateRandomListModel(RdRandomList rdRandomList) throws ApiException {
        if (null == rdRandomList) {
            return;
        }
        try {
            this.rdRandomListMapper.updateByPrimaryKeySelective(rdRandomList);
        }
        catch (Exception e) {
            throw new ApiException("rd.RANDOM.RdRandomListServiceImpl.updateRandomListModel.ex", (Throwable)e);
        }
    }

    private void updateStateRandomListModel(Integer randomlistId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == randomlistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("randomlistId", randomlistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rdRandomListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rd.RANDOM.RdRandomListServiceImpl.updateStateRandomListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rd.RANDOM.RdRandomListServiceImpl.updateStateRandomListModel.null");
        }
    }

    private RdRandomList makeRandomList(RdRandomListDomain rdRandomListDomain, RdRandomList rdRandomList) {
        if (null == rdRandomListDomain) {
            return null;
        }
        if (null == rdRandomList) {
            rdRandomList = new RdRandomList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rdRandomList, (Object)rdRandomListDomain);
            return rdRandomList;
        }
        catch (Exception e) {
            this.logger.error("rd.RANDOM.RdRandomListServiceImpl.makeRandomList", (Throwable)e);
            return null;
        }
    }

    private List<RdRandomList> queryRandomListModelPage(Map<String, Object> parammap) {
        try {
            return this.rdRandomListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rd.RANDOM.RdRandomListServiceImpl.queryRandomListModel", (Throwable)e);
            return null;
        }
    }

    private int countRandomList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rdRandomListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rd.RANDOM.RdRandomListServiceImpl.countRandomList", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveRandomList(RdRandomListDomain rdRandomListDomain) throws ApiException {
        String msg = this.checkRandomList(rdRandomListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rd.RANDOM.RdRandomListServiceImpl.saveRandomList.checkRandomList", msg);
        }
        RdRandomList rdRandomList = this.makeRandomList(rdRandomListDomain, null);
        this.setRandomListDefault(rdRandomList);
        this.saveRandomListModel(rdRandomList);
    }

    @Override
    public void updateRandomListState(Integer randomlistId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRandomListModel(randomlistId, dataState, oldDataState);
    }

    @Override
    public void updateRandomList(RdRandomListDomain rdRandomListDomain) throws ApiException {
        String msg = this.checkRandomList(rdRandomListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rd.RANDOM.RdRandomListServiceImpl.updateRandomList.checkRandomList", msg);
        }
        RdRandomList oldRdRandomList = this.getRandomListModelById(rdRandomListDomain.getRandomlistId());
        if (null == oldRdRandomList) {
            throw new ApiException("rd.RANDOM.RdRandomListServiceImpl.updateRandomList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RdRandomList rdRandomList = this.makeRandomList(rdRandomListDomain, oldRdRandomList);
        this.setRandomListUpdataDefault(rdRandomList);
        this.updateRandomListModel(rdRandomList);
    }

    @Override
    public RdRandomList getRandomList(Integer randomlistId) {
        return this.getRandomListModelById(randomlistId);
    }

    @Override
    public void deleteRandomList(Integer randomlistId) throws ApiException {
        this.deleteRandomListModel(randomlistId);
    }

    @Override
    public QueryResult<RdRandomList> queryRandomListPage(Map<String, Object> map) {
        List<RdRandomList> rdRandomListList = this.queryRandomListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRandomList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rdRandomListList);
        return queryResult;
    }

    @Override
    public RdRandomList getRandomListByCode(Map<String, Object> map) {
        return this.getRandomListModelByCode(map);
    }

    @Override
    public void delRandomListByCode(Map<String, Object> map) throws ApiException {
        this.delRandomListModelByCode(map);
    }

    @Override
    public Map<String, Object> executeRandomValidity(String businessType, String host, String random, String appKey, String tenantCode) {
        RdRandomConfig randomConfig;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)businessType) || StringUtils.isEmpty((String)tenantCode) || StringUtils.isEmpty((String)random) || StringUtils.isEmpty((String)appKey)) {
            result.put("flag", false);
            result.put("message", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return result;
        }
        String str = DisUtil.getMap((String)this.cacheKey, (String)(businessType + "-" + tenantCode));
        if (StringUtils.isBlank((String)str)) {
            str = DisUtil.getMap((String)this.cacheKey, (String)(businessType + "-" + "00000000"));
        }
        if ((randomConfig = (RdRandomConfig)JsonUtil.buildNormalBinder().getJsonToObject(str, RdRandomConfig.class)) == null) {
            result.put("flag", false);
            result.put("message", "\u672a\u627e\u5230\u9a8c\u8bc1\u7801\u914d\u7f6e\u4fe1\u606f\uff01");
            this.logger.error("rd.RANDOM.RdRandomListServiceImpl.executeRandomValidity.config", (Object)(businessType + "-" + tenantCode));
            return result;
        }
        Integer randomconfigValid = randomConfig.getRandomconfigValid();
        String ra = null;
        String valrandom = null;
        Integer randomconfigEncrypt = randomConfig.getRandomconfigEncrypt();
        String randomlistCode = null;
        valrandom = null != randomconfigEncrypt && randomconfigEncrypt == 1 ? MD5Util.MD5((String)random) : random;
        if (null != randomconfigValid && randomconfigValid == 0) {
            String rastr = DisUtil.getRemot((String)("RdRandomList_Valid-" + businessType + "-" + host + "-" + appKey + "-" + tenantCode));
            if (StringUtils.isNotBlank((String)rastr)) {
                String[] s = rastr.split("\\|");
                if (null == s || s.length != 2) {
                    this.logger.error("rd.RANDOM.RdRandomListServiceImpl.executeRandomValidity.s", (Object)rastr);
                } else {
                    ra = s[0];
                    randomlistCode = s[1];
                }
            } else {
                this.logger.error("rd.RANDOM.RdRandomListServiceImpl.executeRandomValidity.rastr", (Object)("RdRandomList_Valid-" + businessType + "-" + host + "-" + appKey + "-" + tenantCode));
            }
        } else {
            HashMap<String, Object> timeMap = new HashMap<String, Object>();
            timeMap.put("randomlistBustype", businessType);
            timeMap.put("randomlistHost", host);
            timeMap.put("appmanageAppkey", appKey);
            timeMap.put("tenantCode", tenantCode);
            timeMap.put("order", true);
            List<RdRandomList> rdRandomListList = this.queryRandomListModelPage(timeMap);
            if (CollectionUtils.isEmpty(rdRandomListList)) {
                result.put("flag", false);
                result.put("message", "\u65e0\u6548\u9a8c\u8bc1\u7801\uff01");
                this.logger.error("rd.RANDOM.RdRandomListServiceImpl.executeRandomValidity.rdRandomListList", (Object)((Object)timeMap).toString());
                return result;
            }
            RdRandomList rdRandom = rdRandomListList.get(0);
            if (null == rdRandom.getRandomlistValidtime() || rdRandom.getRandomlistValidtime().compareTo(Calendar.getInstance().getTime()) > 0) {
                ra = rdRandom.getRandomlistRandom();
                randomlistCode = rdRandom.getRandomlistCode();
            } else {
                this.logger.error("rd.RANDOM.RdRandomListServiceImpl.executeRandomValidity.getRandomlistValidtime", (Object)("RdRandomList_Valid-" + businessType + "-" + host + "-" + appKey + "-" + tenantCode));
            }
        }
        boolean flag = false;
        if (StringUtils.isNotBlank((String)ra) && ra.equals(valrandom)) {
            flag = true;
        } else {
            this.logger.error("rd.RANDOM.RdRandomListServiceImpl.executeRandomValidity.e", (Object)(valrandom + "==" + ra + "==" + "RdRandomList_Valid" + "-" + businessType + "-" + host + "-" + appKey + "-" + tenantCode));
        }
        if (flag) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("randomlistCode", randomlistCode);
            map.put("tenantCode", tenantCode);
            this.delRandomListModelByCode(map);
        }
        result.put("flag", flag);
        return result;
    }

    @Override
    public void removeInvalidRandom() {
        try {
            Date date = new Date();
            this.rdRandomListMapper.deleteInvalidRandomBatch(date);
        }
        catch (Exception e) {
            throw new ApiException("rd.RANDOM.RdRandomListServiceImpl.deleteRandomListModel.ex", (Throwable)e);
        }
    }

    private AppProperty getApp(String appKey) {
        List appPropertyList = (List)MapUtil.get((Map)LocalCache.getAppManagerMap(), (Object)appKey);
        if (!CollectionUtils.isEmpty((Collection)appPropertyList)) {
            return (AppProperty)appPropertyList.get(0);
        }
        return null;
    }

    @Override
    public Map<String, Object> createRandom(String businessType, String host, String app_id, String tenantCode) {
        RdRandomConfig randomConfig;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)businessType) || StringUtils.isEmpty((String)tenantCode) || StringUtils.isEmpty((String)app_id) || StringUtils.isEmpty((String)host)) {
            result.put("flag", false);
            result.put("message", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return result;
        }
        String str = DisUtil.getMap((String)this.cacheKey, (String)(businessType + "-" + tenantCode));
        if (StringUtils.isBlank((String)str)) {
            str = DisUtil.getMap((String)this.cacheKey, (String)(businessType + "-" + "00000000"));
        }
        if (null == (randomConfig = (RdRandomConfig)JsonUtil.buildNormalBinder().getJsonToObject(str, RdRandomConfig.class))) {
            result.put("flag", false);
            result.put("message", "\u672a\u627e\u5230\u9a8c\u8bc1\u7801\u914d\u7f6e\u4fe1\u606f\uff01" + businessType + "-" + tenantCode);
            return result;
        }
        Integer genType = randomConfig.getRandomconfigGentype();
        Integer length = randomConfig.getRandomconfigLength();
        String randomCode = RandomUtils.generateRandom((int)length, (Integer)genType);
        this.saveRandom(randomConfig, randomCode, host, app_id, tenantCode);
        Integer hosttype = randomConfig.getRandomconfigHosttype();
        if (hosttype != null && (hosttype == 1 || hosttype == 0)) {
            this.sendRandom(randomConfig, randomCode, host, app_id, tenantCode);
        }
        result.put("flag", true);
        result.put("message", randomCode);
        return result;
    }

    private void saveRandom(RdRandomConfig randomConfig, String randomCode, String host, String appKey, String tenantCode) {
        RdRandomList rdRandomList = new RdRandomList();
        rdRandomList.setRandomlistBustype(randomConfig.getRandomconfigBustype());
        rdRandomList.setRandomlistBusname(randomConfig.getRandomconfigBusname());
        rdRandomList.setMnsconfigBustype(randomConfig.getMnsconfigBustype());
        rdRandomList.setMnsconfigBusname(randomConfig.getMnsconfigBusname());
        rdRandomList.setAppmanageAppkey(appKey);
        rdRandomList.setTenantCode(tenantCode);
        Integer randomconfigEncrypt = randomConfig.getRandomconfigEncrypt();
        if (null != randomconfigEncrypt && randomconfigEncrypt == 1) {
            rdRandomList.setRandomlistRandom(MD5Util.MD5((String)randomCode));
        } else {
            rdRandomList.setRandomlistRandom(randomCode);
        }
        rdRandomList.setRandomlistHost(host);
        this.setRandomListDefault(rdRandomList);
        Integer randomconfigValid = randomConfig.getRandomconfigValid();
        if (null != randomconfigValid && randomconfigValid == 0) {
            rdRandomList.setRandomlistValidtime(DateUtil.addMinutes((Date)this.getSysDate(), (int)randomConfig.getRandomconfigTime()));
            DisUtil.set((String)("RdRandomList_Valid-" + rdRandomList.getRandomlistBustype() + "-" + rdRandomList.getRandomlistHost() + "-" + rdRandomList.getAppmanageAppkey() + "-" + tenantCode), (String)(rdRandomList.getRandomlistRandom() + "|" + rdRandomList.getRandomlistCode()), (int)(randomConfig.getRandomconfigTime() * 60));
        }
        this.saveRandomListModel(rdRandomList);
    }

    private void sendRandom(RdRandomConfig randomConfig, String random, String host, String appName, String tenantCode) {
        ConcurrentHashMap<String, String> mnsMap = new ConcurrentHashMap<String, String>();
        mnsMap.put("mnslistSubject", "");
        mnsMap.put("mnslistSource", "0");
        mnsMap.put("mnslistBusType", randomConfig.getMnsconfigBustype());
        mnsMap.put("mnslistBusName", randomConfig.getMnsconfigBusname());
        mnsMap.put("mnslistExp", this.getMnslistExp(host, random, randomConfig.getMnsconfigBustype(), String.valueOf(randomConfig.getRandomconfigTime()), appName));
        mnsMap.put("tenantCode", tenantCode);
        ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
        sendMap.put("mnsMnslistDomainBean", JsonUtil.buildNormalBinder().toJson(mnsMap));
        Object res = this.getInternalRouter().inInvoke("mns.mns.saveSendMnslist", "1.0", "0", sendMap);
        if (null == res) {
            res = "";
        }
        this.logger.debug("rd.RANDOM.RdRandomListServiceImpl.host", (Object)("host:" + host + "==res:" + res.toString() + "===map:" + ((Object)mnsMap).toString()));
    }

    private String getMnslistExp(String host, String random, String businessType, String time, String appName) {
        if (StringUtils.isEmpty((String)random)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapSender = new HashMap<String, String>();
        mapSender.put("code", "sys");
        mapSender.put("name", "sys");
        map.put("sender", JsonUtil.buildNonDefaultBinder().toJson(mapSender));
        ArrayList listReceiver = new ArrayList();
        HashMap<String, String> mapReceiver = new HashMap<String, String>();
        mapReceiver.put("code", "");
        mapReceiver.put("name", "");
        mapReceiver.put("telphone", host);
        mapReceiver.put("email", host);
        listReceiver.add(mapReceiver);
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(listReceiver));
        map.put("theme", "");
        map.put("businessType", businessType);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("random", random);
        paramMap.put("time", time);
        if (StringUtils.isNotBlank((String)appName)) {
            paramMap.put("appName", appName);
        }
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        return JsonUtil.buildNonDefaultBinder().toJson(map);
    }
}

