/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.recruit.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.recruit.dao.RecChannelSendApiMapper;
import com.yqbsoft.laser.service.recruit.domain.RecChannelSendApiDomain;
import com.yqbsoft.laser.service.recruit.domain.RecChannelSendApiReDomain;
import com.yqbsoft.laser.service.recruit.model.RecChannelSendApi;
import com.yqbsoft.laser.service.recruit.service.RecChannelSendApiService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecChannelSendApiServiceImpl
extends BaseServiceImpl
implements RecChannelSendApiService {
    private static final String SYS_CODE = "rec.RecChannelSendApiServiceImpl";
    private RecChannelSendApiMapper recChannelSendApiMapper;

    public void setRecChannelSendApiMapper(RecChannelSendApiMapper recChannelSendApiMapper) {
        this.recChannelSendApiMapper = recChannelSendApiMapper;
    }

    private Date getSysDate() {
        try {
            return this.recChannelSendApiMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendApiServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkChannelSendApi(RecChannelSendApiDomain recChannelSendApiDomain) {
        if (null == recChannelSendApiDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)recChannelSendApiDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setChannelSendApiDefault(RecChannelSendApi recChannelSendApi) {
        if (null == recChannelSendApi) {
            return;
        }
        if (null == recChannelSendApi.getDataState()) {
            recChannelSendApi.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == recChannelSendApi.getGmtCreate()) {
            recChannelSendApi.setGmtCreate(date);
        }
        recChannelSendApi.setGmtModified(date);
        if (StringUtils.isBlank((String)recChannelSendApi.getChannelsendApiCode())) {
            recChannelSendApi.setChannelsendApiCode(this.getNo(null, "RecChannelSendApi", "recChannelSendApi", recChannelSendApi.getTenantCode()));
        }
    }

    private int getChannelSendApiMaxCode() {
        int code = 0;
        try {
            return this.recChannelSendApiMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendApiServiceImpl.getChannelSendApiMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setChannelSendApiUpdataDefault(RecChannelSendApi recChannelSendApi) {
        if (null == recChannelSendApi) {
            return;
        }
        recChannelSendApi.setGmtModified(this.getSysDate());
    }

    private void saveChannelSendApiModel(RecChannelSendApi recChannelSendApi) throws ApiException {
        if (null == recChannelSendApi) {
            return;
        }
        try {
            this.recChannelSendApiMapper.insert(recChannelSendApi);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendApiServiceImpl.saveChannelSendApiModel.ex", (Throwable)e);
        }
    }

    private void saveChannelSendApiBatchModel(List<RecChannelSendApi> recChannelSendApiList) throws ApiException {
        if (null == recChannelSendApiList || recChannelSendApiList.isEmpty()) {
            return;
        }
        try {
            this.recChannelSendApiMapper.insertBatch(recChannelSendApiList);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendApiServiceImpl.saveChannelSendApiBatchModel.ex", (Throwable)e);
        }
    }

    private RecChannelSendApi getChannelSendApiModelById(Integer channelsendApiId) {
        if (null == channelsendApiId) {
            return null;
        }
        try {
            return this.recChannelSendApiMapper.selectByPrimaryKey(channelsendApiId);
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendApiServiceImpl.getChannelSendApiModelById", (Throwable)e);
            return null;
        }
    }

    private RecChannelSendApi getChannelSendApiModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.recChannelSendApiMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendApiServiceImpl.getChannelSendApiModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delChannelSendApiModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.recChannelSendApiMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendApiServiceImpl.delChannelSendApiModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecChannelSendApiServiceImpl.delChannelSendApiModelByCode.num");
        }
    }

    private void deleteChannelSendApiModel(Integer channelsendApiId) throws ApiException {
        if (null == channelsendApiId) {
            return;
        }
        int i = 0;
        try {
            i = this.recChannelSendApiMapper.deleteByPrimaryKey(channelsendApiId);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendApiServiceImpl.deleteChannelSendApiModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecChannelSendApiServiceImpl.deleteChannelSendApiModel.num");
        }
    }

    private void updateChannelSendApiModel(RecChannelSendApi recChannelSendApi) throws ApiException {
        if (null == recChannelSendApi) {
            return;
        }
        int i = 0;
        try {
            i = this.recChannelSendApiMapper.updateByPrimaryKey(recChannelSendApi);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendApiServiceImpl.updateChannelSendApiModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecChannelSendApiServiceImpl.updateChannelSendApiModel.num");
        }
    }

    private void updateStateChannelSendApiModel(Integer channelsendApiId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == channelsendApiId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelsendApiId", channelsendApiId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recChannelSendApiMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendApiServiceImpl.updateStateChannelSendApiModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecChannelSendApiServiceImpl.updateStateChannelSendApiModel.null");
        }
    }

    private void updateStateChannelSendApiModelByCode(String tenantCode, String channelsendApiCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)channelsendApiCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelsendApiCode", channelsendApiCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recChannelSendApiMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendApiServiceImpl.updateStateChannelSendApiModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecChannelSendApiServiceImpl.updateStateChannelSendApiModelByCode.null");
        }
    }

    private RecChannelSendApi makeChannelSendApi(RecChannelSendApiDomain recChannelSendApiDomain, RecChannelSendApi recChannelSendApi) {
        if (null == recChannelSendApiDomain) {
            return null;
        }
        if (null == recChannelSendApi) {
            recChannelSendApi = new RecChannelSendApi();
        }
        try {
            BeanUtils.copyAllPropertys((Object)recChannelSendApi, (Object)recChannelSendApiDomain);
            return recChannelSendApi;
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendApiServiceImpl.makeChannelSendApi", (Throwable)e);
            return null;
        }
    }

    private RecChannelSendApiReDomain makeRecChannelSendApiReDomain(RecChannelSendApi recChannelSendApi) {
        if (null == recChannelSendApi) {
            return null;
        }
        RecChannelSendApiReDomain recChannelSendApiReDomain = new RecChannelSendApiReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)recChannelSendApiReDomain, (Object)recChannelSendApi);
            return recChannelSendApiReDomain;
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendApiServiceImpl.makeRecChannelSendApiReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RecChannelSendApi> queryChannelSendApiModelPage(Map<String, Object> parammap) {
        try {
            return this.recChannelSendApiMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendApiServiceImpl.queryChannelSendApiModel", (Throwable)e);
            return null;
        }
    }

    private int countChannelSendApi(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.recChannelSendApiMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendApiServiceImpl.countChannelSendApi", (Throwable)e);
        }
        return i;
    }

    private RecChannelSendApi createRecChannelSendApi(RecChannelSendApiDomain recChannelSendApiDomain) {
        String msg = this.checkChannelSendApi(recChannelSendApiDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecChannelSendApiServiceImpl.saveChannelSendApi.checkChannelSendApi", msg);
        }
        RecChannelSendApi recChannelSendApi = this.makeChannelSendApi(recChannelSendApiDomain, null);
        this.setChannelSendApiDefault(recChannelSendApi);
        return recChannelSendApi;
    }

    @Override
    public String saveChannelSendApi(RecChannelSendApiDomain recChannelSendApiDomain) throws ApiException {
        RecChannelSendApi recChannelSendApi = this.createRecChannelSendApi(recChannelSendApiDomain);
        this.saveChannelSendApiModel(recChannelSendApi);
        return recChannelSendApi.getChannelsendApiCode();
    }

    @Override
    public String saveChannelSendApiBatch(List<RecChannelSendApiDomain> recChannelSendApiDomainList) throws ApiException {
        if (null == recChannelSendApiDomainList || recChannelSendApiDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RecChannelSendApi> recChannelSendApiList = new ArrayList<RecChannelSendApi>();
        String code = "";
        for (RecChannelSendApiDomain recChannelSendApiDomain : recChannelSendApiDomainList) {
            RecChannelSendApi recChannelSendApi = this.createRecChannelSendApi(recChannelSendApiDomain);
            code = recChannelSendApi.getChannelsendApiCode();
            recChannelSendApiList.add(recChannelSendApi);
        }
        this.saveChannelSendApiBatchModel(recChannelSendApiList);
        return code;
    }

    @Override
    public void updateChannelSendApiState(Integer channelsendApiId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == channelsendApiId) {
            return;
        }
        this.updateStateChannelSendApiModel(channelsendApiId, dataState, oldDataState, map);
    }

    @Override
    public void updateChannelSendApiStateByCode(String tenantCode, String channelsendApiCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)channelsendApiCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateChannelSendApiModelByCode(tenantCode, channelsendApiCode, dataState, oldDataState, map);
    }

    @Override
    public void updateChannelSendApi(RecChannelSendApiDomain recChannelSendApiDomain) throws ApiException {
        String msg = this.checkChannelSendApi(recChannelSendApiDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecChannelSendApiServiceImpl.updateChannelSendApi.checkChannelSendApi", msg);
        }
        RecChannelSendApi oldRecChannelSendApi = this.getChannelSendApiModelById(recChannelSendApiDomain.getChannelsendApiId());
        if (null == oldRecChannelSendApi) {
            throw new ApiException("rec.RecChannelSendApiServiceImpl.updateChannelSendApi.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RecChannelSendApi recChannelSendApi = this.makeChannelSendApi(recChannelSendApiDomain, oldRecChannelSendApi);
        this.setChannelSendApiUpdataDefault(recChannelSendApi);
        this.updateChannelSendApiModel(recChannelSendApi);
    }

    @Override
    public RecChannelSendApi getChannelSendApi(Integer channelsendApiId) {
        if (null == channelsendApiId) {
            return null;
        }
        return this.getChannelSendApiModelById(channelsendApiId);
    }

    @Override
    public void deleteChannelSendApi(Integer channelsendApiId) throws ApiException {
        if (null == channelsendApiId) {
            return;
        }
        this.deleteChannelSendApiModel(channelsendApiId);
    }

    @Override
    public QueryResult<RecChannelSendApi> queryChannelSendApiPage(Map<String, Object> map) {
        List<RecChannelSendApi> recChannelSendApiList = this.queryChannelSendApiModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countChannelSendApi(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(recChannelSendApiList);
        return queryResult;
    }

    @Override
    public RecChannelSendApi getChannelSendApiByCode(String tenantCode, String channelsendApiCode) throws ApiException {
        if (StringUtils.isBlank((String)channelsendApiCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelsendApiCode", channelsendApiCode);
        return this.getChannelSendApiModelByCode(map);
    }

    @Override
    public void deleteChannelSendApiByCode(String tenantCode, String channelsendApiCode) throws ApiException {
        if (StringUtils.isBlank((String)channelsendApiCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelsendApiCode", channelsendApiCode);
        this.delChannelSendApiModelByCode(map);
    }
}

