/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.recruit.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.recruit.dao.RecChannelSendMapper;
import com.yqbsoft.laser.service.recruit.domain.RecChannelSendDomain;
import com.yqbsoft.laser.service.recruit.domain.RecChannelSendReDomain;
import com.yqbsoft.laser.service.recruit.model.RecChannelSend;
import com.yqbsoft.laser.service.recruit.service.RecChannelSendService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecChannelSendServiceImpl
extends BaseServiceImpl
implements RecChannelSendService {
    private static final String SYS_CODE = "rec.RecChannelSendServiceImpl";
    private RecChannelSendMapper recChannelSendMapper;

    public void setRecChannelSendMapper(RecChannelSendMapper recChannelSendMapper) {
        this.recChannelSendMapper = recChannelSendMapper;
    }

    private Date getSysDate() {
        try {
            return this.recChannelSendMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkChannelSend(RecChannelSendDomain recChannelSendDomain) {
        if (null == recChannelSendDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)recChannelSendDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setChannelSendDefault(RecChannelSend recChannelSend) {
        if (null == recChannelSend) {
            return;
        }
        if (null == recChannelSend.getDataState()) {
            recChannelSend.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == recChannelSend.getGmtCreate()) {
            recChannelSend.setGmtCreate(date);
        }
        recChannelSend.setGmtModified(date);
        if (StringUtils.isBlank((String)recChannelSend.getChannelsendCode())) {
            recChannelSend.setChannelsendCode(this.getNo(null, "RecChannelSend", "recChannelSend", recChannelSend.getTenantCode()));
        }
    }

    private int getChannelSendMaxCode() {
        int code = 0;
        try {
            return this.recChannelSendMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendServiceImpl.getChannelSendMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setChannelSendUpdataDefault(RecChannelSend recChannelSend) {
        if (null == recChannelSend) {
            return;
        }
        recChannelSend.setGmtModified(this.getSysDate());
    }

    private void saveChannelSendModel(RecChannelSend recChannelSend) throws ApiException {
        if (null == recChannelSend) {
            return;
        }
        try {
            this.recChannelSendMapper.insert(recChannelSend);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendServiceImpl.saveChannelSendModel.ex", (Throwable)e);
        }
    }

    private void saveChannelSendBatchModel(List<RecChannelSend> recChannelSendList) throws ApiException {
        if (null == recChannelSendList || recChannelSendList.isEmpty()) {
            return;
        }
        try {
            this.recChannelSendMapper.insertBatch(recChannelSendList);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendServiceImpl.saveChannelSendBatchModel.ex", (Throwable)e);
        }
    }

    private RecChannelSend getChannelSendModelById(Integer channelsendId) {
        if (null == channelsendId) {
            return null;
        }
        try {
            return this.recChannelSendMapper.selectByPrimaryKey(channelsendId);
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendServiceImpl.getChannelSendModelById", (Throwable)e);
            return null;
        }
    }

    private RecChannelSend getChannelSendModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.recChannelSendMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendServiceImpl.getChannelSendModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delChannelSendModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.recChannelSendMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendServiceImpl.delChannelSendModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecChannelSendServiceImpl.delChannelSendModelByCode.num");
        }
    }

    private void deleteChannelSendModel(Integer channelsendId) throws ApiException {
        if (null == channelsendId) {
            return;
        }
        int i = 0;
        try {
            i = this.recChannelSendMapper.deleteByPrimaryKey(channelsendId);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendServiceImpl.deleteChannelSendModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecChannelSendServiceImpl.deleteChannelSendModel.num");
        }
    }

    private void updateChannelSendModel(RecChannelSend recChannelSend) throws ApiException {
        if (null == recChannelSend) {
            return;
        }
        int i = 0;
        try {
            i = this.recChannelSendMapper.updateByPrimaryKey(recChannelSend);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendServiceImpl.updateChannelSendModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecChannelSendServiceImpl.updateChannelSendModel.num");
        }
    }

    private void updateStateChannelSendModel(Integer channelsendId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == channelsendId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelsendId", channelsendId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recChannelSendMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendServiceImpl.updateStateChannelSendModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecChannelSendServiceImpl.updateStateChannelSendModel.null");
        }
    }

    private void updateStateChannelSendModelByCode(String tenantCode, String channelsendCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)channelsendCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelsendCode", channelsendCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recChannelSendMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendServiceImpl.updateStateChannelSendModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecChannelSendServiceImpl.updateStateChannelSendModelByCode.null");
        }
    }

    private RecChannelSend makeChannelSend(RecChannelSendDomain recChannelSendDomain, RecChannelSend recChannelSend) {
        if (null == recChannelSendDomain) {
            return null;
        }
        if (null == recChannelSend) {
            recChannelSend = new RecChannelSend();
        }
        try {
            BeanUtils.copyAllPropertys((Object)recChannelSend, (Object)recChannelSendDomain);
            return recChannelSend;
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendServiceImpl.makeChannelSend", (Throwable)e);
            return null;
        }
    }

    private RecChannelSendReDomain makeRecChannelSendReDomain(RecChannelSend recChannelSend) {
        if (null == recChannelSend) {
            return null;
        }
        RecChannelSendReDomain recChannelSendReDomain = new RecChannelSendReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)recChannelSendReDomain, (Object)recChannelSend);
            return recChannelSendReDomain;
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendServiceImpl.makeRecChannelSendReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RecChannelSend> queryChannelSendModelPage(Map<String, Object> parammap) {
        try {
            return this.recChannelSendMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendServiceImpl.queryChannelSendModel", (Throwable)e);
            return null;
        }
    }

    private int countChannelSend(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.recChannelSendMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendServiceImpl.countChannelSend", (Throwable)e);
        }
        return i;
    }

    private RecChannelSend createRecChannelSend(RecChannelSendDomain recChannelSendDomain) {
        String msg = this.checkChannelSend(recChannelSendDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecChannelSendServiceImpl.saveChannelSend.checkChannelSend", msg);
        }
        RecChannelSend recChannelSend = this.makeChannelSend(recChannelSendDomain, null);
        this.setChannelSendDefault(recChannelSend);
        return recChannelSend;
    }

    @Override
    public String saveChannelSend(RecChannelSendDomain recChannelSendDomain) throws ApiException {
        RecChannelSend recChannelSend = this.createRecChannelSend(recChannelSendDomain);
        this.saveChannelSendModel(recChannelSend);
        return recChannelSend.getChannelsendCode();
    }

    @Override
    public String saveChannelSendBatch(List<RecChannelSendDomain> recChannelSendDomainList) throws ApiException {
        if (null == recChannelSendDomainList || recChannelSendDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RecChannelSend> recChannelSendList = new ArrayList<RecChannelSend>();
        String code = "";
        for (RecChannelSendDomain recChannelSendDomain : recChannelSendDomainList) {
            RecChannelSend recChannelSend = this.createRecChannelSend(recChannelSendDomain);
            code = recChannelSend.getChannelsendCode();
            recChannelSendList.add(recChannelSend);
        }
        this.saveChannelSendBatchModel(recChannelSendList);
        return code;
    }

    @Override
    public void updateChannelSendState(Integer channelsendId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == channelsendId) {
            return;
        }
        this.updateStateChannelSendModel(channelsendId, dataState, oldDataState, map);
    }

    @Override
    public void updateChannelSendStateByCode(String tenantCode, String channelsendCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)channelsendCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateChannelSendModelByCode(tenantCode, channelsendCode, dataState, oldDataState, map);
    }

    @Override
    public void updateChannelSend(RecChannelSendDomain recChannelSendDomain) throws ApiException {
        String msg = this.checkChannelSend(recChannelSendDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecChannelSendServiceImpl.updateChannelSend.checkChannelSend", msg);
        }
        RecChannelSend oldRecChannelSend = this.getChannelSendModelById(recChannelSendDomain.getChannelsendId());
        if (null == oldRecChannelSend) {
            throw new ApiException("rec.RecChannelSendServiceImpl.updateChannelSend.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RecChannelSend recChannelSend = this.makeChannelSend(recChannelSendDomain, oldRecChannelSend);
        this.setChannelSendUpdataDefault(recChannelSend);
        this.updateChannelSendModel(recChannelSend);
    }

    @Override
    public RecChannelSend getChannelSend(Integer channelsendId) {
        if (null == channelsendId) {
            return null;
        }
        return this.getChannelSendModelById(channelsendId);
    }

    @Override
    public void deleteChannelSend(Integer channelsendId) throws ApiException {
        if (null == channelsendId) {
            return;
        }
        this.deleteChannelSendModel(channelsendId);
    }

    @Override
    public QueryResult<RecChannelSend> queryChannelSendPage(Map<String, Object> map) {
        List<RecChannelSend> recChannelSendList = this.queryChannelSendModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countChannelSend(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(recChannelSendList);
        return queryResult;
    }

    @Override
    public RecChannelSend getChannelSendByCode(String tenantCode, String channelsendCode) throws ApiException {
        if (StringUtils.isBlank((String)channelsendCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelsendCode", channelsendCode);
        return this.getChannelSendModelByCode(map);
    }

    @Override
    public void deleteChannelSendByCode(String tenantCode, String channelsendCode) throws ApiException {
        if (StringUtils.isBlank((String)channelsendCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelsendCode", channelsendCode);
        this.delChannelSendModelByCode(map);
    }
}

