/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.recruit.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.recruit.dao.RecChannelSendListMapper;
import com.yqbsoft.laser.service.recruit.domain.RecChannelSendListDomain;
import com.yqbsoft.laser.service.recruit.domain.RecChannelSendListReDomain;
import com.yqbsoft.laser.service.recruit.model.RecChannelSendList;
import com.yqbsoft.laser.service.recruit.service.RecChannelSendListService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecChannelSendListServiceImpl
extends BaseServiceImpl
implements RecChannelSendListService {
    private static final String SYS_CODE = "rec.RecChannelSendListServiceImpl";
    private RecChannelSendListMapper recChannelSendListMapper;

    public void setRecChannelSendListMapper(RecChannelSendListMapper recChannelSendListMapper) {
        this.recChannelSendListMapper = recChannelSendListMapper;
    }

    private Date getSysDate() {
        try {
            return this.recChannelSendListMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendListServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkChannelSendList(RecChannelSendListDomain recChannelSendListDomain) {
        if (null == recChannelSendListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)recChannelSendListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setChannelSendListDefault(RecChannelSendList recChannelSendList) {
        if (null == recChannelSendList) {
            return;
        }
        if (null == recChannelSendList.getDataState()) {
            recChannelSendList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == recChannelSendList.getGmtCreate()) {
            recChannelSendList.setGmtCreate(date);
        }
        recChannelSendList.setGmtModified(date);
        if (StringUtils.isBlank((String)recChannelSendList.getChannelsendlistCode())) {
            recChannelSendList.setChannelsendlistCode(this.getNo(null, "RecChannelSendList", "recChannelSendList", recChannelSendList.getTenantCode()));
        }
    }

    private int getChannelSendListMaxCode() {
        int code = 0;
        try {
            return this.recChannelSendListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendListServiceImpl.getChannelSendListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setChannelSendListUpdataDefault(RecChannelSendList recChannelSendList) {
        if (null == recChannelSendList) {
            return;
        }
        recChannelSendList.setGmtModified(this.getSysDate());
    }

    private void saveChannelSendListModel(RecChannelSendList recChannelSendList) throws ApiException {
        if (null == recChannelSendList) {
            return;
        }
        try {
            this.recChannelSendListMapper.insert(recChannelSendList);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendListServiceImpl.saveChannelSendListModel.ex", (Throwable)e);
        }
    }

    private void saveChannelSendListBatchModel(List<RecChannelSendList> recChannelSendListList) throws ApiException {
        if (null == recChannelSendListList || recChannelSendListList.isEmpty()) {
            return;
        }
        try {
            this.recChannelSendListMapper.insertBatch(recChannelSendListList);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendListServiceImpl.saveChannelSendListBatchModel.ex", (Throwable)e);
        }
    }

    private RecChannelSendList getChannelSendListModelById(Integer channelsendlistId) {
        if (null == channelsendlistId) {
            return null;
        }
        try {
            return this.recChannelSendListMapper.selectByPrimaryKey(channelsendlistId);
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendListServiceImpl.getChannelSendListModelById", (Throwable)e);
            return null;
        }
    }

    private RecChannelSendList getChannelSendListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.recChannelSendListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendListServiceImpl.getChannelSendListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delChannelSendListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.recChannelSendListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendListServiceImpl.delChannelSendListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecChannelSendListServiceImpl.delChannelSendListModelByCode.num");
        }
    }

    private void deleteChannelSendListModel(Integer channelsendlistId) throws ApiException {
        if (null == channelsendlistId) {
            return;
        }
        int i = 0;
        try {
            i = this.recChannelSendListMapper.deleteByPrimaryKey(channelsendlistId);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendListServiceImpl.deleteChannelSendListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecChannelSendListServiceImpl.deleteChannelSendListModel.num");
        }
    }

    private void updateChannelSendListModel(RecChannelSendList recChannelSendList) throws ApiException {
        if (null == recChannelSendList) {
            return;
        }
        int i = 0;
        try {
            i = this.recChannelSendListMapper.updateByPrimaryKey(recChannelSendList);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendListServiceImpl.updateChannelSendListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecChannelSendListServiceImpl.updateChannelSendListModel.num");
        }
    }

    private void updateStateChannelSendListModel(Integer channelsendlistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == channelsendlistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelsendlistId", channelsendlistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recChannelSendListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendListServiceImpl.updateStateChannelSendListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecChannelSendListServiceImpl.updateStateChannelSendListModel.null");
        }
    }

    private void updateStateChannelSendListModelByCode(String tenantCode, String channelsendlistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)channelsendlistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelsendlistCode", channelsendlistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recChannelSendListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecChannelSendListServiceImpl.updateStateChannelSendListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecChannelSendListServiceImpl.updateStateChannelSendListModelByCode.null");
        }
    }

    private RecChannelSendList makeChannelSendList(RecChannelSendListDomain recChannelSendListDomain, RecChannelSendList recChannelSendList) {
        if (null == recChannelSendListDomain) {
            return null;
        }
        if (null == recChannelSendList) {
            recChannelSendList = new RecChannelSendList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)recChannelSendList, (Object)recChannelSendListDomain);
            return recChannelSendList;
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendListServiceImpl.makeChannelSendList", (Throwable)e);
            return null;
        }
    }

    private RecChannelSendListReDomain makeRecChannelSendListReDomain(RecChannelSendList recChannelSendList) {
        if (null == recChannelSendList) {
            return null;
        }
        RecChannelSendListReDomain recChannelSendListReDomain = new RecChannelSendListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)recChannelSendListReDomain, (Object)recChannelSendList);
            return recChannelSendListReDomain;
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendListServiceImpl.makeRecChannelSendListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RecChannelSendList> queryChannelSendListModelPage(Map<String, Object> parammap) {
        try {
            return this.recChannelSendListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendListServiceImpl.queryChannelSendListModel", (Throwable)e);
            return null;
        }
    }

    private int countChannelSendList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.recChannelSendListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecChannelSendListServiceImpl.countChannelSendList", (Throwable)e);
        }
        return i;
    }

    private RecChannelSendList createRecChannelSendList(RecChannelSendListDomain recChannelSendListDomain) {
        String msg = this.checkChannelSendList(recChannelSendListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecChannelSendListServiceImpl.saveChannelSendList.checkChannelSendList", msg);
        }
        RecChannelSendList recChannelSendList = this.makeChannelSendList(recChannelSendListDomain, null);
        this.setChannelSendListDefault(recChannelSendList);
        return recChannelSendList;
    }

    @Override
    public String saveChannelSendList(RecChannelSendListDomain recChannelSendListDomain) throws ApiException {
        RecChannelSendList recChannelSendList = this.createRecChannelSendList(recChannelSendListDomain);
        this.saveChannelSendListModel(recChannelSendList);
        return recChannelSendList.getChannelsendlistCode();
    }

    @Override
    public String saveChannelSendListBatch(List<RecChannelSendListDomain> recChannelSendListDomainList) throws ApiException {
        if (null == recChannelSendListDomainList || recChannelSendListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RecChannelSendList> recChannelSendListList = new ArrayList<RecChannelSendList>();
        String code = "";
        for (RecChannelSendListDomain recChannelSendListDomain : recChannelSendListDomainList) {
            RecChannelSendList recChannelSendList = this.createRecChannelSendList(recChannelSendListDomain);
            code = recChannelSendList.getChannelsendlistCode();
            recChannelSendListList.add(recChannelSendList);
        }
        this.saveChannelSendListBatchModel(recChannelSendListList);
        return code;
    }

    @Override
    public void updateChannelSendListState(Integer channelsendlistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == channelsendlistId) {
            return;
        }
        this.updateStateChannelSendListModel(channelsendlistId, dataState, oldDataState, map);
    }

    @Override
    public void updateChannelSendListStateByCode(String tenantCode, String channelsendlistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)channelsendlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateChannelSendListModelByCode(tenantCode, channelsendlistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateChannelSendList(RecChannelSendListDomain recChannelSendListDomain) throws ApiException {
        String msg = this.checkChannelSendList(recChannelSendListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecChannelSendListServiceImpl.updateChannelSendList.checkChannelSendList", msg);
        }
        RecChannelSendList oldRecChannelSendList = this.getChannelSendListModelById(recChannelSendListDomain.getChannelsendlistId());
        if (null == oldRecChannelSendList) {
            throw new ApiException("rec.RecChannelSendListServiceImpl.updateChannelSendList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RecChannelSendList recChannelSendList = this.makeChannelSendList(recChannelSendListDomain, oldRecChannelSendList);
        this.setChannelSendListUpdataDefault(recChannelSendList);
        this.updateChannelSendListModel(recChannelSendList);
    }

    @Override
    public RecChannelSendList getChannelSendList(Integer channelsendlistId) {
        if (null == channelsendlistId) {
            return null;
        }
        return this.getChannelSendListModelById(channelsendlistId);
    }

    @Override
    public void deleteChannelSendList(Integer channelsendlistId) throws ApiException {
        if (null == channelsendlistId) {
            return;
        }
        this.deleteChannelSendListModel(channelsendlistId);
    }

    @Override
    public QueryResult<RecChannelSendList> queryChannelSendListPage(Map<String, Object> map) {
        List<RecChannelSendList> recChannelSendListList = this.queryChannelSendListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countChannelSendList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(recChannelSendListList);
        return queryResult;
    }

    @Override
    public RecChannelSendList getChannelSendListByCode(String tenantCode, String channelsendlistCode) throws ApiException {
        if (StringUtils.isBlank((String)channelsendlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelsendlistCode", channelsendlistCode);
        return this.getChannelSendListModelByCode(map);
    }

    @Override
    public void deleteChannelSendListByCode(String tenantCode, String channelsendlistCode) throws ApiException {
        if (StringUtils.isBlank((String)channelsendlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelsendlistCode", channelsendlistCode);
        this.delChannelSendListModelByCode(map);
    }
}

