/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.recruit.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.recruit.dao.RecRecruitEnrollFileMapper;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitEnrollFileDomain;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitEnrollFileReDomain;
import com.yqbsoft.laser.service.recruit.model.RecRecruitEnrollFile;
import com.yqbsoft.laser.service.recruit.service.RecRecruitEnrollFileService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecRecruitEnrollFileServiceImpl
extends BaseServiceImpl
implements RecRecruitEnrollFileService {
    private static final String SYS_CODE = "rec.RecRecruitEnrollFileServiceImpl";
    private RecRecruitEnrollFileMapper recRecruitEnrollFileMapper;

    public void setRecRecruitEnrollFileMapper(RecRecruitEnrollFileMapper recRecruitEnrollFileMapper) {
        this.recRecruitEnrollFileMapper = recRecruitEnrollFileMapper;
    }

    private Date getSysDate() {
        try {
            return this.recRecruitEnrollFileMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitEnrollFileServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRecruitEnrollFile(RecRecruitEnrollFileDomain recRecruitEnrollFileDomain) {
        if (null == recRecruitEnrollFileDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)recRecruitEnrollFileDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRecruitEnrollFileDefault(RecRecruitEnrollFile recRecruitEnrollFile) {
        if (null == recRecruitEnrollFile) {
            return;
        }
        if (null == recRecruitEnrollFile.getDataState()) {
            recRecruitEnrollFile.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == recRecruitEnrollFile.getGmtCreate()) {
            recRecruitEnrollFile.setGmtCreate(date);
        }
        recRecruitEnrollFile.setGmtModified(date);
        if (StringUtils.isBlank((String)recRecruitEnrollFile.getRecruitEnrollfileCode())) {
            recRecruitEnrollFile.setRecruitEnrollfileCode(this.createUUIDString());
        }
    }

    private int getRecruitEnrollFileMaxCode() {
        int code = 0;
        try {
            return this.recRecruitEnrollFileMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitEnrollFileServiceImpl.getRecruitEnrollFileMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRecruitEnrollFileUpdataDefault(RecRecruitEnrollFile recRecruitEnrollFile) {
        if (null == recRecruitEnrollFile) {
            return;
        }
        recRecruitEnrollFile.setGmtModified(this.getSysDate());
    }

    private void saveRecruitEnrollFileModel(RecRecruitEnrollFile recRecruitEnrollFile) throws ApiException {
        if (null == recRecruitEnrollFile) {
            return;
        }
        try {
            Integer i = this.recRecruitEnrollFileMapper.insert(recRecruitEnrollFile);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitEnrollFileServiceImpl.saveRecruitEnrollFileModel.ex", (Throwable)e);
        }
    }

    private void saveRecruitEnrollFileBatchModel(List<RecRecruitEnrollFile> recRecruitEnrollFileList) throws ApiException {
        if (null == recRecruitEnrollFileList || recRecruitEnrollFileList.isEmpty()) {
            return;
        }
        try {
            this.recRecruitEnrollFileMapper.insertBatch(recRecruitEnrollFileList);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitEnrollFileServiceImpl.saveRecruitEnrollFileBatchModel.ex", (Throwable)e);
        }
    }

    private RecRecruitEnrollFile getRecruitEnrollFileModelById(Integer recruitEnrollfileId) {
        if (null == recruitEnrollfileId) {
            return null;
        }
        try {
            return this.recRecruitEnrollFileMapper.selectByPrimaryKey(recruitEnrollfileId);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitEnrollFileServiceImpl.getRecruitEnrollFileModelById", (Throwable)e);
            return null;
        }
    }

    private RecRecruitEnrollFile getRecruitEnrollFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.recRecruitEnrollFileMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitEnrollFileServiceImpl.getRecruitEnrollFileModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRecruitEnrollFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitEnrollFileMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitEnrollFileServiceImpl.delRecruitEnrollFileModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitEnrollFileServiceImpl.delRecruitEnrollFileModelByCode.num");
        }
    }

    private void deleteRecruitEnrollFileModel(Integer recruitEnrollfileId) throws ApiException {
        if (null == recruitEnrollfileId) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitEnrollFileMapper.deleteByPrimaryKey(recruitEnrollfileId);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitEnrollFileServiceImpl.deleteRecruitEnrollFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitEnrollFileServiceImpl.deleteRecruitEnrollFileModel.num");
        }
    }

    private void updateRecruitEnrollFileModel(RecRecruitEnrollFile recRecruitEnrollFile) throws ApiException {
        if (null == recRecruitEnrollFile) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitEnrollFileMapper.updateByPrimaryKey(recRecruitEnrollFile);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitEnrollFileServiceImpl.updateRecruitEnrollFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitEnrollFileServiceImpl.updateRecruitEnrollFileModel.num");
        }
    }

    private void updateStateRecruitEnrollFileModel(Integer recruitEnrollfileId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == recruitEnrollfileId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recruitEnrollfileId", recruitEnrollfileId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recRecruitEnrollFileMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitEnrollFileServiceImpl.updateStateRecruitEnrollFileModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecRecruitEnrollFileServiceImpl.updateStateRecruitEnrollFileModel.null");
        }
    }

    private void updateStateRecruitEnrollFileModelByCode(String tenantCode, String recruitEnrollfileCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)recruitEnrollfileCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitEnrollfileCode", recruitEnrollfileCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recRecruitEnrollFileMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitEnrollFileServiceImpl.updateStateRecruitEnrollFileModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecRecruitEnrollFileServiceImpl.updateStateRecruitEnrollFileModelByCode.null");
        }
    }

    private RecRecruitEnrollFile makeRecruitEnrollFile(RecRecruitEnrollFileDomain recRecruitEnrollFileDomain, RecRecruitEnrollFile recRecruitEnrollFile) {
        if (null == recRecruitEnrollFileDomain) {
            return null;
        }
        if (null == recRecruitEnrollFile) {
            recRecruitEnrollFile = new RecRecruitEnrollFile();
        }
        try {
            BeanUtils.copyAllPropertys((Object)recRecruitEnrollFile, (Object)recRecruitEnrollFileDomain);
            return recRecruitEnrollFile;
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitEnrollFileServiceImpl.makeRecruitEnrollFile", (Throwable)e);
            return null;
        }
    }

    private RecRecruitEnrollFileReDomain makeRecRecruitEnrollFileReDomain(RecRecruitEnrollFile recRecruitEnrollFile) {
        if (null == recRecruitEnrollFile) {
            return null;
        }
        RecRecruitEnrollFileReDomain recRecruitEnrollFileReDomain = new RecRecruitEnrollFileReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)recRecruitEnrollFileReDomain, (Object)recRecruitEnrollFile);
            return recRecruitEnrollFileReDomain;
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitEnrollFileServiceImpl.makeRecRecruitEnrollFileReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RecRecruitEnrollFile> queryRecruitEnrollFileModelPage(Map<String, Object> parammap) {
        try {
            return this.recRecruitEnrollFileMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitEnrollFileServiceImpl.queryRecruitEnrollFileModel", (Throwable)e);
            return null;
        }
    }

    private int countRecruitEnrollFile(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.recRecruitEnrollFileMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitEnrollFileServiceImpl.countRecruitEnrollFile", (Throwable)e);
        }
        return i;
    }

    private RecRecruitEnrollFile createRecRecruitEnrollFile(RecRecruitEnrollFileDomain recRecruitEnrollFileDomain) {
        String msg = this.checkRecruitEnrollFile(recRecruitEnrollFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecRecruitEnrollFileServiceImpl.saveRecruitEnrollFile.checkRecruitEnrollFile", msg);
        }
        RecRecruitEnrollFile recRecruitEnrollFile = this.makeRecruitEnrollFile(recRecruitEnrollFileDomain, null);
        this.setRecruitEnrollFileDefault(recRecruitEnrollFile);
        return recRecruitEnrollFile;
    }

    @Override
    public String saveRecruitEnrollFile(RecRecruitEnrollFileDomain recRecruitEnrollFileDomain) throws ApiException {
        RecRecruitEnrollFile recRecruitEnrollFile = this.createRecRecruitEnrollFile(recRecruitEnrollFileDomain);
        this.saveRecruitEnrollFileModel(recRecruitEnrollFile);
        return recRecruitEnrollFile.getRecruitEnrollfileCode();
    }

    @Override
    public String saveRecruitEnrollFileBatch(List<RecRecruitEnrollFileDomain> recRecruitEnrollFileDomainList) throws ApiException {
        if (null == recRecruitEnrollFileDomainList || recRecruitEnrollFileDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RecRecruitEnrollFile> recRecruitEnrollFileList = new ArrayList<RecRecruitEnrollFile>();
        String code = "";
        for (RecRecruitEnrollFileDomain recRecruitEnrollFileDomain : recRecruitEnrollFileDomainList) {
            RecRecruitEnrollFile recRecruitEnrollFile = this.createRecRecruitEnrollFile(recRecruitEnrollFileDomain);
            code = recRecruitEnrollFile.getRecruitEnrollfileCode();
            recRecruitEnrollFileList.add(recRecruitEnrollFile);
        }
        this.saveRecruitEnrollFileBatchModel(recRecruitEnrollFileList);
        return code;
    }

    @Override
    public void updateRecruitEnrollFileState(Integer recruitEnrollfileId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == recruitEnrollfileId) {
            return;
        }
        this.updateStateRecruitEnrollFileModel(recruitEnrollfileId, dataState, oldDataState, map);
    }

    @Override
    public void updateRecruitEnrollFileStateByCode(String tenantCode, String recruitEnrollfileCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)recruitEnrollfileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRecruitEnrollFileModelByCode(tenantCode, recruitEnrollfileCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRecruitEnrollFile(RecRecruitEnrollFileDomain recRecruitEnrollFileDomain) throws ApiException {
        String msg = this.checkRecruitEnrollFile(recRecruitEnrollFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecRecruitEnrollFileServiceImpl.updateRecruitEnrollFile.checkRecruitEnrollFile", msg);
        }
        RecRecruitEnrollFile oldRecRecruitEnrollFile = this.getRecruitEnrollFileModelById(recRecruitEnrollFileDomain.getRecruitEnrollfileId());
        if (null == oldRecRecruitEnrollFile) {
            throw new ApiException("rec.RecRecruitEnrollFileServiceImpl.updateRecruitEnrollFile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RecRecruitEnrollFile recRecruitEnrollFile = this.makeRecruitEnrollFile(recRecruitEnrollFileDomain, oldRecRecruitEnrollFile);
        this.setRecruitEnrollFileUpdataDefault(recRecruitEnrollFile);
        this.updateRecruitEnrollFileModel(recRecruitEnrollFile);
    }

    @Override
    public RecRecruitEnrollFile getRecruitEnrollFile(Integer recruitEnrollfileId) {
        if (null == recruitEnrollfileId) {
            return null;
        }
        return this.getRecruitEnrollFileModelById(recruitEnrollfileId);
    }

    @Override
    public void deleteRecruitEnrollFile(Integer recruitEnrollfileId) throws ApiException {
        if (null == recruitEnrollfileId) {
            return;
        }
        this.deleteRecruitEnrollFileModel(recruitEnrollfileId);
    }

    @Override
    public QueryResult<RecRecruitEnrollFile> queryRecruitEnrollFilePage(Map<String, Object> map) {
        List<RecRecruitEnrollFile> recRecruitEnrollFileList = this.queryRecruitEnrollFileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRecruitEnrollFile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(recRecruitEnrollFileList);
        return queryResult;
    }

    @Override
    public RecRecruitEnrollFile getRecruitEnrollFileByCode(String tenantCode, String recruitEnrollfileCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitEnrollfileCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitEnrollfileCode", recruitEnrollfileCode);
        return this.getRecruitEnrollFileModelByCode(map);
    }

    @Override
    public void deleteRecruitEnrollFileByCode(String tenantCode, String recruitEnrollfileCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitEnrollfileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitEnrollfileCode", recruitEnrollfileCode);
        this.delRecruitEnrollFileModelByCode(map);
    }
}

