/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.recruit.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.recruit.dao.RecRecruitMapper;
import com.yqbsoft.laser.service.recruit.dao.RecRecruitPersonnelMapper;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitDomain;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitEnrollDomain;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitFileDomain;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitOtherDomain;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitPersonnelDomain;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitReDomain;
import com.yqbsoft.laser.service.recruit.domain.RecRecruitServiceAreaDomain;
import com.yqbsoft.laser.service.recruit.domain.UmUserInfoReDomain;
import com.yqbsoft.laser.service.recruit.enumc.RecruitObj;
import com.yqbsoft.laser.service.recruit.enumc.RecruitStatus;
import com.yqbsoft.laser.service.recruit.model.RecRecruit;
import com.yqbsoft.laser.service.recruit.model.RecRecruitEnroll;
import com.yqbsoft.laser.service.recruit.model.RecRecruitFile;
import com.yqbsoft.laser.service.recruit.model.RecRecruitOther;
import com.yqbsoft.laser.service.recruit.service.RecRecruitEnrollFileService;
import com.yqbsoft.laser.service.recruit.service.RecRecruitEnrollService;
import com.yqbsoft.laser.service.recruit.service.RecRecruitFileService;
import com.yqbsoft.laser.service.recruit.service.RecRecruitOtherService;
import com.yqbsoft.laser.service.recruit.service.RecRecruitPersonnelService;
import com.yqbsoft.laser.service.recruit.service.RecRecruitService;
import com.yqbsoft.laser.service.recruit.service.RecRecruitServiceAreaService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.util.TextUtils;
import org.springframework.transaction.annotation.Transactional;

public class RecRecruitServiceImpl
extends BaseServiceImpl
implements RecRecruitService {
    private static final String SYS_CODE = "rec.RecRecruitServiceImpl";
    private RecRecruitMapper recRecruitMapper;
    private RecRecruitFileService recRecruitFileService;
    private RecRecruitOtherService recRecruitOtherService;
    private RecRecruitEnrollService recRecruitEnrollService;
    private RecRecruitEnrollFileService recRecruitEnrollFileService;
    private RecRecruitPersonnelService recRecruitPersonnelService;
    private RecRecruitPersonnelMapper recRecruitPersonnelMapper;
    private RecRecruitServiceAreaService recRecruitServiceAreaService;
    private static final int SIZE = 4;
    private static final String SYMBOL = "*";

    public RecRecruitEnrollFileService getRecRecruitEnrollFileService() {
        return this.recRecruitEnrollFileService;
    }

    public void setRecRecruitEnrollFileService(RecRecruitEnrollFileService recRecruitEnrollFileService) {
        this.recRecruitEnrollFileService = recRecruitEnrollFileService;
    }

    public RecRecruitPersonnelService getRecRecruitPersonnelService() {
        return this.recRecruitPersonnelService;
    }

    public void setRecRecruitPersonnelService(RecRecruitPersonnelService recRecruitPersonnelService) {
        this.recRecruitPersonnelService = recRecruitPersonnelService;
    }

    public RecRecruitPersonnelMapper getRecRecruitPersonnelMapper() {
        return this.recRecruitPersonnelMapper;
    }

    public void setRecRecruitPersonnelMapper(RecRecruitPersonnelMapper recRecruitPersonnelMapper) {
        this.recRecruitPersonnelMapper = recRecruitPersonnelMapper;
    }

    public RecRecruitServiceAreaService getRecRecruitServiceAreaService() {
        return this.recRecruitServiceAreaService;
    }

    public void setRecRecruitServiceAreaService(RecRecruitServiceAreaService recRecruitServiceAreaService) {
        this.recRecruitServiceAreaService = recRecruitServiceAreaService;
    }

    public void setRecRecruitMapper(RecRecruitMapper recRecruitMapper) {
        this.recRecruitMapper = recRecruitMapper;
    }

    public RecRecruitFileService getRecRecruitFileService() {
        return this.recRecruitFileService;
    }

    public void setRecRecruitFileService(RecRecruitFileService recRecruitFileService) {
        this.recRecruitFileService = recRecruitFileService;
    }

    public RecRecruitOtherService getRecRecruitOtherService() {
        return this.recRecruitOtherService;
    }

    public void setRecRecruitOtherService(RecRecruitOtherService recRecruitOtherService) {
        this.recRecruitOtherService = recRecruitOtherService;
    }

    public RecRecruitEnrollService getRecRecruitEnrollService() {
        return this.recRecruitEnrollService;
    }

    public void setRecRecruitEnrollService(RecRecruitEnrollService recRecruitEnrollService) {
        this.recRecruitEnrollService = recRecruitEnrollService;
    }

    private Date getSysDate() {
        try {
            return this.recRecruitMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRecruit(RecRecruitDomain recRecruitDomain) {
        if (null == recRecruitDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)recRecruitDomain.getRecruitName())) {
            msg = msg + "RecruitName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)recRecruitDomain.getRecruitType())) {
            msg = msg + "RecruitType\u4e3a\u7a7a;";
        }
        if (null != recRecruitDomain.getRecruitStype() && recRecruitDomain.getRecruitStype() == 1 && (null == recRecruitDomain.getRecruitEdate() || recRecruitDomain.getRecruitEdate().equals(""))) {
            msg = msg + "recruitEdate\u4e3a\u7a7a";
        }
        if (null != recRecruitDomain.getRecruitContactPhone() && !RecRecruitServiceImpl.isMobileNum(recRecruitDomain.getRecruitContactPhone()) && !RecRecruitServiceImpl.isPhoneNum(recRecruitDomain.getRecruitContactPhone())) {
            msg = msg + "\u8054\u7cfb\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e";
        }
        if (null != recRecruitDomain.getRecruitContactEmail() && !RecRecruitServiceImpl.isValidEmail(recRecruitDomain.getRecruitContactEmail())) {
            msg = msg + "\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e";
        }
        if (null != recRecruitDomain.getRecruitObj() && recRecruitDomain.getRecruitObj().equals(RecruitObj.SUPPLIER.getCode()) && (ListUtil.isEmpty(recRecruitDomain.getRecRecruitEnrollList()) || recRecruitDomain.getRecRecruitEnrollList().size() == 0)) {
            msg = msg + "\u672a\u9080\u8bf7\u4f9b\u8d27\u5546";
        }
        return msg;
    }

    public static boolean isMobileNum(String number) {
        String num = "[1][3456789]\\d{9}";
        if (TextUtils.isEmpty((CharSequence)number)) {
            return false;
        }
        return number.matches(num);
    }

    public static boolean isPhoneNum(String number) {
        String num = "([0-9]{3,4}-)?[0-9]{7,8}";
        if (TextUtils.isEmpty((CharSequence)number)) {
            return false;
        }
        return number.matches(num);
    }

    public static boolean isValidEmail(String email) {
        if (email != null && !email.isEmpty()) {
            return Pattern.matches("^(\\w+([-.][A-Za-z0-9]+)*){3,18}@\\w+([-.][A-Za-z0-9]+)*\\.\\w+([-.][A-Za-z0-9]+)*$", email);
        }
        return false;
    }

    public String hideInfo(String str) {
        return str.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
    }

    public String replaceNameX(String str) {
        String reg = ".{1}";
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(str);
        int i = 0;
        while (m.find()) {
            if (++i == 1) continue;
            m.appendReplacement(sb, SYMBOL);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public String display(String value) {
        if (null == value || "".equals(value)) {
            return value;
        }
        int len = value.length();
        int pamaone = len / 2;
        int pamatwo = pamaone - 1;
        int pamathree = len % 2;
        StringBuilder stringBuilder = new StringBuilder();
        if (len <= 2) {
            if (pamathree == 1) {
                return SYMBOL;
            }
            stringBuilder.append(SYMBOL);
            stringBuilder.append(value.charAt(len - 1));
        } else if (pamatwo <= 0) {
            stringBuilder.append(value.substring(0, 1));
            stringBuilder.append(SYMBOL);
            stringBuilder.append(value.substring(len - 1, len));
        } else if (pamatwo >= 2 && 5 != len) {
            int pamafive = (len - 4) / 2;
            stringBuilder.append(value.substring(0, pamafive));
            for (int i = 0; i < 4; ++i) {
                stringBuilder.append(SYMBOL);
            }
            if (pamathree == 0) {
                // empty if block
            }
            if (pamathree != 0) {
                // empty if block
            }
            stringBuilder.append(value.substring(len - (pamafive + 1), len));
        } else {
            int pamafour = len - 2;
            stringBuilder.append(value.substring(0, 1));
            for (int i = 0; i < pamafour; ++i) {
                stringBuilder.append(SYMBOL);
            }
            stringBuilder.append(value.substring(len - 1, len));
        }
        return stringBuilder.toString();
    }

    private void setRecruitDefault(RecRecruit recRecruit) {
        if (null == recRecruit) {
            return;
        }
        if (null == recRecruit.getDataState()) {
            recRecruit.setDataState(RecruitStatus.ACCEPTREGIST.getCode());
        }
        Date date = this.getSysDate();
        if (null == recRecruit.getGmtCreate()) {
            recRecruit.setGmtCreate(date);
        }
        recRecruit.setGmtModified(date);
        recRecruit.setRecruitPdate(date);
        if (StringUtils.isBlank((String)recRecruit.getRecruitCode())) {
            recRecruit.setRecruitCode(this.createUUIDString());
        }
    }

    private int getRecruitMaxCode() {
        int code = 0;
        try {
            return this.recRecruitMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitServiceImpl.getRecruitMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRecruitUpdataDefault(RecRecruit recRecruit) {
        if (null == recRecruit) {
            return;
        }
        recRecruit.setGmtModified(this.getSysDate());
    }

    private void saveRecruitModel(RecRecruit recRecruit) throws ApiException {
        if (null == recRecruit) {
            return;
        }
        try {
            this.recRecruitMapper.insert(recRecruit);
            this.addUserActivity(recRecruit.getMemberCode(), recRecruit.getMemberName());
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitServiceImpl.saveRecruitModel.ex", (Throwable)e);
        }
    }

    private void addUserActivity(String userinfoCode, String userName) {
        HashMap<String, String> userActivityMap = SupDisUtil.getMapAll((String)"fz_activity_key");
        if (userActivityMap == null) {
            userActivityMap = new HashMap<String, String>();
        }
        if (StringUtils.isEmpty((String)((String)userActivityMap.get(userinfoCode)))) {
            userActivityMap.put(userinfoCode, userName + ",1");
        } else {
            int cnt = Integer.valueOf(((String)userActivityMap.get(userinfoCode)).split(",")[1]);
            userActivityMap.put(userinfoCode, userName + "," + (cnt + 1));
        }
        SupDisUtil.setMap((String)"fz_activity_key", userActivityMap);
    }

    private void saveRecruitBatchModel(List<RecRecruit> recRecruitList) throws ApiException {
        if (null == recRecruitList || recRecruitList.isEmpty()) {
            return;
        }
        try {
            this.recRecruitMapper.insertBatch(recRecruitList);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitServiceImpl.saveRecruitBatchModel.ex", (Throwable)e);
        }
    }

    private RecRecruit getRecruitModelById(Integer recruitId) {
        if (null == recruitId) {
            return null;
        }
        try {
            RecRecruit recRecruit = this.recRecruitMapper.selectByPrimaryKey(recruitId);
            if (null != recRecruit.getRecruitTel() && recRecruit.getRecruitTel().equals("1")) {
                recRecruit.setRecruitContactEmail(this.display(recRecruit.getRecruitContactEmail()));
                recRecruit.setRecruitContactPhone(this.hideInfo(recRecruit.getRecruitContactPhone()));
                recRecruit.setRecruitContact(this.replaceNameX(recRecruit.getRecruitContact()));
            }
            return recRecruit;
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitServiceImpl.getRecruitModelById", (Throwable)e);
            return null;
        }
    }

    private RecRecruit getRecruitModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.recRecruitMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitServiceImpl.getRecruitModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRecruitModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitServiceImpl.delRecruitModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitServiceImpl.delRecruitModelByCode.num");
        }
    }

    private void deleteRecruitModel(Integer recruitId) throws ApiException {
        if (null == recruitId) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitMapper.deleteByPrimaryKey(recruitId);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitServiceImpl.deleteRecruitModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitServiceImpl.deleteRecruitModel.num");
        }
    }

    private void updateRecruitModel(RecRecruit recRecruit) throws ApiException {
        if (null == recRecruit) {
            return;
        }
        int i = 0;
        try {
            i = this.recRecruitMapper.updateByPrimaryKey(recRecruit);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitServiceImpl.updateRecruitModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rec.RecRecruitServiceImpl.updateRecruitModel.num");
        }
    }

    private void updateStateRecruitModel(Integer recruitId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == recruitId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recruitId", recruitId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recRecruitMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitServiceImpl.updateStateRecruitModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecRecruitServiceImpl.updateStateRecruitModel.null");
        }
    }

    private void updateStateRecruitModelByCode(String tenantCode, String recruitCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)recruitCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitCode", recruitCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.recRecruitMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rec.RecRecruitServiceImpl.updateStateRecruitModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rec.RecRecruitServiceImpl.updateStateRecruitModelByCode.null");
        }
    }

    private RecRecruit makeRecruit(RecRecruitDomain recRecruitDomain, RecRecruit recRecruit) {
        if (null == recRecruitDomain) {
            return null;
        }
        if (null == recRecruit) {
            recRecruit = new RecRecruit();
        }
        try {
            BeanUtils.copyAllPropertys((Object)recRecruit, (Object)recRecruitDomain);
            return recRecruit;
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitServiceImpl.makeRecruit", (Throwable)e);
            return null;
        }
    }

    private RecRecruitReDomain makeRecRecruitReDomain(RecRecruit recRecruit) {
        if (null == recRecruit) {
            return null;
        }
        RecRecruitReDomain recRecruitReDomain = new RecRecruitReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)recRecruitReDomain, (Object)recRecruit);
            return recRecruitReDomain;
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitServiceImpl.makeRecRecruitReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RecRecruit> queryRecruitModelPage(Map<String, Object> parammap) {
        try {
            this.logger.info("weiwh-------------------------------------------------" + parammap.toString());
            return this.recRecruitMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitServiceImpl.queryRecruitModel", (Throwable)e);
            return null;
        }
    }

    private int countRecruit(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.recRecruitMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rec.RecRecruitServiceImpl.countRecruit", (Throwable)e);
        }
        return i;
    }

    private RecRecruit createRecRecruit(RecRecruitDomain recRecruitDomain) {
        String msg = this.checkRecruit(recRecruitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecRecruitServiceImpl.saveRecruit.checkRecruit", msg);
        }
        RecRecruit recRecruit = this.makeRecruit(recRecruitDomain, null);
        this.setRecruitDefault(recRecruit);
        return recRecruit;
    }

    @Override
    @Transactional
    public String saveRecruit(RecRecruitDomain recRecruitDomain) throws ApiException {
        int i;
        RecRecruit recRecruit = this.createRecRecruit(recRecruitDomain);
        recRecruit.setDataState(1);
        this.saveRecruitModel(recRecruit);
        if (ListUtil.isNotEmpty(recRecruitDomain.getRecRecruitFileDomainList())) {
            List<RecRecruitFileDomain> fileList = recRecruitDomain.getRecRecruitFileDomainList();
            for (i = 0; i < fileList.size(); ++i) {
                fileList.get(i).setTenantCode(recRecruit.getTenantCode());
                fileList.get(i).setRecruitCode(recRecruit.getRecruitCode());
                fileList.get(i).setRecruitName(recRecruit.getRecruitName());
            }
            if (ListUtil.isNotEmpty(fileList)) {
                this.recRecruitFileService.saveRecruitFileBatch(fileList);
            }
        }
        if (ListUtil.isNotEmpty(recRecruitDomain.getRecRecruitEnrollList())) {
            this.logger.error(".enrollList1", (Object)"recRecruitDomain.getRecRecruitEnrollList().isNotEmpty()");
            List<RecRecruitEnrollDomain> enrollList = recRecruitDomain.getRecRecruitEnrollList();
            this.logger.error(".enrollList2", (Object)enrollList.toString());
            for (i = 0; i < enrollList.size(); ++i) {
                enrollList.get(i).setTenantCode(recRecruit.getTenantCode());
                enrollList.get(i).setRecruitCode(recRecruit.getRecruitCode());
                enrollList.get(i).setRecruitName(recRecruit.getRecruitName());
                enrollList.get(i).setMemberBcode(recRecruit.getMemberBcode());
            }
            if (ListUtil.isNotEmpty(enrollList)) {
                this.logger.error(".enroll", (Object)("\u62db\u52df\u9080\u8bf7\u6570\u91cf:" + enrollList.size()));
                this.recRecruitEnrollService.saveRecruitEnrollBatch(enrollList);
            }
        }
        if (ListUtil.isNotEmpty(recRecruitDomain.getRecRecruitOtherDomainList())) {
            List<RecRecruitOtherDomain> recruitOtherList = recRecruitDomain.getRecRecruitOtherDomainList();
            for (i = 0; i < recruitOtherList.size(); ++i) {
                recruitOtherList.get(i).setTenantCode(recRecruit.getTenantCode());
                recruitOtherList.get(i).setRecruitCode(recRecruit.getRecruitCode());
                recruitOtherList.get(i).setRecruitName(recRecruit.getRecruitName());
            }
            if (ListUtil.isNotEmpty(recruitOtherList)) {
                this.recRecruitOtherService.saveRecruitOtherBatch(recruitOtherList);
            }
        }
        List<RecRecruitPersonnelDomain> recRecruitPersonnelList = recRecruitDomain.getRecRecruitPersonnelList();
        this.logger.error("recRecruitDomain.getRecRecruitPersonnelList()--------------ww----------------------" + recRecruitPersonnelList);
        if (ListUtil.isNotEmpty(recRecruitPersonnelList)) {
            for (i = 0; i < recRecruitPersonnelList.size(); ++i) {
                RecRecruitPersonnelDomain recRecruitPersonnelDomain = recRecruitPersonnelList.get(i);
                recRecruitPersonnelDomain.setTenantCode(recRecruit.getTenantCode());
                recRecruitPersonnelDomain.setRecruitEnrollCode(recRecruitPersonnelDomain.getRecruitCode());
                recRecruitPersonnelDomain.setRecruitCode(recRecruit.getRecruitCode());
                String recruitPersionnelCode = this.recRecruitPersonnelService.saveRecRecruitPersonnel(recRecruitPersonnelDomain);
                List<RecRecruitServiceAreaDomain> recRecruitServiceAreaList = recRecruitPersonnelDomain.getRecRecruitServiceAreaDomainList();
                if (null == recRecruitServiceAreaList || recRecruitServiceAreaList.size() <= 0) continue;
                for (int j = 0; j < recRecruitServiceAreaList.size(); ++j) {
                    recRecruitServiceAreaList.get(j).setTenantCode(recRecruit.getTenantCode());
                    recRecruitServiceAreaList.get(j).setRecruitCode(recRecruit.getRecruitCode());
                    recRecruitServiceAreaList.get(j).setMemberCode(recRecruitPersonnelDomain.getMemberCode());
                    recRecruitServiceAreaList.get(j).setMemberName(recRecruitPersonnelDomain.getMemberName());
                }
                if (!ListUtil.isNotEmpty(recRecruitServiceAreaList)) continue;
                this.recRecruitServiceAreaService.saveRecRecruitServiceAreaBatch(recRecruitServiceAreaList);
            }
        }
        return recRecruit.getRecruitCode();
    }

    @Override
    public String saveRecruitBatch(List<RecRecruitDomain> recRecruitDomainList) throws ApiException {
        if (null == recRecruitDomainList || recRecruitDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RecRecruit> recRecruitList = new ArrayList<RecRecruit>();
        String code = "";
        for (RecRecruitDomain recRecruitDomain : recRecruitDomainList) {
            RecRecruit recRecruit = this.createRecRecruit(recRecruitDomain);
            code = recRecruit.getRecruitCode();
            recRecruitList.add(recRecruit);
        }
        this.saveRecruitBatchModel(recRecruitList);
        return code;
    }

    @Override
    public void updateRecruitState(Integer recruitId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == recruitId) {
            return;
        }
        this.updateStateRecruitModel(recruitId, dataState, oldDataState, map);
    }

    @Override
    public void updateRecruitStateByCode(String tenantCode, String recruitCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)recruitCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRecruitModelByCode(tenantCode, recruitCode, dataState, oldDataState, map);
    }

    @Override
    @Transactional
    public void updateRecruit(RecRecruitDomain recRecruitDomain) throws ApiException {
        int i;
        QueryResult<RecRecruitEnroll> queryResult2;
        QueryResult<RecRecruitFile> queryResult1;
        String msg = this.checkRecruit(recRecruitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rec.RecRecruitServiceImpl.updateRecruit.checkRecruit", msg);
        }
        RecRecruit oldRecRecruit = this.getRecruitModelById(recRecruitDomain.getRecruitId());
        if (null == oldRecRecruit) {
            throw new ApiException("rec.RecRecruitServiceImpl.updateRecruit.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RecRecruit recRecruit = this.makeRecruit(recRecruitDomain, oldRecRecruit);
        this.setRecruitUpdataDefault(recRecruit);
        this.updateRecruitModel(recRecruit);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("fuzzy", false);
        param.put("recruitCode", recRecruitDomain.getRecruitCode());
        QueryResult<RecRecruitOther> queryResult = this.recRecruitOtherService.queryRecruitOtherPage(param);
        if (ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            this.recRecruitOtherService.deleteRecruitOtherByRecruitCode(recRecruitDomain.getTenantCode(), recRecruitDomain.getRecruitCode());
        }
        if (ListUtil.isNotEmpty((Collection)(queryResult1 = this.recRecruitFileService.queryRecruitFilePage(param)).getList())) {
            this.recRecruitFileService.deleteRecruitFileByRecruitCode(recRecruitDomain.getTenantCode(), recRecruitDomain.getRecruitCode());
        }
        if (ListUtil.isNotEmpty((Collection)(queryResult2 = this.recRecruitEnrollService.queryRecruitEnrollPage(param)).getList())) {
            this.recRecruitEnrollService.deleteRecruitEnrollByRecruitCode(recRecruitDomain.getTenantCode(), recRecruitDomain.getRecruitCode());
        }
        List<RecRecruitOtherDomain> otherDomainList = recRecruitDomain.getRecRecruitOtherDomainList();
        List<RecRecruitFileDomain> filelist = recRecruitDomain.getRecRecruitFileDomainList();
        List<RecRecruitEnrollDomain> enrollDomainList = recRecruitDomain.getRecRecruitEnrollList();
        if (ListUtil.isNotEmpty(otherDomainList)) {
            for (i = 0; i < otherDomainList.size(); ++i) {
                otherDomainList.get(i).setRecruitCode(recRecruitDomain.getRecruitCode());
                otherDomainList.get(i).setTenantCode(recRecruitDomain.getTenantCode());
            }
            this.recRecruitOtherService.saveRecruitOtherBatch(otherDomainList);
        }
        if (ListUtil.isNotEmpty(filelist)) {
            for (i = 0; i < filelist.size(); ++i) {
                filelist.get(i).setRecruitCode(recRecruitDomain.getRecruitCode());
                filelist.get(i).setTenantCode(recRecruitDomain.getTenantCode());
            }
            this.recRecruitFileService.saveRecruitFileBatch(filelist);
        }
        if (ListUtil.isNotEmpty(enrollDomainList)) {
            for (i = 0; i < enrollDomainList.size(); ++i) {
                enrollDomainList.get(i).setRecruitCode(recRecruitDomain.getRecruitCode());
                enrollDomainList.get(i).setTenantCode(recRecruitDomain.getTenantCode());
            }
            this.recRecruitEnrollService.saveRecruitEnrollBatch(enrollDomainList);
        }
    }

    @Override
    public RecRecruit getRecruit(Integer recruitId) {
        if (null == recruitId) {
            return null;
        }
        return this.getRecruitModelById(recruitId);
    }

    @Override
    public void deleteRecruit(Integer recruitId) throws ApiException {
        if (null == recruitId) {
            return;
        }
        this.deleteRecruitModel(recruitId);
    }

    @Override
    public QueryResult<RecRecruit> queryRecruitPage(Map<String, Object> map) {
        List<RecRecruit> recRecruitList = this.queryRecruitModelPage(map);
        if (ListUtil.isNotEmpty(recRecruitList)) {
            for (int i = 0; i < recRecruitList.size(); ++i) {
                if (!StringUtils.isNotBlank((String)recRecruitList.get(i).getRecruitTel()) || !recRecruitList.get(i).getRecruitTel().equals("1")) continue;
                if (StringUtils.isNotBlank((String)recRecruitList.get(i).getRecruitContactEmail())) {
                    String email = recRecruitList.get(i).getRecruitContactEmail();
                    recRecruitList.get(i).setRecruitContactEmail(this.display(email));
                }
                if (StringUtils.isNotBlank((String)recRecruitList.get(i).getRecruitContactPhone())) {
                    String phone = recRecruitList.get(i).getRecruitContactPhone();
                    recRecruitList.get(i).setRecruitContactPhone(this.hideInfo(phone));
                }
                if (!StringUtils.isNotBlank((String)recRecruitList.get(i).getRecruitContact())) continue;
                String contact = recRecruitList.get(i).getRecruitContact();
                recRecruitList.get(i).setRecruitContact(this.replaceNameX(contact));
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRecruit(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(recRecruitList);
        return queryResult;
    }

    @Override
    public RecRecruit getRecruitByCode(String tenantCode, String recruitCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitCode", recruitCode);
        return this.getRecruitModelByCode(map);
    }

    @Override
    public void deleteRecruitByCode(String tenantCode, String recruitCode) throws ApiException {
        if (StringUtils.isBlank((String)recruitCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("recruitCode", recruitCode);
        this.delRecruitModelByCode(map);
    }

    @Override
    public Map<String, Object> queryCountByState(String tenantCode, int dataState) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        return this.recRecruitMapper.queryCountByState(map);
    }

    @Override
    public Map<String, Object> queryCountByState1(String tenantCode, int dataState, String recruitType, String memberBcode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("recruitType", recruitType);
        map.put("memberBcode", memberBcode);
        return this.recRecruitMapper.queryCountByState1(map);
    }

    @Override
    public void autoUpdateRecruitState() {
        this.recRecruitMapper.updateStateByEndDate();
    }

    @Override
    public QueryResult<UmUserInfoReDomain> userAcitivyPage(Map<String, Object> map) {
        QueryResult datas = new QueryResult();
        ArrayList<UmUserInfoReDomain> userInfoReDomains = new ArrayList<UmUserInfoReDomain>();
        Map activityMap = SupDisUtil.getMapAll((String)"fz_activity_key");
        HashMap activityCountMap = new HashMap();
        if (activityMap != null && activityMap.size() != 0) {
            for (Map.Entry entry : activityMap.entrySet()) {
                if (!StringUtils.isNotBlank((String)((String)entry.getValue())) || !StringUtils.isNotBlank((String)((String)entry.getValue()).split(",")[1])) continue;
                activityCountMap.put(entry.getKey(), Integer.valueOf(((String)entry.getValue()).split(",")[1]));
            }
        }
        ArrayList mappingList = new ArrayList(activityCountMap.entrySet());
        Collections.sort(mappingList, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> mapping1, Map.Entry<String, Integer> mapping2) {
                return mapping2.getValue().compareTo(mapping1.getValue());
            }
        });
        int cnt = 0;
        int pageSize = Integer.valueOf(map.get("rows") != null ? map.get("rows").toString() : "9");
        if (activityCountMap != null && activityCountMap.size() != 0) {
            for (Map.Entry entry : mappingList) {
                if (cnt >= pageSize) break;
                ++cnt;
                UmUserInfoReDomain domain = new UmUserInfoReDomain();
                domain.setUserinfoCode((String)entry.getKey());
                domain.setUserinfoCompname(((String)activityMap.get(entry.getKey())).split(",")[0]);
                domain.setUserinfoOrder((Integer)entry.getValue());
                userInfoReDomains.add(domain);
            }
        }
        datas.setList(userInfoReDomains);
        return datas;
    }
}

