/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsSpecGroupMapper;
import com.yqbsoft.laser.service.resources.dao.RsSpecMapper;
import com.yqbsoft.laser.service.resources.dao.RsSpecOptionMapper;
import com.yqbsoft.laser.service.resources.domain.RsSpecDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecGroupDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecOptionDomain;
import com.yqbsoft.laser.service.resources.model.RsSpec;
import com.yqbsoft.laser.service.resources.model.RsSpecGroup;
import com.yqbsoft.laser.service.resources.model.RsSpecOption;
import com.yqbsoft.laser.service.resources.service.RsSpecService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsSpecServiceImpl
extends BaseServiceImpl
implements RsSpecService {
    public static final String SYS_CODE = "rs.RsSpecServiceImpl";
    private RsSpecMapper rsSpecMapper;
    private RsSpecGroupMapper rsSpecGroupMapper;
    private RsSpecOptionMapper rsSpecOptionMapper;

    public void setRsSpecMapper(RsSpecMapper rsSpecMapper) {
        this.rsSpecMapper = rsSpecMapper;
    }

    public void setRsSpecGroupMapper(RsSpecGroupMapper rsSpecGroupMapper) {
        this.rsSpecGroupMapper = rsSpecGroupMapper;
    }

    public void setRsSpecOptionMapper(RsSpecOptionMapper rsSpecOptionMapper) {
        this.rsSpecOptionMapper = rsSpecOptionMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsSpecMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSpec(RsSpecDomain rsSpecDomain) {
        if (null == rsSpecDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSpecDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)rsSpecDomain.getSpecGroupCode())) {
            msg = msg + "\u89c4\u683c\u7ec4\u4ee3\u7801\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSpecDefault(RsSpec rsSpec) {
        if (null == rsSpec) {
            return;
        }
        if (null == rsSpec.getDataState()) {
            rsSpec.setDataState(0);
        }
        if (null == rsSpec.getGmtCreate()) {
            rsSpec.setGmtCreate(this.getSysDate());
        }
        rsSpec.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsSpec.getSpecCode())) {
            rsSpec.setSpecCode(this.createUUIDString());
        }
    }

    private int getSpecMaxCode() {
        int code = 0;
        try {
            return this.rsSpecMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.getSpecMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSpecUpdataDefault(RsSpec rsSpec) {
        if (null == rsSpec) {
            return;
        }
        rsSpec.setGmtModified(this.getSysDate());
    }

    private void saveSpecModel(RsSpec rsSpec) throws ApiException {
        if (null == rsSpec) {
            return;
        }
        try {
            this.rsSpecMapper.insert(rsSpec);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecServiceImpl.saveSpecModel.ex", (Throwable)e);
        }
    }

    private RsSpec getSpecModelById(Integer specId) {
        if (null == specId) {
            return null;
        }
        try {
            return this.rsSpecMapper.selectByPrimaryKey(specId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.getSpecModelById", (Throwable)e);
            return null;
        }
    }

    public RsSpec getSpecModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSpecMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.getSpecModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delSpecModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSpecMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecServiceImpl.delSpecModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSpecServiceImpl.delSpecModelByCode.num");
        }
    }

    private void deleteSpecModel(Integer specId) throws ApiException {
        if (null == specId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSpecMapper.deleteByPrimaryKey(specId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecServiceImpl.deleteSpecModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSpecServiceImpl.deleteSpecModel.num");
        }
    }

    private void updateSpecModel(RsSpec rsSpec) throws ApiException {
        if (null == rsSpec) {
            return;
        }
        try {
            this.rsSpecMapper.updateByPrimaryKeySelective(rsSpec);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecServiceImpl.updateSpecModel.ex", (Throwable)e);
        }
    }

    private void updateStateSpecModel(Integer specId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == specId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("specId", specId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsSpecMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecServiceImpl.updateStateSpecModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSpecServiceImpl.updateStateSpecModel.null");
        }
    }

    private RsSpec makeSpec(RsSpecDomain rsSpecDomain, RsSpec rsSpec) {
        if (null == rsSpecDomain) {
            return null;
        }
        if (null == rsSpec) {
            rsSpec = new RsSpec();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsSpec, (Object)rsSpecDomain);
            return rsSpec;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.makeSpec", (Throwable)e);
            return null;
        }
    }

    private List<RsSpec> querySpecModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSpecMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.querySpecModel", (Throwable)e);
            return null;
        }
    }

    private int countSpec(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSpecMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.countSpec", (Throwable)e);
        }
        return i;
    }

    private String checkSpecGroup(RsSpecGroupDomain rsSpecGroupDomain) {
        if (null == rsSpecGroupDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSpecGroupDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSpecGroupDefault(RsSpecGroup rsSpecGroup) {
        if (null == rsSpecGroup) {
            return;
        }
        if (null == rsSpecGroup.getDataState()) {
            rsSpecGroup.setDataState(0);
        }
        if (null == rsSpecGroup.getGmtCreate()) {
            rsSpecGroup.setGmtCreate(this.getSysDate());
        }
        rsSpecGroup.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsSpecGroup.getSpecGroupCode())) {
            rsSpecGroup.setSpecGroupCode(this.createUUIDString());
        }
    }

    private int getSpecGroupMaxCode() {
        int code = 0;
        try {
            return this.rsSpecGroupMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.getSpecGroupMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSpecGroupUpdataDefault(RsSpecGroup rsSpecGroup) {
        if (null == rsSpecGroup) {
            return;
        }
        rsSpecGroup.setGmtModified(this.getSysDate());
    }

    private void saveSpecGroupModel(RsSpecGroup rsSpecGroup) throws ApiException {
        if (null == rsSpecGroup) {
            return;
        }
        try {
            this.rsSpecGroupMapper.insert(rsSpecGroup);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecServiceImpl.saveSpecGroupModel.ex", (Throwable)e);
        }
    }

    private RsSpecGroup getSpecGroupModelById(Integer specGroupId) {
        if (null == specGroupId) {
            return null;
        }
        try {
            return this.rsSpecGroupMapper.selectByPrimaryKey(specGroupId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.getSpecGroupModelById", (Throwable)e);
            return null;
        }
    }

    public RsSpecGroup getSpecGroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSpecGroupMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.getSpecGroupModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delSpecGroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSpecGroupMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecServiceImpl.delSpecGroupModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSpecServiceImpl.delSpecGroupModelByCode.num");
        }
    }

    private void deleteSpecGroupModel(Integer specGroupId) throws ApiException {
        if (null == specGroupId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSpecGroupMapper.deleteByPrimaryKey(specGroupId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecServiceImpl.deleteSpecGroupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSpecServiceImpl.deleteSpecGroupModel.num");
        }
    }

    protected void updateSpecGroupModel(RsSpecGroup rsSpecGroup) throws ApiException {
        if (null == rsSpecGroup) {
            return;
        }
        try {
            this.rsSpecGroupMapper.updateByPrimaryKeySelective(rsSpecGroup);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecServiceImpl.updateSpecGroupModel.ex", (Throwable)e);
        }
    }

    private void updateStateSpecGroupModel(Integer specGroupId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == specGroupId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("specGroupId", specGroupId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsSpecGroupMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecServiceImpl.updateStateSpecGroupModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSpecServiceImpl.updateStateSpecGroupModel.null");
        }
    }

    private RsSpecGroup makeSpecGroup(RsSpecGroupDomain rsSpecGroupDomain, RsSpecGroup rsSpecGroup) {
        if (null == rsSpecGroupDomain) {
            return null;
        }
        if (null == rsSpecGroup) {
            rsSpecGroup = new RsSpecGroup();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsSpecGroup, (Object)rsSpecGroupDomain);
            return rsSpecGroup;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.makeSpecGroup", (Throwable)e);
            return null;
        }
    }

    private List<RsSpecGroup> querySpecGroupModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSpecGroupMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.querySpecGroupModel", (Throwable)e);
            return null;
        }
    }

    private int countSpecGroup(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSpecGroupMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.countSpecGroup", (Throwable)e);
        }
        return i;
    }

    private String checkSpecOption(RsSpecOptionDomain rsSpecOptionDomain) {
        if (null == rsSpecOptionDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSpecOptionDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)rsSpecOptionDomain.getSpecGroupCode())) {
            msg = msg + "\u89c4\u683c\u7ec4\u4ee3\u7801\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)rsSpecOptionDomain.getSpecCode())) {
            msg = msg + "\u89c4\u683c\u4ee3\u7801\u4e3a\u7a7a";
        }
        return msg;
    }

    private void setSpecOptionDefault(RsSpecOption rsSpecOption) {
        if (null == rsSpecOption) {
            return;
        }
        if (null == rsSpecOption.getDataState()) {
            rsSpecOption.setDataState(0);
        }
        if (null == rsSpecOption.getGmtCreate()) {
            rsSpecOption.setGmtCreate(this.getSysDate());
        }
        rsSpecOption.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsSpecOption.getSpecOptionCode())) {
            rsSpecOption.setSpecOptionCode(this.createUUIDString());
        }
    }

    private int getSpecOptionMaxCode() {
        int code = 0;
        try {
            return this.rsSpecOptionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.getSpecOptionMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSpecOptionUpdataDefault(RsSpecOption rsSpecOption) {
        if (null == rsSpecOption) {
            return;
        }
        rsSpecOption.setGmtModified(this.getSysDate());
    }

    private void saveSpecOptionModel(RsSpecOption rsSpecOption) throws ApiException {
        if (null == rsSpecOption) {
            return;
        }
        try {
            this.rsSpecOptionMapper.insert(rsSpecOption);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecServiceImpl.saveSpecOptionModel.ex", (Throwable)e);
        }
    }

    private RsSpecOption getSpecOptionModelById(Integer specOptionId) {
        if (null == specOptionId) {
            return null;
        }
        try {
            return this.rsSpecOptionMapper.selectByPrimaryKey(specOptionId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.getSpecOptionModelById", (Throwable)e);
            return null;
        }
    }

    public RsSpecOption getSpecOptionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSpecOptionMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.getSpecOptionModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delSpecOptionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSpecOptionMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecServiceImpl.delSpecOptionModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSpecServiceImpl.delSpecOptionModelByCode.num");
        }
    }

    private void deleteSpecOptionModel(Integer specOptionId) throws ApiException {
        if (null == specOptionId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSpecOptionMapper.deleteByPrimaryKey(specOptionId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecServiceImpl.deleteSpecOptionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSpecServiceImpl.deleteSpecOptionModel.num");
        }
    }

    private void updateSpecOptionModel(RsSpecOption rsSpecOption) throws ApiException {
        if (null == rsSpecOption) {
            return;
        }
        try {
            this.rsSpecOptionMapper.updateByPrimaryKeySelective(rsSpecOption);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecServiceImpl.updateSpecOptionModel.ex", (Throwable)e);
        }
    }

    private void updateStateSpecOptionModel(Integer specOptionId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == specOptionId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("specOptionId", specOptionId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsSpecOptionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSpecServiceImpl.updateStateSpecOptionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSpecServiceImpl.updateStateSpecOptionModel.null");
        }
    }

    private RsSpecOption makeSpecOption(RsSpecOptionDomain rsSpecOptionDomain, RsSpecOption rsSpecOption) {
        if (null == rsSpecOptionDomain) {
            return null;
        }
        if (null == rsSpecOption) {
            rsSpecOption = new RsSpecOption();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsSpecOption, (Object)rsSpecOptionDomain);
            return rsSpecOption;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.makeSpecOption", (Throwable)e);
            return null;
        }
    }

    private List<RsSpecOption> querySpecOptionModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSpecOptionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.querySpecOptionModel", (Throwable)e);
            return null;
        }
    }

    private int countSpecOption(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSpecOptionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSpecServiceImpl.countSpecOption", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveSpec(RsSpecDomain rsSpecDomain) throws ApiException {
        String msg = this.checkSpec(rsSpecDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSpecServiceImpl.saveSpec.checkSpec", msg);
        }
        RsSpec rsSpec = this.makeSpec(rsSpecDomain, null);
        this.setSpecDefault(rsSpec);
        this.saveSpecModel(rsSpec);
        return rsSpec.getSpecCode();
    }

    @Override
    public void updateSpecState(Integer specId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateSpecModel(specId, dataState, oldDataState);
    }

    @Override
    public void updateSpec(RsSpecDomain rsSpecDomain) throws ApiException {
        String msg = this.checkSpec(rsSpecDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSpecServiceImpl.updateSpec.checkSpec", msg);
        }
        RsSpec oldRsSpec = this.getSpecModelById(rsSpecDomain.getSpecId());
        if (null == oldRsSpec) {
            throw new ApiException("rs.RsSpecServiceImpl.updateSpec.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsSpec rsSpec = this.makeSpec(rsSpecDomain, oldRsSpec);
        this.setSpecUpdataDefault(rsSpec);
        this.updateSpecModel(rsSpec);
    }

    @Override
    public RsSpec getSpec(Integer specId) {
        return this.getSpecModelById(specId);
    }

    @Override
    public void deleteSpec(Integer specId) throws ApiException {
        this.deleteSpecModel(specId);
    }

    @Override
    public QueryResult<RsSpec> querySpecPage(Map<String, Object> map) {
        List<RsSpec> rsSpecList = this.querySpecModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSpec(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSpecList);
        return queryResult;
    }

    @Override
    public RsSpec getSpecByCode(Map<String, Object> map) {
        return this.getSpecModelByCode(map);
    }

    @Override
    public void delSpecByCode(Map<String, Object> map) throws ApiException {
        this.delSpecModelByCode(map);
    }

    @Override
    public String saveSpecGroup(RsSpecGroupDomain rsSpecGroupDomain) throws ApiException {
        String msg = this.checkSpecGroup(rsSpecGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSpecServiceImpl.saveSpecGroup.checkSpecGroup", msg);
        }
        RsSpecGroup rsSpecGroup = this.makeSpecGroup(rsSpecGroupDomain, null);
        this.setSpecGroupDefault(rsSpecGroup);
        this.saveSpecGroupModel(rsSpecGroup);
        return rsSpecGroup.getSpecGroupCode();
    }

    @Override
    public void updateSpecGroupState(Integer specGroupId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateSpecGroupModel(specGroupId, dataState, oldDataState);
    }

    @Override
    public void updateSpecGroup(RsSpecGroupDomain rsSpecGroupDomain) throws ApiException {
        String msg = this.checkSpecGroup(rsSpecGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSpecServiceImpl.updateSpecGroup.checkSpecGroup", msg);
        }
        RsSpecGroup rsSpecGroup = null;
        if (null != rsSpecGroupDomain && rsSpecGroupDomain.getSpecGroupId() != null) {
            RsSpecGroup oldRsSpecGroup = this.getSpecGroupModelById(rsSpecGroupDomain.getSpecGroupId());
            if (null == oldRsSpecGroup) {
                throw new ApiException("rs.RsSpecServiceImpl.updateSpecGroup.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            rsSpecGroup = this.makeSpecGroup(rsSpecGroupDomain, oldRsSpecGroup);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("specGroupCode", rsSpecGroupDomain.getSpecGroupCode());
            rsSpecGroup = this.getSpecGroupModelByCode(map);
            rsSpecGroup.setPntreeCode(rsSpecGroupDomain.getPntreeCode());
        }
        this.setSpecGroupUpdataDefault(rsSpecGroup);
        this.updateSpecGroupModel(rsSpecGroup);
    }

    @Override
    public RsSpecGroup getSpecGroup(Integer specGroupId) {
        return this.getSpecGroupModelById(specGroupId);
    }

    @Override
    public void deleteSpecGroup(Integer specGroupId) throws ApiException {
        this.deleteSpecGroupModel(specGroupId);
    }

    @Override
    public QueryResult<RsSpecGroup> querySpecGroupPage(Map<String, Object> map) {
        List<RsSpecGroup> rsSpecGroupList = this.querySpecGroupModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSpecGroup(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSpecGroupList);
        return queryResult;
    }

    @Override
    public RsSpecGroup getSpecGroupByCode(Map<String, Object> map) {
        return this.getSpecGroupModelByCode(map);
    }

    @Override
    public void delSpecGroupByCode(Map<String, Object> map) throws ApiException {
        this.delSpecGroupModelByCode(map);
    }

    @Override
    public String saveSpecOption(RsSpecOptionDomain rsSpecOptionDomain) throws ApiException {
        String msg = this.checkSpecOption(rsSpecOptionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSpecServiceImpl.saveSpecOption.checkSpecOption", msg);
        }
        RsSpecOption rsSpecOption = this.makeSpecOption(rsSpecOptionDomain, null);
        this.setSpecOptionDefault(rsSpecOption);
        this.saveSpecOptionModel(rsSpecOption);
        return rsSpecOption.getSpecOptionCode();
    }

    @Override
    public void updateSpecOptionState(Integer specOptionId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateSpecOptionModel(specOptionId, dataState, oldDataState);
    }

    @Override
    public void updateSpecOption(RsSpecOptionDomain rsSpecOptionDomain) throws ApiException {
        String msg = this.checkSpecOption(rsSpecOptionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSpecServiceImpl.updateSpecOption.checkSpecOption", msg);
        }
        RsSpecOption oldRsSpecOption = this.getSpecOptionModelById(rsSpecOptionDomain.getSpecOptionId());
        if (null == oldRsSpecOption) {
            throw new ApiException("rs.RsSpecServiceImpl.updateSpecOption.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsSpecOption rsSpecOption = this.makeSpecOption(rsSpecOptionDomain, oldRsSpecOption);
        this.setSpecOptionUpdataDefault(rsSpecOption);
        this.updateSpecOptionModel(rsSpecOption);
    }

    @Override
    public RsSpecOption getSpecOption(Integer specOptionId) {
        return this.getSpecOptionModelById(specOptionId);
    }

    @Override
    public void deleteSpecOption(Integer specOptionId) throws ApiException {
        this.deleteSpecOptionModel(specOptionId);
    }

    @Override
    public QueryResult<RsSpecOption> querySpecOptionPage(Map<String, Object> map) {
        List<RsSpecOption> rsSpecOptionList = this.querySpecOptionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSpecOption(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSpecOptionList);
        return queryResult;
    }

    @Override
    public RsSpecOption getSpecOptionByCode(Map<String, Object> map) {
        return this.getSpecOptionModelByCode(map);
    }

    @Override
    public void delSpecOptionByCode(Map<String, Object> map) throws ApiException {
        this.delSpecOptionModelByCode(map);
    }

    @Override
    public List<RsSpecGroup> getSpecGroupByPntree(Map<String, Object> map) {
        return this.rsSpecGroupMapper.getSpecGroupByPntree(map);
    }
}

