/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsBrandMapper;
import com.yqbsoft.laser.service.resources.domain.RsBrandDomain;
import com.yqbsoft.laser.service.resources.model.RsBrand;
import com.yqbsoft.laser.service.resources.service.RsBrandService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsBrandServiceImpl
extends BaseServiceImpl
implements RsBrandService {
    public static final String SYS_CODE = "rs.RsBrandServiceImpl";
    private RsBrandMapper rsBrandMapper;

    public void setRsBrandMapper(RsBrandMapper rsBrandMapper) {
        this.rsBrandMapper = rsBrandMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsBrandMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBrand(RsBrandDomain bsBrandDomain) {
        if (null == bsBrandDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setBrandDefault(RsBrand bsBrand) {
        if (null == bsBrand) {
            return;
        }
        if (null == bsBrand.getDataState()) {
            bsBrand.setDataState(0);
        }
        if (null == bsBrand.getGmtCreate()) {
            bsBrand.setGmtCreate(this.getSysDate());
        }
        bsBrand.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)bsBrand.getBrandCode())) {
            bsBrand.setBrandCode(this.getNo(null, RsBrand.class.getSimpleName(), "brandCode", bsBrand.getTenantCode()));
        }
    }

    private int getBrandMaxCode() {
        int code = 0;
        try {
            return this.rsBrandMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.getBrandMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBrandUpdataDefault(RsBrand bsBrand) {
        if (null == bsBrand) {
            return;
        }
        bsBrand.setGmtModified(this.getSysDate());
    }

    private void saveBrandModel(RsBrand bsBrand) throws ApiException {
        if (null == bsBrand) {
            return;
        }
        try {
            this.rsBrandMapper.insert(bsBrand);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandServiceImpl.saveBrandModel.ex", (Throwable)e);
        }
    }

    private RsBrand getBrandModelById(Integer brandId) {
        if (null == brandId) {
            return null;
        }
        try {
            return this.rsBrandMapper.selectByPrimaryKey(brandId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.getBrandModelById", (Throwable)e);
            return null;
        }
    }

    public RsBrand getBrandModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsBrandMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.getBrandModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delBrandModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsBrandMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandServiceImpl.delBrandModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsBrandServiceImpl.delBrandModelByCode.num");
        }
    }

    private void deleteBrandModel(Integer brandId) throws ApiException {
        if (null == brandId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsBrandMapper.deleteByPrimaryKey(brandId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandServiceImpl.deleteBrandModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsBrandServiceImpl.deleteBrandModel.num");
        }
    }

    private void updateBrandModel(RsBrand bsBrand) throws ApiException {
        if (null == bsBrand) {
            return;
        }
        try {
            this.rsBrandMapper.updateByPrimaryKeySelective(bsBrand);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandServiceImpl.updateBrandModel.ex", (Throwable)e);
        }
    }

    private void updateStateBrandModel(Integer brandId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == brandId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("brandId", brandId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsBrandMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsBrandServiceImpl.updateStateBrandModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsBrandServiceImpl.updateStateBrandModel.null");
        }
    }

    private RsBrand makeBrand(RsBrandDomain bsBrandDomain, RsBrand bsBrand) {
        if (null == bsBrandDomain) {
            return null;
        }
        if (null == bsBrand) {
            bsBrand = new RsBrand();
        }
        try {
            BeanUtils.copyAllPropertys((Object)bsBrand, (Object)bsBrandDomain);
            return bsBrand;
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.makeBrand", (Throwable)e);
            return null;
        }
    }

    private List<RsBrand> queryBrandModelPage(Map<String, Object> parammap) {
        try {
            return this.rsBrandMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.queryBrandModel", (Throwable)e);
            return null;
        }
    }

    private int countBrand(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsBrandMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.countBrand", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveBrand(RsBrandDomain bsBrandDomain) throws ApiException {
        String msg = this.checkBrand(bsBrandDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsBrandServiceImpl.saveBrand.checkBrand", msg);
        }
        RsBrand bsBrand = this.makeBrand(bsBrandDomain, null);
        this.setBrandDefault(bsBrand);
        this.saveBrandModel(bsBrand);
        return bsBrand.getBrandCode();
    }

    @Override
    public void updateBrandState(Integer brandId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateBrandModel(brandId, dataState, oldDataState);
    }

    @Override
    public void updateBrand(RsBrandDomain bsBrandDomain) throws ApiException {
        String msg = this.checkBrand(bsBrandDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsBrandServiceImpl.updateBrand.checkBrand", msg);
        }
        RsBrand oldRsBrand = this.getBrandModelById(bsBrandDomain.getBrandId());
        if (null == oldRsBrand) {
            throw new ApiException("rs.RsBrandServiceImpl.updateBrand.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsBrand bsBrand = this.makeBrand(bsBrandDomain, oldRsBrand);
        this.setBrandUpdataDefault(bsBrand);
        this.updateBrandModel(bsBrand);
    }

    @Override
    public RsBrand getBrand(Integer brandId) {
        return this.getBrandModelById(brandId);
    }

    @Override
    public void deleteBrand(Integer brandId) throws ApiException {
        this.deleteBrandModel(brandId);
    }

    @Override
    public QueryResult<RsBrand> queryBrandPage(Map<String, Object> map) {
        List<RsBrand> bsBrandList = this.queryBrandModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBrand(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(bsBrandList);
        return queryResult;
    }

    @Override
    public RsBrand getBrandByCode(Map<String, Object> map) {
        return this.getBrandModelByCode(map);
    }

    @Override
    public void delBrandByCode(Map<String, Object> map) throws ApiException {
        this.delBrandModelByCode(map);
    }

    @Override
    public List<RsBrand> queryBrandByPntree(Map<String, Object> map) {
        return this.rsBrandMapper.selectByPntree(map);
    }

    @Override
    public RsBrand getBrandByName(String brandName, String tenantCode) {
        if (StringUtils.isEmpty((String)brandName) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("rs.RsBrandServiceImpl.getBrandByName.null", "\u53c3\u6578\u4e3a\u7a7a");
        }
        try {
            return this.rsBrandMapper.selectByName(brandName, tenantCode);
        }
        catch (Exception e) {
            this.logger.error("rs.RsBrandServiceImpl.getBrandByName", (Throwable)e);
            return null;
        }
    }
}

