/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsFlowDataMapper;
import com.yqbsoft.laser.service.resources.domain.DisChannel;
import com.yqbsoft.laser.service.resources.domain.DisDgoods;
import com.yqbsoft.laser.service.resources.domain.DisDgoodsScopelist;
import com.yqbsoft.laser.service.resources.domain.DisDpriceConf;
import com.yqbsoft.laser.service.resources.domain.DisDpriceDomain;
import com.yqbsoft.laser.service.resources.domain.DisRsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.DisRsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.HtmlRelease;
import com.yqbsoft.laser.service.resources.domain.RsGoodsRelDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuDomain;
import com.yqbsoft.laser.service.resources.es.EsEnginePollThread;
import com.yqbsoft.laser.service.resources.es.EsEnginePutThread;
import com.yqbsoft.laser.service.resources.es.EsEngineService;
import com.yqbsoft.laser.service.resources.model.EsSku;
import com.yqbsoft.laser.service.resources.model.RsClasstree;
import com.yqbsoft.laser.service.resources.model.RsFlowData;
import com.yqbsoft.laser.service.resources.model.RsFlowDataFinish;
import com.yqbsoft.laser.service.resources.model.RsGoodsClass;
import com.yqbsoft.laser.service.resources.model.RsSpecValue;
import com.yqbsoft.laser.service.resources.service.RsFlowDataAssistService;
import com.yqbsoft.laser.service.resources.service.RsFlowDataService;
import com.yqbsoft.laser.service.resources.service.RsSpecValueService;
import com.yqbsoft.laser.service.suppercore.es.StoreDomain;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsFlowDataServiceImpl
extends BaseServiceImpl
implements RsFlowDataService {
    public static final String SYS_CODE = ".RsFlowDataServiceImpl";
    private RsFlowDataMapper rsFlowDataMapper;
    private RsSpecValueService rsSpecValueService;
    private RsFlowDataAssistService rsFlowDataAssistService;
    private static EsEngineService esEngineService;
    private static Object lock;
    private static String DISCHANNEL_SALE;
    private static String DISCHANNEL_CON;
    private static String DISCHANNEL_BUS;

    public void setRsFlowDataMapper(RsFlowDataMapper rsFlowDataMapper) {
        this.rsFlowDataMapper = rsFlowDataMapper;
    }

    public void setRsSpecValueService(RsSpecValueService rsSpecValueService) {
        this.rsSpecValueService = rsSpecValueService;
    }

    public void setRsFlowDataAssistService(RsFlowDataAssistService rsFlowDataAssistService) {
        this.rsFlowDataAssistService = rsFlowDataAssistService;
    }

    private void saveRsFlowDataModel(RsFlowData rsFlowData) throws ApiException {
        if (null == rsFlowData) {
            return;
        }
        try {
            this.rsFlowDataMapper.insertFLowData(rsFlowData);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApiException(".RsFlowDataServiceImpl.saveRsFlowDataModel.ex", (Throwable)e);
        }
    }

    private void saveRsFlowDataFinishModel(RsFlowDataFinish rsFlowDataFinish) throws ApiException {
        if (null == rsFlowDataFinish) {
            return;
        }
        try {
            this.rsFlowDataMapper.insertFLowDataFinish(rsFlowDataFinish);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApiException(".RsFlowDataServiceImpl.saveRsFlowDataFinishModel.ex", (Throwable)e);
        }
    }

    private void insertBatchFlowDataModel(List<RsFlowData> rsFlowDataList) throws ApiException {
        if (null == rsFlowDataList || rsFlowDataList.isEmpty()) {
            return;
        }
        try {
            this.rsFlowDataMapper.insertBatch(rsFlowDataList);
        }
        catch (Exception e) {
            throw new ApiException(".RsFlowDataServiceImpl.insertBatchFlowDataModel.ex", (Throwable)e);
        }
    }

    private void deleteFlowDataModel(String fdCode, String tenantCode) throws ApiException {
        if (StringUtils.isEmpty((String)fdCode) || StringUtils.isEmpty((String)tenantCode)) {
            return;
        }
        try {
            this.rsFlowDataMapper.deleteByCode(fdCode, tenantCode);
        }
        catch (Exception e) {
            throw new ApiException(".RsFlowDataServiceImpl.deleteFlowDataModel.ex", (Throwable)e);
        }
    }

    @Override
    public void sendBatchFlowDataModel(List<RsFlowData> rsFlowDataList) {
        if (null == rsFlowDataList || rsFlowDataList.isEmpty()) {
            return;
        }
        for (RsFlowData rsFlowData : rsFlowDataList) {
            rsFlowData.setDataState(1);
            rsFlowData.setGmtCreate(new Date());
            String fdCode1 = this.getNo(null, RsFlowData.class.getSimpleName(), "fdCode", rsFlowData.getTenantCode());
            rsFlowData.setFdCode(fdCode1);
        }
        this.insertBatchFlowDataModel(rsFlowDataList);
        this.getEsEngineService().addPutPool(new EsEnginePutThread(this.getEsEngineService(), rsFlowDataList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EsEngineService getEsEngineService() {
        Object object = lock;
        synchronized (object) {
            if (null == esEngineService) {
                esEngineService = new EsEngineService((RsFlowDataService)SpringApplicationContextUtil.getBean((String)"rsFlowDataService"));
                for (int i = 0; i < 10; ++i) {
                    esEngineService.addPollPool(new EsEnginePollThread(esEngineService));
                }
            }
            return esEngineService;
        }
    }

    @Override
    public void loadFlowDataProcess() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            List<RsFlowData> rsFlowDataList = this.rsFlowDataMapper.query(map);
            if (null != rsFlowDataList && rsFlowDataList.size() > 0) {
                this.getEsEngineService().addPutPool(new EsEnginePutThread(this.getEsEngineService(), rsFlowDataList));
            }
        }
        catch (Exception e) {
            throw new ApiException(".RsFlowDataServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    @Override
    public boolean processRsToEsAndStatic(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return true;
        }
        if (rsFlowData.getFdBizType() == 1 ? !this.sendGoods(rsFlowData) : (rsFlowData.getFdBizType() == 2 ? !this.sendSku(rsFlowData) : (rsFlowData.getFdBizType() == 3 ? !this.sendClass(rsFlowData) : (rsFlowData.getFdBizType() == 4 ? !this.sendGoodsClass(rsFlowData) : (rsFlowData.getFdBizType() == 5 ? !this.sendDisGoods(rsFlowData) : rsFlowData.getFdBizType() == 6 && !this.sendDisSku(rsFlowData)))))) {
            return false;
        }
        this.deleteFlowDataModel(rsFlowData.getFdCode(), rsFlowData.getTenantCode());
        RsFlowDataFinish rsFlowDataFinish = new RsFlowDataFinish();
        try {
            BeanUtils.copyAllPropertys((Object)rsFlowDataFinish, (Object)rsFlowData);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveRsFlowDataFinishModel(rsFlowDataFinish);
        return true;
    }

    private boolean sendGoodsClass(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        String tenantCode = rsFlowData.getTenantCode();
        HashMap<String, List<RsGoodsClass>> goodsClassMap = new HashMap<String, List<RsGoodsClass>>();
        List<RsGoodsClass> rsGoodsClassList = this.rsFlowDataAssistService.queryAllGoodsClassAssist(tenantCode);
        HtmlRelease htmlRelease = new HtmlRelease();
        htmlRelease.setTenantCode(tenantCode);
        htmlRelease.setHtmldataCode("RsGoodsClass");
        htmlRelease.setHtmldataFilename("goodsclass.html");
        htmlRelease.setHtmldataFilepath("goodsclass");
        goodsClassMap.put("rsGoodsClass", rsGoodsClassList);
        htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson(goodsClassMap));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
        this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
        return true;
    }

    private boolean sendClass(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        String tenantCode = rsFlowData.getTenantCode();
        HashMap<String, List<RsClasstree>> classtreeMap = new HashMap<String, List<RsClasstree>>();
        List<RsClasstree> rsClasstreeList = this.rsFlowDataAssistService.queryAllClasstreeAssist(tenantCode);
        HtmlRelease htmlRelease = new HtmlRelease();
        htmlRelease.setTenantCode(tenantCode);
        htmlRelease.setHtmldataCode("RsClasstree");
        htmlRelease.setHtmldataFilename("classtree.html");
        htmlRelease.setHtmldataFilepath("classtree");
        classtreeMap.put("rsClasstree", rsClasstreeList);
        htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson(classtreeMap));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
        this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
        return true;
    }

    private boolean sendSku(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizCode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsSkuDomain rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        if (null != rsSkuDomain) {
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{rsSkuDomain.getGoodsCode(), rsFlowData.getTenantCode()}));
            if (!"delete".equals(rsFlowData.getEsRequestType())) {
                HtmlRelease htmlRelease = new HtmlRelease();
                htmlRelease.setTenantCode(rsSkuDomain.getTenantCode());
                htmlRelease.setHtmldataCode("RsSku");
                htmlRelease.setHtmldataFilename(rsSkuDomain.getSkuCode() + ".html");
                htmlRelease.setHtmldataFilepath("sku");
                HashMap<String, Serializable> htmlMap = new HashMap<String, Serializable>();
                htmlMap.put("goods", rsResourceGoodsReDomain);
                HashMap<String, Object> svMap = new HashMap<String, Object>();
                svMap.put("specValueBillno", rsSkuDomain.getGoodsCode());
                svMap.put("tenantCode", rsSkuDomain.getTenantCode());
                QueryResult<RsSpecValue> rsSpecValueListResult = this.rsSpecValueService.querySpecValuePage(svMap);
                if (null != rsSpecValueListResult && null != rsSpecValueListResult.getList() && rsSpecValueListResult.getList().size() > 0) {
                    HashMap<String, ArrayList<String>> specValueMap = new HashMap<String, ArrayList<String>>();
                    List rsSpecValueList = rsSpecValueListResult.getList();
                    for (RsSpecValue rsSpecValue : rsSpecValueList) {
                        String specName = rsSpecValue.getSpecName();
                        ArrayList<String> specValueList = (ArrayList<String>)specValueMap.get(specName);
                        if (null == specValueList || specValueList.size() == 0) {
                            specValueList = new ArrayList<String>();
                        }
                        specValueList.add(rsSpecValue.getSpecValueValue());
                        if (!StringUtils.isNotBlank((String)specName)) continue;
                        specValueMap.put(specName, specValueList);
                    }
                    htmlMap.put("spec", specValueMap);
                }
                htmlMap.put("rsSku", rsSkuDomain);
                List<RsGoodsRelDomain> rsGoodsRelList = rsResourceGoodsReDomain.getRsGoodsRelDomainList();
                ArrayList<RsSkuDomain> rsSkuList = new ArrayList<RsSkuDomain>();
                if (ListUtil.isNotEmpty(rsGoodsRelList)) {
                    for (RsGoodsRelDomain rsGoodsRel : rsGoodsRelList) {
                        QueryResult<RsSkuDomain> rsSkuList1;
                        RsResourceGoodsReDomain rsResourceGoodsReDomain1 = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(this.getQueryParamMap("goodsCode,tenantCode,unwantedRelatedData", new Object[]{rsGoodsRel.getGoodsRelGcode(), rsFlowData.getTenantCode(), "1"}));
                        if (null == rsResourceGoodsReDomain1 || null == (rsSkuList1 = this.rsFlowDataAssistService.querySkuPageAssist(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{rsGoodsRel.getGoodsRelGcode(), rsFlowData.getTenantCode()}))).getList() || rsSkuList1.getList().size() <= 0) continue;
                        RsSkuDomain rsSku1 = (RsSkuDomain)rsSkuList1.getList().get(0);
                        rsSku1.setGoodsName(rsResourceGoodsReDomain1.getGoodsName());
                        rsSkuList.add(rsSku1);
                    }
                }
                htmlMap.put("rsSkuRel", rsSkuList);
                htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson(htmlMap));
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
                this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
            }
        }
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setRequestType(rsFlowData.getEsRequestType());
        storeDomain.setBizType("sku");
        storeDomain.setTenantCode(rsFlowData.getTenantCode());
        storeDomain.setBizId(rsFlowData.getFdBizId() + "");
        if (!rsFlowData.getEsRequestType().equals("delete")) {
            EsSku esSku = new EsSku();
            try {
                BeanUtils.copyAllPropertys((Object)esSku, (Object)rsResourceGoodsReDomain);
                BeanUtils.copyAllPropertys((Object)esSku, (Object)rsSkuDomain);
            }
            catch (Exception e) {
                // empty catch block
            }
            esSku.setRsGoodsFileDomainList(rsSkuDomain.getRsGoodsFileDomainList());
            esSku.setRsSpecValueMap(rsSkuDomain.getRsSpecValueMap());
            esSku.setGoodsNo(rsResourceGoodsReDomain.getGoodsNo());
            esSku.setPntreeCode(rsResourceGoodsReDomain.getPntreeCode());
            esSku.setMemberName(rsResourceGoodsReDomain.getMemberName());
            esSku.setClasstreeName(rsResourceGoodsReDomain.getClasstreeName());
            esSku.setClasstreeCode(rsResourceGoodsReDomain.getClasstreeCode());
            esSku.setPntreeName(rsResourceGoodsReDomain.getPntreeName());
            esSku.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
            esSku.setGoodsProperty(rsResourceGoodsReDomain.getGoodsProperty());
            esSku.setBrandCode(rsResourceGoodsReDomain.getBrandCode());
            esSku.setBrandName(rsResourceGoodsReDomain.getBrandName());
            if (null == esSku.getGoodsSalesvolume()) {
                esSku.setGoodsSalesvolume(BigDecimal.ZERO);
            }
            esSku.setPropertiesName(this.rsFlowDataAssistService.getPropertiesName(esSku.getTenantCode(), esSku.getGoodsCode()));
            String esSkuStr = JsonUtil.buildNonNullBinder().toJson((Object)esSku);
            storeDomain.setStoreObj((Object)esSkuStr);
        }
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        paramMap1.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        String result = (String)this.getInternalRouter().inInvoke("es.searchengine.store", "1.0", "0", paramMap1);
        return !StringUtils.isEmpty((String)result) && !"false".equals(result);
    }

    private boolean sendDisSku(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        List<DisChannel> channelList = this.queryChannel(rsFlowData.getMemberCode(), rsFlowData.getTenantCode());
        if (null == channelList || channelList.isEmpty()) {
            return true;
        }
        String skuOldcode = rsFlowData.getFdBizCode();
        String tenantCode = rsFlowData.getTenantCode();
        if ("delete".equals(rsFlowData.getEsRequestType())) {
            this.rsFlowDataAssistService.deleteDisSku(skuOldcode, null, tenantCode);
        } else if ("insert".equals(rsFlowData.getEsRequestType())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsFlowData.getFdBizCode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            if (null == rsResourceGoodsReDomain) {
                return false;
            }
            map.put("skuCode", rsFlowData.getFdBizCode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            RsSkuDomain rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            if (null == rsSkuDomain) {
                return false;
            }
            List<DisRsSkuDomain> disRsSkuList = this.makeDisSku(rsResourceGoodsReDomain, rsSkuDomain, channelList);
            if (!ListUtil.isEmpty(disRsSkuList)) {
                this.rsFlowDataAssistService.saveDisSku(disRsSkuList);
            }
        } else {
            this.rsFlowDataAssistService.updateDisCannelSku(skuOldcode, null, tenantCode);
        }
        return true;
    }

    private List<DisChannel> queryChannel(String memberCode, String tenantCode) {
        List memchannelList;
        if (StringUtils.isBlank((String)memberCode)) {
            return null;
        }
        ArrayList<DisChannel> channelList = new ArrayList<DisChannel>();
        String channelListStr = DisUtil.getMap((String)"DisChannel-memberMcode", (String)(memberCode + "-" + DISCHANNEL_SALE + "-" + tenantCode));
        if (StringUtils.isNotBlank((String)channelListStr) && ListUtil.isNotEmpty((Collection)(memchannelList = (List)JsonUtil.buildNormalBinder().getJsonToList(channelListStr, DisChannel.class)))) {
            channelList.addAll(memchannelList);
        }
        if (StringUtils.isNotBlank((String)(channelListStr = DisUtil.getMap((String)"DisChannel-memberCcode", (String)(memberCode + "-" + DISCHANNEL_CON + "-" + tenantCode)))) && ListUtil.isNotEmpty((Collection)(memchannelList = (List)JsonUtil.buildNormalBinder().getJsonToList(channelListStr, DisChannel.class)))) {
            channelList.addAll(memchannelList);
        }
        if (StringUtils.isNotBlank((String)(channelListStr = DisUtil.getMap((String)"DisChannel-memberMcode", (String)(memberCode + "-" + DISCHANNEL_BUS + "-" + tenantCode)))) && ListUtil.isNotEmpty((Collection)(memchannelList = (List)JsonUtil.buildNormalBinder().getJsonToList(channelListStr, DisChannel.class)))) {
            channelList.addAll(memchannelList);
        }
        return channelList;
    }

    private boolean sendDisGoods(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        List<DisChannel> channelList = this.queryChannel(rsFlowData.getMemberCode(), rsFlowData.getTenantCode());
        if (null == channelList || channelList.isEmpty()) {
            return true;
        }
        String goodsOldcode = rsFlowData.getFdBizCode();
        String tenantCode = rsFlowData.getTenantCode();
        if ("delete".equals(rsFlowData.getEsRequestType())) {
            this.rsFlowDataAssistService.deleteDisGoods(goodsOldcode, null, rsFlowData.getTenantCode());
        } else if ("insert".equals(rsFlowData.getEsRequestType())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsFlowData.getFdBizCode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            if (null == rsResourceGoodsReDomain) {
                return false;
            }
            List<DisRsResourceGoodsDomain> disRsResourceGoodsList = this.makeDisGoods(rsResourceGoodsReDomain, channelList);
            if (!ListUtil.isEmpty(disRsResourceGoodsList)) {
                this.rsFlowDataAssistService.saveDisResourceGoods(disRsResourceGoodsList);
            }
        } else {
            this.rsFlowDataAssistService.updateDisCannelGoods(goodsOldcode, null, tenantCode);
        }
        return true;
    }

    private List<DisRsSkuDomain> makeDisSku(RsResourceGoodsReDomain rsResourceGoodsReDomain, RsSkuDomain rsSkuDomain, List<DisChannel> channelList) {
        if (null == rsResourceGoodsReDomain || null == rsSkuDomain || ListUtil.isEmpty(channelList)) {
            return null;
        }
        ArrayList<DisRsSkuDomain> disList = new ArrayList<DisRsSkuDomain>();
        for (DisChannel disChannel : channelList) {
            DisRsResourceGoodsDomain disRsResourceGoodsDomain = this.checkDisGoods(rsResourceGoodsReDomain, disChannel);
            if (null == disRsResourceGoodsDomain) continue;
            disList.add(this.makeDisSku(rsResourceGoodsReDomain, rsSkuDomain, disChannel));
        }
        return disList;
    }

    private DisRsSkuDomain makeDisSku(RsResourceGoodsReDomain rsResourceGoodsReDomain, RsSkuDomain rsSkuDomain, DisChannel disChannel) {
        if (null == rsResourceGoodsReDomain || null == disChannel) {
            return null;
        }
        DisRsSkuDomain disRsSkuDomain = new DisRsSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRsSkuDomain, (Object)rsResourceGoodsReDomain);
            BeanUtils.copyAllPropertys((Object)disRsSkuDomain, (Object)rsSkuDomain);
            disRsSkuDomain.setGoodsShowno(rsResourceGoodsReDomain.getGoodsNo());
            disRsSkuDomain.setSkuShowno(rsSkuDomain.getSkuNo());
            disRsSkuDomain.setSkuCodeOld(rsSkuDomain.getSkuCode());
            disRsSkuDomain.setSkuOldcode(rsSkuDomain.getSkuCode());
            disRsSkuDomain.setGoodsOldcode(rsResourceGoodsReDomain.getGoodsCode());
            disRsSkuDomain.setChannelCode(disChannel.getChannelCode());
            disRsSkuDomain.setChannelName(disChannel.getChannelName());
            disRsSkuDomain.setMemberCode(disChannel.getMemberCode());
            disRsSkuDomain.setMemberName(disChannel.getMemberName());
            if (DISCHANNEL_CON.equals(disChannel.getChannelSort())) {
                disRsSkuDomain.setMemberCcode(disChannel.getMemberCcode());
                disRsSkuDomain.setMemberCname(disChannel.getMemberCname());
            }
        }
        catch (Exception e) {
            return null;
        }
        return disRsSkuDomain;
    }

    private List<DisRsResourceGoodsDomain> makeDisGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain, List<DisChannel> channelList) {
        if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(channelList)) {
            return null;
        }
        ArrayList<DisRsResourceGoodsDomain> disList = new ArrayList<DisRsResourceGoodsDomain>();
        for (DisChannel disChannel : channelList) {
            DisRsResourceGoodsDomain disRsResourceGoodsDomain = this.checkDisGoods(rsResourceGoodsReDomain, disChannel);
            if (null == disRsResourceGoodsDomain) continue;
            disList.add(disRsResourceGoodsDomain);
        }
        return disList;
    }

    private DisRsResourceGoodsDomain makeDisGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain, DisChannel disChannel) {
        if (null == rsResourceGoodsReDomain || null == disChannel) {
            return null;
        }
        DisRsResourceGoodsDomain disRsResourceGoodsDomain = new DisRsResourceGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRsResourceGoodsDomain, (Object)rsResourceGoodsReDomain);
            disRsResourceGoodsDomain.setGoodsShowname(rsResourceGoodsReDomain.getGoodsName());
            disRsResourceGoodsDomain.setGoodsShowno(rsResourceGoodsReDomain.getGoodsNo());
            disRsResourceGoodsDomain.setGoodsCodeOld(rsResourceGoodsReDomain.getGoodsCode());
            disRsResourceGoodsDomain.setGoodsOldcode(rsResourceGoodsReDomain.getGoodsCode());
            disRsResourceGoodsDomain.setChannelCode(disChannel.getChannelCode());
            disRsResourceGoodsDomain.setChannelName(disChannel.getChannelName());
            disRsResourceGoodsDomain.setMemberCode(disChannel.getMemberCode());
            disRsResourceGoodsDomain.setMemberName(disChannel.getMemberName());
            disRsResourceGoodsDomain.setGoodsOrigin("7");
            if (DISCHANNEL_CON.equals(disChannel.getChannelSort())) {
                disRsResourceGoodsDomain.setMemberCcode(disChannel.getMemberCcode());
                disRsResourceGoodsDomain.setMemberCname(disChannel.getMemberCname());
            }
            disRsResourceGoodsDomain.setDisRsSkuDomainList(this.makeDisSkuList(rsResourceGoodsReDomain.getRsSkuDomainList(), disChannel));
        }
        catch (Exception e) {
            return null;
        }
        return disRsResourceGoodsDomain;
    }

    private List<DisRsSkuDomain> makeDisSkuList(List<RsSkuDomain> rsSkuDomainList, DisChannel disChannel) {
        if (ListUtil.isEmpty(rsSkuDomainList) || null == disChannel) {
            return null;
        }
        ArrayList<DisRsSkuDomain> disRsSkuDomainList = new ArrayList<DisRsSkuDomain>();
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            DisRsSkuDomain disRsSkuDomain = this.makeDisSku(rsSkuDomain, disChannel);
            if (null == disRsSkuDomain) continue;
            disRsSkuDomainList.add(disRsSkuDomain);
        }
        return disRsSkuDomainList;
    }

    private DisRsSkuDomain makeDisSku(RsSkuDomain rsSkuDomain, DisChannel disChannel) {
        if (null == rsSkuDomain || null == disChannel) {
            return null;
        }
        DisRsSkuDomain disRsSkuDomain = new DisRsSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRsSkuDomain, (Object)rsSkuDomain);
            disRsSkuDomain.setSkuCodeOld(rsSkuDomain.getSkuCode());
            disRsSkuDomain.setSkuOldcode(rsSkuDomain.getSkuCode());
            disRsSkuDomain.setGoodsOldcode(rsSkuDomain.getGoodsOldcode());
            disRsSkuDomain.setChannelCode(disChannel.getChannelCode());
            disRsSkuDomain.setChannelName(disChannel.getChannelName());
            disRsSkuDomain.setMemberCode(disChannel.getMemberCode());
            disRsSkuDomain.setMemberName(disChannel.getMemberName());
        }
        catch (Exception e) {
            return null;
        }
        return disRsSkuDomain;
    }

    private DisRsResourceGoodsDomain checkDisGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain, DisChannel disChannel) {
        DisRsResourceGoodsDomain disRsResourceGoodsDomain;
        if (null == rsResourceGoodsReDomain || null == disChannel) {
            return null;
        }
        String goodsStr = DisUtil.getMap((String)"DisDgoods-channelCode", (String)(disChannel.getChannelCode() + "-" + disChannel.getTenantCode()));
        if (StringUtils.isBlank((String)goodsStr)) {
            return null;
        }
        DisDgoods disDgoods = (DisDgoods)JsonUtil.buildNormalBinder().getJsonToObject(goodsStr, DisDgoods.class);
        if (null == disDgoods) {
            return null;
        }
        goodsStr = DisUtil.getMap((String)"DisDgoodsScopelist-DgoodsCode", (String)(disDgoods.getDgoodsCode() + "-" + disChannel.getTenantCode()));
        if (StringUtils.isBlank((String)goodsStr)) {
            return null;
        }
        List disDgoodsScopelistList = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsStr, DisDgoodsScopelist.class);
        if (ListUtil.isEmpty((Collection)disDgoodsScopelistList)) {
            disRsResourceGoodsDomain = this.makeDisGoods(rsResourceGoodsReDomain, disChannel);
        } else {
            Map<String, List<String>> map = this.makeScopelist(disDgoodsScopelistList);
            if (null == map || map.isEmpty()) {
                return null;
            }
            for (String key : map.keySet()) {
                String objValue = (String)BeanUtils.forceGetProperty((Object)rsResourceGoodsReDomain, (String)key);
                if (null == objValue) {
                    return null;
                }
                if (map.get(key).contains(objValue)) continue;
                return null;
            }
            disRsResourceGoodsDomain = this.makeDisGoods(rsResourceGoodsReDomain, disChannel);
        }
        this.makePice(disRsResourceGoodsDomain, disChannel);
        if ("1".equals(disDgoods.getDgoodsPut())) {
            disRsResourceGoodsDomain.setDataOpbillstate(1);
        }
        return disRsResourceGoodsDomain;
    }

    private void makePice(DisRsResourceGoodsDomain disRsResourceGoodsDomain, DisChannel disChannel) {
        if (null == disRsResourceGoodsDomain || null == disChannel) {
            return;
        }
        String goodsStr = DisUtil.getMap((String)"DisDpriceConf-channelCode", (String)(disChannel.getChannelCode() + "-" + disChannel.getTenantCode()));
        if (StringUtils.isBlank((String)goodsStr)) {
            return;
        }
        List disDpriceList = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsStr, DisDpriceDomain.class);
        if (ListUtil.isEmpty((Collection)disDpriceList)) {
            return;
        }
        for (DisDpriceDomain disDpriceDomain : disDpriceList) {
            Map<String, List<String>> map = this.makeDpeicelist(disDpriceDomain.getDisDpriceConfList());
            if (null == map || map.isEmpty()) continue;
            for (String key : map.keySet()) {
                String objValue = (String)BeanUtils.forceGetProperty((Object)disRsResourceGoodsDomain, (String)key);
                if (null != objValue && map.get(key).contains(objValue)) continue;
            }
            this.setPrice(disDpriceDomain, disRsResourceGoodsDomain);
            return;
        }
    }

    private void setPrice(DisDpriceDomain disDpriceDomain, DisRsResourceGoodsDomain disRsResourceGoodsDomain) {
        if (null == disDpriceDomain || null == disRsResourceGoodsDomain) {
            return;
        }
        String pro = disDpriceDomain.getDpricePro();
        BigDecimal rmoney = BigDecimal.ZERO;
        BigDecimal money = disRsResourceGoodsDomain.getPricesetNprice();
        if ("0".equals(pro)) {
            rmoney = disDpriceDomain.getDpricePrice();
        } else if ("1".equals(pro)) {
            rmoney = money.subtract(disDpriceDomain.getDpricePrice().divide(new BigDecimal("100")).multiply(money));
        } else if ("1".equals(pro)) {
            rmoney = BigDecimal.ZERO;
        }
        disRsResourceGoodsDomain.setPricesetNprice(disRsResourceGoodsDomain.getPricesetNprice().subtract(rmoney));
    }

    private Map<String, List<String>> makeDpeicelist(List<DisDpriceConf> disDpriceConfList) {
        if (ListUtil.isEmpty(disDpriceConfList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DisDpriceConf disDpriceConf : disDpriceConfList) {
            ArrayList<String> list = (ArrayList<String>)map.get(disDpriceConf.getDpriceConfType());
            if (null == list) {
                list = new ArrayList<String>();
                map.put(disDpriceConf.getDpriceConfType(), list);
            }
            list.add(disDpriceConf.getDpriceConfValue());
        }
        return map;
    }

    private Map<String, List<String>> makeScopelist(List<DisDgoodsScopelist> disDgoodsScopelistList) {
        if (ListUtil.isEmpty(disDgoodsScopelistList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DisDgoodsScopelist disDgoodsScopelist : disDgoodsScopelistList) {
            ArrayList<String> list = (ArrayList<String>)map.get(disDgoodsScopelist.getDgoodsScopelistType());
            if (null == list) {
                list = new ArrayList<String>();
                map.put(disDgoodsScopelist.getDgoodsScopelistType(), list);
            }
            list.add(disDgoodsScopelist.getDgoodsScopelistValue());
        }
        return map;
    }

    private boolean sendGoods(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", rsFlowData.getFdBizCode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
        if (null == rsResourceGoodsReDomain) {
            return false;
        }
        if (!"delete".equals(rsFlowData.getEsRequestType())) {
            HtmlRelease htmlRelease = new HtmlRelease();
            htmlRelease.setTenantCode(rsResourceGoodsReDomain.getTenantCode());
            htmlRelease.setHtmldataCode("RsResourceGoods");
            htmlRelease.setHtmldataFilename(rsResourceGoodsReDomain.getGoodsCode() + ".html");
            htmlRelease.setHtmldataFilepath("goods");
            htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsReDomain));
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
            this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
        }
        StoreDomain storeDomain = new StoreDomain();
        storeDomain.setRequestType(rsFlowData.getEsRequestType());
        storeDomain.setBizType("goods");
        storeDomain.setBizId(rsResourceGoodsReDomain.getGoodsId() + "");
        storeDomain.setTenantCode(rsFlowData.getTenantCode());
        String s = JsonUtil.buildNonNullBinder().toJson((Object)rsResourceGoodsReDomain);
        storeDomain.setStoreObj((Object)s);
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        paramMap1.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        String result = (String)this.getInternalRouter().inInvoke("es.searchengine.store", "1.0", "0", paramMap1);
        return !StringUtils.isEmpty((String)result) && !"false".equals(result);
    }

    static {
        lock = new Object();
        DISCHANNEL_SALE = "0";
        DISCHANNEL_CON = "1";
        DISCHANNEL_BUS = "2";
    }
}

