/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsFlowDataMapper;
import com.yqbsoft.laser.service.resources.domain.DisChannel;
import com.yqbsoft.laser.service.resources.domain.DisDgoods;
import com.yqbsoft.laser.service.resources.domain.DisDgoodsScopelist;
import com.yqbsoft.laser.service.resources.domain.DisDpriceConf;
import com.yqbsoft.laser.service.resources.domain.DisDpriceDomain;
import com.yqbsoft.laser.service.resources.domain.DisRsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.DisRsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.HtmlRelease;
import com.yqbsoft.laser.service.resources.domain.RsGoodsFileDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsRelDomain;
import com.yqbsoft.laser.service.resources.domain.RsPropertiesValueDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.RsSpecValueDomain;
import com.yqbsoft.laser.service.resources.es.EsEnginePollThread;
import com.yqbsoft.laser.service.resources.es.EsEnginePutThread;
import com.yqbsoft.laser.service.resources.es.EsEngineService;
import com.yqbsoft.laser.service.resources.model.EsSku;
import com.yqbsoft.laser.service.resources.model.RsClasstree;
import com.yqbsoft.laser.service.resources.model.RsFlowData;
import com.yqbsoft.laser.service.resources.model.RsFlowDataFinish;
import com.yqbsoft.laser.service.resources.model.RsGoodsClass;
import com.yqbsoft.laser.service.resources.model.RsRessendApi;
import com.yqbsoft.laser.service.resources.model.RsRessendApiconf;
import com.yqbsoft.laser.service.resources.model.RsSpecValue;
import com.yqbsoft.laser.service.resources.service.RsFlowDataAssistService;
import com.yqbsoft.laser.service.resources.service.RsFlowDataService;
import com.yqbsoft.laser.service.resources.service.RsRessendApiService;
import com.yqbsoft.laser.service.resources.service.RsSpecValueService;
import com.yqbsoft.laser.service.suppercore.es.StoreDomain;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsFlowDataServiceImpl
extends BaseServiceImpl
implements RsFlowDataService {
    public static final String SYS_CODE = ".RsFlowDataServiceImpl";
    private static EsEngineService esEngineService;
    private static Object lock;
    private static String DISCHANNEL_SALE;
    private static String DISCHANNEL_CON;
    private static String DISCHANNEL_BUS;
    private RsFlowDataMapper rsFlowDataMapper;
    private RsSpecValueService rsSpecValueService;
    private RsFlowDataAssistService rsFlowDataAssistService;
    private RsRessendApiService rsRessendApiService;

    public void setRsRessendApiService(RsRessendApiService rsRessendApiService) {
        this.rsRessendApiService = rsRessendApiService;
    }

    public void setRsFlowDataMapper(RsFlowDataMapper rsFlowDataMapper) {
        this.rsFlowDataMapper = rsFlowDataMapper;
    }

    public void setRsSpecValueService(RsSpecValueService rsSpecValueService) {
        this.rsSpecValueService = rsSpecValueService;
    }

    public void setRsFlowDataAssistService(RsFlowDataAssistService rsFlowDataAssistService) {
        this.rsFlowDataAssistService = rsFlowDataAssistService;
    }

    private void saveRsFlowDataModel(RsFlowData rsFlowData) throws ApiException {
        if (null == rsFlowData) {
            return;
        }
        try {
            this.rsFlowDataMapper.insertFLowData(rsFlowData);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApiException(".RsFlowDataServiceImpl.saveRsFlowDataModel.ex", (Throwable)e);
        }
    }

    private void saveRsFlowDataFinishModel(RsFlowDataFinish rsFlowDataFinish) throws ApiException {
        if (null == rsFlowDataFinish) {
            return;
        }
        try {
            this.rsFlowDataMapper.insertFLowDataFinish(rsFlowDataFinish);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApiException(".RsFlowDataServiceImpl.saveRsFlowDataFinishModel.ex", (Throwable)e);
        }
    }

    private void insertBatchFlowDataModel(List<RsFlowData> rsFlowDataList) throws ApiException {
        if (null == rsFlowDataList || rsFlowDataList.isEmpty()) {
            return;
        }
        try {
            this.rsFlowDataMapper.insertBatch(rsFlowDataList);
        }
        catch (Exception e) {
            throw new ApiException(".RsFlowDataServiceImpl.insertBatchFlowDataModel.ex", (Throwable)e);
        }
    }

    private void deleteFlowDataModel(String fdCode, String tenantCode) throws ApiException {
        if (StringUtils.isEmpty((String)fdCode) || StringUtils.isEmpty((String)tenantCode)) {
            return;
        }
        try {
            this.rsFlowDataMapper.deleteByCode(fdCode, tenantCode);
        }
        catch (Exception e) {
            throw new ApiException(".RsFlowDataServiceImpl.deleteFlowDataModel.ex", (Throwable)e);
        }
    }

    @Override
    public void sendBatchFlowDataModel(List<RsFlowData> rsFlowDataList) {
        if (null == rsFlowDataList || rsFlowDataList.isEmpty()) {
            return;
        }
        for (RsFlowData rsFlowData : rsFlowDataList) {
            rsFlowData.setDataState(1);
            rsFlowData.setGmtCreate(new Date());
            String fdCode1 = this.getNo(null, RsFlowData.class.getSimpleName(), "fdCode", rsFlowData.getTenantCode());
            rsFlowData.setFdCode(fdCode1);
        }
        this.insertBatchFlowDataModel(rsFlowDataList);
        this.getEsEngineService().addPutPool(new EsEnginePutThread(this.getEsEngineService(), rsFlowDataList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EsEngineService getEsEngineService() {
        Object object = lock;
        synchronized (object) {
            if (null == esEngineService) {
                esEngineService = new EsEngineService((RsFlowDataService)SpringApplicationContextUtil.getBean((String)"rsFlowDataService"));
                for (int i = 0; i < 100; ++i) {
                    esEngineService.addPollPool(new EsEnginePollThread(esEngineService));
                }
            }
            return esEngineService;
        }
    }

    @Override
    public void loadFlowDataProcess() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            List<RsFlowData> rsFlowDataList = this.rsFlowDataMapper.query(map);
            if (null != rsFlowDataList && rsFlowDataList.size() > 0) {
                this.getEsEngineService().addPutPool(new EsEnginePutThread(this.getEsEngineService(), rsFlowDataList));
            }
        }
        catch (Exception e) {
            throw new ApiException(".RsFlowDataServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    @Override
    public boolean processRsToEsAndStatic(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return true;
        }
        this.logger.error("=====================" + rsFlowData.getFdBizType() + "=" + rsFlowData.getFdBizCode());
        if (rsFlowData.getFdBizType() == 1 ? !this.sendGoods(rsFlowData) : (rsFlowData.getFdBizType() == 2 ? !this.sendSku(rsFlowData) : (rsFlowData.getFdBizType() == 3 ? !this.sendClass(rsFlowData) : (rsFlowData.getFdBizType() == 4 ? !this.sendGoodsClass(rsFlowData) : (rsFlowData.getFdBizType() == 5 ? !this.sendDisGoods(rsFlowData) : (rsFlowData.getFdBizType() == 6 ? !this.sendDisSku(rsFlowData) : rsFlowData.getFdBizType() == 7 && !this.sendOutGoods(rsFlowData))))))) {
            return false;
        }
        this.deleteFlowDataModel(rsFlowData.getFdCode(), rsFlowData.getTenantCode());
        RsFlowDataFinish rsFlowDataFinish = new RsFlowDataFinish();
        try {
            BeanUtils.copyAllPropertys((Object)rsFlowDataFinish, (Object)rsFlowData);
            rsFlowDataFinish.setFdId(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveRsFlowDataFinishModel(rsFlowDataFinish);
        return true;
    }

    private boolean sendOutGoods(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsCode", rsFlowData.getFdBizCode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = rsFlowData.getRsResourceGoodsReDomain();
        if (null == rsResourceGoodsReDomain) {
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
        }
        if (null == rsResourceGoodsReDomain) {
            return false;
        }
        Map paramMap = this.getQueryParamMap("tenantCode", new Object[]{rsFlowData.getTenantCode()});
        if (null != paramMap) {
            QueryResult<RsRessendApi> ressendApiResult = this.rsRessendApiService.queryRessendApiPage(paramMap);
            if (null == ressendApiResult || ListUtil.isEmpty((Collection)ressendApiResult.getList())) {
                return true;
            }
            List<RsRessendApi> listRessendApi = this.structureApi(ressendApiResult.getList(), rsResourceGoodsReDomain);
            if (ListUtil.isEmpty(listRessendApi)) {
                return true;
            }
            for (RsRessendApi rsRessendApi : listRessendApi) {
                HashMap<String, String> paramMap1 = new HashMap<String, String>();
                paramMap1.put("rsResourceGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsReDomain));
                String result = (String)this.getInternalRouter().inInvoke(rsRessendApi.getRessendApiApicode(), "1.0", "0", paramMap1);
                if (!StringUtils.isEmpty((String)result) && !"false".equals(result)) continue;
                this.logger.error("\u672a\u6210\u529f\u5904\u7406\u7684api *****" + rsRessendApi.getRessendApiCode() + "*****" + rsFlowData.getFdBizCode());
                return false;
            }
        }
        return true;
    }

    private List<RsRessendApi> structureApi(List<RsRessendApi> ressendApiList, RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        ArrayList<RsRessendApi> sendApiList = new ArrayList<RsRessendApi>();
        for (RsRessendApi rsRessendApi : ressendApiList) {
            List apiconfList;
            Map<String, List<String>> map;
            HashMap<String, Object> apiconfMap = new HashMap<String, Object>();
            apiconfMap.put("ressendApiCode", rsRessendApi.getRessendApiCode());
            apiconfMap.put("tenantCode", rsRessendApi.getTenantCode());
            QueryResult<RsRessendApiconf> apiconf = this.rsRessendApiService.queryRessendApiconfPage(apiconfMap);
            if (null == apiconf || apiconf.getList().size() <= 0) {
                sendApiList.add(rsRessendApi);
            }
            if (null == (map = this.makeRessendScopelist(apiconfList = apiconf.getList())) || map.isEmpty()) continue;
            for (String key : map.keySet()) {
                String objValue = (String)BeanUtils.forceGetProperty((Object)rsResourceGoodsReDomain, (String)key);
                if (null == objValue || !map.get(key).contains(objValue) || sendApiList.contains(rsRessendApi)) continue;
                sendApiList.add(rsRessendApi);
            }
        }
        return sendApiList;
    }

    private Map<String, List<String>> makeRessendScopelist(List<RsRessendApiconf> apiconfList) {
        if (ListUtil.isEmpty(apiconfList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (RsRessendApiconf rsRessendApiconf : apiconfList) {
            ArrayList<String> list = (ArrayList<String>)map.get(rsRessendApiconf.getRessendApiconfType());
            if (null == list) {
                list = new ArrayList<String>();
                map.put(rsRessendApiconf.getRessendApiconfType(), list);
            }
            list.add(rsRessendApiconf.getRessendApiconfOp());
        }
        return map;
    }

    private boolean sendGoodsClass(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        String tenantCode = rsFlowData.getTenantCode();
        HashMap<String, List<RsGoodsClass>> goodsClassMap = new HashMap<String, List<RsGoodsClass>>();
        List<RsGoodsClass> rsGoodsClassList = this.rsFlowDataAssistService.queryAllGoodsClassAssist(tenantCode);
        HtmlRelease htmlRelease = new HtmlRelease();
        htmlRelease.setTenantCode(tenantCode);
        htmlRelease.setHtmldataCode("RsGoodsClass");
        htmlRelease.setHtmldataFilename("goodsclass.html");
        htmlRelease.setHtmldataFilepath("goodsclass");
        goodsClassMap.put("rsGoodsClass", rsGoodsClassList);
        htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson(goodsClassMap));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
        try {
            this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
        }
        catch (Exception e) {
            this.logger.error("rsFlowDataServiceImpl.sendGoodsClass.ex", (Throwable)e);
        }
        return true;
    }

    private boolean sendClass(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        String tenantCode = rsFlowData.getTenantCode();
        HashMap<String, List<RsClasstree>> classtreeMap = new HashMap<String, List<RsClasstree>>();
        List<RsClasstree> rsClasstreeList = this.rsFlowDataAssistService.queryAllClasstreeAssist(tenantCode);
        HtmlRelease htmlRelease = new HtmlRelease();
        htmlRelease.setTenantCode(tenantCode);
        htmlRelease.setHtmldataCode("RsClasstree");
        htmlRelease.setHtmldataFilename("classtree.html");
        htmlRelease.setHtmldataFilepath("classtree");
        classtreeMap.put("rsClasstree", rsClasstreeList);
        htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson(classtreeMap));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
        try {
            this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
        }
        catch (Exception e) {
            this.logger.error("rsFlowDataServiceImpl.sendClass.ex", (Throwable)e);
        }
        return true;
    }

    private boolean sendSku(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", rsFlowData.getFdBizCode());
        map.put("tenantCode", rsFlowData.getTenantCode());
        RsSkuDomain rsSkuDomain = null;
        StoreDomain storeDomain = new StoreDomain();
        if (!"delete".equals(rsFlowData.getEsRequestType())) {
            RsResourceGoodsReDomain rsResourceGoodsReDomain = rsFlowData.getRsResourceGoodsReDomain();
            if (null == rsResourceGoodsReDomain) {
                rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
                if (null == rsSkuDomain) {
                    this.logger.error(".RsFlowDataServiceImpl.sendSku.rsSkuDomain", (Object)((Object)map).toString());
                }
                rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{rsSkuDomain.getGoodsCode(), rsFlowData.getTenantCode()}));
            }
            if (null == rsResourceGoodsReDomain) {
                return false;
            }
            List<RsSkuDomain> rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList();
            if (ListUtil.isEmpty(rsSkuDomainList)) {
                return false;
            }
            if (null != rsSkuDomain) {
                for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
                    if (!rsSkuDomain2.getSkuCode().equals(rsFlowData.getFdBizCode())) continue;
                    rsSkuDomain = rsSkuDomain2;
                    break;
                }
            }
            if (null == rsSkuDomain) {
                rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
            }
            HtmlRelease htmlRelease = new HtmlRelease();
            htmlRelease.setTenantCode(rsSkuDomain.getTenantCode());
            htmlRelease.setHtmldataCode("RsSku");
            htmlRelease.setHtmldataFilename(rsSkuDomain.getSkuCode() + ".html");
            htmlRelease.setHtmldataFilepath("sku");
            HashMap<String, Serializable> htmlMap = new HashMap<String, Serializable>();
            htmlMap.put("goods", rsResourceGoodsReDomain);
            HashMap<String, Object> svMap = new HashMap<String, Object>();
            svMap.put("specValueBillno", rsSkuDomain.getGoodsCode());
            svMap.put("tenantCode", rsSkuDomain.getTenantCode());
            QueryResult<RsSpecValue> rsSpecValueListResult = this.rsSpecValueService.querySpecValuePage(svMap);
            if (null != rsSpecValueListResult && null != rsSpecValueListResult.getList() && rsSpecValueListResult.getList().size() > 0) {
                HashMap<String, ArrayList<String>> specValueMap = new HashMap<String, ArrayList<String>>();
                List rsSpecValueList = rsSpecValueListResult.getList();
                for (RsSpecValue rsSpecValue : rsSpecValueList) {
                    String specName = rsSpecValue.getSpecName();
                    ArrayList<String> specValueList = (ArrayList<String>)specValueMap.get(specName);
                    if (null == specValueList || specValueList.size() == 0) {
                        specValueList = new ArrayList<String>();
                    }
                    specValueList.add(rsSpecValue.getSpecValueValue());
                    if (!StringUtils.isNotBlank((String)specName)) continue;
                    specValueMap.put(specName, specValueList);
                }
                htmlMap.put("spec", specValueMap);
            }
            htmlMap.put("rsSku", rsSkuDomain);
            List<RsGoodsRelDomain> rsGoodsRelList = rsResourceGoodsReDomain.getRsGoodsRelDomainList();
            ArrayList<RsSkuDomain> rsSkuList = new ArrayList<RsSkuDomain>();
            if (ListUtil.isNotEmpty(rsGoodsRelList)) {
                for (RsGoodsRelDomain rsGoodsRel : rsGoodsRelList) {
                    QueryResult<RsSkuDomain> rsSkuList1;
                    RsResourceGoodsReDomain rsResourceGoodsReDomain1 = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(this.getQueryParamMap("goodsCode,tenantCode,unwantedRelatedData", new Object[]{rsGoodsRel.getGoodsRelGcode(), rsFlowData.getTenantCode(), "1"}));
                    if (null == rsResourceGoodsReDomain1 || null == (rsSkuList1 = this.rsFlowDataAssistService.querySkuPageAssist(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{rsGoodsRel.getGoodsRelGcode(), rsFlowData.getTenantCode()}))).getList() || rsSkuList1.getList().size() <= 0) continue;
                    RsSkuDomain rsSku1 = (RsSkuDomain)rsSkuList1.getList().get(0);
                    rsSku1.setGoodsName(rsResourceGoodsReDomain1.getGoodsName());
                    rsSkuList.add(rsSku1);
                }
            }
            htmlMap.put("rsSkuRel", rsSkuList);
            htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson(htmlMap));
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
            try {
                this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
            }
            catch (Exception e) {
                this.logger.error("rsFlowDataServiceImpl.sendSku.ex", (Throwable)e);
            }
            if (!rsFlowData.getEsRequestType().equals("delete")) {
                EsSku esSku = new EsSku();
                try {
                    BeanUtils.copyAllPropertys((Object)esSku, (Object)rsResourceGoodsReDomain);
                    BeanUtils.copyAllPropertys((Object)esSku, (Object)rsSkuDomain);
                }
                catch (Exception e) {
                    // empty catch block
                }
                esSku.setRsGoodsFileDomainList(rsSkuDomain.getRsGoodsFileDomainList());
                esSku.setRsSpecValueMap(rsSkuDomain.getRsSpecValueMap());
                esSku.setGoodsNo(rsResourceGoodsReDomain.getGoodsNo());
                esSku.setPntreeCode(rsResourceGoodsReDomain.getPntreeCode());
                esSku.setMemberName(rsResourceGoodsReDomain.getMemberName());
                esSku.setClasstreeName(rsResourceGoodsReDomain.getClasstreeName());
                esSku.setClasstreeCode(rsResourceGoodsReDomain.getClasstreeCode());
                esSku.setPntreeName(rsResourceGoodsReDomain.getPntreeName());
                esSku.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                esSku.setGoodsProperty(rsResourceGoodsReDomain.getGoodsProperty());
                esSku.setBrandCode(rsResourceGoodsReDomain.getBrandCode());
                esSku.setBrandName(rsResourceGoodsReDomain.getBrandName());
                esSku.setGoodsSpec(null == rsResourceGoodsReDomain.getGoodsSpec() ? "" : rsResourceGoodsReDomain.getGoodsSpec());
                if (null == esSku.getGoodsSalesvolume()) {
                    esSku.setGoodsSalesvolume(BigDecimal.ZERO);
                }
                esSku.setPropertiesName(this.rsFlowDataAssistService.getPropertiesName(esSku.getTenantCode(), esSku.getGoodsCode()));
                String esSkuStr = JsonUtil.buildNonNullBinder().toJson((Object)esSku);
                storeDomain.setStoreObj((Object)esSkuStr);
            }
        }
        storeDomain.setRequestType(rsFlowData.getEsRequestType());
        storeDomain.setBizType("sku");
        storeDomain.setTenantCode(rsFlowData.getTenantCode());
        storeDomain.setBizId(rsFlowData.getFdBizId() + "");
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        paramMap1.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        String result = (String)this.getInternalRouter().inInvoke("es.searchengine.store", "1.0", "0", paramMap1);
        return !StringUtils.isEmpty((String)result) && !"false".equals(result);
    }

    private boolean sendDisSku(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        List<DisChannel> channelList = this.queryChannel(rsFlowData.getMemberCode(), rsFlowData.getTenantCode());
        if (null == channelList || channelList.isEmpty()) {
            return true;
        }
        String skuOldcode = rsFlowData.getFdBizCode();
        String tenantCode = rsFlowData.getTenantCode();
        if ("delete".equals(rsFlowData.getEsRequestType())) {
            this.rsFlowDataAssistService.deleteDisSku(skuOldcode, null, tenantCode);
        } else if ("insert".equals(rsFlowData.getEsRequestType())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            RsResourceGoodsReDomain rsResourceGoodsReDomain = rsFlowData.getRsResourceGoodsReDomain();
            RsSkuDomain rsSkuDomain = null;
            if (null == rsResourceGoodsReDomain) {
                map.put("skuCode", rsFlowData.getFdBizCode());
                map.put("tenantCode", rsFlowData.getTenantCode());
                rsSkuDomain = this.rsFlowDataAssistService.getSkuByCodeAssist(map);
                if (null == rsSkuDomain) {
                    return false;
                }
                map.remove("skuCode");
                map.put("goodsCode", rsSkuDomain.getGoodsCode());
                map.put("tenantCode", rsFlowData.getTenantCode());
                rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            } else {
                List<RsSkuDomain> rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList();
                if (ListUtil.isEmpty(rsSkuDomainList)) {
                    return false;
                }
                for (RsSkuDomain rsSkuDomain2 : rsSkuDomainList) {
                    if (!rsSkuDomain2.getSkuCode().equals(rsFlowData.getFdBizCode())) continue;
                    rsSkuDomain = rsSkuDomain2;
                    break;
                }
            }
            if (null == rsResourceGoodsReDomain) {
                return false;
            }
            List<DisRsSkuDomain> disRsSkuList = this.makeDisSku(rsResourceGoodsReDomain, rsSkuDomain, channelList);
            if (!ListUtil.isEmpty(disRsSkuList)) {
                this.rsFlowDataAssistService.saveDisSku(disRsSkuList);
            }
        } else {
            this.rsFlowDataAssistService.updateDisCannelSku(skuOldcode, null, tenantCode);
        }
        return true;
    }

    private List<DisChannel> queryChannel(String memberCode, String tenantCode) {
        List memchannelList1;
        DisChannel memchannel;
        if (StringUtils.isBlank((String)memberCode)) {
            return null;
        }
        ArrayList<DisChannel> channelList = new ArrayList<DisChannel>();
        List memchannelList = DisUtil.getMapListJson((String)"DisChannel-memberMcode", (String)(memberCode + "-" + DISCHANNEL_SALE + "-" + tenantCode), DisChannel.class);
        if (ListUtil.isNotEmpty((Collection)memchannelList)) {
            channelList.addAll(memchannelList);
        }
        if (null != (memchannel = (DisChannel)DisUtil.getMapJson((String)"DisChannel-memberCcode", (String)(memberCode + "-" + DISCHANNEL_CON + "-" + tenantCode), DisChannel.class))) {
            channelList.add(memchannel);
        }
        if (ListUtil.isNotEmpty((Collection)(memchannelList1 = DisUtil.getMapListJson((String)"DisChannel-memberMcode", (String)(memberCode + "-" + DISCHANNEL_BUS + "-" + tenantCode), DisChannel.class)))) {
            channelList.addAll(memchannelList1);
        }
        return channelList;
    }

    private boolean sendDisGoods(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            this.logger.error(".RsFlowDataServiceImpl.sendDisGoods.rsFlowData");
            return false;
        }
        List<DisChannel> channelList = this.queryChannel(rsFlowData.getMemberCode(), rsFlowData.getTenantCode());
        if (null == channelList || channelList.isEmpty()) {
            return true;
        }
        String goodsOldcode = rsFlowData.getFdBizCode();
        String tenantCode = rsFlowData.getTenantCode();
        if ("delete".equals(rsFlowData.getEsRequestType())) {
            this.rsFlowDataAssistService.deleteDisGoods(goodsOldcode, null, rsFlowData.getTenantCode());
        } else if ("insert".equals(rsFlowData.getEsRequestType())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsFlowData.getFdBizCode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            RsResourceGoodsReDomain rsResourceGoodsReDomain = rsFlowData.getRsResourceGoodsReDomain();
            if (null == rsResourceGoodsReDomain && null == (rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map))) {
                this.logger.error(".RsFlowDataServiceImpl.sendDisGoods.rsResourceGoodsReDomain", (Object)((Object)map).toString());
                return false;
            }
            List<DisRsResourceGoodsDomain> disRsResourceGoodsList = this.makeDisGoods(rsResourceGoodsReDomain, channelList);
            if (!ListUtil.isEmpty(disRsResourceGoodsList)) {
                this.rsFlowDataAssistService.saveDisResourceGoods(disRsResourceGoodsList);
            }
        } else {
            this.rsFlowDataAssistService.updateDisCannelGoods(goodsOldcode, null, tenantCode);
        }
        return true;
    }

    private boolean checkChannelEnd(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return true;
        }
        DisChannel oldDisChannel = (DisChannel)DisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class);
        return null == oldDisChannel || !"2".equals(oldDisChannel.getChannelSort());
    }

    private List<DisRsSkuDomain> makeDisSku(RsResourceGoodsReDomain rsResourceGoodsReDomain, RsSkuDomain rsSkuDomain, List<DisChannel> channelList) {
        if (null == rsResourceGoodsReDomain || null == rsSkuDomain || ListUtil.isEmpty(channelList)) {
            return null;
        }
        if (!this.checkChannelEnd(rsResourceGoodsReDomain.getChannelCode(), rsResourceGoodsReDomain.getTenantCode())) {
            return null;
        }
        ArrayList<DisRsSkuDomain> disList = new ArrayList<DisRsSkuDomain>();
        for (DisChannel disChannel : channelList) {
            DisRsResourceGoodsDomain disRsResourceGoodsDomain = this.checkDisGoods(rsResourceGoodsReDomain, disChannel);
            if (null == disRsResourceGoodsDomain) continue;
            disList.add(this.makeDisSku(rsResourceGoodsReDomain, rsSkuDomain, disChannel));
        }
        return disList;
    }

    private DisRsSkuDomain makeDisSku(RsResourceGoodsReDomain rsResourceGoodsReDomain, RsSkuDomain rsSkuDomain, DisChannel disChannel) {
        if (null == rsResourceGoodsReDomain || null == disChannel) {
            return null;
        }
        DisRsSkuDomain disRsSkuDomain = new DisRsSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRsSkuDomain, (Object)rsResourceGoodsReDomain);
            BeanUtils.copyAllPropertys((Object)disRsSkuDomain, (Object)rsSkuDomain);
            disRsSkuDomain.setGoodsShowno(rsResourceGoodsReDomain.getGoodsNo());
            disRsSkuDomain.setSkuShowno(rsSkuDomain.getSkuNo());
            disRsSkuDomain.setSkuCodeOld(rsSkuDomain.getSkuCode());
            disRsSkuDomain.setSkuOldcode(rsSkuDomain.getSkuCode());
            disRsSkuDomain.setGoodsOldcode(rsResourceGoodsReDomain.getGoodsCode());
            disRsSkuDomain.setChannelCode(disChannel.getChannelCode());
            disRsSkuDomain.setChannelName(disChannel.getChannelName());
            disRsSkuDomain.setMemberCode(disChannel.getMemberCode());
            disRsSkuDomain.setMemberName(disChannel.getMemberName());
            if (DISCHANNEL_CON.equals(disChannel.getChannelSort())) {
                disRsSkuDomain.setGoodsOrigin("12");
                disRsSkuDomain.setMemberCcode(disChannel.getMemberCcode());
                disRsSkuDomain.setMemberCname(disChannel.getMemberCname());
            } else if (DISCHANNEL_SALE.equals(disChannel.getChannelSort())) {
                disRsSkuDomain.setGoodsOrigin("11");
            } else if (DISCHANNEL_BUS.equals(disChannel.getChannelSort())) {
                disRsSkuDomain.setGoodsOrigin("13");
            }
        }
        catch (Exception e) {
            return null;
        }
        return disRsSkuDomain;
    }

    private List<DisRsResourceGoodsDomain> makeDisGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain, List<DisChannel> channelList) {
        if (null == rsResourceGoodsReDomain || ListUtil.isEmpty(channelList)) {
            return null;
        }
        if (!this.checkChannelEnd(rsResourceGoodsReDomain.getChannelCode(), rsResourceGoodsReDomain.getTenantCode())) {
            return null;
        }
        ArrayList<DisRsResourceGoodsDomain> disList = new ArrayList<DisRsResourceGoodsDomain>();
        for (DisChannel disChannel : channelList) {
            DisRsResourceGoodsDomain disRsResourceGoodsDomain = this.checkDisGoods(rsResourceGoodsReDomain, disChannel);
            if (null == disRsResourceGoodsDomain) continue;
            disList.add(disRsResourceGoodsDomain);
        }
        return disList;
    }

    private DisRsResourceGoodsDomain makeDisGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain, DisChannel disChannel) {
        if (null == rsResourceGoodsReDomain || null == disChannel) {
            return null;
        }
        DisRsResourceGoodsDomain disRsResourceGoodsDomain = new DisRsResourceGoodsDomain();
        String nowChannelCode = rsResourceGoodsReDomain.getChannelCode();
        if (null == nowChannelCode) {
            nowChannelCode = "";
        }
        if (nowChannelCode.equals(disChannel.getChannelCode())) {
            return null;
        }
        try {
            BeanUtils.copyAllPropertys((Object)disRsResourceGoodsDomain, (Object)rsResourceGoodsReDomain);
            disRsResourceGoodsDomain.setGoodsShowname(rsResourceGoodsReDomain.getGoodsName());
            disRsResourceGoodsDomain.setGoodsShowno(rsResourceGoodsReDomain.getGoodsNo());
            disRsResourceGoodsDomain.setGoodsCodeOld(rsResourceGoodsReDomain.getGoodsCode());
            disRsResourceGoodsDomain.setGoodsOldcode(rsResourceGoodsReDomain.getGoodsCode());
            disRsResourceGoodsDomain.setChannelCode(disChannel.getChannelCode());
            disRsResourceGoodsDomain.setChannelName(disChannel.getChannelName());
            disRsResourceGoodsDomain.setMemberCode(disChannel.getMemberCode());
            disRsResourceGoodsDomain.setMemberName(disChannel.getMemberName());
            if (DISCHANNEL_CON.equals(disChannel.getChannelSort())) {
                disRsResourceGoodsDomain.setGoodsOrigin("12");
                disRsResourceGoodsDomain.setMemberCcode(disChannel.getMemberCcode());
                disRsResourceGoodsDomain.setMemberCname(disChannel.getMemberCname());
            } else if (DISCHANNEL_SALE.equals(disChannel.getChannelSort())) {
                disRsResourceGoodsDomain.setGoodsOrigin("11");
            } else if (DISCHANNEL_BUS.equals(disChannel.getChannelSort())) {
                disRsResourceGoodsDomain.setGoodsOrigin("13");
            }
            ArrayList<RsSpecValueDomain> rsSpecValueDomainList = new ArrayList<RsSpecValueDomain>();
            if (null != rsResourceGoodsReDomain.getRsSpecValueDomainList() && rsResourceGoodsReDomain.getRsSpecValueDomainList().size() > 0) {
                for (RsSpecValueDomain rsSpecValueDomain : rsResourceGoodsReDomain.getRsSpecValueDomainList()) {
                    RsSpecValueDomain rsSpecValueDomain1 = new RsSpecValueDomain();
                    BeanUtils.copyAllPropertys((Object)rsSpecValueDomain1, (Object)rsSpecValueDomain);
                    rsSpecValueDomain1.setSpecValueId(null);
                    rsSpecValueDomain1.setSpecValueCode(this.createUUIDString());
                    rsSpecValueDomainList.add(rsSpecValueDomain1);
                }
            }
            disRsResourceGoodsDomain.setRsSpecValueDomainList(rsSpecValueDomainList);
            ArrayList<RsGoodsFileDomain> rsGoodsFileDomains = new ArrayList<RsGoodsFileDomain>();
            if (null != rsResourceGoodsReDomain.getRsGoodsFileDomainList() && rsResourceGoodsReDomain.getRsGoodsFileDomainList().size() > 0) {
                for (RsGoodsFileDomain rsGoodsFileDomain : rsResourceGoodsReDomain.getRsGoodsFileDomainList()) {
                    RsGoodsFileDomain rsGoodsFileDomain1 = new RsGoodsFileDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain1, (Object)rsGoodsFileDomain);
                    rsGoodsFileDomain1.setGoodsFileId(null);
                    rsGoodsFileDomain1.setGoodsFileCode(this.createUUIDString());
                    rsGoodsFileDomains.add(rsGoodsFileDomain1);
                }
            }
            disRsResourceGoodsDomain.setRsGoodsFileDomainList(rsGoodsFileDomains);
            ArrayList<RsGoodsRelDomain> rsGoodsRelDomains = new ArrayList<RsGoodsRelDomain>();
            if (null != rsResourceGoodsReDomain.getRsGoodsRelDomainList() && rsResourceGoodsReDomain.getRsGoodsRelDomainList().size() > 0) {
                for (RsGoodsRelDomain rsGoodsRelDomain : rsResourceGoodsReDomain.getRsGoodsRelDomainList()) {
                    RsGoodsRelDomain rsGoodsRelDomain1 = new RsGoodsRelDomain();
                    BeanUtils.copyAllPropertys((Object)rsGoodsRelDomain1, (Object)rsGoodsRelDomain);
                    rsGoodsRelDomain1.setGoodsRelId(null);
                    rsGoodsRelDomain1.setGoodsRelCode(this.createUUIDString());
                    rsGoodsRelDomains.add(rsGoodsRelDomain1);
                }
            }
            disRsResourceGoodsDomain.setRsGoodsRelDomainList(rsGoodsRelDomains);
            ArrayList<RsPropertiesValueDomain> rsPropertiesValueDomains = new ArrayList<RsPropertiesValueDomain>();
            if (null != rsResourceGoodsReDomain.getRsPropertiesValueDomainList() && rsResourceGoodsReDomain.getRsPropertiesValueDomainList().size() > 0) {
                for (RsPropertiesValueDomain rsPropertiesValueDomain : rsResourceGoodsReDomain.getRsPropertiesValueDomainList()) {
                    RsPropertiesValueDomain rsPropertiesValueDomain1 = new RsPropertiesValueDomain();
                    BeanUtils.copyAllPropertys((Object)rsPropertiesValueDomain1, (Object)rsPropertiesValueDomain);
                    rsPropertiesValueDomain1.setPropertiesValueId(null);
                    rsPropertiesValueDomain1.setPropertiesValueCode(this.createUUIDString());
                    rsPropertiesValueDomains.add(rsPropertiesValueDomain1);
                }
            }
            disRsResourceGoodsDomain.setRsPropertiesValueDomainList(rsPropertiesValueDomains);
            disRsResourceGoodsDomain.setPricesetAsprice(disRsResourceGoodsDomain.getPricesetNprice());
            disRsResourceGoodsDomain.setPricesetInsideprice(disRsResourceGoodsDomain.getPricesetRefrice());
            disRsResourceGoodsDomain.setDisRsSkuDomainList(this.makeDisSkuList(rsResourceGoodsReDomain.getRsSkuDomainList(), disChannel));
        }
        catch (Exception e) {
            return null;
        }
        return disRsResourceGoodsDomain;
    }

    private List<DisRsSkuDomain> makeDisSkuList(List<RsSkuDomain> rsSkuDomainList, DisChannel disChannel) {
        if (ListUtil.isEmpty(rsSkuDomainList) || null == disChannel) {
            return null;
        }
        ArrayList<DisRsSkuDomain> disRsSkuDomainList = new ArrayList<DisRsSkuDomain>();
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            DisRsSkuDomain disRsSkuDomain = this.makeDisSku(rsSkuDomain, disChannel);
            if (null == disRsSkuDomain) continue;
            disRsSkuDomain.setPricesetAsprice(disRsSkuDomain.getPricesetNprice());
            disRsSkuDomain.setPricesetInsideprice(disRsSkuDomain.getPricesetRefrice());
            try {
                ArrayList<RsPropertiesValueDomain> rsPropertiesValueDomains = new ArrayList<RsPropertiesValueDomain>();
                if (null != rsSkuDomain.getPropertiesList() && rsSkuDomain.getPropertiesList().size() > 0) {
                    for (RsPropertiesValueDomain rsPropertiesValueDomain : rsSkuDomain.getPropertiesList()) {
                        RsPropertiesValueDomain rsPropertiesValueDomain1 = new RsPropertiesValueDomain();
                        BeanUtils.copyAllPropertys((Object)rsPropertiesValueDomain1, (Object)rsPropertiesValueDomain);
                        rsPropertiesValueDomain1.setPropertiesValueId(null);
                        rsPropertiesValueDomain1.setPropertiesValueCode(this.createUUIDString());
                        rsPropertiesValueDomains.add(rsPropertiesValueDomain1);
                    }
                }
                disRsSkuDomain.setPropertiesList(rsPropertiesValueDomains);
                ArrayList<RsSpecValueDomain> rsSpecValueDomains = new ArrayList<RsSpecValueDomain>();
                if (null != rsSkuDomain.getSpecList() && rsSkuDomain.getSpecList().size() > 0) {
                    for (RsSpecValueDomain rsSpecValueDomain : rsSkuDomain.getSpecList()) {
                        RsSpecValueDomain rsSpecValueDomain1 = new RsSpecValueDomain();
                        BeanUtils.copyAllPropertys((Object)rsSpecValueDomain1, (Object)rsSpecValueDomain);
                        rsSpecValueDomain1.setSpecValueId(null);
                        rsSpecValueDomain1.setSpecValueCode(this.createUUIDString());
                        rsSpecValueDomains.add(rsSpecValueDomain1);
                    }
                }
                disRsSkuDomain.setSpecList(rsSpecValueDomains);
                ArrayList<RsGoodsFileDomain> rsGoodsFileDomains = new ArrayList<RsGoodsFileDomain>();
                if (null != rsSkuDomain.getRsGoodsFileDomainList() && rsSkuDomain.getRsGoodsFileDomainList().size() > 0) {
                    for (RsGoodsFileDomain rsGoodsFileDomain : rsSkuDomain.getRsGoodsFileDomainList()) {
                        RsGoodsFileDomain rsGoodsFileDomain1 = new RsGoodsFileDomain();
                        BeanUtils.copyAllPropertys((Object)rsGoodsFileDomain1, (Object)rsGoodsFileDomain);
                        rsGoodsFileDomain1.setGoodsFileId(null);
                        rsGoodsFileDomain1.setGoodsFileCode(this.createUUIDString());
                        rsGoodsFileDomains.add(rsGoodsFileDomain1);
                    }
                }
                disRsSkuDomain.setRsGoodsFileDomainList(rsGoodsFileDomains);
                ArrayList<RsGoodsRelDomain> rsGoodsRelDomains = new ArrayList<RsGoodsRelDomain>();
                if (null != rsSkuDomain.getRsGoodsRelDomainList() && rsSkuDomain.getRsGoodsRelDomainList().size() > 0) {
                    for (RsGoodsRelDomain rsGoodsRelDomain : rsSkuDomain.getRsGoodsRelDomainList()) {
                        RsGoodsRelDomain rsGoodsRelDomain1 = new RsGoodsRelDomain();
                        BeanUtils.copyAllPropertys((Object)rsGoodsRelDomain1, (Object)rsGoodsRelDomain);
                        rsGoodsRelDomain1.setGoodsRelId(null);
                        rsGoodsRelDomain1.setGoodsRelCode(this.createUUIDString());
                        rsGoodsRelDomains.add(rsGoodsRelDomain1);
                    }
                }
                disRsSkuDomain.setRsGoodsRelDomainList(rsGoodsRelDomains);
                disRsSkuDomainList.add(disRsSkuDomain);
            }
            catch (Exception e) {
                return null;
            }
        }
        return disRsSkuDomainList;
    }

    private DisRsSkuDomain makeDisSku(RsSkuDomain rsSkuDomain, DisChannel disChannel) {
        if (null == rsSkuDomain || null == disChannel) {
            return null;
        }
        DisRsSkuDomain disRsSkuDomain = new DisRsSkuDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disRsSkuDomain, (Object)rsSkuDomain);
            disRsSkuDomain.setGoodsNum(rsSkuDomain.getGoodsSupplynum());
            disRsSkuDomain.setGoodsWeight(rsSkuDomain.getGoodsSupplyweight());
            disRsSkuDomain.setSkuCodeOld(rsSkuDomain.getSkuCode());
            disRsSkuDomain.setSkuOldcode(rsSkuDomain.getSkuCode());
            disRsSkuDomain.setGoodsOldcode(rsSkuDomain.getGoodsOldcode());
            disRsSkuDomain.setChannelCode(disChannel.getChannelCode());
            disRsSkuDomain.setChannelName(disChannel.getChannelName());
            disRsSkuDomain.setMemberCode(disChannel.getMemberCode());
            disRsSkuDomain.setMemberName(disChannel.getMemberName());
        }
        catch (Exception e) {
            return null;
        }
        return disRsSkuDomain;
    }

    private DisRsResourceGoodsDomain checkDisGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain, DisChannel disChannel) {
        DisRsResourceGoodsDomain disRsResourceGoodsDomain;
        if (null == rsResourceGoodsReDomain || null == disChannel) {
            return null;
        }
        DisDgoods disDgoods = (DisDgoods)DisUtil.getMapJson((String)"DisDgoods-channelCode", (String)(disChannel.getChannelCode() + "-" + disChannel.getTenantCode()), DisDgoods.class);
        if (null == disDgoods) {
            return null;
        }
        List disDgoodsScopelistList = DisUtil.getMapListJson((String)"DisDgoodsScopelist-DgoodsCode", (String)(disDgoods.getDgoodsCode() + "-" + disChannel.getTenantCode()), DisDgoodsScopelist.class);
        if (ListUtil.isEmpty((Collection)disDgoodsScopelistList)) {
            disRsResourceGoodsDomain = this.makeDisGoods(rsResourceGoodsReDomain, disChannel);
        } else {
            Map<String, List<String>> map = this.makeScopelist(disDgoodsScopelistList);
            if (null == map || map.isEmpty()) {
                return null;
            }
            for (String key : map.keySet()) {
                String objValue = (String)BeanUtils.forceGetProperty((Object)rsResourceGoodsReDomain, (String)key);
                if (null == objValue) {
                    return null;
                }
                if (map.get(key).contains(objValue)) continue;
                return null;
            }
            disRsResourceGoodsDomain = this.makeDisGoods(rsResourceGoodsReDomain, disChannel);
        }
        if (null == disRsResourceGoodsDomain) {
            return null;
        }
        this.makePice(disRsResourceGoodsDomain, disChannel);
        if ("1".equals(disDgoods.getDgoodsPut())) {
            disRsResourceGoodsDomain.setDataOpbillstate(1);
            disRsResourceGoodsDomain.setDgoodsPut(disDgoods.getDgoodsPut());
        } else if ("0".equals(disDgoods.getDgoodsPut())) {
            disRsResourceGoodsDomain.setDataOpbillstate(0);
            disRsResourceGoodsDomain.setDgoodsPut(disDgoods.getDgoodsPut());
        }
        return disRsResourceGoodsDomain;
    }

    private void makePice(DisRsResourceGoodsDomain disRsResourceGoodsDomain, DisChannel disChannel) {
        if (null == disRsResourceGoodsDomain || null == disChannel) {
            return;
        }
        List disDpriceList = DisUtil.getMapListJson((String)"DisDpriceConf-channelCode", (String)(disChannel.getChannelCode() + "-" + disChannel.getTenantCode()), DisDpriceDomain.class);
        if (ListUtil.isEmpty((Collection)disDpriceList)) {
            return;
        }
        for (DisDpriceDomain disDpriceDomain : disDpriceList) {
            Map<String, List<String>> map = this.makeDpeicelist(disDpriceDomain.getDisDpriceConfList());
            if (null == map || map.isEmpty()) continue;
            for (String key : map.keySet()) {
                String objValue = (String)BeanUtils.forceGetProperty((Object)disRsResourceGoodsDomain, (String)key);
                if (null != objValue && map.get(key).contains(objValue)) continue;
            }
            this.setPrice(disDpriceDomain, disRsResourceGoodsDomain);
            return;
        }
    }

    private void setPrice(DisDpriceDomain disDpriceDomain, DisRsResourceGoodsDomain disRsResourceGoodsDomain) {
        if (null == disDpriceDomain || null == disRsResourceGoodsDomain) {
            return;
        }
        String pro = disDpriceDomain.getDpricePro();
        BigDecimal rmoney = BigDecimal.ZERO;
        BigDecimal money = disRsResourceGoodsDomain.getPricesetNprice();
        if ("0".equals(pro)) {
            rmoney = disDpriceDomain.getDpricePrice();
        } else if ("1".equals(pro)) {
            rmoney = money.subtract(disDpriceDomain.getDpricePrice().divide(new BigDecimal("100")).multiply(money));
        } else if ("1".equals(pro)) {
            rmoney = BigDecimal.ZERO;
        }
        disRsResourceGoodsDomain.setPricesetNprice(disRsResourceGoodsDomain.getPricesetNprice().subtract(rmoney));
    }

    private Map<String, List<String>> makeDpeicelist(List<DisDpriceConf> disDpriceConfList) {
        if (ListUtil.isEmpty(disDpriceConfList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DisDpriceConf disDpriceConf : disDpriceConfList) {
            ArrayList<String> list = (ArrayList<String>)map.get(disDpriceConf.getDpriceConfType());
            if (null == list) {
                list = new ArrayList<String>();
                map.put(disDpriceConf.getDpriceConfType(), list);
            }
            list.add(disDpriceConf.getDpriceConfValue());
        }
        return map;
    }

    private Map<String, List<String>> makeScopelist(List<DisDgoodsScopelist> disDgoodsScopelistList) {
        if (ListUtil.isEmpty(disDgoodsScopelistList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (DisDgoodsScopelist disDgoodsScopelist : disDgoodsScopelistList) {
            ArrayList<String> list = (ArrayList<String>)map.get(disDgoodsScopelist.getDgoodsScopelistType());
            if (null == list) {
                list = new ArrayList<String>();
                map.put(disDgoodsScopelist.getDgoodsScopelistType(), list);
            }
            list.add(disDgoodsScopelist.getDgoodsScopelistValue());
        }
        return map;
    }

    private boolean sendGoods(RsFlowData rsFlowData) {
        if (null == rsFlowData) {
            return false;
        }
        RsResourceGoodsReDomain rsResourceGoodsReDomain = rsFlowData.getRsResourceGoodsReDomain();
        if (null == rsResourceGoodsReDomain) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goodsCode", rsFlowData.getFdBizCode());
            map.put("tenantCode", rsFlowData.getTenantCode());
            rsResourceGoodsReDomain = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(map);
            if (null == rsResourceGoodsReDomain) {
                return false;
            }
        }
        List<RsSkuDomain> rsSkuDomainList = rsResourceGoodsReDomain.getRsSkuDomainList();
        RsSkuDomain rsSkuDomain = rsSkuDomainList.get(0);
        if (!"delete".equals(rsFlowData.getEsRequestType())) {
            HtmlRelease htmlRelease = new HtmlRelease();
            htmlRelease.setTenantCode(rsResourceGoodsReDomain.getTenantCode());
            htmlRelease.setHtmldataCode("RsResourceGoods");
            htmlRelease.setHtmldataFilename(rsResourceGoodsReDomain.getGoodsCode() + ".html");
            htmlRelease.setHtmldataFilepath("goods");
            htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsReDomain));
            HashMap<String, Serializable> htmlMap = new HashMap<String, Serializable>();
            htmlMap.put("goods", rsResourceGoodsReDomain);
            HashMap<String, Object> svMap = new HashMap<String, Object>();
            svMap.put("specValueBillno", rsSkuDomain.getGoodsCode());
            svMap.put("tenantCode", rsSkuDomain.getTenantCode());
            QueryResult<RsSpecValue> rsSpecValueListResult = this.rsSpecValueService.querySpecValuePage(svMap);
            if (null != rsSpecValueListResult && null != rsSpecValueListResult.getList() && rsSpecValueListResult.getList().size() > 0) {
                HashMap<String, ArrayList<String>> specValueMap = new HashMap<String, ArrayList<String>>();
                List rsSpecValueList = rsSpecValueListResult.getList();
                for (RsSpecValue rsSpecValue : rsSpecValueList) {
                    String specName = rsSpecValue.getSpecName();
                    ArrayList<String> specValueList = (ArrayList<String>)specValueMap.get(specName);
                    if (null == specValueList || specValueList.size() == 0) {
                        specValueList = new ArrayList<String>();
                    }
                    specValueList.add(rsSpecValue.getSpecValueValue());
                    if (!StringUtils.isNotBlank((String)specName)) continue;
                    specValueMap.put(specName, specValueList);
                }
                htmlMap.put("spec", specValueMap);
            }
            htmlMap.put("rsSku", rsSkuDomain);
            List<RsGoodsRelDomain> rsGoodsRelList = rsResourceGoodsReDomain.getRsGoodsRelDomainList();
            ArrayList<RsSkuDomain> rsSkuList = new ArrayList<RsSkuDomain>();
            if (ListUtil.isNotEmpty(rsGoodsRelList)) {
                for (RsGoodsRelDomain rsGoodsRel : rsGoodsRelList) {
                    QueryResult<RsSkuDomain> rsSkuList1;
                    RsResourceGoodsReDomain rsResourceGoodsReDomain1 = this.rsFlowDataAssistService.getResourceGoodsByCodeAssist(this.getQueryParamMap("goodsCode,tenantCode,unwantedRelatedData", new Object[]{rsGoodsRel.getGoodsRelGcode(), rsFlowData.getTenantCode(), "1"}));
                    if (null == rsResourceGoodsReDomain1 || null == (rsSkuList1 = this.rsFlowDataAssistService.querySkuPageAssist(this.getQueryParamMap("goodsCode,tenantCode", new Object[]{rsGoodsRel.getGoodsRelGcode(), rsFlowData.getTenantCode()}))).getList() || rsSkuList1.getList().size() <= 0) continue;
                    RsSkuDomain rsSku1 = (RsSkuDomain)rsSkuList1.getList().get(0);
                    rsSku1.setGoodsName(rsResourceGoodsReDomain1.getGoodsName());
                    rsSkuList.add(rsSku1);
                }
            }
            htmlMap.put("rsSkuRel", rsSkuList);
            htmlRelease.setHtmlcontOpparam(JsonUtil.buildNormalBinder().toJson(htmlMap));
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("htmlRelease", JsonUtil.buildNormalBinder().toJson((Object)htmlRelease));
            try {
                this.getInternalRouter().inInvoke("pfs.htmlcont.sendHtmlcontOpData", "1.0", "0", paramMap);
            }
            catch (Exception e) {
                this.logger.error("rsFlowDataServiceImpl.sendGoods.ex", (Throwable)e);
            }
        }
        StoreDomain storeDomain = new StoreDomain();
        if (!rsFlowData.getEsRequestType().equals("delete")) {
            EsSku esSku = new EsSku();
            try {
                BeanUtils.copyAllPropertys((Object)esSku, (Object)rsResourceGoodsReDomain);
                BeanUtils.copyAllPropertys((Object)esSku, (Object)rsSkuDomain);
            }
            catch (Exception e) {
                // empty catch block
            }
            esSku.setRsGoodsFileDomainList(rsSkuDomain.getRsGoodsFileDomainList());
            esSku.setRsSpecValueMap(rsSkuDomain.getRsSpecValueMap());
            esSku.setGoodsNo(rsResourceGoodsReDomain.getGoodsNo());
            esSku.setPntreeCode(rsResourceGoodsReDomain.getPntreeCode());
            esSku.setMemberName(rsResourceGoodsReDomain.getMemberName());
            esSku.setClasstreeName(rsResourceGoodsReDomain.getClasstreeName());
            esSku.setClasstreeCode(rsResourceGoodsReDomain.getClasstreeCode());
            esSku.setPntreeName(rsResourceGoodsReDomain.getPntreeName());
            esSku.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
            esSku.setGoodsProperty(rsResourceGoodsReDomain.getGoodsProperty());
            esSku.setBrandCode(rsResourceGoodsReDomain.getBrandCode());
            esSku.setBrandName(rsResourceGoodsReDomain.getBrandName());
            esSku.setGoodsSpec(null == rsResourceGoodsReDomain.getGoodsSpec() ? "" : rsResourceGoodsReDomain.getGoodsSpec());
            if (null == esSku.getGoodsSalesvolume()) {
                esSku.setGoodsSalesvolume(BigDecimal.ZERO);
            }
            esSku.setPropertiesName(this.rsFlowDataAssistService.getPropertiesName(esSku.getTenantCode(), esSku.getGoodsCode()));
            String esSkuStr = JsonUtil.buildNonNullBinder().toJson((Object)esSku);
            storeDomain.setStoreObj((Object)esSkuStr);
        }
        storeDomain.setRequestType(rsFlowData.getEsRequestType());
        storeDomain.setBizType("goods");
        storeDomain.setBizId(rsResourceGoodsReDomain.getGoodsId() + "");
        storeDomain.setTenantCode(rsFlowData.getTenantCode());
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        paramMap1.put("storeDomain", JsonUtil.buildNormalBinder().toJson((Object)storeDomain));
        String result = (String)this.getInternalRouter().inInvoke("es.searchengine.store", "1.0", "0", paramMap1);
        return !StringUtils.isEmpty((String)result) && !"false".equals(result);
    }

    static {
        lock = new Object();
        DISCHANNEL_SALE = "0";
        DISCHANNEL_CON = "1";
        DISCHANNEL_BUS = "2";
    }
}

