/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.domain.OcReorderDomain;
import com.yqbsoft.laser.service.resources.domain.ResourceStockDomain;
import com.yqbsoft.laser.service.resources.enumc.ResourcesStartCon;
import com.yqbsoft.laser.service.resources.model.RsResourceList;
import com.yqbsoft.laser.service.resources.service.RsResourceGoodsService;
import com.yqbsoft.laser.service.resources.service.RsResourceListService;
import com.yqbsoft.laser.service.resources.service.RsResourceService;
import java.util.HashMap;
import java.util.List;

public class RsResourceServiceImpl
extends BaseServiceImpl
implements RsResourceService {
    public static final String SYS_CODE = "rs.RsResourceServiceImpl";
    private RsResourceGoodsService rsResourceGoodsService;
    private RsResourceListService rsResourceListService;

    public RsResourceListService getRsResourceListService() {
        return this.rsResourceListService;
    }

    public void setRsResourceListService(RsResourceListService rsResourceListService) {
        this.rsResourceListService = rsResourceListService;
    }

    public RsResourceGoodsService getRsResourceGoodsService() {
        return this.rsResourceGoodsService;
    }

    public void setRsResourceGoodsService(RsResourceGoodsService rsResourceGoodsService) {
        this.rsResourceGoodsService = rsResourceGoodsService;
    }

    @Override
    public OcReorderDomain updateResourceStockByOrder(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.saveResources(resourceGoodsList, ResourcesStartCon.ORDER.getCode(), false);
    }

    @Override
    public OcReorderDomain updateResourceStockChannelByOrder(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.saveResources(resourceGoodsList, ResourcesStartCon.ORDER.getCode(), true);
    }

    private OcReorderDomain saveResources(List<ResourceStockDomain> resourceGoodsList, String type, boolean channelflag) {
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        if (null == resourceGoodsList || resourceGoodsList.isEmpty()) {
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", resourceGoodsList.get(0).getContractBillcode());
        map.put("tenantCode", resourceGoodsList.get(0).getTenantCode());
        map.put("goodsCode", resourceGoodsList.get(0).getGoodsCode());
        QueryResult<RsResourceList> relist = this.rsResourceListService.queryResourceListPage(map);
        if (null != relist && null != relist.getRows() && !relist.getRows().isEmpty()) {
            ocReorderDomain.setOrderState("2");
            return ocReorderDomain;
        }
        try {
            if (channelflag) {
                this.rsResourceGoodsService.updateResourceChannleStock(resourceGoodsList, type);
            } else {
                this.rsResourceGoodsService.updateResourceStock(resourceGoodsList, type);
            }
            ocReorderDomain.setOrderState("2");
            return ocReorderDomain;
        }
        catch (Exception e) {
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
    }

    @Override
    public OcReorderDomain updateResourceStockByPay(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.saveResources(resourceGoodsList, ResourcesStartCon.PAY.getCode(), false);
    }

    @Override
    public OcReorderDomain updateResourceStockByBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.saveResources(resourceGoodsList, ResourcesStartCon.BACK.getCode(), false);
    }

    @Override
    public OcReorderDomain updateResourceStockChannelByBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.saveResources(resourceGoodsList, ResourcesStartCon.BACK.getCode(), true);
    }

    @Override
    public OcReorderDomain updateResourceStockChannelByPay(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.saveResources(resourceGoodsList, ResourcesStartCon.PAY.getCode(), true);
    }
}

