/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.domain.DisRsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.domain.DisRsSkuDomain;
import com.yqbsoft.laser.service.resources.domain.EditSkuDomain;
import com.yqbsoft.laser.service.resources.domain.OcReorderDomain;
import com.yqbsoft.laser.service.resources.domain.ResourceStockDomain;
import com.yqbsoft.laser.service.resources.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.resources.enumc.ResourcesStartCon;
import com.yqbsoft.laser.service.resources.model.RsResourceList;
import com.yqbsoft.laser.service.resources.model.RsSenddata;
import com.yqbsoft.laser.service.resources.service.RsResourceGoodsService;
import com.yqbsoft.laser.service.resources.service.RsResourceListService;
import com.yqbsoft.laser.service.resources.service.RsResourceService;
import com.yqbsoft.laser.service.resources.service.RsSenddataBaseService;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsResourceServiceImpl
extends BaseServiceImpl
implements RsResourceService {
    public static final String SYS_CODE = "rs.RsResourceServiceImpl";
    private RsResourceGoodsService rsResourceGoodsService;
    private RsResourceListService rsResourceListService;
    private RsSenddataBaseService rsSenddataBaseService;

    public RsSenddataBaseService getRsSenddataBaseService() {
        return this.rsSenddataBaseService;
    }

    public void setRsSenddataBaseService(RsSenddataBaseService rsSenddataBaseService) {
        this.rsSenddataBaseService = rsSenddataBaseService;
    }

    public RsResourceListService getRsResourceListService() {
        return this.rsResourceListService;
    }

    public void setRsResourceListService(RsResourceListService rsResourceListService) {
        this.rsResourceListService = rsResourceListService;
    }

    public RsResourceGoodsService getRsResourceGoodsService() {
        return this.rsResourceGoodsService;
    }

    public void setRsResourceGoodsService(RsResourceGoodsService rsResourceGoodsService) {
        this.rsResourceGoodsService = rsResourceGoodsService;
    }

    @Override
    public OcReorderDomain updateResourceStockByOrder(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.saveResources(resourceGoodsList, ResourcesStartCon.ORDER.getCode(), false);
    }

    @Override
    public OcReorderDomain updateResourceStockChannelByOrder(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.saveResources(resourceGoodsList, ResourcesStartCon.ORDER.getCode(), true);
    }

    private OcReorderDomain saveResources(List<ResourceStockDomain> resourceGoodsList, String type, boolean channelflag) {
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        if (null == resourceGoodsList || resourceGoodsList.isEmpty()) {
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", resourceGoodsList.get(0).getContractBillcode());
        map.put("tenantCode", resourceGoodsList.get(0).getTenantCode());
        map.put("goodsCode", resourceGoodsList.get(0).getGoodsCode());
        QueryResult<RsResourceList> relist = this.rsResourceListService.queryResourceListPage(map);
        if (null != relist && null != relist.getRows() && !relist.getRows().isEmpty() && !ResourcesStartCon.BACK.getCode().equals(type)) {
            ocReorderDomain.setOrderState("2");
            return ocReorderDomain;
        }
        try {
            if (channelflag) {
                this.rsResourceGoodsService.updateResourceChannleStock(resourceGoodsList, type);
            } else {
                this.rsResourceGoodsService.updateResourceStock(resourceGoodsList, type);
            }
            ocReorderDomain.setOrderState("2");
            return ocReorderDomain;
        }
        catch (Exception e) {
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
    }

    @Override
    public OcReorderDomain updateResourceStockByPay(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.saveResources(resourceGoodsList, ResourcesStartCon.PAY.getCode(), false);
    }

    @Override
    public OcReorderDomain updateResourceStockByBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.saveResources(resourceGoodsList, ResourcesStartCon.BACK.getCode(), false);
    }

    @Override
    public OcReorderDomain updateResourceStockChannelByBack(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.saveResources(resourceGoodsList, ResourcesStartCon.BACK.getCode(), true);
    }

    @Override
    public OcReorderDomain updateResourceStockChannelByPay(List<ResourceStockDomain> resourceGoodsList) throws ApiException {
        return this.saveResources(resourceGoodsList, ResourcesStartCon.PAY.getCode(), true);
    }

    @Override
    public String sendSaveResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        return this.rsResourceGoodsService.saveResourceGoods(rsResourceGoodsDomain);
    }

    @Override
    public void sendSavePassResourceGoodsBatch(List<RsResourceGoodsDomain> goodsList) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.savePassResourceGoodsBatch(goodsList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendSaveResourceGoodsBatch(List<RsResourceGoodsDomain> goodsList) throws ApiException {
        this.rsResourceGoodsService.saveResourceGoodsBatch(goodsList);
    }

    @Override
    public void sendUpdateResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) throws ApiException {
        this.rsResourceGoodsService.updateResourceGoods(rsResourceGoodsDomain);
    }

    @Override
    public void sendDelResourceGoodsByCode(Map<String, Object> map) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.delResourceGoodsByCode(map);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateShelveGoods(List<Integer> goodsIds) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateShelveGoods(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSoldOutGoods(List<Integer> goodsIds) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSoldOutGoods(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateAuditResource(List<Integer> goodsIds) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateAuditResource(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateAuditResourcePass(List<Integer> goodsIds) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateAuditResourcePass(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateAuditResourceNoPass(List<Integer> goodsIds) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateAuditResourceNoPass(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateGoodsStateById(Integer goodsId, Integer dataState, Integer oldDataState) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateGoodsStateById(goodsId, dataState, oldDataState);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSkuStateById(Integer skuId, Integer dataState, Integer oldDataState) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuStateById(skuId, dataState, oldDataState);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteGoodsById(Integer goodsId) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteGoodsById(goodsId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteResourceGoodsList(List<Integer> goodsIds) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteResourceGoodsList(goodsIds);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSoldOutSku(Integer skuId) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSoldOutSku(skuId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateShelveSku(Integer skuId) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateShelveSku(skuId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateSkuEdit(EditSkuDomain editSkuDomain) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateSkuEdit(editSkuDomain);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendSaveDisResourceGoods(List<DisRsResourceGoodsDomain> disRsResourceGoodsList) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.saveDisResourceGoods(disRsResourceGoodsList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendSaveDisSku(List<DisRsSkuDomain> disRsSkuList) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.saveDisSku(disRsSkuList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateDisCannelSku(String skuOldcode, String channelCode, String tenantCode) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateDisCannelSku(skuOldcode, channelCode, tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateDisCannelGoods(String goodsOldcode, String channelCode, String tenantCode) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateDisCannelGoods(goodsOldcode, channelCode, tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteDisSku(String skuOldcode, String channelCode, String tenantCode) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteDisSku(skuOldcode, channelCode, tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteDisGoods(String goodsOldcode, String channelCode, String tenantCode) throws ApiException {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteDisGoods(goodsOldcode, channelCode, tenantCode);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendSaveDisSkuEdit(List<DisRsSkuDomain> disRsSkuList) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.saveDisSkuEdit(disRsSkuList);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateDisCannelGoodsState(Map<String, Object> map) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateDisCannelGoodsState(map);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendUpdateDisCannelSkuState(Map<String, Object> map) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.updateDisCannelSkuState(map);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }

    @Override
    public void sendDeleteSkuBySkuId(Integer skuId) {
        List<RsSenddata> rsSenddataList = this.rsResourceGoodsService.deleteSkuBySkuId(skuId);
        if (ListUtil.isNotEmpty(rsSenddataList)) {
            this.rsSenddataBaseService.sendData(rsSenddataList);
        }
    }
}

