/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsSkuOneMapper;
import com.yqbsoft.laser.service.resources.domain.RsSkuOneDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuOneReDomain;
import com.yqbsoft.laser.service.resources.model.RsSkuOne;
import com.yqbsoft.laser.service.resources.service.RsSkuOneService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsSkuOneServiceImpl
extends BaseServiceImpl
implements RsSkuOneService {
    private static final String SYS_CODE = "rs.RsSkuOneServiceImpl";
    private RsSkuOneMapper rsSkuOneMapper;
    private String cachekey = "SkuOne-ChannelCode-TenantCode";

    public void setRsSkuOneMapper(RsSkuOneMapper rsSkuOneMapper) {
        this.rsSkuOneMapper = rsSkuOneMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsSkuOneMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSkuOne(RsSkuOneDomain rsSkuOneDomain) {
        if (null == rsSkuOneDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSkuOneDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSkuOneDefault(RsSkuOne rsSkuOne) {
        if (null == rsSkuOne) {
            return;
        }
        if (null == rsSkuOne.getDataState()) {
            rsSkuOne.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsSkuOne.getGmtCreate()) {
            rsSkuOne.setGmtCreate(date);
        }
        rsSkuOne.setGmtModified(date);
        if (StringUtils.isBlank((String)rsSkuOne.getSkuOneCode())) {
            rsSkuOne.setSkuOneCode(this.getNo(null, "RsSkuOne", "rsSkuOne", rsSkuOne.getTenantCode()));
        }
    }

    private int getSkuOneMaxCode() {
        int code = 0;
        try {
            return this.rsSkuOneMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.getSkuOneMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSkuOneUpdataDefault(RsSkuOne rsSkuOne) {
        if (null == rsSkuOne) {
            return;
        }
        rsSkuOne.setGmtModified(this.getSysDate());
    }

    private void saveSkuOneModel(RsSkuOne rsSkuOne) throws ApiException {
        if (null == rsSkuOne) {
            return;
        }
        try {
            this.rsSkuOneMapper.insert(rsSkuOne);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.saveSkuOneModel.ex", (Throwable)e);
        }
    }

    private void saveSkuOneBatchModel(List<RsSkuOne> rsSkuOneList) throws ApiException {
        if (null == rsSkuOneList || rsSkuOneList.isEmpty()) {
            return;
        }
        try {
            this.rsSkuOneMapper.insertBatch(rsSkuOneList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.saveSkuOneBatchModel.ex", (Throwable)e);
        }
    }

    private RsSkuOne getSkuOneModelById(Integer skuOneId) {
        if (null == skuOneId) {
            return null;
        }
        try {
            return this.rsSkuOneMapper.selectByPrimaryKey(skuOneId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.getSkuOneModelById", (Throwable)e);
            return null;
        }
    }

    private RsSkuOne getSkuOneModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSkuOneMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.getSkuOneModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSkuOneModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuOneMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.delSkuOneModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuOneServiceImpl.delSkuOneModelByCode.num");
        }
    }

    private void deleteSkuOneModel(Integer skuOneId) throws ApiException {
        if (null == skuOneId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuOneMapper.deleteByPrimaryKey(skuOneId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.deleteSkuOneModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuOneServiceImpl.deleteSkuOneModel.num");
        }
    }

    private void updateSkuOneModel(RsSkuOne rsSkuOne) throws ApiException {
        if (null == rsSkuOne) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuOneMapper.updateByPrimaryKey(rsSkuOne);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateSkuOneModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateSkuOneModel.num");
        }
    }

    private void updateStateSkuOneModel(Integer skuOneId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == skuOneId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuOneId", skuOneId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsSkuOneMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateStateSkuOneModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateStateSkuOneModel.null");
        }
    }

    private void updateStateSkuOneModelByCode(String tenantCode, String skuOneCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)skuOneCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuOneCode", skuOneCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsSkuOneMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateStateSkuOneModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateStateSkuOneModelByCode.null");
        }
    }

    private RsSkuOne makeSkuOne(RsSkuOneDomain rsSkuOneDomain, RsSkuOne rsSkuOne) {
        if (null == rsSkuOneDomain) {
            return null;
        }
        if (null == rsSkuOne) {
            rsSkuOne = new RsSkuOne();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuOne, (Object)rsSkuOneDomain);
            return rsSkuOne;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.makeSkuOne", (Throwable)e);
            return null;
        }
    }

    private RsSkuOneDomain makeSkuOneDomain(RsSkuOne rsSkuOne, RsSkuOneDomain rsSkuOneDomain) {
        if (null == rsSkuOne) {
            return null;
        }
        if (null == rsSkuOneDomain) {
            rsSkuOneDomain = new RsSkuOneDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuOneDomain, (Object)rsSkuOne);
            return rsSkuOneDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.makeSkuOne", (Throwable)e);
            return null;
        }
    }

    private RsSkuOneReDomain makeRsSkuOneReDomain(RsSkuOne rsSkuOne) {
        if (null == rsSkuOne) {
            return null;
        }
        RsSkuOneReDomain rsSkuOneReDomain = new RsSkuOneReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuOneReDomain, (Object)rsSkuOne);
            return rsSkuOneReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.makeRsSkuOneReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsSkuOne> querySkuOneModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSkuOneMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.querySkuOneModel", (Throwable)e);
            return null;
        }
    }

    private int countSkuOne(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuOneMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.countSkuOne", (Throwable)e);
        }
        return i;
    }

    private RsSkuOne createRsSkuOne(RsSkuOneDomain rsSkuOneDomain) {
        String msg = this.checkSkuOne(rsSkuOneDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuOneServiceImpl.saveSkuOne.checkSkuOne", msg);
        }
        RsSkuOne rsSkuOne = this.makeSkuOne(rsSkuOneDomain, null);
        this.setSkuOneDefault(rsSkuOne);
        return rsSkuOne;
    }

    @Override
    public String saveSkuOne(RsSkuOneDomain rsSkuOneDomain) throws ApiException {
        RsSkuOne rsSkuOne = this.createRsSkuOne(rsSkuOneDomain);
        this.saveSkuOneModel(rsSkuOne);
        this.updateSkuOneCache(rsSkuOne);
        return rsSkuOne.getSkuOneCode();
    }

    @Override
    public String saveSkuOneBatch(List<RsSkuOneDomain> rsSkuOneDomainList) throws ApiException {
        if (null == rsSkuOneDomainList || rsSkuOneDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsSkuOne> rsSkuOneList = new ArrayList<RsSkuOne>();
        String code = "";
        for (RsSkuOneDomain rsSkuOneDomain : rsSkuOneDomainList) {
            RsSkuOne rsSkuOne = this.createRsSkuOne(rsSkuOneDomain);
            code = rsSkuOne.getSkuOneCode();
            rsSkuOneList.add(rsSkuOne);
            this.updateSkuOneCache(rsSkuOne);
        }
        this.saveSkuOneBatchModel(rsSkuOneList);
        return code;
    }

    @Override
    public void updateSkuOneState(Integer skuOneId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == skuOneId) {
            return;
        }
        this.updateStateSkuOneModel(skuOneId, dataState, oldDataState, map);
    }

    @Override
    public void updateSkuOneStateByCode(String tenantCode, String skuOneCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)skuOneCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSkuOneModelByCode(tenantCode, skuOneCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSkuOne(RsSkuOneDomain rsSkuOneDomain) throws ApiException {
        String msg = this.checkSkuOne(rsSkuOneDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateSkuOne.checkSkuOne", msg);
        }
        RsSkuOne oldRsSkuOne = this.getSkuOneModelById(rsSkuOneDomain.getSkuOneId());
        if (null == oldRsSkuOne) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateSkuOne.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.deleteSkuOneCache(oldRsSkuOne);
        RsSkuOne rsSkuOne = this.makeSkuOne(rsSkuOneDomain, oldRsSkuOne);
        this.setSkuOneUpdataDefault(rsSkuOne);
        this.updateSkuOneModel(rsSkuOne);
        this.updateSkuOneCache(rsSkuOne);
    }

    @Override
    public RsSkuOne getSkuOne(Integer skuOneId) {
        if (null == skuOneId) {
            return null;
        }
        return this.getSkuOneModelById(skuOneId);
    }

    @Override
    public void deleteSkuOne(Integer skuOneId) throws ApiException {
        if (null == skuOneId) {
            return;
        }
        RsSkuOne skuOne = this.getSkuOne(skuOneId);
        this.deleteSkuOneCache(skuOne);
        this.deleteSkuOneModel(skuOneId);
    }

    @Override
    public QueryResult<RsSkuOne> querySkuOnePage(Map<String, Object> map) {
        List<RsSkuOne> rsSkuOneList = this.querySkuOneModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSkuOne(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuOneList);
        return queryResult;
    }

    @Override
    public RsSkuOne getSkuOneByCode(String tenantCode, String skuOneCode) throws ApiException {
        if (StringUtils.isBlank((String)skuOneCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuOneCode", skuOneCode);
        return this.getSkuOneModelByCode(map);
    }

    @Override
    public void deleteSkuOneByCode(String tenantCode, String skuOneCode) throws ApiException {
        if (StringUtils.isBlank((String)skuOneCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        RsSkuOne skuOneByCode = this.getSkuOneByCode(tenantCode, skuOneCode);
        this.deleteSkuOneCache(skuOneByCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuOneCode", skuOneCode);
        this.delSkuOneModelByCode(map);
    }

    private void deleteSkuOneCache(RsSkuOne skuOne) {
        if (null == skuOne) {
            return;
        }
        if (StringUtils.isBlank((String)skuOne.getChannelCode())) {
            skuOne.setChannelCode("all");
        }
        if (StringUtils.isBlank((String)skuOne.getGoodsNo())) {
            skuOne.setGoodsNo("all");
        }
        if (StringUtils.isBlank((String)skuOne.getSkuNo())) {
            skuOne.setSkuNo("all");
        }
        String key = skuOne.getChannelCode() + "-" + skuOne.getGoodsNo() + "-" + skuOne.getSkuNo() + "-" + skuOne.getTenantCode();
        DisUtil.del((String)key);
    }

    private void updateSkuOneCache(RsSkuOne skuOne) {
        if (null == skuOne) {
            return;
        }
        if (StringUtils.isBlank((String)skuOne.getChannelCode())) {
            skuOne.setChannelCode("all");
        }
        if (StringUtils.isBlank((String)skuOne.getGoodsNo())) {
            skuOne.setGoodsNo("all");
        }
        if (StringUtils.isBlank((String)skuOne.getSkuNo())) {
            skuOne.setSkuNo("all");
        }
        RsSkuOneDomain salequotaDomain = this.makeSkuOneDomain(skuOne, null);
        String key = skuOne.getChannelCode() + "-" + skuOne.getGoodsNo() + "-" + skuOne.getSkuNo() + "-" + skuOne.getTenantCode();
        DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)salequotaDomain));
    }

    @Override
    public void querySkuOneLoadCache() {
        this.logger.info("SkuOneServiceImpl.querySalequotaLoadCache", (Object)"===========start==========");
        List<RsSkuOne> salequotaList = this.querySkuOneModelPage(new HashMap<String, Object>());
        if (null == salequotaList || salequotaList.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("SkuOneServiceImpl.querySalequotaLoadCache", (Object)"===========del-end==========");
            return;
        }
        for (RsSkuOne skuOne : salequotaList) {
            if (StringUtils.isBlank((String)skuOne.getChannelCode())) {
                skuOne.setChannelCode("all");
            }
            if (StringUtils.isBlank((String)skuOne.getGoodsNo())) {
                skuOne.setGoodsNo("all");
            }
            if (StringUtils.isBlank((String)skuOne.getSkuNo())) {
                skuOne.setSkuNo("all");
            }
            RsSkuOneDomain skuOneDomain = this.makeSkuOneDomain(skuOne, null);
            String key = skuOne.getChannelCode() + "-" + skuOne.getGoodsNo() + "-" + skuOne.getSkuNo() + "-" + skuOne.getTenantCode();
            DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)skuOneDomain));
        }
        this.logger.info("SkuOneServiceImpl.querySalequotaLoadCache", (Object)"===========add-end==========");
    }
}

