/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsGoodsClassMapper;
import com.yqbsoft.laser.service.resources.domain.RsGoodsClassDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsClassReDomain;
import com.yqbsoft.laser.service.resources.domain.RsGoodsClassconfDomain;
import com.yqbsoft.laser.service.resources.domain.RsSenddataDomain;
import com.yqbsoft.laser.service.resources.domain.UmUserinfo;
import com.yqbsoft.laser.service.resources.model.RsGoodsClass;
import com.yqbsoft.laser.service.resources.model.RsSenddata;
import com.yqbsoft.laser.service.resources.service.RsGoodsClassService;
import com.yqbsoft.laser.service.resources.service.RsGoodsClassconfService;
import com.yqbsoft.laser.service.resources.service.RsSenddataBaseService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsGoodsClassServiceImpl
extends BaseServiceImpl
implements RsGoodsClassService {
    private static final String SYS_CODE = "rs.RsGoodsClassServiceImpl";
    private RsGoodsClassMapper rsGoodsClassMapper;
    private RsGoodsClassconfService rsGoodsClassconfService;
    RsSenddataBaseService rsSenddataBaseService;

    public void setRsGoodsClassconfService(RsGoodsClassconfService rsGoodsClassconfService) {
        this.rsGoodsClassconfService = rsGoodsClassconfService;
    }

    public void setRsGoodsClassMapper(RsGoodsClassMapper rsGoodsClassMapper) {
        this.rsGoodsClassMapper = rsGoodsClassMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsGoodsClassMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsClassServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) {
        if (null == rsGoodsClassDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setGoodsClassDefault(RsGoodsClass rsGoodsClass) {
        if (null == rsGoodsClass) {
            return;
        }
        if (null == rsGoodsClass.getDataState()) {
            rsGoodsClass.setDataState(0);
        }
        if (null == rsGoodsClass.getGmtCreate()) {
            rsGoodsClass.setGmtCreate(this.getSysDate());
        }
        rsGoodsClass.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsGoodsClass.getGoodsClassCode())) {
            rsGoodsClass.setGoodsClassCode(this.getNo(null, "RsGoodsClass", "goodsClassCode", rsGoodsClass.getTenantCode()));
        }
        if (StringUtils.isBlank((String)rsGoodsClass.getGoodsClassNo())) {
            rsGoodsClass.setGoodsClassNo(this.getNo(null, "RsGoodsClass", "goodsClassNo", rsGoodsClass.getTenantCode()));
        }
    }

    private int getGoodsClassMaxCode() {
        int code = 0;
        try {
            return this.rsGoodsClassMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsClassServiceImpl.getGoodsClassMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGoodsClassUpdataDefault(RsGoodsClass rsGoodsClass) {
        if (null == rsGoodsClass) {
            return;
        }
        rsGoodsClass.setGmtModified(this.getSysDate());
    }

    private void saveGoodsClassModel(RsGoodsClass rsGoodsClass) throws ApiException {
        if (null == rsGoodsClass) {
            return;
        }
        try {
            this.rsGoodsClassMapper.insert(rsGoodsClass);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.saveGoodsClassModel.ex", (Throwable)e);
        }
    }

    public void saveBatchGoodsClassModel(List<RsGoodsClass> rsGoodsClassList) throws ApiException {
        if (ListUtil.isEmpty(rsGoodsClassList)) {
            return;
        }
        try {
            this.rsGoodsClassMapper.insertBatch(rsGoodsClassList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.saveBatchGoodsClassModel.ex", (Throwable)e);
        }
    }

    private RsGoodsClass getGoodsClassModelById(Integer goodsClassId) {
        if (null == goodsClassId) {
            return null;
        }
        try {
            return this.rsGoodsClassMapper.selectByPrimaryKey(goodsClassId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsClassServiceImpl.getGoodsClassModelById", (Throwable)e);
            return null;
        }
    }

    public RsGoodsClass getGoodsClassModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsGoodsClassMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsClassServiceImpl.getGoodsClassModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delGoodsClassModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsClassMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.delGoodsClassModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.delGoodsClassModelByCode.num");
        }
    }

    private void deleteGoodsClassModel(Integer goodsClassId) throws ApiException {
        if (null == goodsClassId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsGoodsClassMapper.deleteByPrimaryKey(goodsClassId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.deleteGoodsClassModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.deleteGoodsClassModel.num");
        }
    }

    private void updateGoodsClassModel(RsGoodsClass rsGoodsClass) throws ApiException {
        if (null == rsGoodsClass) {
            return;
        }
        try {
            this.rsGoodsClassMapper.updateByPrimaryKeySelective(rsGoodsClass);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.updateGoodsClassModel.ex", (Throwable)e);
        }
    }

    private void updateStateGoodsClassModel(Integer goodsClassId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == goodsClassId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsClassId", goodsClassId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rsGoodsClassMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.updateStateGoodsClassModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.updateStateGoodsClassModel.null");
        }
    }

    private RsGoodsClass makeGoodsClass(RsGoodsClassDomain rsGoodsClassDomain, RsGoodsClass rsGoodsClass) {
        if (null == rsGoodsClassDomain) {
            return null;
        }
        if (null == rsGoodsClass) {
            rsGoodsClass = new RsGoodsClass();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsClass, (Object)rsGoodsClassDomain);
            return rsGoodsClass;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsClassServiceImpl.makeGoodsClass", (Throwable)e);
            return null;
        }
    }

    private List<RsGoodsClass> queryGoodsClassModelPage(Map<String, Object> parammap) {
        try {
            return this.rsGoodsClassMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsClassServiceImpl.queryGoodsClassModel", (Throwable)e);
            return null;
        }
    }

    private int countGoodsClass(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsGoodsClassMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsClassServiceImpl.countGoodsClass", (Throwable)e);
        }
        return i;
    }

    public RsGoodsClass getGoodsClassModelByNo(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsGoodsClassMapper.getByNo(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsClassServiceImpl.getGoodsClassModelByNo", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<RsSenddata> saveGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) throws ApiException {
        RsGoodsClass rsGoodsClass = this.saveGoods(rsGoodsClassDomain);
        this.processFLowDataForHtml(rsGoodsClass, "insert");
        ArrayList<RsGoodsClass> goodsClasses = new ArrayList<RsGoodsClass>();
        goodsClasses.add(rsGoodsClass);
        List<RsSenddata> rsSenddata = this.saveSenddata(goodsClasses, "add");
        if (null == rsSenddata) {
            rsSenddata = new ArrayList<RsSenddata>();
        }
        return rsSenddata;
    }

    @Override
    public RsGoodsClass saveRsGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) throws ApiException {
        return this.saveGoods(rsGoodsClassDomain);
    }

    private RsGoodsClass saveGoods(RsGoodsClassDomain rsGoodsClassDomain) {
        RsGoodsClass rsGoodsClass = this.makeModel(rsGoodsClassDomain);
        this.saveGoodsClassModel(rsGoodsClass);
        this.saveConfList(rsGoodsClass, rsGoodsClassDomain.getRsGoodsClassconfDomainList());
        return rsGoodsClass;
    }

    private RsGoodsClass makeModel(RsGoodsClassDomain rsGoodsClassDomain) {
        String msg = this.checkGoodsClass(rsGoodsClassDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.saveGoodsClass.checkGoodsClass", msg);
        }
        RsGoodsClass rsGoodsClass = this.makeGoodsClass(rsGoodsClassDomain, null);
        this.setGoodsClassDefault(rsGoodsClass);
        return rsGoodsClass;
    }

    @Override
    public List<RsSenddata> saveGoodsClassList(List<RsGoodsClassDomain> rsGoodsClassDomainList) throws ApiException {
        if (ListUtil.isEmpty(rsGoodsClassDomainList)) {
            this.logger.error("rs.RsGoodsClassServiceImpl.saveGoodsClassList", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        ArrayList<RsSenddata> rslist = new ArrayList<RsSenddata>();
        for (RsGoodsClassDomain rsGoodsClassDomain : rsGoodsClassDomainList) {
            List<RsSenddata> crslist = this.saveGoodsClass(rsGoodsClassDomain);
            if (!ListUtil.isNotEmpty(crslist)) continue;
            rslist.addAll(crslist);
        }
        return rslist;
    }

    private void saveConfList(RsGoodsClass rsGoodsClass, List<RsGoodsClassconfDomain> rsGoodsClassconfDomainList) {
        if (null == rsGoodsClass || ListUtil.isEmpty(rsGoodsClassconfDomainList)) {
            return;
        }
        for (RsGoodsClassconfDomain rsGoodsClassconfDomain : rsGoodsClassconfDomainList) {
            rsGoodsClassconfDomain.setGoodsClassCode(rsGoodsClass.getGoodsClassCode());
            rsGoodsClassconfDomain.setTenantCode(rsGoodsClass.getTenantCode());
            rsGoodsClassconfDomain.setMemberCode(rsGoodsClass.getMemberCode());
            rsGoodsClassconfDomain.setMemberName(rsGoodsClass.getMemberName());
        }
        this.rsGoodsClassconfService.saveGoodsClassconfBatch(rsGoodsClassconfDomainList);
    }

    private List<RsSenddata> saveSenddata(List<RsGoodsClass> goodsClasses, String requestType) {
        if (ListUtil.isEmpty(goodsClasses) || StringUtils.isBlank((String)requestType)) {
            this.logger.error("rs.RsGoodsClassServiceImpl.saveSenddata.goodsClasses/requestType:", (Object)(goodsClasses + "=:=" + requestType));
            return null;
        }
        ArrayList<RsSenddataDomain> rsSenddataDomainList = new ArrayList<RsSenddataDomain>();
        for (RsGoodsClass goodsClass : goodsClasses) {
            String fdBizcodestr = JsonUtil.buildNormalBinder().toJson((Object)goodsClass);
            RsSenddataDomain rsSenddataDomain = new RsSenddataDomain();
            rsSenddataDomain.setEsrequestType(requestType);
            rsSenddataDomain.setMemberCode(goodsClass.getMemberCode());
            rsSenddataDomain.setChannelCode(goodsClass.getChannelCode());
            rsSenddataDomain.setTenantCode(goodsClass.getTenantCode());
            rsSenddataDomain.setAppmanageIcode(goodsClass.getAppmanageIcode());
            rsSenddataDomain.setFdBizcode(goodsClass.getGoodsClassNo());
            rsSenddataDomain.setFdBiztype("RsGoodsClass");
            rsSenddataDomain.setFdBizcodestr(fdBizcodestr);
            rsSenddataDomain.setFdState(goodsClass.getDataState());
            rsSenddataDomain.setFdBizid(goodsClass.getGoodsClassId());
            rsSenddataDomainList.add(rsSenddataDomain);
        }
        this.logger.error("rs.RsGoodsClassServiceImpl.saveSenddata.rsSenddataDomainList.", (Object)JsonUtil.buildNormalBinder().toJson(rsSenddataDomainList));
        return this.getRsSenddataBaseService().saveDatasendBatch(rsSenddataDomainList);
    }

    @Override
    public void updateGoodsClassState(Integer goodsClassId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGoodsClassModel(goodsClassId, dataState, oldDataState);
    }

    @Override
    public List<RsSenddata> updateGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) throws ApiException {
        String msg = this.checkGoodsClass(rsGoodsClassDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.updateGoodsClass.checkGoodsClass", msg);
        }
        RsGoodsClass oldRsGoodsClass = this.getGoodsClassModelById(rsGoodsClassDomain.getGoodsClassId());
        if (null == oldRsGoodsClass) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.updateGoodsClass.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsGoodsClass rsGoodsClass = this.makeGoodsClass(rsGoodsClassDomain, oldRsGoodsClass);
        this.setGoodsClassUpdataDefault(rsGoodsClass);
        this.updateGoodsClassModel(rsGoodsClass);
        rsGoodsClass = this.getGoodsClassModelById(rsGoodsClassDomain.getGoodsClassId());
        this.processFLowDataForHtml(rsGoodsClass, "update");
        ArrayList<RsGoodsClass> goodsClasses = new ArrayList<RsGoodsClass>();
        goodsClasses.add(rsGoodsClass);
        List<RsSenddata> rsSenddata = this.saveSenddata(goodsClasses, "add");
        if (null == rsSenddata) {
            rsSenddata = new ArrayList<RsSenddata>();
        }
        return rsSenddata;
    }

    @Override
    public RsGoodsClassReDomain getGoodsClass(Integer goodsClassId) {
        return this.makeReDomain(this.getGoodsClassModelById(goodsClassId));
    }

    @Override
    public List<RsSenddata> deleteGoodsClass(Integer goodsClassId) throws ApiException {
        RsGoodsClass rsGoodsClass = this.getGoodsClassModelById(goodsClassId);
        this.deleteGoodsClassModel(goodsClassId);
        this.processFLowDataForHtml(rsGoodsClass, "delete");
        ArrayList<RsGoodsClass> goodsClasses = new ArrayList<RsGoodsClass>();
        goodsClasses.add(rsGoodsClass);
        List<RsSenddata> rsSenddata = this.saveSenddata(goodsClasses, "add");
        if (null == rsSenddata) {
            rsSenddata = new ArrayList<RsSenddata>();
        }
        return rsSenddata;
    }

    @Override
    public QueryResult<RsGoodsClass> queryGoodsClassPage(Map<String, Object> map) {
        List<RsGoodsClass> rsGoodsClassList = this.queryGoodsClassModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGoodsClass(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsGoodsClassList);
        return queryResult;
    }

    @Override
    public RsGoodsClassReDomain getGoodsClassByCode(Map<String, Object> map) {
        return this.makeReDomain(this.getGoodsClassModelByCode(map));
    }

    private RsGoodsClassReDomain makeReDomain(RsGoodsClass rsGoodsClass) {
        if (null == rsGoodsClass) {
            return null;
        }
        RsGoodsClassReDomain rsGoodsClassReDomain = new RsGoodsClassReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsClassReDomain, (Object)rsGoodsClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setConf(rsGoodsClassReDomain);
        return rsGoodsClassReDomain;
    }

    private void setConf(RsGoodsClassReDomain rsGoodsClassReDomain) {
        if (null == rsGoodsClassReDomain) {
            return;
        }
        List<RsGoodsClassconfDomain> list = this.rsGoodsClassconfService.queryGoodsClassconfByClasscode(rsGoodsClassReDomain.getTenantCode(), rsGoodsClassReDomain.getGoodsClassCode());
        rsGoodsClassReDomain.setRsGoodsClassconfDomainList(list);
    }

    @Override
    public List<RsSenddata> delGoodsClassByCode(Map<String, Object> map) throws ApiException {
        RsGoodsClass rsGoodsClass = this.getGoodsClassModelByCode(map);
        this.delGoodsClassModelByCode(map);
        return this.processFLowDataForHtml(rsGoodsClass, "delete");
    }

    public RsSenddataBaseService getRsSenddataBaseService() {
        if (null == this.rsSenddataBaseService) {
            this.rsSenddataBaseService = (RsSenddataBaseService)ApplicationContextUtil.getService((String)"rsSenddataBaseService");
        }
        return this.rsSenddataBaseService;
    }

    public List<RsSenddata> processFLowDataForHtml(RsGoodsClass rsGoodsClass, String esrequestType) {
        if (null == rsGoodsClass) {
            return null;
        }
        ArrayList<RsSenddataDomain> rsFlowDataList = new ArrayList<RsSenddataDomain>();
        String fdBizcodestr = JsonUtil.buildNormalBinder().toJson((Object)rsGoodsClass);
        int fdState = 0;
        if (esrequestType.equals("delete")) {
            fdState = -1;
        }
        RsSenddataDomain rsFlowData = new RsSenddataDomain();
        rsFlowData.setEsrequestType(esrequestType);
        rsFlowData.setTenantCode(rsGoodsClass.getTenantCode());
        rsFlowData.setFdBizcode(rsGoodsClass.getGoodsClassCode());
        rsFlowData.setChannelCode(rsGoodsClass.getChannelCode());
        rsFlowData.setFdBiztype("RsGoodsClass");
        rsFlowData.setFdBizcodestr(fdBizcodestr);
        rsFlowData.setMemberCode(rsGoodsClass.getMemberCode());
        rsFlowData.setFdState(fdState);
        rsFlowDataList.add(rsFlowData);
        return this.getRsSenddataBaseService().saveDatasendBatch(rsFlowDataList);
    }

    @Override
    public void updateStateList(String tenantCode, Integer dataState, Integer oldDataState, String goodsClassHide) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || null == dataState || null == oldDataState || StringUtils.isBlank((String)goodsClassHide)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("goodsClassHide", goodsClassHide);
        this.updateStateListModel(map);
    }

    private void updateStateListModel(Map<String, Object> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.rsGoodsClassMapper.updateStateBatch(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsGoodsClassServiceImpl.updateStateListModel.ex", (Throwable)e);
        }
    }

    private List<UmUserinfo> queryUserinfo(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "um.user.queryUserinfoPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, Object> pmp = new HashMap<String, Object>();
        pmp.put("tenantCode", tenantCode);
        pmp.put("userinfoQuality", "bus");
        pmp.put("order", true);
        pmp.put("fuzzy", true);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(pmp));
        QueryResult qlist = this.getQueryResutl(apiCode, paramMap, UmUserinfo.class);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            return null;
        }
        return qlist.getList();
    }

    @Override
    public List<RsSenddata> saveGoodsClassInit(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        List<UmUserinfo> userinfoList = this.queryUserinfo(tenantCode);
        if (ListUtil.isEmpty(userinfoList)) {
            return null;
        }
        ArrayList<RsSenddata> rslist = new ArrayList<RsSenddata>();
        for (UmUserinfo umUserinfo : userinfoList) {
            QueryResult<RsGoodsClass> rsGoodsClassQueryResult = this.queryGoodsClassPage(this.getQueryMapParam("memberCode,tenantCode", new Object[]{umUserinfo.getUserinfoQuality(), "00000000"}));
            if (null == rsGoodsClassQueryResult || ListUtil.isEmpty((Collection)rsGoodsClassQueryResult.getList())) continue;
            List rsGoodsClassList = rsGoodsClassQueryResult.getList();
            for (RsGoodsClass rsGoodsClass : rsGoodsClassList) {
                RsGoodsClass oldRsGoodsClass = this.getGoodsClassModelByCode(this.getQueryMapParam("goodsClassCode,tenantCode", new Object[]{rsGoodsClass.getGoodsClassCode(), tenantCode}));
                if (null != oldRsGoodsClass) continue;
                RsGoodsClassDomain rsGoodsClassDomain = this.makeRsGoodsClassDomain(rsGoodsClass);
                rsGoodsClassDomain.setGoodsClassId(null);
                rsGoodsClassDomain.setMemberCode(umUserinfo.getUserinfoCode());
                rsGoodsClassDomain.setMemberName(umUserinfo.getUserinfoCompname());
                rsGoodsClassDomain.setTenantCode(tenantCode);
                List<RsSenddata> crslist = this.saveGoodsClass(rsGoodsClassDomain);
                if (!ListUtil.isNotEmpty(crslist)) continue;
                rslist.addAll(crslist);
            }
        }
        return rslist;
    }

    private RsGoodsClassDomain makeRsGoodsClassDomain(RsGoodsClass rsGoodsClass) {
        if (null == rsGoodsClass) {
            return null;
        }
        RsGoodsClassDomain rsGoodsClassDomain = new RsGoodsClassDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsGoodsClassDomain, (Object)rsGoodsClass);
            return rsGoodsClassDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsGoodsClassServiceImpl.makeRsGoodsClassDomain", (Throwable)e);
            return null;
        }
    }

    @Override
    public void processFLowDataForHtml(String tenantCode) {
    }

    @Override
    public List<RsSenddata> updateGoodsClassChannelInit(String tenantCode) {
        QueryResult<RsGoodsClass> rsGoodsClassQueryResult = this.queryGoodsClassPage(this.getQueryMapParam("tenantCode", new Object[]{tenantCode}));
        if (null == rsGoodsClassQueryResult || ListUtil.isEmpty((Collection)rsGoodsClassQueryResult.getList())) {
            return null;
        }
        ArrayList<RsSenddata> relist = new ArrayList<RsSenddata>();
        for (RsGoodsClass rsGoodsClass : rsGoodsClassQueryResult.getList()) {
            List<RsSenddata> list = this.processFLowDataForHtml(rsGoodsClass, "insert");
            if (!ListUtil.isNotEmpty(list)) continue;
            relist.addAll(list);
        }
        return relist;
    }

    @Override
    public List<RsGoodsClassReDomain> queryGoodsClassByParent(String goodsClassParentcode, String goodsClassType, String channelCode, String tenantCode) {
        return this.queryClasstreeParent(channelCode, tenantCode, goodsClassType, goodsClassParentcode);
    }

    private RsGoodsClassReDomain makeRsClasstreeReDomain(RsGoodsClass rsGoodsClass) {
        if (null == rsGoodsClass) {
            return null;
        }
        RsGoodsClassReDomain rsClasstreeReDomain = new RsGoodsClassReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsClasstreeReDomain, (Object)rsGoodsClass);
            rsClasstreeReDomain.setChildList(this.queryClasstreeParent(rsGoodsClass.getMemberCode(), rsGoodsClass.getTenantCode(), rsGoodsClass.getGoodsClassType(), rsGoodsClass.getGoodsClassParentcode()));
        }
        catch (Exception e) {
            return null;
        }
        return rsClasstreeReDomain;
    }

    private List<RsGoodsClassReDomain> queryClasstreeParent(String channelCode, String tenantCode, String goodsClassType, String goodsClassParentcode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelCode", channelCode);
        map.put("tenantCode", tenantCode);
        map.put("goodsClassType", goodsClassType);
        map.put("goodsClassParentcode", goodsClassParentcode);
        List<RsGoodsClass> rsGoodsClassList = this.queryGoodsClassModelPage(map);
        if (null == rsGoodsClassList || rsGoodsClassList.isEmpty()) {
            return null;
        }
        ArrayList<RsGoodsClassReDomain> rsClasstreeReDomainList = new ArrayList<RsGoodsClassReDomain>();
        for (RsGoodsClass rsGoodsClass : rsGoodsClassList) {
            rsClasstreeReDomainList.add(this.makeRsClasstreeReDomain(rsGoodsClass));
        }
        return rsClasstreeReDomainList;
    }

    @Override
    public List<RsSenddata> deleteGoodsClassByNo(String goodsClassNo, String channelCode, String tenantCode) throws ApiException {
        List<RsGoodsClass> rsGoodsClasses;
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("goodsClassNo", goodsClassNo);
        parammap.put("tenantCode", tenantCode);
        if (StringUtils.isNotBlank((String)channelCode)) {
            parammap.put("channelCode", channelCode);
        }
        if (ListUtil.isEmpty(rsGoodsClasses = this.queryGoodsClassModelPage(parammap))) {
            return null;
        }
        ArrayList<RsSenddata> rsSenddataList = new ArrayList<RsSenddata>();
        for (RsGoodsClass rsGoodsClasse : rsGoodsClasses) {
            List<RsSenddata> rsSenddatas = this.deleteGoodsClass(rsGoodsClasse.getGoodsClassId());
            if (!ListUtil.isNotEmpty(rsSenddatas)) continue;
            rsSenddataList.addAll(rsSenddatas);
        }
        return rsSenddataList;
    }

    @Override
    public RsGoodsClassDomain getGoodsClassByNo(Map<String, Object> map) throws ApiException {
        return this.makeRsGoodsClassDomain(this.getGoodsClassModelByNo(map));
    }

    @Override
    public List<RsSenddata> updateBatchDisGoodsClass(List<RsGoodsClassDomain> rsGoodsClassDomains) throws ApiException {
        if (ListUtil.isEmpty(rsGoodsClassDomains)) {
            return null;
        }
        ArrayList<RsSenddata> rsSenddataList = new ArrayList<RsSenddata>();
        for (RsGoodsClassDomain rsGoodsClassDomain : rsGoodsClassDomains) {
            List<RsSenddata> rsSenddatas = this.updateGoodsClass(rsGoodsClassDomain);
            if (!ListUtil.isNotEmpty(rsSenddatas)) continue;
            rsSenddataList.addAll(rsSenddatas);
        }
        return rsSenddataList;
    }

    @Override
    public List<RsSenddata> saveBatchDisGoodsClass(List<RsGoodsClassDomain> rsGoodsClassDomains) throws ApiException {
        if (ListUtil.isEmpty(rsGoodsClassDomains)) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        ArrayList<RsSenddata> rsSenddataList = new ArrayList<RsSenddata>();
        for (RsGoodsClassDomain rsGoodsClassDomain : rsGoodsClassDomains) {
            List<RsSenddata> skursSenddataList;
            parammap.put("memberCode", rsGoodsClassDomain.getMemberCode());
            parammap.put("goodsClassNo", rsGoodsClassDomain.getGoodsClassOldno());
            parammap.put("tenantCode", rsGoodsClassDomain.getTenantCode());
            parammap.put("channelCode", rsGoodsClassDomain.getChannelCode());
            RsGoodsClassDomain rctDomain = this.getGoodsClassByNo(parammap);
            if (null == rctDomain) {
                ArrayList<RsGoodsClassDomain> rsClasstreeDomainList = new ArrayList<RsGoodsClassDomain>();
                rsClasstreeDomainList.add(rctDomain);
                skursSenddataList = this.saveBatchDisGoodsClass(rsClasstreeDomainList);
                if (!ListUtil.isNotEmpty(skursSenddataList)) continue;
                rsSenddataList.addAll(skursSenddataList);
                continue;
            }
            skursSenddataList = this.updateGoodsClass(rctDomain);
            if (!ListUtil.isNotEmpty(skursSenddataList)) continue;
            rsSenddataList.addAll(skursSenddataList);
        }
        return rsSenddataList;
    }
}

