/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsSkuOneMapper;
import com.yqbsoft.laser.service.resources.dao.RsSkuOnelistMapper;
import com.yqbsoft.laser.service.resources.domain.RsSkuOneDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuOneReDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuOnelistDomain;
import com.yqbsoft.laser.service.resources.domain.RsSkuOnelistReDomain;
import com.yqbsoft.laser.service.resources.model.RsSkuOne;
import com.yqbsoft.laser.service.resources.model.RsSkuOnelist;
import com.yqbsoft.laser.service.resources.service.RsSkuOneService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RsSkuOneServiceImpl
extends BaseServiceImpl
implements RsSkuOneService {
    private static final String SYS_CODE = "rs.RsSkuOneServiceImpl";
    private RsSkuOneMapper rsSkuOneMapper;
    private RsSkuOnelistMapper rsSkuOnelistMapper;
    private String cachekey = "SkuOne-ChannelCode-TenantCode";

    public void setRsSkuOneMapper(RsSkuOneMapper rsSkuOneMapper) {
        this.rsSkuOneMapper = rsSkuOneMapper;
    }

    public void setRsSkuOnelistMapper(RsSkuOnelistMapper rsSkuOnelistMapper) {
        this.rsSkuOnelistMapper = rsSkuOnelistMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsSkuOneMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSkuOne(RsSkuOneDomain rsSkuOneDomain) {
        if (null == rsSkuOneDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSkuOneDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSkuOneDefault(RsSkuOne rsSkuOne) {
        if (null == rsSkuOne) {
            return;
        }
        if (null == rsSkuOne.getDataState()) {
            rsSkuOne.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsSkuOne.getGmtCreate()) {
            rsSkuOne.setGmtCreate(date);
        }
        rsSkuOne.setGmtModified(date);
        if (StringUtils.isBlank((String)rsSkuOne.getSkuOneCode())) {
            rsSkuOne.setSkuOneCode(this.getNo(null, "RsSkuOne", "rsSkuOne", rsSkuOne.getTenantCode()));
        }
    }

    private int getSkuOneMaxCode() {
        int code = 0;
        try {
            return this.rsSkuOneMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.getSkuOneMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSkuOneUpdataDefault(RsSkuOne rsSkuOne) {
        if (null == rsSkuOne) {
            return;
        }
        rsSkuOne.setGmtModified(this.getSysDate());
    }

    private void saveSkuOneModel(RsSkuOne rsSkuOne) throws ApiException {
        if (null == rsSkuOne) {
            return;
        }
        try {
            this.rsSkuOneMapper.insert(rsSkuOne);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.saveSkuOneModel.ex", (Throwable)e);
        }
    }

    private void saveSkuOneBatchModel(List<RsSkuOne> rsSkuOneList) throws ApiException {
        if (null == rsSkuOneList || rsSkuOneList.isEmpty()) {
            return;
        }
        try {
            this.rsSkuOneMapper.insertBatch(rsSkuOneList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.saveSkuOneBatchModel.ex", (Throwable)e);
        }
    }

    private RsSkuOne getSkuOneModelById(Integer skuOneId) {
        if (null == skuOneId) {
            return null;
        }
        try {
            return this.rsSkuOneMapper.selectByPrimaryKey(skuOneId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.getSkuOneModelById", (Throwable)e);
            return null;
        }
    }

    private RsSkuOne getSkuOneModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSkuOneMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.getSkuOneModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSkuOneModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuOneMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.delSkuOneModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuOneServiceImpl.delSkuOneModelByCode.num");
        }
    }

    private void deleteSkuOneModel(Integer skuOneId) throws ApiException {
        if (null == skuOneId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuOneMapper.deleteByPrimaryKey(skuOneId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.deleteSkuOneModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuOneServiceImpl.deleteSkuOneModel.num");
        }
    }

    private void updateSkuOneModel(RsSkuOne rsSkuOne) throws ApiException {
        if (null == rsSkuOne) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuOneMapper.updateByPrimaryKey(rsSkuOne);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateSkuOneModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateSkuOneModel.num");
        }
    }

    private void updateStateSkuOneModel(Integer skuOneId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == skuOneId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuOneId", skuOneId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsSkuOneMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateStateSkuOneModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateStateSkuOneModel.null");
        }
    }

    private void updateStateSkuOneModelByCode(String tenantCode, String skuOneCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)skuOneCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuOneCode", skuOneCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsSkuOneMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateStateSkuOneModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateStateSkuOneModelByCode.null");
        }
    }

    private RsSkuOne makeSkuOne(RsSkuOneDomain rsSkuOneDomain, RsSkuOne rsSkuOne) {
        if (null == rsSkuOneDomain) {
            return null;
        }
        if (null == rsSkuOne) {
            rsSkuOne = new RsSkuOne();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuOne, (Object)rsSkuOneDomain);
            return rsSkuOne;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.makeSkuOne", (Throwable)e);
            return null;
        }
    }

    private RsSkuOneDomain makeSkuOneDomain(RsSkuOne rsSkuOne, RsSkuOneDomain rsSkuOneDomain) {
        if (null == rsSkuOne) {
            return null;
        }
        if (null == rsSkuOneDomain) {
            rsSkuOneDomain = new RsSkuOneDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuOneDomain, (Object)rsSkuOne);
            return rsSkuOneDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.makeSkuOne", (Throwable)e);
            return null;
        }
    }

    private RsSkuOneReDomain makeRsSkuOneReDomain(RsSkuOne rsSkuOne) {
        if (null == rsSkuOne) {
            return null;
        }
        RsSkuOneReDomain rsSkuOneReDomain = new RsSkuOneReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuOneReDomain, (Object)rsSkuOne);
            return rsSkuOneReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.makeRsSkuOneReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsSkuOne> querySkuOneModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSkuOneMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.querySkuOneModel", (Throwable)e);
            return null;
        }
    }

    private int countSkuOne(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuOneMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.countSkuOne", (Throwable)e);
        }
        return i;
    }

    private RsSkuOne createRsSkuOne(RsSkuOneDomain rsSkuOneDomain) {
        String msg = this.checkSkuOne(rsSkuOneDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuOneServiceImpl.saveSkuOne.checkSkuOne", msg);
        }
        RsSkuOne rsSkuOne = this.makeSkuOne(rsSkuOneDomain, null);
        this.setSkuOneDefault(rsSkuOne);
        return rsSkuOne;
    }

    private String checkSkuOnelist(RsSkuOnelistDomain rsSkuOnelistDomain) {
        if (null == rsSkuOnelistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsSkuOnelistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSkuOnelistDefault(RsSkuOnelist rsSkuOnelist) {
        if (null == rsSkuOnelist) {
            return;
        }
        if (null == rsSkuOnelist.getDataState()) {
            rsSkuOnelist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsSkuOnelist.getGmtCreate()) {
            rsSkuOnelist.setGmtCreate(date);
        }
        rsSkuOnelist.setGmtModified(date);
        if (StringUtils.isBlank((String)rsSkuOnelist.getSkuOnelistCode())) {
            rsSkuOnelist.setSkuOnelistCode(this.getNo(null, "RsSkuOnelist", "rsSkuOnelist", rsSkuOnelist.getTenantCode()));
        }
    }

    private int getSkuOnelistMaxCode() {
        int code = 0;
        try {
            return this.rsSkuOnelistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.getSkuOnelistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSkuOnelistUpdataDefault(RsSkuOnelist rsSkuOnelist) {
        if (null == rsSkuOnelist) {
            return;
        }
        rsSkuOnelist.setGmtModified(this.getSysDate());
    }

    private void saveSkuOnelistModel(RsSkuOnelist rsSkuOnelist) throws ApiException {
        if (null == rsSkuOnelist) {
            return;
        }
        try {
            this.rsSkuOnelistMapper.insert(rsSkuOnelist);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.saveSkuOnelistModel.ex", (Throwable)e);
        }
    }

    private void saveSkuOnelistBatchModel(List<RsSkuOnelist> rsSkuOnelistList) throws ApiException {
        if (null == rsSkuOnelistList || rsSkuOnelistList.isEmpty()) {
            return;
        }
        try {
            this.rsSkuOnelistMapper.insertBatch(rsSkuOnelistList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.saveSkuOnelistBatchModel.ex", (Throwable)e);
        }
    }

    private RsSkuOnelist getSkuOnelistModelById(Integer skuOnelistId) {
        if (null == skuOnelistId) {
            return null;
        }
        try {
            return this.rsSkuOnelistMapper.selectByPrimaryKey(skuOnelistId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.getSkuOnelistModelById", (Throwable)e);
            return null;
        }
    }

    private RsSkuOnelist getSkuOnelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsSkuOnelistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.getSkuOnelistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSkuOnelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuOnelistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.delSkuOnelistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuOneServiceImpl.delSkuOnelistModelByCode.num");
        }
    }

    private void deleteSkuOnelistModel(Integer skuOnelistId) throws ApiException {
        if (null == skuOnelistId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuOnelistMapper.deleteByPrimaryKey(skuOnelistId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.deleteSkuOnelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuOneServiceImpl.deleteSkuOnelistModel.num");
        }
    }

    private void updateSkuOnelistModel(RsSkuOnelist rsSkuOnelist) throws ApiException {
        if (null == rsSkuOnelist) {
            return;
        }
        int i = 0;
        try {
            i = this.rsSkuOnelistMapper.updateByPrimaryKey(rsSkuOnelist);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateSkuOnelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateSkuOnelistModel.num");
        }
    }

    private void updateStateSkuOnelistModel(Integer skuOnelistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == skuOnelistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuOnelistId", skuOnelistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsSkuOnelistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateStateSkuOnelistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateStateSkuOnelistModel.null");
        }
    }

    private void updateStateSkuOnelistModelByCode(String tenantCode, String skuOnelistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)skuOnelistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuOnelistCode", skuOnelistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsSkuOnelistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateStateSkuOnelistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateStateSkuOnelistModelByCode.null");
        }
    }

    private RsSkuOnelist makeSkuOnelist(RsSkuOnelistDomain rsSkuOnelistDomain, RsSkuOnelist rsSkuOnelist) {
        if (null == rsSkuOnelistDomain) {
            return null;
        }
        if (null == rsSkuOnelist) {
            rsSkuOnelist = new RsSkuOnelist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuOnelist, (Object)rsSkuOnelistDomain);
            return rsSkuOnelist;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.makeSkuOnelist", (Throwable)e);
            return null;
        }
    }

    private RsSkuOnelistReDomain makeRsSkuOnelistReDomain(RsSkuOnelist rsSkuOnelist) {
        if (null == rsSkuOnelist) {
            return null;
        }
        RsSkuOnelistReDomain rsSkuOnelistReDomain = new RsSkuOnelistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuOnelistReDomain, (Object)rsSkuOnelist);
            return rsSkuOnelistReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.makeRsSkuOnelistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsSkuOnelistDomain> makeSkuOnelistDomain(List<RsSkuOnelist> rsSkuOnelistList) {
        if (ListUtil.isEmpty(rsSkuOnelistList)) {
            return null;
        }
        ArrayList<RsSkuOnelistDomain> rsSkuOnelistDomainList = new ArrayList<RsSkuOnelistDomain>();
        for (RsSkuOnelist rsSkuOnelist : rsSkuOnelistList) {
            RsSkuOnelistReDomain rsSkuOnelistDomain = this.makeRsSkuOnelistReDomain(rsSkuOnelist);
            if (null == rsSkuOnelistDomain) continue;
            rsSkuOnelistDomainList.add(rsSkuOnelistDomain);
        }
        return rsSkuOnelistDomainList;
    }

    private List<RsSkuOnelist> querySkuOnelistModelPage(Map<String, Object> parammap) {
        try {
            return this.rsSkuOnelistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.querySkuOnelistModel", (Throwable)e);
            return null;
        }
    }

    private int countSkuOnelist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsSkuOnelistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsSkuOneServiceImpl.countSkuOnelist", (Throwable)e);
        }
        return i;
    }

    private RsSkuOnelist createRsSkuOnelist(RsSkuOnelistDomain rsSkuOnelistDomain) {
        String msg = this.checkSkuOnelist(rsSkuOnelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuOneServiceImpl.saveSkuOnelist.checkSkuOnelist", msg);
        }
        RsSkuOnelist rsSkuOnelist = this.makeSkuOnelist(rsSkuOnelistDomain, null);
        this.setSkuOnelistDefault(rsSkuOnelist);
        return rsSkuOnelist;
    }

    @Override
    public String saveSkuOne(RsSkuOneDomain rsSkuOneDomain) throws ApiException {
        RsSkuOne rsSkuOne = this.createRsSkuOne(rsSkuOneDomain);
        this.saveSkuOneModel(rsSkuOne);
        this.updateSkuOneCache(rsSkuOne);
        return rsSkuOne.getSkuOneCode();
    }

    @Override
    public String saveOrUpdateSkuOneAndSkuOneList(RsSkuOneDomain rsSkuOneDomain) throws ApiException {
        String skuOneCode = "";
        if (null == rsSkuOneDomain.getSkuOneCode()) {
            skuOneCode = this.saveSkuOne(rsSkuOneDomain);
        } else {
            skuOneCode = rsSkuOneDomain.getSkuOneCode();
            this.updateSkuOne(rsSkuOneDomain);
        }
        if (ListUtil.isNotEmpty(rsSkuOneDomain.getRsSkuOnelistDomainList())) {
            rsSkuOneDomain.setSkuOneCode(skuOneCode);
            this.saveOrUpdateSkuOneList(rsSkuOneDomain, rsSkuOneDomain.getRsSkuOnelistDomainList());
        }
        return skuOneCode;
    }

    private void saveOrUpdateSkuOneList(RsSkuOneDomain rsSkuOneDomain, List<RsSkuOnelistDomain> rsSkuOnelistDomainList) {
        for (RsSkuOnelistDomain rsSkuOnelistDomain : rsSkuOnelistDomainList) {
            rsSkuOnelistDomain.setTenantCode(rsSkuOneDomain.getTenantCode());
            rsSkuOnelistDomain.setSkuOneCode(rsSkuOneDomain.getSkuOneCode());
            if (null == rsSkuOnelistDomain.getSkuOnelistCode()) {
                this.saveSkuOnelist(rsSkuOnelistDomain);
                continue;
            }
            this.updateSkuOnelist(rsSkuOnelistDomain);
        }
    }

    @Override
    public String saveSkuOneBatch(List<RsSkuOneDomain> rsSkuOneDomainList) throws ApiException {
        if (null == rsSkuOneDomainList || rsSkuOneDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsSkuOne> rsSkuOneList = new ArrayList<RsSkuOne>();
        String code = "";
        for (RsSkuOneDomain rsSkuOneDomain : rsSkuOneDomainList) {
            RsSkuOne rsSkuOne = this.createRsSkuOne(rsSkuOneDomain);
            code = rsSkuOne.getSkuOneCode();
            rsSkuOneList.add(rsSkuOne);
            this.updateSkuOneCache(rsSkuOne);
        }
        this.saveSkuOneBatchModel(rsSkuOneList);
        return code;
    }

    @Override
    public void updateSkuOneState(Integer skuOneId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == skuOneId) {
            return;
        }
        this.updateStateSkuOneModel(skuOneId, dataState, oldDataState, map);
    }

    @Override
    public void updateSkuOneStateByCode(String tenantCode, String skuOneCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)skuOneCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSkuOneModelByCode(tenantCode, skuOneCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSkuOne(RsSkuOneDomain rsSkuOneDomain) throws ApiException {
        String msg = this.checkSkuOne(rsSkuOneDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateSkuOne.checkSkuOne", msg);
        }
        RsSkuOne oldRsSkuOne = null;
        oldRsSkuOne = null == rsSkuOneDomain.getSkuOneId() && null != rsSkuOneDomain.getSkuOneCode() ? this.getSkuOneByCode(rsSkuOneDomain.getTenantCode(), rsSkuOneDomain.getSkuOneCode()) : this.getSkuOneModelById(rsSkuOneDomain.getSkuOneId());
        if (null == oldRsSkuOne) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateSkuOne.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsSkuOne rsSkuOne = this.makeSkuOne(rsSkuOneDomain, oldRsSkuOne);
        this.setSkuOneUpdataDefault(rsSkuOne);
        this.updateSkuOneModel(rsSkuOne);
        this.updateSkuOneCache(rsSkuOne);
    }

    @Override
    public RsSkuOne getSkuOne(Integer skuOneId) {
        if (null == skuOneId) {
            return null;
        }
        return this.getSkuOneModelById(skuOneId);
    }

    @Override
    public void deleteSkuOne(Integer skuOneId) throws ApiException {
        if (null == skuOneId) {
            return;
        }
        RsSkuOne skuOne = this.getSkuOne(skuOneId);
        this.deleteSkuOneCache(skuOne);
        this.deleteSkuOneModel(skuOneId);
    }

    @Override
    public QueryResult<RsSkuOne> querySkuOnePage(Map<String, Object> map) {
        List<RsSkuOne> rsSkuOneList = this.querySkuOneModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSkuOne(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuOneList);
        return queryResult;
    }

    @Override
    public RsSkuOne getSkuOneByCode(String tenantCode, String skuOneCode) throws ApiException {
        if (StringUtils.isBlank((String)skuOneCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuOneCode", skuOneCode);
        return this.getSkuOneModelByCode(map);
    }

    @Override
    public void deleteSkuOneByCode(String tenantCode, String skuOneCode) throws ApiException {
        if (StringUtils.isBlank((String)skuOneCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        RsSkuOne skuOneByCode = this.getSkuOneByCode(tenantCode, skuOneCode);
        this.deleteSkuOneCache(skuOneByCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuOneCode", skuOneCode);
        this.delSkuOneModelByCode(map);
    }

    @Override
    public String saveSkuOnelist(RsSkuOnelistDomain rsSkuOnelistDomain) throws ApiException {
        RsSkuOnelist rsSkuOnelist = this.createRsSkuOnelist(rsSkuOnelistDomain);
        this.saveSkuOnelistModel(rsSkuOnelist);
        return rsSkuOnelist.getSkuOnelistCode();
    }

    @Override
    public String saveSkuOnelistBatch(List<RsSkuOnelistDomain> rsSkuOnelistDomainList) throws ApiException {
        if (null == rsSkuOnelistDomainList || rsSkuOnelistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsSkuOnelist> rsSkuOnelistList = new ArrayList<RsSkuOnelist>();
        String code = "";
        for (RsSkuOnelistDomain rsSkuOnelistDomain : rsSkuOnelistDomainList) {
            RsSkuOnelist rsSkuOnelist = this.createRsSkuOnelist(rsSkuOnelistDomain);
            code = rsSkuOnelist.getSkuOnelistCode();
            rsSkuOnelistList.add(rsSkuOnelist);
        }
        this.saveSkuOnelistBatchModel(rsSkuOnelistList);
        return code;
    }

    @Override
    public void updateSkuOnelistState(Integer skuOnelistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == skuOnelistId) {
            return;
        }
        this.updateStateSkuOnelistModel(skuOnelistId, dataState, oldDataState, map);
    }

    @Override
    public void updateSkuOnelistStateByCode(String tenantCode, String skuOnelistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)skuOnelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSkuOnelistModelByCode(tenantCode, skuOnelistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSkuOnelist(RsSkuOnelistDomain rsSkuOnelistDomain) throws ApiException {
        String msg = this.checkSkuOnelist(rsSkuOnelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateSkuOnelist.checkSkuOnelist", msg);
        }
        RsSkuOnelist oldRsSkuOnelist = null;
        if (null != rsSkuOnelistDomain.getSkuOnelistId()) {
            oldRsSkuOnelist = this.getSkuOnelistModelById(rsSkuOnelistDomain.getSkuOnelistId());
        } else if (null == rsSkuOnelistDomain.getSkuOnelistId() && null != rsSkuOnelistDomain.getSkuOnelistCode()) {
            oldRsSkuOnelist = this.getSkuOnelistByCode(rsSkuOnelistDomain.getTenantCode(), rsSkuOnelistDomain.getSkuOnelistCode());
        }
        if (null == oldRsSkuOnelist) {
            throw new ApiException("rs.RsSkuOneServiceImpl.updateSkuOnelist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsSkuOnelist rsSkuOnelist = this.makeSkuOnelist(rsSkuOnelistDomain, oldRsSkuOnelist);
        this.setSkuOnelistUpdataDefault(rsSkuOnelist);
        this.updateSkuOnelistModel(rsSkuOnelist);
    }

    @Override
    public RsSkuOnelist getSkuOnelist(Integer skuOnelistId) {
        if (null == skuOnelistId) {
            return null;
        }
        return this.getSkuOnelistModelById(skuOnelistId);
    }

    @Override
    public void deleteSkuOnelist(Integer skuOnelistId) throws ApiException {
        if (null == skuOnelistId) {
            return;
        }
        this.deleteSkuOnelistModel(skuOnelistId);
    }

    @Override
    public QueryResult<RsSkuOnelist> querySkuOnelistPage(Map<String, Object> map) {
        List<RsSkuOnelist> rsSkuOnelistList = this.querySkuOnelistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSkuOnelist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsSkuOnelistList);
        return queryResult;
    }

    @Override
    public RsSkuOnelist getSkuOnelistByCode(String tenantCode, String skuOnelistCode) throws ApiException {
        if (StringUtils.isBlank((String)skuOnelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuOnelistCode", skuOnelistCode);
        return this.getSkuOnelistModelByCode(map);
    }

    @Override
    public void deleteSkuOnelistByCode(String tenantCode, String skuOnelistCode) throws ApiException {
        if (StringUtils.isBlank((String)skuOnelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("skuOnelistCode", skuOnelistCode);
        this.delSkuOnelistModelByCode(map);
    }

    private void deleteSkuOneCache(RsSkuOne skuOne) {
        String key;
        String json;
        if (null == skuOne) {
            return;
        }
        if (StringUtils.isBlank((String)skuOne.getChannelCode())) {
            skuOne.setChannelCode("all");
        }
        if (StringUtils.isBlank((String)skuOne.getGoodsNo())) {
            skuOne.setGoodsNo("all");
        }
        if (StringUtils.isBlank((String)skuOne.getSkuNo())) {
            skuOne.setSkuNo("all");
        }
        if (StringUtils.isBlank((String)(json = DisUtil.getRemotMap((String)this.cachekey, (String)(key = skuOne.getChannelCode() + "-" + skuOne.getGoodsNo() + "-" + skuOne.getSkuNo() + "-" + skuOne.getTenantCode()))))) {
            return;
        }
        List mlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, RsSkuOneDomain.class);
        ArrayList<RsSkuOneDomain> mlist2 = new ArrayList<RsSkuOneDomain>();
        if (ListUtil.isNotEmpty((Collection)mlist)) {
            for (RsSkuOneDomain rsSkuOneDomain : mlist) {
                if (rsSkuOneDomain.getSkuOneCode().equals(rsSkuOneDomain.getSkuOneCode())) continue;
                mlist2.add(rsSkuOneDomain);
            }
        }
        DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(mlist2));
    }

    private void updateSkuOneCache(RsSkuOne skuOne) {
        if (null == skuOne) {
            return;
        }
        if (StringUtils.isBlank((String)skuOne.getChannelCode())) {
            skuOne.setChannelCode("all");
        }
        if (StringUtils.isBlank((String)skuOne.getGoodsNo())) {
            skuOne.setGoodsNo("all");
        }
        if (StringUtils.isBlank((String)skuOne.getSkuNo())) {
            skuOne.setSkuNo("all");
        }
        RsSkuOneDomain skuOneDomain = this.makeSkuOneDomain(skuOne, null);
        List<RsSkuOnelist> rsSkuOnelists = this.querySkuOnelistModelPage(this.getQueryParamMap("tenantCode,skuOneCode", new Object[]{skuOneDomain.getTenantCode(), skuOneDomain.getSkuOneCode()}));
        skuOneDomain.setRsSkuOnelistDomainList(this.makeSkuOnelistDomain(rsSkuOnelists));
        String key = skuOne.getChannelCode() + "-" + skuOne.getGoodsNo() + "-" + skuOne.getSkuNo() + "-" + skuOne.getTenantCode();
        String json = DisUtil.getRemotMap((String)this.cachekey, (String)key);
        if (StringUtils.isBlank((String)json)) {
            ArrayList<RsSkuOneDomain> mlist = new ArrayList<RsSkuOneDomain>();
            mlist.add(skuOneDomain);
            DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(mlist));
        } else {
            List mlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, RsSkuOneDomain.class);
            ArrayList<RsSkuOneDomain> mprlist = new ArrayList<RsSkuOneDomain>();
            if (ListUtil.isNotEmpty((Collection)mlist)) {
                boolean flag = false;
                for (RsSkuOneDomain rsSkuOneDomain : mlist) {
                    if (rsSkuOneDomain.getSkuOneCode().equals(rsSkuOneDomain.getSkuOneCode())) {
                        flag = true;
                        mprlist.add(skuOneDomain);
                        continue;
                    }
                    mprlist.add(rsSkuOneDomain);
                }
                if (!flag) {
                    mprlist.add(skuOneDomain);
                }
            } else {
                mprlist.add(skuOneDomain);
            }
            DisUtil.setMapVer((String)this.cachekey, (String)key, (String)JsonUtil.buildNormalBinder().toJson(mprlist));
        }
    }

    @Override
    public void querySkuOneLoadCache() {
        this.logger.info("SkuOneServiceImpl.querySalequotaLoadCache", (Object)"===========start==========");
        List<RsSkuOne> rsSkuOneList = this.querySkuOneModelPage(new HashMap<String, Object>());
        if (null == rsSkuOneList || rsSkuOneList.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("SkuOneServiceImpl.querySalequotaLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, ArrayList<RsSkuOneDomain>> ddListMap = new ConcurrentHashMap<String, ArrayList<RsSkuOneDomain>>();
        for (RsSkuOne skuOne : rsSkuOneList) {
            if (StringUtils.isBlank((String)skuOne.getChannelCode())) {
                skuOne.setChannelCode("all");
            }
            if (StringUtils.isBlank((String)skuOne.getGoodsNo())) {
                skuOne.setGoodsNo("all");
            }
            if (StringUtils.isBlank((String)skuOne.getSkuNo())) {
                skuOne.setSkuNo("all");
            }
            String key = skuOne.getChannelCode() + "-" + skuOne.getGoodsNo() + "-" + skuOne.getSkuNo() + "-" + skuOne.getTenantCode();
            RsSkuOneDomain rsSkuOneDomain = this.makeSkuOneDomain(skuOne, null);
            List<RsSkuOnelist> rsSkuOnelists = this.querySkuOnelistModelPage(this.getQueryParamMap("tenantCode,skuOneCode", new Object[]{rsSkuOneDomain.getTenantCode(), rsSkuOneDomain.getSkuOneCode()}));
            rsSkuOneDomain.setRsSkuOnelistDomainList(this.makeSkuOnelistDomain(rsSkuOnelists));
            ArrayList<RsSkuOneDomain> slist = (ArrayList<RsSkuOneDomain>)ddListMap.get(key);
            if (null == slist) {
                slist = new ArrayList<RsSkuOneDomain>();
                ddListMap.put(key, slist);
            }
            slist.add(rsSkuOneDomain);
        }
        for (String key : ddListMap.keySet()) {
            ddMap.put(key, JsonUtil.buildNormalBinder().toJson(ddListMap.get(key)));
        }
        DisUtil.setMapVer((String)this.cachekey, ddMap);
        this.logger.info("SkuOneServiceImpl.querySalequotaLoadCache", (Object)"===========add-end==========");
    }
}

