/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsStoreRuleMapper;
import com.yqbsoft.laser.service.resources.domain.RsStoreRuleDomain;
import com.yqbsoft.laser.service.resources.domain.RsStoreRuleReDomain;
import com.yqbsoft.laser.service.resources.model.RsStoreRule;
import com.yqbsoft.laser.service.resources.service.RsLaundryGoodsService;
import com.yqbsoft.laser.service.resources.service.RsStoreRuleService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsStoreRuleServiceImpl
extends BaseServiceImpl
implements RsStoreRuleService {
    private static final String SYS_CODE = "rs.RsStoreRuleServiceImpl";
    private RsStoreRuleMapper rsStoreRuleMapper;
    private RsLaundryGoodsService rsLaundryGoodsService;

    public RsLaundryGoodsService getRsLaundryGoodsService() {
        return this.rsLaundryGoodsService;
    }

    public void setRsLaundryGoodsService(RsLaundryGoodsService rsLaundryGoodsService) {
        this.rsLaundryGoodsService = rsLaundryGoodsService;
    }

    public void setRsStoreRuleMapper(RsStoreRuleMapper rsStoreRuleMapper) {
        this.rsStoreRuleMapper = rsStoreRuleMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsStoreRuleMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreRuleServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkStoreRule(RsStoreRuleDomain rsStoreRuleDomain) {
        if (null == rsStoreRuleDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsStoreRuleDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setStoreRuleDefault(RsStoreRule rsStoreRule) {
        if (null == rsStoreRule) {
            return;
        }
        if (null == rsStoreRule.getDataState()) {
            rsStoreRule.setDataState(0);
        }
        if (null == rsStoreRule.getGmtCreate()) {
            rsStoreRule.setGmtCreate(this.getSysDate());
        }
        rsStoreRule.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)rsStoreRule.getRuleCode())) {
            rsStoreRule.setRuleCode(this.getNo(null, "RsStoreRule", "rsStoreRule", rsStoreRule.getTenantCode()));
        }
    }

    private int getStoreRuleMaxCode() {
        int code = 0;
        try {
            return this.rsStoreRuleMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreRuleServiceImpl.getStoreRuleMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStoreRuleUpdataDefault(RsStoreRule rsStoreRule) {
        if (null == rsStoreRule) {
            return;
        }
        rsStoreRule.setGmtModified(this.getSysDate());
    }

    private void saveStoreRuleModel(RsStoreRule rsStoreRule) throws ApiException {
        if (null == rsStoreRule) {
            return;
        }
        try {
            this.rsStoreRuleMapper.insert(rsStoreRule);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreRuleServiceImpl.saveStoreRuleModel.ex", (Throwable)e);
        }
    }

    private void saveStoreRuleBatchModel(List<RsStoreRule> rsStoreRuleList) throws ApiException {
        if (null == rsStoreRuleList || rsStoreRuleList.isEmpty()) {
            return;
        }
        try {
            this.rsStoreRuleMapper.insertBatch(rsStoreRuleList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreRuleServiceImpl.saveStoreRuleBatchModel.ex", (Throwable)e);
        }
    }

    private RsStoreRule getStoreRuleModelById(Integer ruleId) {
        if (null == ruleId) {
            return null;
        }
        try {
            return this.rsStoreRuleMapper.selectByPrimaryKey(ruleId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreRuleServiceImpl.getStoreRuleModelById", (Throwable)e);
            return null;
        }
    }

    private RsStoreRule getStoreRuleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsStoreRuleMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreRuleServiceImpl.getStoreRuleModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delStoreRuleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsStoreRuleMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreRuleServiceImpl.delStoreRuleModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsStoreRuleServiceImpl.delStoreRuleModelByCode.num");
        }
    }

    private void deleteStoreRuleModel(Integer ruleId) throws ApiException {
        if (null == ruleId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsStoreRuleMapper.deleteByPrimaryKey(ruleId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreRuleServiceImpl.deleteStoreRuleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsStoreRuleServiceImpl.deleteStoreRuleModel.num");
        }
    }

    private void updateStoreRuleModel(RsStoreRule rsStoreRule) throws ApiException {
        if (null == rsStoreRule) {
            return;
        }
        int i = 0;
        try {
            i = this.rsStoreRuleMapper.updateByPrimaryKeySelective(rsStoreRule);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreRuleServiceImpl.updateStoreRuleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsStoreRuleServiceImpl.updateStoreRuleModel.num");
        }
    }

    private void updateStateStoreRuleModel(Integer ruleId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ruleId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ruleId", ruleId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsStoreRuleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreRuleServiceImpl.updateStateStoreRuleModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsStoreRuleServiceImpl.updateStateStoreRuleModel.null");
        }
    }

    private void updateStateStoreRuleModelByCode(String tenantCode, String ruleCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ruleCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ruleCode", ruleCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsStoreRuleMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreRuleServiceImpl.updateStateStoreRuleModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsStoreRuleServiceImpl.updateStateStoreRuleModelByCode.null");
        }
    }

    private RsStoreRule makeStoreRule(RsStoreRuleDomain rsStoreRuleDomain, RsStoreRule rsStoreRule) {
        if (null == rsStoreRuleDomain) {
            return null;
        }
        if (null == rsStoreRule) {
            rsStoreRule = new RsStoreRule();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsStoreRule, (Object)rsStoreRuleDomain);
            return rsStoreRule;
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreRuleServiceImpl.makeStoreRule", (Throwable)e);
            return null;
        }
    }

    private RsStoreRuleReDomain makeRsStoreRuleReDomain(RsStoreRule rsStoreRule) {
        if (null == rsStoreRule) {
            return null;
        }
        RsStoreRuleReDomain rsStoreRuleReDomain = new RsStoreRuleReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsStoreRuleReDomain, (Object)rsStoreRule);
            return rsStoreRuleReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreRuleServiceImpl.makeRsStoreRuleReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsStoreRule> queryStoreRuleModelPage(Map<String, Object> parammap) {
        try {
            return this.rsStoreRuleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreRuleServiceImpl.queryStoreRuleModel", (Throwable)e);
            return null;
        }
    }

    private int countStoreRule(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsStoreRuleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsStoreRuleServiceImpl.countStoreRule", (Throwable)e);
        }
        return i;
    }

    private RsStoreRule createRsStoreRule(RsStoreRuleDomain rsStoreRuleDomain) {
        String msg = this.checkStoreRule(rsStoreRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsStoreRuleServiceImpl.saveStoreRule.checkStoreRule", msg);
        }
        RsStoreRule rsStoreRule = this.makeStoreRule(rsStoreRuleDomain, null);
        this.setStoreRuleDefault(rsStoreRule);
        return rsStoreRule;
    }

    @Override
    public String saveStoreRule(RsStoreRuleDomain rsStoreRuleDomain) throws ApiException {
        RsStoreRule rsStoreRule = this.createRsStoreRule(rsStoreRuleDomain);
        this.saveStoreRuleModel(rsStoreRule);
        return rsStoreRule.getRuleCode();
    }

    @Override
    public String saveStoreRuleBatch(List<RsStoreRuleDomain> rsStoreRuleDomainList) throws ApiException {
        if (null == rsStoreRuleDomainList || rsStoreRuleDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsStoreRule> rsStoreRuleList = new ArrayList<RsStoreRule>();
        String code = "";
        for (RsStoreRuleDomain rsStoreRuleDomain : rsStoreRuleDomainList) {
            RsStoreRule rsStoreRule = this.createRsStoreRule(rsStoreRuleDomain);
            code = rsStoreRule.getRuleCode();
            rsStoreRuleList.add(rsStoreRule);
        }
        this.saveStoreRuleBatchModel(rsStoreRuleList);
        return code;
    }

    @Override
    public void updateStoreRuleState(Integer ruleId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateStoreRuleModel(ruleId, dataState, oldDataState, map);
    }

    @Override
    public void updateStoreRuleStateByCode(String tenantCode, String ruleCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateStoreRuleModelByCode(tenantCode, ruleCode, dataState, oldDataState, map);
    }

    @Override
    public void updateStoreRule(RsStoreRuleDomain rsStoreRuleDomain) throws ApiException {
        String msg = this.checkStoreRule(rsStoreRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsStoreRuleServiceImpl.updateStoreRule.checkStoreRule", msg);
        }
        RsStoreRule oldRsStoreRule = this.getStoreRuleModelById(rsStoreRuleDomain.getRuleId());
        if (null == oldRsStoreRule) {
            throw new ApiException("rs.RsStoreRuleServiceImpl.updateStoreRule.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsStoreRule rsStoreRule = this.makeStoreRule(rsStoreRuleDomain, oldRsStoreRule);
        this.setStoreRuleUpdataDefault(rsStoreRule);
        this.updateStoreRuleModel(rsStoreRule);
    }

    @Override
    public RsStoreRule getStoreRule(Integer ruleId) {
        return this.getStoreRuleModelById(ruleId);
    }

    @Override
    public void deleteStoreRule(Integer ruleId) throws ApiException {
        this.deleteStoreRuleModel(ruleId);
    }

    @Override
    public QueryResult<RsStoreRule> queryStoreRulePage(Map<String, Object> map) {
        List<RsStoreRule> rsStoreRuleList = this.queryStoreRuleModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStoreRule(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsStoreRuleList);
        return queryResult;
    }

    @Override
    public RsStoreRule getStoreRuleByCode(String tenantCode, String ruleCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ruleCode", ruleCode);
        return this.getStoreRuleModelByCode(map);
    }

    @Override
    public void deleteStoreRuleByCode(String tenantCode, String ruleCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ruleCode", ruleCode);
        this.delStoreRuleModelByCode(map);
    }

    @Override
    public void updateStoreRulePrice(Integer ruleId, String subMoney, Map<String, Object> map) throws ApiException {
        RsStoreRule rsStoreRule = this.getStoreRuleModelById(ruleId);
        if (null == rsStoreRule || StringUtils.isBlank((String)subMoney)) {
            this.logger.error("rs.RsStoreRuleServiceImpl.updateStoreRulePrice", (Object)("isnull" + ruleId + "subMoney" + subMoney));
        }
        BigDecimal pricesetNprice = new BigDecimal(subMoney);
        this.updateStoreRulePriceModel(ruleId, pricesetNprice, map);
        this.rsLaundryGoodsService.updateLaundryGoodsPrice(rsStoreRule.getSkuCode(), rsStoreRule.getTenantCode(), null, rsStoreRule.getCityCode(), rsStoreRule.getAreaCode(), subMoney, null, null, null);
    }

    private void updateStoreRulePriceModel(Integer ruleId, BigDecimal pricesetNprice, Map<String, Object> expmap) throws ApiException {
        if (null == ruleId || null == pricesetNprice) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ruleId", ruleId);
        map.put("pricesetNprice", pricesetNprice);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsStoreRuleMapper.updateStoreRulePrice(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsStoreRuleServiceImpl.updateStoreRulePriceModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsStoreRuleServiceImpl.updateStoreRulePriceModel.null" + map);
        }
    }
}

