/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.resources.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.dao.RsPntreeRelMapper;
import com.yqbsoft.laser.service.resources.domain.RsPntreeRelDomain;
import com.yqbsoft.laser.service.resources.domain.RsPntreeRelReDomain;
import com.yqbsoft.laser.service.resources.model.RsPntreeRel;
import com.yqbsoft.laser.service.resources.service.RsPntreeRelService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RsPntreeRelServiceImpl
extends BaseServiceImpl
implements RsPntreeRelService {
    private static final String SYS_CODE = "rs.RsPntreeRelServiceImpl";
    private RsPntreeRelMapper rsPntreeRelMapper;

    public void setRsPntreeRelMapper(RsPntreeRelMapper rsPntreeRelMapper) {
        this.rsPntreeRelMapper = rsPntreeRelMapper;
    }

    private Date getSysDate() {
        try {
            return this.rsPntreeRelMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeRelServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPntreeRel(RsPntreeRelDomain rsPntreeRelDomain) {
        if (null == rsPntreeRelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsPntreeRelDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPntreeRelDefault(RsPntreeRel rsPntreeRel) {
        if (null == rsPntreeRel) {
            return;
        }
        if (null == rsPntreeRel.getDataState()) {
            rsPntreeRel.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == rsPntreeRel.getGmtCreate()) {
            rsPntreeRel.setGmtCreate(date);
        }
        rsPntreeRel.setGmtModified(date);
        if (StringUtils.isBlank((String)rsPntreeRel.getPntreeRelCode())) {
            rsPntreeRel.setPntreeRelCode(this.getNo(null, "RsPntreeRel", "rsPntreeRel", rsPntreeRel.getTenantCode()));
        }
    }

    private int getPntreeRelMaxCode() {
        int code = 0;
        try {
            return this.rsPntreeRelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeRelServiceImpl.getPntreeRelMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPntreeRelUpdataDefault(RsPntreeRel rsPntreeRel) {
        if (null == rsPntreeRel) {
            return;
        }
        rsPntreeRel.setGmtModified(this.getSysDate());
    }

    private void savePntreeRelModel(RsPntreeRel rsPntreeRel) throws ApiException {
        if (null == rsPntreeRel) {
            return;
        }
        try {
            this.rsPntreeRelMapper.insert(rsPntreeRel);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPntreeRelServiceImpl.savePntreeRelModel.ex", (Throwable)e);
        }
    }

    private void savePntreeRelBatchModel(List<RsPntreeRel> rsPntreeRelList) throws ApiException {
        if (null == rsPntreeRelList || rsPntreeRelList.isEmpty()) {
            return;
        }
        try {
            this.rsPntreeRelMapper.insertBatch(rsPntreeRelList);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPntreeRelServiceImpl.savePntreeRelBatchModel.ex", (Throwable)e);
        }
    }

    private RsPntreeRel getPntreeRelModelById(Integer pntreeRelId) {
        if (null == pntreeRelId) {
            return null;
        }
        try {
            return this.rsPntreeRelMapper.selectByPrimaryKey(pntreeRelId);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeRelServiceImpl.getPntreeRelModelById", (Throwable)e);
            return null;
        }
    }

    private RsPntreeRel getPntreeRelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.rsPntreeRelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeRelServiceImpl.getPntreeRelModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPntreeRelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.rsPntreeRelMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPntreeRelServiceImpl.delPntreeRelModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsPntreeRelServiceImpl.delPntreeRelModelByCode.num");
        }
    }

    private void deletePntreeRelModel(Integer pntreeRelId) throws ApiException {
        if (null == pntreeRelId) {
            return;
        }
        int i = 0;
        try {
            i = this.rsPntreeRelMapper.deleteByPrimaryKey(pntreeRelId);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPntreeRelServiceImpl.deletePntreeRelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsPntreeRelServiceImpl.deletePntreeRelModel.num");
        }
    }

    private void updatePntreeRelModel(RsPntreeRel rsPntreeRel) throws ApiException {
        if (null == rsPntreeRel) {
            return;
        }
        int i = 0;
        try {
            i = this.rsPntreeRelMapper.updateByPrimaryKey(rsPntreeRel);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPntreeRelServiceImpl.updatePntreeRelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("rs.RsPntreeRelServiceImpl.updatePntreeRelModel.num");
        }
    }

    private void updateStatePntreeRelModel(Integer pntreeRelId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pntreeRelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pntreeRelId", pntreeRelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsPntreeRelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPntreeRelServiceImpl.updateStatePntreeRelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsPntreeRelServiceImpl.updateStatePntreeRelModel.null");
        }
    }

    private void updateStatePntreeRelModelByCode(String tenantCode, String pntreeRelCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pntreeRelCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pntreeRelCode", pntreeRelCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.rsPntreeRelMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("rs.RsPntreeRelServiceImpl.updateStatePntreeRelModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("rs.RsPntreeRelServiceImpl.updateStatePntreeRelModelByCode.null");
        }
    }

    private RsPntreeRel makePntreeRel(RsPntreeRelDomain rsPntreeRelDomain, RsPntreeRel rsPntreeRel) {
        if (null == rsPntreeRelDomain) {
            return null;
        }
        if (null == rsPntreeRel) {
            rsPntreeRel = new RsPntreeRel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rsPntreeRel, (Object)rsPntreeRelDomain);
            return rsPntreeRel;
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeRelServiceImpl.makePntreeRel", (Throwable)e);
            return null;
        }
    }

    private RsPntreeRelReDomain makeRsPntreeRelReDomain(RsPntreeRel rsPntreeRel) {
        if (null == rsPntreeRel) {
            return null;
        }
        RsPntreeRelReDomain rsPntreeRelReDomain = new RsPntreeRelReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsPntreeRelReDomain, (Object)rsPntreeRel);
            return rsPntreeRelReDomain;
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeRelServiceImpl.makeRsPntreeRelReDomain", (Throwable)e);
            return null;
        }
    }

    private List<RsPntreeRel> queryPntreeRelModelPage(Map<String, Object> parammap) {
        try {
            return this.rsPntreeRelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeRelServiceImpl.queryPntreeRelModel", (Throwable)e);
            return null;
        }
    }

    private int countPntreeRel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rsPntreeRelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("rs.RsPntreeRelServiceImpl.countPntreeRel", (Throwable)e);
        }
        return i;
    }

    private RsPntreeRel createRsPntreeRel(RsPntreeRelDomain rsPntreeRelDomain) {
        String msg = this.checkPntreeRel(rsPntreeRelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsPntreeRelServiceImpl.savePntreeRel.checkPntreeRel", msg);
        }
        RsPntreeRel rsPntreeRel = this.makePntreeRel(rsPntreeRelDomain, null);
        this.setPntreeRelDefault(rsPntreeRel);
        return rsPntreeRel;
    }

    @Override
    public String savePntreeRel(RsPntreeRelDomain rsPntreeRelDomain) throws ApiException {
        RsPntreeRel rsPntreeRel = this.createRsPntreeRel(rsPntreeRelDomain);
        this.savePntreeRelModel(rsPntreeRel);
        return rsPntreeRel.getPntreeRelCode();
    }

    @Override
    public String savePntreeRelBatch(List<RsPntreeRelDomain> rsPntreeRelDomainList) throws ApiException {
        if (null == rsPntreeRelDomainList || rsPntreeRelDomainList.isEmpty()) {
            return null;
        }
        ArrayList<RsPntreeRel> rsPntreeRelList = new ArrayList<RsPntreeRel>();
        String code = "";
        for (RsPntreeRelDomain rsPntreeRelDomain : rsPntreeRelDomainList) {
            RsPntreeRel rsPntreeRel = this.createRsPntreeRel(rsPntreeRelDomain);
            code = rsPntreeRel.getPntreeRelCode();
            rsPntreeRelList.add(rsPntreeRel);
        }
        this.savePntreeRelBatchModel(rsPntreeRelList);
        return code;
    }

    @Override
    public void updatePntreeRelState(Integer pntreeRelId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pntreeRelId) {
            return;
        }
        this.updateStatePntreeRelModel(pntreeRelId, dataState, oldDataState, map);
    }

    @Override
    public void updatePntreeRelStateByCode(String tenantCode, String pntreeRelCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pntreeRelCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePntreeRelModelByCode(tenantCode, pntreeRelCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePntreeRel(RsPntreeRelDomain rsPntreeRelDomain) throws ApiException {
        String msg = this.checkPntreeRel(rsPntreeRelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("rs.RsPntreeRelServiceImpl.updatePntreeRel.checkPntreeRel", msg);
        }
        RsPntreeRel oldRsPntreeRel = this.getPntreeRelModelById(rsPntreeRelDomain.getPntreeRelId());
        if (null == oldRsPntreeRel) {
            throw new ApiException("rs.RsPntreeRelServiceImpl.updatePntreeRel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RsPntreeRel rsPntreeRel = this.makePntreeRel(rsPntreeRelDomain, oldRsPntreeRel);
        this.setPntreeRelUpdataDefault(rsPntreeRel);
        this.updatePntreeRelModel(rsPntreeRel);
    }

    @Override
    public RsPntreeRel getPntreeRel(Integer pntreeRelId) {
        if (null == pntreeRelId) {
            return null;
        }
        return this.getPntreeRelModelById(pntreeRelId);
    }

    @Override
    public void deletePntreeRel(Integer pntreeRelId) throws ApiException {
        if (null == pntreeRelId) {
            return;
        }
        this.deletePntreeRelModel(pntreeRelId);
    }

    @Override
    public QueryResult<RsPntreeRel> queryPntreeRelPage(Map<String, Object> map) {
        List<RsPntreeRel> rsPntreeRelList = this.queryPntreeRelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPntreeRel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rsPntreeRelList);
        return queryResult;
    }

    @Override
    public RsPntreeRel getPntreeRelByCode(String tenantCode, String pntreeRelCode) throws ApiException {
        if (StringUtils.isBlank((String)pntreeRelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pntreeRelCode", pntreeRelCode);
        return this.getPntreeRelModelByCode(map);
    }

    @Override
    public void deletePntreeRelByCode(String tenantCode, String pntreeRelCode) throws ApiException {
        if (StringUtils.isBlank((String)pntreeRelCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pntreeRelCode", pntreeRelCode);
        this.delPntreeRelModelByCode(map);
    }
}

