/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.route.matching.check;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.AppModelAppValue;
import com.yqbsoft.laser.service.route.matching.check.AbstractValueCheck;
import com.yqbsoft.laser.service.route.matching.util.AppModelContext;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;

public class BetweenValueCheck
extends AbstractValueCheck {
    private static final long serialVersionUID = 1289284838798173554L;
    private static final String sys_code = "ecore.ESB.CORE.BetweenValueCheck";

    @Override
    public boolean checkValue(Object inValue, AppModelContext appModelContext) throws ApiException {
        if (null == appModelContext) {
            throw new ApiException(sys_code, "objects length error");
        }
        if (null == appModelContext.getAppModelValue().getAppvalueList() || appModelContext.getAppModelValue().getAppvalueList().isEmpty()) {
            if (null == appModelContext.getModelValue() || appModelContext.getModelValue().length < 2) {
                throw new ApiException(sys_code, "objects length error");
            }
            return this.compareValue(inValue, appModelContext.getModelValue());
        }
        for (AppModelAppValue appModelAppValue : appModelContext.getAppModelValue().getAppvalueList()) {
            if (null == appModelAppValue || null == appModelAppValue.getParamValue() || null == appModelAppValue.getParamValue2() || !this.compareValue(inValue, appModelAppValue.getParamValue(), appModelAppValue.getParamValue2())) continue;
            appModelContext.getAppModelValue().setAppmanageIcode(appModelAppValue.getAppmanageIcode());
            appModelContext.getAppModelValue().setParamValue(appModelAppValue.getParamValue());
            appModelContext.getAppModelValue().setParamValue2(appModelAppValue.getParamValue2());
            return true;
        }
        return false;
    }

    private boolean compareValue(Object inValue, Object ... objects) {
        if (null == objects) {
            throw new ApiException(sys_code, "objects null");
        }
        try {
            Integer value = Integer.valueOf(inValue.toString());
            Integer checkValue1 = Integer.valueOf(objects[0].toString());
            Integer checkValue2 = Integer.valueOf(objects[1].toString());
            if (value >= checkValue1 && value <= checkValue2) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            throw new ApiException(sys_code, "value type is not number");
        }
        return false;
    }

    @Override
    public String getParamValue(Map<String, String> incomingMap, String paramName) {
        if (null == incomingMap || incomingMap.isEmpty() || StringUtils.isBlank((String)paramName)) {
            return null;
        }
        String[] ketStr = paramName.split("\\.");
        String vstr = "";
        Map valueMap = incomingMap;
        for (int i = 0; i < ketStr.length; ++i) {
            if (StringUtils.isNotBlank((String)vstr)) {
                valueMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(vstr, String.class, String.class);
            }
            if (null == valueMap) {
                return null;
            }
            vstr = (String)valueMap.get(ketStr[i]);
        }
        return vstr;
    }
}

