/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.route.matching.pre0;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.handler.InvokeContext;
import com.yqbsoft.laser.service.esb.core.handler.InvokeHandlerUnit;
import com.yqbsoft.laser.service.esb.core.handler.InvokeResult;
import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.esb.core.router.AppModelValue;
import com.yqbsoft.laser.service.esb.core.router.AppmodelParam;
import com.yqbsoft.laser.service.esb.core.router.CheckStrategy;
import com.yqbsoft.laser.service.esb.core.router.LocalCache;
import com.yqbsoft.laser.service.esb.core.router.Pre0Validator;
import com.yqbsoft.laser.service.route.matching.util.AppModelContext;
import com.yqbsoft.laser.service.route.matching.util.ModelMathingUtil;
import com.yqbsoft.laser.service.route.matching.util.WeightContext;
import com.yqbsoft.laser.service.route.matching.util.WeightMathingUtil;
import com.yqbsoft.laser.service.suppercore.core.Invoke;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.router.ApiRouterProperty;
import com.yqbsoft.laser.service.suppercore.router.AppProperty;
import com.yqbsoft.laser.service.tool.VfinOpenConstants;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.TokenUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class ModelRouteValidator
extends Pre0Validator
implements InvokeHandlerUnit {
    private static final OpenLogUtil logger = new OpenLogUtil(ModelRouteValidator.class);
    private static final String JAR_APPMANAGE_ICODE = "jarAppmanageIcode";

    public InvokeResult execute(InvokeContext context) throws ApiException {
        String nowAppicode = ServletMain.getAppName();
        logger.info("ModelRouteValidator.nowAppicode", (Object)(nowAppicode + " apppapiCalltype:" + context.getApiProperty().getAppapiCalltype() + ",toAppCode:" + context.getToAppProperty().getAppmanageIcode()));
        if (nowAppicode.equals("laser") ? !VfinOpenConstants.APPAPI_CALLTYPE_PRODUCT.equals(context.getApiProperty().getAppapiCalltype()) : !VfinOpenConstants.APPAPI_CALLTYPE_PRODUCT.equals(context.getApiProperty().getAppapiCalltype()) || !nowAppicode.equals(context.getToAppProperty().getAppmanageRicode())) {
            return new InvokeResult();
        }
        String appmanageApptype = context.getApiAppProperty().getAppmanageApptype();
        logger.info("ModelRouteValidator.appmanageApptype", (Object)("appmanageApptype:" + appmanageApptype));
        if (StringUtils.isNotBlank((String)appmanageApptype)) {
            ArrayList<WeightContext> keys = new ArrayList<WeightContext>();
            List<AppmodelParam> appModelList = this.getAppModelParamList(appmanageApptype);
            if (ListUtil.isEmpty(appModelList)) {
                return new InvokeResult("ecore.ESB.CORE.getway.app", context.getApiKey() + "-\u6a21\u578b\u53c2\u6570\u5bf9\u7167\u672a\u8bbe\u7f6e");
            }
            Map<String, AppmodelParam> appModelParamMap = this.makeAppModelMap(appModelList);
            Map<String, List<AppModelValue>> appIcodeModelValueMap = this.getAppModelValueMap(appmanageApptype);
            if (MapUtil.isEmpty(appIcodeModelValueMap)) {
                return new InvokeResult("ecore.ESB.CORE.getway.app", context.getApiKey() + "-\u4ea7\u54c1\u6a21\u578b\u503c\u672a\u8bbe\u7f6e");
            }
            Map<String, String> checkMap = this.makeCheckMap(context);
            logger.info("ModelRouteValidator.checkMap", (Object)JsonUtil.buildNormalBinder().toJson(checkMap));
            for (String key : appIcodeModelValueMap.keySet()) {
                List<AppModelValue> appIcodeValueList = appIcodeModelValueMap.get(key);
                logger.info("ModelRouteValidator.appIcodeValueList", (Object)JsonUtil.buildNormalBinder().toJson(appIcodeValueList));
                boolean matchingFlag = true;
                boolean defaultPro = false;
                logger.info("ModelRouteValidator.appIcodeValueList", (Object)JsonUtil.buildNormalBinder().toJson(appIcodeValueList));
                for (AppModelValue appModelValue : appIcodeValueList) {
                    AppmodelParam appmodelParam = appModelParamMap.get(appModelValue.getAppmodelCode());
                    logger.info("ModelRouteValidator.appmodelParam", (Object)JsonUtil.buildNormalBinder().toJson((Object)appmodelParam));
                    if (appmodelParam == null) continue;
                    matchingFlag = ModelMathingUtil.matches(new AppModelContext(appmodelParam, appModelValue), checkMap, CheckStrategy.StrategyType.VALUE);
                    logger.info("ModelRouteValidator", (Object)("matchingFlag:" + matchingFlag + ",appModelValue:" + appModelValue.getParamValue()));
                    if (matchingFlag) continue;
                    String testing = context.getInMessage().getParam("sys_product_testing");
                    if (!"test".equals(testing) && !context.isTestFlag() || !"test".equals(appModelValue.getParamValue())) break;
                    matchingFlag = true;
                    defaultPro = true;
                }
                if (!matchingFlag) continue;
                this.add2Weights(keys, key, appIcodeValueList, defaultPro);
            }
            if (ListUtil.isNotEmpty(keys)) {
                logger.info("ModelRouteValidator", (Object)("keys.size:" + keys.size()));
                WeightContext wcontext = WeightMathingUtil.selection(keys, null);
                String appIcode = wcontext.getAppmanageIcode();
                logger.info("ModelRouteValidator", (Object)("appIcode:" + wcontext.getAppmanageIcode()));
                context.getInMessage().getSysParamMap().put("sys_product_code", wcontext.getProductCode());
                logger.info("ModelRouteValidator", (Object)("sys_product_code:" + wcontext.getProductCode()));
                List appPropertyList = (List)MapUtil.get((Map)LocalCache.getAppManagerMap(), (Object)appIcode);
                if (CollectionUtils.isEmpty((Collection)appPropertyList)) {
                    logger.error(context.getApiKey() + "-\u6a21\u578b\u5339\u914d\u76ee\u6807APP\u4e3a\u7a7a:" + appIcode);
                    return new InvokeResult("ecore.ESB.CORE.getway.app", context.getApiKey() + "-\u6a21\u578b\u5339\u914d\u76ee\u6807APP\u4e3a\u7a7a:" + appIcode);
                }
                AppProperty toApp = (AppProperty)appPropertyList.get(0);
                Integer routerDire = toApp.getRouterDire();
                String apiRouterkey = TokenUtil.genToken((Object[])new Object[]{context.getApiKey(), routerDire});
                ApiRouterProperty router = LocalCache.getApiRouterMap((String)apiRouterkey);
                if (null == router) {
                    logger.error("\u6a21\u578b\u5339\u914dAPI\u8def\u7531\u4e3a\u7a7a:" + apiRouterkey);
                    return new InvokeResult("ecore.ESB.CORE.getway.api", "\u6a21\u578b\u5339\u914dAPI\u8def\u7531\u4e3a\u7a7a:" + apiRouterkey);
                }
                context.setToAppProperty(toApp);
                context.setApiRouterProperty(router);
                context.setApiRouterKey(apiRouterkey);
                logger.info("ModelRouteValidator.apiRouterkey", (Object)(apiRouterkey + "----" + toApp.getAppmanageIcode()));
                Invoke invoke = this.instanceInvoke(null, router, context.getApiProperty(), toApp, context.isTestFlag());
                context.getInMessage().setInvoke(invoke);
                context.getInMessage().setToAppmanageIcode(toApp.getAppmanageIcode());
                context.getInMessage().setToRAppmanageIcode(toApp.getAppmanageIcode());
            } else {
                logger.info("ModelRouteValidator.no", checkMap);
                return new InvokeResult("ecore.ESB.CORE.getway.api", "\u6ca1\u6709\u5339\u914d\u7684\u4ea7\u54c1");
            }
        }
        return new InvokeResult();
    }

    private Map<String, String> makeCheckMap(InvokeContext context) {
        HashMap<String, String> checkMap = new HashMap<String, String>();
        checkMap.putAll(context.getInMessage().getAllParamMap());
        checkMap.putAll(context.getInMessage().getSysParamMap());
        checkMap.put(JAR_APPMANAGE_ICODE, context.getApiAppProperty().getAppmanageIcode());
        return checkMap;
    }

    private void add2Weights(List<WeightContext> keys, String key, List<AppModelValue> appIcodeValueList, boolean defaultPro) {
        String appmanageApptype = appIcodeValueList.get(0).getAppmanageApptype();
        String appmanageIcode = appIcodeValueList.get(0).getAppmanageIcode();
        keys.add(new WeightContext(appmanageApptype, appmanageIcode, key, null, defaultPro));
    }

    private Map<String, List<AppModelValue>> getAppModelValueMap(String appmanageApptype) {
        if (StringUtils.isBlank((String)appmanageApptype)) {
            return null;
        }
        Map appModelValueMap = LocalCache.getAppModelValueMap();
        List apptypeModelValueList = (List)appModelValueMap.get(appmanageApptype);
        if (ListUtil.isEmpty((Collection)apptypeModelValueList)) {
            return null;
        }
        HashMap<String, List<AppModelValue>> appIcodeModelValueMap = new HashMap<String, List<AppModelValue>>();
        for (AppModelValue appModelValue : apptypeModelValueList) {
            ArrayList<AppModelValue> appIcodeModelValueList = (ArrayList<AppModelValue>)appIcodeModelValueMap.get(appModelValue.getProductCode());
            if (ListUtil.isEmpty((Collection)appIcodeModelValueList)) {
                appIcodeModelValueList = new ArrayList<AppModelValue>();
                appIcodeModelValueMap.put(appModelValue.getProductCode(), appIcodeModelValueList);
            }
            appIcodeModelValueList.add(appModelValue);
        }
        return appIcodeModelValueMap;
    }

    private List<AppmodelParam> getAppModelParamList(String appmanageApptype) {
        List appModelParamList = null;
        Map appModelParamMap = LocalCache.getAppModelParamMap();
        if (MapUtil.isNotEmpty((Map)appModelParamMap)) {
            appModelParamList = (List)appModelParamMap.get(appmanageApptype);
        }
        return appModelParamList;
    }

    private Map<String, AppmodelParam> makeAppModelMap(List<AppmodelParam> appModelParamList) {
        if (ListUtil.isEmpty(appModelParamList)) {
            return null;
        }
        HashMap<String, AppmodelParam> map = new HashMap<String, AppmodelParam>();
        for (AppmodelParam appmodelParam : appModelParamList) {
            map.put(appmodelParam.getAppmodelCode(), appmodelParam);
        }
        return map;
    }
}

