/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.route.rule.util;

import com.yqbsoft.laser.service.esb.core.auth.Apilimit;
import com.yqbsoft.laser.service.esb.core.auth.ApiparamAllot;
import com.yqbsoft.laser.service.esb.core.auth.ApiparamCon;
import com.yqbsoft.laser.service.esb.core.auth.ParamVerify;
import com.yqbsoft.laser.service.esb.core.handler.InvokeContext;
import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.esb.core.router.LocalCache;
import com.yqbsoft.laser.service.route.rule.util.AllotUtil;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.suppercore.router.AppProperty;
import com.yqbsoft.laser.service.suppercore.router.AppState;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.TokenUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.util.CollectionUtils;

public class ApilimitUtil {
    public static final OpenLogUtil logger = new OpenLogUtil(ApilimitUtil.class);
    public static final String SYS_CODE = "ApilimitUtil";
    public static final String LIMIT_TYPE_PARAM = "0";
    public static final String CON_TYPE_VALIDATING = "validate";
    public static final String BUSINESS = "business";
    private static final int[] states = new int[]{AppState.PRE_ONLINE.getCode(), AppState.APPLY_ONLINE.getCode()};

    public static String checkApilimit(InvokeContext context) {
        AppProperty property;
        if (!context.getApiAppProperty().isValidating() && (property = context.getInAppProperty()) != null && !ArrayUtils.contains((int[])states, (int)property.getDataState())) {
            logger.info(SYS_CODE, (Object)("property state=" + property.getDataState()));
            return null;
        }
        Map apilimitMap = LocalCache.getApilimitMap();
        if (apilimitMap == null) {
            logger.info(SYS_CODE, (Object)"apilimitMap = null");
            return null;
        }
        String apilimitKey = TokenUtil.genToken((Object[])new Object[]{context.getApiProperty().getAppapiCode(), context.getApiRouterProperty().getRouterDire()});
        List apilimitList = (List)apilimitMap.get(apilimitKey);
        if (CollectionUtils.isEmpty((Collection)apilimitList)) {
            logger.info(SYS_CODE, (Object)("apilimitList = null, apirouterkey=" + apilimitKey));
            return null;
        }
        for (Apilimit apilimit : apilimitList) {
            String checkMsg;
            if (!LIMIT_TYPE_PARAM.equals(apilimit.getApilimitType()) || !StringUtils.isNotBlank((String)(checkMsg = ApilimitUtil.checkParam(context)))) continue;
            return checkMsg;
        }
        return null;
    }

    private static String checkParam(InvokeContext context) {
        Map paramVerifyMap;
        String apilimitKey = TokenUtil.genToken((Object[])new Object[]{context.getApiProperty().getAppapiCode(), context.getApiRouterProperty().getRouterDire()});
        boolean strict = context.getRouteRule().isStrict();
        int dire = context.getInMessage().getRouterDire();
        String apiAppIcode = context.getApiProperty().getAppmanageIcode();
        InMessage inMessage = context.getInMessage();
        Map paramConMap = LocalCache.getApiparamConMap();
        if (CollectionUtils.isEmpty((Map)paramConMap)) {
            logger.info(SYS_CODE, (Object)"paramConMap cache not exist");
            return strict ? "paramConMap cache not exist" : null;
        }
        List paramConList = (List)paramConMap.get(apiAppIcode + "-" + apilimitKey);
        if (CollectionUtils.isEmpty((Collection)paramConList)) {
            logger.info(SYS_CODE, (Object)("apiAppIcode=" + apiAppIcode + ",apilimitKey=" + apilimitKey));
            paramConList = (List)paramConMap.get(apiAppIcode + "-0-" + dire);
            if (CollectionUtils.isEmpty((Collection)paramConList)) {
                logger.info(SYS_CODE, (Object)"paramConList cache not exist");
                return strict ? "paramConList cache not exist" : null;
            }
            logger.info(SYS_CODE, (Object)("paramConList =" + paramConList));
        }
        if (CollectionUtils.isEmpty((Map)(paramVerifyMap = LocalCache.getParamVerifyMap()))) {
            logger.info(SYS_CODE, (Object)"paramVerifyMap = null");
            return strict ? "paramVerifyMap cache not exist" : null;
        }
        Map paramAllotMap = LocalCache.getApiparamAllotMap();
        if (CollectionUtils.isEmpty((Map)paramAllotMap)) {
            logger.info(SYS_CODE, (Object)"paramAllotMap = null");
            return "\u672a\u7ed1\u5b9a\u9884\u4e0a\u7ebf\u63a7\u5236\u53c2\u6570";
        }
        AppProperty inApp = context.getInAppProperty();
        String userCode = inApp.getUserCode();
        String appIcode = inApp.getAppmanageIcode();
        if (context.getApiAppProperty().isValidating()) {
            userCode = BUSINESS;
            appIcode = BUSINESS;
        }
        for (ApiparamCon apiparamCon : paramConList) {
            String conType = apiparamCon.getConType();
            String paramVerifyCode = apiparamCon.getParamVerifyCode();
            ParamVerify paramVerify = (ParamVerify)paramVerifyMap.get(TokenUtil.genToken((Object[])new Object[]{conType, paramVerifyCode}));
            logger.info(SYS_CODE, (Object)("conType = " + conType + ",paramVerifyCode=" + paramVerifyCode));
            if (null == paramVerify) {
                return "\u9a8c\u8bc1\u53c2\u6570\u4e3a\u7a7a";
            }
            String paramVerifyRule = paramVerify.getParamVerifyRule();
            logger.info(SYS_CODE, (Object)("paramVerifyRule = " + paramVerifyRule));
            if (StringUtils.isNotBlank((String)paramVerifyRule)) {
                if (context.getApiAppProperty().isValidating() && !CON_TYPE_VALIDATING.equals(apiparamCon.getConType()) || !context.getApiAppProperty().isValidating() && ApilimitUtil.noValidatingType(conType)) continue;
                List allotList = (List)paramAllotMap.get(TokenUtil.genToken((Object[])new Object[]{userCode, appIcode, apiparamCon.getConType(), paramVerifyCode, dire}));
                if (CollectionUtils.isEmpty((Collection)allotList)) {
                    return "\u9884\u4e0a\u7ebf\u63a7\u5236\u53c2\u6570\u672a\u8bbe\u7f6e";
                }
                String conValue = inMessage.getParam(apiparamCon.getParamName());
                logger.info(SYS_CODE, (Object)("ParamName = " + apiparamCon.getParamName() + ", value=" + conValue));
                if (StringUtils.isBlank((String)conValue)) {
                    return "\u4f20\u5165\u9884\u4e0a\u7ebf\u63a7\u5236\u53c2\u6570\u4e3a\u7a7a";
                }
                boolean haveallot = false;
                for (ApiparamAllot apiparamAllot : allotList) {
                    try {
                        haveallot = AllotUtil.checkParamAllot(apiparamAllot.getAllotValue(), paramVerifyRule, conValue);
                        if (!haveallot) continue;
                        break;
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        return "\u9a8c\u8bc1\u53c2\u6570\u6821\u9a8c\u5f02\u5e38";
                    }
                }
                if (haveallot) continue;
                return "\u9884\u4e0a\u7ebf\u63a7\u5236\u53c2\u6570\u4e0d\u5728\u7ed1\u5b9a\u8303\u56f4\u5185";
            }
            return "\u9a8c\u8bc1\u89c4\u5219\u4e3a\u7a7a";
        }
        return null;
    }

    private static boolean noValidatingType(String conType) {
        return CON_TYPE_VALIDATING.equals(conType) || "risk".equals(conType);
    }
}

