/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.route.rule.util;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.auth.Apilimit;
import com.yqbsoft.laser.service.esb.core.auth.ApiparamAllot;
import com.yqbsoft.laser.service.esb.core.auth.ApiparamCon;
import com.yqbsoft.laser.service.esb.core.auth.ParamVerify;
import com.yqbsoft.laser.service.esb.core.handler.InvokeContext;
import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.router.LocalCache;
import com.yqbsoft.laser.service.route.rule.util.AllotUtil;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.suppercore.router.AppProperty;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.TokenUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.CollectionUtils;

public class RiskUtil {
    public static final OpenLogUtil logger = new OpenLogUtil(RiskUtil.class);
    public static final String SYS_CODE = "RiskUtil";
    public static final String LIMIT_TYPE_PARAM = "0";
    public static final String CON_TYPE_RISK = "risk";
    public static final String BUSINESS = "business";
    public static final String RISK_ACTION_WARNING = "0";
    public static final String RISK_ACTION_INTERCEPT = "1";
    public static final String SMS_BUSINESS_TYPE_WARNING = "10021";
    public static final String SMS_BUSINESS_TYPE_INTERCEPT = "10020";

    public static String checkRisk(InvokeContext context, InternalRouter internalRouter) {
        Map apilimitMap = LocalCache.getApilimitMap();
        if (apilimitMap == null) {
            logger.info(SYS_CODE, (Object)"apilimitMap = null");
            return null;
        }
        String apilimitKey = TokenUtil.genToken((Object[])new Object[]{context.getApiProperty().getAppapiCode(), context.getApiRouterProperty().getRouterDire()});
        List apilimitList = (List)apilimitMap.get(apilimitKey);
        if (CollectionUtils.isEmpty((Collection)apilimitList)) {
            logger.info(SYS_CODE, (Object)("apilimitList = null, apirouterkey=" + apilimitKey));
            return null;
        }
        for (Apilimit apilimit : apilimitList) {
            String checkMsg;
            if (!"0".equals(apilimit.getApilimitType()) || !StringUtils.isNotBlank((String)(checkMsg = RiskUtil.checkParam(context, internalRouter)))) continue;
            return checkMsg;
        }
        return null;
    }

    private static String checkParam(InvokeContext context, InternalRouter internalRouter) {
        Map paramVerifyMap;
        String apilimitKey = TokenUtil.genToken((Object[])new Object[]{context.getApiProperty().getAppapiCode(), context.getApiRouterProperty().getRouterDire()});
        boolean strict = context.getRouteRule().isStrict();
        int dire = context.getInMessage().getRouterDire();
        String apiAppIcode = context.getApiProperty().getAppmanageIcode();
        InMessage inMessage = context.getInMessage();
        Map paramConMap = LocalCache.getApiparamConMap();
        if (CollectionUtils.isEmpty((Map)paramConMap)) {
            logger.info(SYS_CODE, (Object)"paramConMap cache not exist");
            return strict ? "paramConMap cache not exist" : null;
        }
        List paramConList = (List)paramConMap.get(apiAppIcode + "-" + apilimitKey);
        if (CollectionUtils.isEmpty((Collection)paramConList)) {
            logger.info(SYS_CODE, (Object)("apiAppIcode=" + apiAppIcode + ",apilimitKey=" + apilimitKey));
            paramConList = (List)paramConMap.get(apiAppIcode + "-0-" + dire);
            if (CollectionUtils.isEmpty((Collection)paramConList)) {
                logger.info(SYS_CODE, (Object)"paramConList cache not exist");
                return strict ? "paramConList cache not exist" : null;
            }
            logger.info(SYS_CODE, (Object)("paramConList =" + paramConList));
        }
        if (CollectionUtils.isEmpty((Map)(paramVerifyMap = LocalCache.getParamVerifyMap()))) {
            logger.info(SYS_CODE, (Object)"paramVerifyMap = null");
            return strict ? "paramVerifyMap cache not exist" : null;
        }
        Map paramAllotMap = LocalCache.getApiparamAllotMap();
        if (CollectionUtils.isEmpty((Map)paramAllotMap)) {
            return null;
        }
        AppProperty inApp = context.getInAppProperty();
        String userCode = inApp.getUserCode();
        String appIcode = inApp.getAppmanageIcode();
        ParamVerify actionParamVerify = null;
        String allotValue = null;
        boolean isHaveallot = false;
        String emails = null;
        String conValue = null;
        HashMap<String, String> emailsMap = new HashMap<String, String>();
        HashMap<String, String> allotValueMap = new HashMap<String, String>();
        ArrayList<ParamVerify> paramVerifyList = new ArrayList<ParamVerify>();
        block2: for (ApiparamCon apiparamCon : paramConList) {
            String conType = apiparamCon.getConType();
            String paramVerifyCode = apiparamCon.getParamVerifyCode();
            ParamVerify paramVerify = (ParamVerify)paramVerifyMap.get(TokenUtil.genToken((Object[])new Object[]{conType, paramVerifyCode}));
            logger.debug(SYS_CODE, (Object)("conType = " + conType + ",paramVerifyCode=" + paramVerifyCode));
            if (null == paramVerify) {
                return "\u9a8c\u8bc1\u53c2\u6570\u4e3a\u7a7a";
            }
            String paramVerifyRule = paramVerify.getParamVerifyRule();
            logger.debug(SYS_CODE, (Object)("paramVerifyRule = " + paramVerifyRule));
            if (StringUtils.isNotBlank((String)paramVerifyRule)) {
                if (!CON_TYPE_RISK.equals(conType)) continue;
                List allotList = (List)paramAllotMap.get(TokenUtil.genToken((Object[])new Object[]{userCode, appIcode, apiparamCon.getConType(), paramVerifyCode, dire}));
                if (CollectionUtils.isEmpty((Collection)allotList)) {
                    logger.info(SYS_CODE, (Object)("contype = " + apiparamCon.getConType() + ", paramVerifyCode=" + paramVerifyCode + ",\u672a\u8bbe\u7f6e!"));
                    continue;
                }
                conValue = inMessage.getParam(apiparamCon.getParamName());
                logger.debug(SYS_CODE, (Object)("ParamName = " + apiparamCon.getParamName() + ", value=" + conValue));
                if (StringUtils.isBlank((String)conValue)) {
                    return "\u4f20\u5165\u98ce\u63a7\u53c2\u6570\u4e3a\u7a7a";
                }
                boolean haveallot = false;
                for (ApiparamAllot apiparamAllot : allotList) {
                    try {
                        String[] allotValues = apiparamAllot.getAllotValue().split(",");
                        String tempAllotValue = allotValues[0];
                        logger.debug(SYS_CODE, (Object)("allotValues = " + tempAllotValue));
                        haveallot = AllotUtil.checkParamAllot(tempAllotValue, paramVerifyRule, conValue);
                        logger.debug(SYS_CODE, (Object)("haveallot = " + haveallot));
                        if (!haveallot) continue;
                        allotValue = tempAllotValue;
                        allotValueMap.put(paramVerify.getParamVerifyId().toString(), tempAllotValue);
                        paramVerifyList.add(paramVerify);
                        isHaveallot = true;
                        if (allotValues.length <= 1) continue block2;
                        emails = allotValues[1];
                        emailsMap.put(paramVerify.getParamVerifyId().toString(), emails);
                        continue block2;
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        return "\u98ce\u63a7\u53c2\u6570\u6821\u9a8c\u5f02\u5e38";
                    }
                }
                continue;
            }
            return "\u98ce\u63a7\u89c4\u5219\u4e3a\u7a7a";
        }
        Collections.sort(paramVerifyList, new Comparator<ParamVerify>(){

            @Override
            public int compare(ParamVerify o1, ParamVerify o2) {
                return Integer.valueOf(o2.getConAction()) - Integer.valueOf(o1.getConAction());
            }
        });
        logger.debug(SYS_CODE, (Object)("isHaveallot = " + isHaveallot));
        if (isHaveallot) {
            actionParamVerify = (ParamVerify)paramVerifyList.get(0);
            String key = actionParamVerify.getParamVerifyId().toString();
            allotValue = (String)allotValueMap.get(key);
            emails = (String)emailsMap.get(key);
            RiskUtil.sendSMS(context, internalRouter, actionParamVerify, conValue, allotValue, emails);
            if (RISK_ACTION_INTERCEPT.equals(actionParamVerify.getConAction())) {
                return "\u98ce\u63a7\u62d2\u7edd";
            }
            if ("0".equals(actionParamVerify.getConAction())) {
                // empty if block
            }
        }
        return null;
    }

    private static void sendSMS(InvokeContext context, InternalRouter internalRouter, ParamVerify paramVerify, String conValue, String allotValue, String emails) {
        logger.debug(SYS_CODE, (Object)("emails=" + emails));
        if (StringUtils.isBlank((String)emails)) {
            return;
        }
        ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> templateMap = new HashMap<String, String>();
        templateMap.put("appId", context.getInAppProperty().getAppmanageAppkey());
        templateMap.put("veriftName", paramVerify.getParamVerifyName());
        templateMap.put("conValue", conValue);
        templateMap.put("appapiCode", context.getApiProperty().getAppapiCode());
        templateMap.put("allotValue", allotValue);
        templateMap.putAll(context.getInMessage().getAllParamMap());
        String paramVerifyRule = "";
        if ("0".equals(paramVerify.getParamVerifyRule())) {
            paramVerifyRule = "\u7b49\u4e8e";
        } else if (RISK_ACTION_INTERCEPT.equals(paramVerify.getParamVerifyRule())) {
            paramVerifyRule = "\u5c0f\u4e8e";
        } else if ("2".equals(paramVerify.getParamVerifyRule())) {
            paramVerifyRule = "\u5927\u4e8e";
        }
        templateMap.put("paramVerifyRule", paramVerifyRule);
        String businessType = null;
        if (RISK_ACTION_INTERCEPT.equals(paramVerify.getConAction())) {
            businessType = SMS_BUSINESS_TYPE_INTERCEPT;
        } else if ("0".equals(paramVerify.getConAction())) {
            businessType = SMS_BUSINESS_TYPE_WARNING;
        }
        RiskUtil.bindreceiver(map, emails);
        map.put("businessType", businessType);
        map.put("theme", "\u98ce\u63a7\u63d0\u9192");
        map.put("paramMap", JsonUtil.buildNormalBinder().toJson(templateMap));
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        logger.info(SYS_CODE, (Object)"risk send msn");
        try {
            internalRouter.inAsyncInvoke("rorl.mns.saveBusinessMnslist", "1.0", "0", paramMap);
        }
        catch (ApiException e) {
            logger.error(SYS_CODE, (Throwable)e);
        }
    }

    private static void bindreceiver(Map<String, Object> map, String emails) {
        String[] emailes;
        HashMap<String, String> mapSender = new HashMap<String, String>();
        mapSender.put("code", "sys");
        mapSender.put("name", "sys");
        map.put("sender", JsonUtil.buildNonDefaultBinder().toJson(mapSender));
        ArrayList listReceiver = new ArrayList();
        for (String email : emailes = emails.split(";")) {
            HashMap<String, String> mapReceiver = new HashMap<String, String>();
            mapReceiver.put("code", "");
            mapReceiver.put("name", "sys");
            mapReceiver.put("email", email);
            mapReceiver.put("telphone", "");
            listReceiver.add(mapReceiver);
        }
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(listReceiver));
    }
}

