/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.route.rule.pre1;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.handler.InvokeContext;
import com.yqbsoft.laser.service.esb.core.handler.InvokeHandlerUnit;
import com.yqbsoft.laser.service.esb.core.handler.InvokeResult;
import com.yqbsoft.laser.service.route.rule.util.OAuthUtil;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.tool.util.StringUtils;

public class TokenValidator
implements InvokeHandlerUnit {
    public InvokeResult execute(InvokeContext context) throws Exception {
        InvokeResult vr = new InvokeResult();
        try {
            InMessage inMessage = context.getInMessage();
            String auth_token = inMessage.getParam("auth_token");
            String apiKey = context.getApiKey();
            String businessType = context.getApiProperty().getAppapiApitype();
            String appType = context.getApiAppProperty().getAppmanageAppkey();
            if (StringUtils.isBlank((String)auth_token)) {
                return new InvokeResult("rorl.ROUTE.RULE.rule.check", "auth_token validate fail,auth_token is null!");
            }
            TokenStatus result = OAuthUtil.checkToken(inMessage, auth_token, apiKey, businessType, appType);
            if (TokenStatus.TOKEN_OK.getStatus() != result.getStatus()) {
                return new InvokeResult("rorl.ROUTE.RULE.rule.check", result.getMsg());
            }
        }
        catch (Exception e) {
            throw new ApiException("rorl.ROUTE.RULE.rule.check", "\u6388\u6743\u68c0\u9a8c\u5f02\u5e38\uff01", (Throwable)e);
        }
        return vr;
    }

    public static enum TokenStatus {
        TOKEN_OK(1, "TOKEN_OK", "\u6388\u6743\u6b63\u5e38"),
        TOKEN_EXPIRES(2, "TOKEN_EXPIRES", "\u6388\u6743\u5df2\u8fc7\u671f"),
        TOKEN_NOT_FOUND_OR_ILLEGAL(3, "TOKEN_NOT_FOUND_OR_ILLEGAL", "\u672a\u53d1\u73b0\u6709\u6548token");

        private int status;
        private String code;
        private String msg;

        private TokenStatus(int status, String code, String msg) {
            this.status = status;
            this.code = code;
            this.msg = msg;
        }

        public int getStatus() {
            return this.status;
        }

        public String getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

