/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.route.rule.pre1;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.auth.Auth;
import com.yqbsoft.laser.service.esb.core.auth.RouteRule;
import com.yqbsoft.laser.service.esb.core.handler.InvokeContext;
import com.yqbsoft.laser.service.esb.core.handler.InvokeHandlerUnit;
import com.yqbsoft.laser.service.esb.core.handler.InvokeResult;
import com.yqbsoft.laser.service.route.rule.util.SHA256Util;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public class SHA256Validator
implements InvokeHandlerUnit {
    public InvokeResult execute(InvokeContext context) throws ApiException {
        InvokeResult vr = new InvokeResult();
        try {
            InMessage inMessage = context.getInMessage();
            String sign_type = inMessage.getParam("sign_type");
            if (StringUtils.isBlank((String)sign_type)) {
                return vr;
            }
            if (!(sign_type = sign_type.toLowerCase()).equals("sha256")) {
                return vr;
            }
            RouteRule rule = context.getRouteRule();
            String sign = inMessage.getParam("sign");
            if (StringUtils.isBlank((String)sign)) {
                return new InvokeResult("rorl.ROUTE.RULE.rule.check", "strict validate fail,sign is null!");
            }
            Auth auth = new Auth();
            Map allParamMap = inMessage.getAllParamMap();
            allParamMap.remove("sign");
            allParamMap.remove("resStream");
            allParamMap.put("secretKey", context.getApiAppProperty().getAppmanageSecretkey());
            String value = SHA256Validator.sortMapToStr(allParamMap);
            auth.setKey(value);
            auth.setValue(sign);
            auth.setType("5");
            boolean authStr = false;
            String str = "";
            try {
                str = SHA256Util.getSHA256String(auth.getKey());
                if (StringUtils.isNotBlank((String)auth.getValue()) && StringUtils.isNotBlank((String)str) && auth.getValue().equals(str)) {
                    authStr = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!authStr) {
                return new InvokeResult("rorl.ROUTE.RULE.rule.check", "\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff01=====" + allParamMap.toString() + "sign" + sign + "str" + str + "value" + value);
            }
        }
        catch (Exception e) {
            throw new ApiException("rorl.ROUTE.RULE.rule.check", "\u7b7e\u540d\u6821\u9a8c\u5f02\u5e38\uff01", (Throwable)e);
        }
        return vr;
    }

    public static String sortMapToStr(Map<String, String> map) {
        String result = "";
        try {
            ArrayList<Map.Entry<String, String>> infoIds = new ArrayList<Map.Entry<String, String>>(map.entrySet());
            Collections.sort(infoIds, new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : infoIds) {
                if (entry.getKey() == null && entry.getKey() == "" || ((String)entry.getKey()).equals("sign")) continue;
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (val == "" || val == null) continue;
                sb.append(key + val);
            }
            result = sb.toString();
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }
}

