/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sdktool.compile;

import com.yqbsoft.laser.service.sdktool.main.LaserApiException;
import com.yqbsoft.laser.service.sdktool.main.SdkContants;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CompileTool {
    private static String os_name = System.getProperty("os.name").toLowerCase();

    public static boolean compileAndJar(String sdkRootPath) throws LaserApiException {
        String app_path = sdkRootPath;
        if (app_path != null && !app_path.endsWith("/") && !app_path.endsWith(File.separator)) {
            app_path = app_path + File.separator;
        }
        String compile_datetime = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String jar_name = SdkContants.PREV_SDKNAME + compile_datetime;
        String cmd = "";
        File cmdFile = null;
        if (os_name.indexOf("windows") > -1) {
            cmd = "cmd.exe /C start " + app_path + "compile.exe " + app_path + " " + jar_name;
            cmdFile = new File(app_path + "compile.exe");
        } else {
            cmd = app_path + "compile.sh " + app_path + " " + jar_name;
            cmdFile = new File(app_path + "compile.sh");
        }
        if (!cmd.equals("") && cmdFile != null && cmdFile.exists()) {
            if (!cmdFile.canExecute()) {
                cmdFile.setExecutable(true);
            }
            return CompileTool.callCmd(cmd);
        }
        throw new LaserApiException("can't find compile command. command:" + cmdFile.getAbsolutePath());
    }

    private static boolean callCmd(String cmdStr) {
        try {
            Process child = Runtime.getRuntime().exec(cmdStr);
            InputStream in = child.getInputStream();
            while (in.read() != -1) {
            }
            in.close();
            try {
                child.waitFor();
                return true;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

