/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sdktool.compile;

import com.yqbsoft.laser.service.sdktool.main.LaserApiException;
import com.yqbsoft.laser.service.sdktool.main.SdkContants;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipTool {
    private static final int BUFFER = 1024;

    public static String zipFile(String sdkRootPath, int type) throws LaserApiException {
        String fileName;
        block14: {
            if (sdkRootPath != null && !sdkRootPath.endsWith("/") && !sdkRootPath.endsWith(File.separator)) {
                sdkRootPath = sdkRootPath + File.separator;
            }
            String dest_path = sdkRootPath + SdkContants.DEST_TMP_PATH;
            String attachfile_path = sdkRootPath + SdkContants.ATTACHFILE_PATH;
            String zip_datetime = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            fileName = SdkContants.PREV_SDKNAME + "-" + zip_datetime + ".zip";
            String cls_path = dest_path + SdkContants.CLS_TMP_PATH;
            File clsFloder = new File(cls_path);
            try {
                if (clsFloder.exists() && clsFloder.listFiles().length > 0) {
                    try {
                        String lib_path = dest_path + SdkContants.LIBS_TMP_PATH;
                        File zipFile = new File(dest_path + fileName);
                        if (!zipFile.getParentFile().exists()) {
                            zipFile.getParentFile().mkdirs();
                        }
                        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
                        File[] files = new File(dest_path).listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return name.endsWith(".jar");
                            }
                        });
                        File[] lib_files = new File(lib_path).listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return name.endsWith(".jar");
                            }
                        });
                        File[] doc_files = new File(attachfile_path).listFiles();
                        if (files != null) {
                            for (File f : files) {
                                ZipTool.compressFile(f, zos, "");
                            }
                            if (lib_files != null) {
                                for (File f : lib_files) {
                                    ZipTool.compressFile(f, zos, "");
                                }
                            }
                            if (doc_files != null) {
                                for (File f : doc_files) {
                                    ZipTool.compressFile(f, zos, "");
                                }
                            }
                        } else {
                            zos.close();
                            throw new LaserApiException("zip jar file failed: can't get any jar file for zip.");
                        }
                        zos.close();
                        break block14;
                    }
                    catch (Exception e) {
                        throw new LaserApiException(e);
                    }
                }
                throw new LaserApiException("class compile failed: class file not found.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fileName;
    }

    private static boolean compressFile(File file, ZipOutputStream out, String basedir) throws LaserApiException {
        if (!file.exists()) {
            throw new LaserApiException("file is not exists");
        }
        try {
            int count;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            ZipEntry entry = new ZipEntry(basedir + file.getName());
            out.putNextEntry(entry);
            byte[] data = new byte[1024];
            while ((count = bis.read(data, 0, 1024)) != -1) {
                out.write(data, 0, count);
            }
            bis.close();
        }
        catch (Exception e) {
            throw new LaserApiException(e);
        }
        return true;
    }
}

