/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sdktool.ftl;

import com.yqbsoft.laser.service.sdktool.ftl.FtlField;
import com.yqbsoft.laser.service.sdktool.ftl.FtlMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DomainObject {
    private String version;
    private String datetime;
    private String clsName;
    private String desc;
    private Map<String, FtlField> fields;
    private List<FtlMethod> methods;
    private Map<String, String> impCls = new HashMap<String, String>();

    public DomainObject() {
    }

    public DomainObject(String datetime, String clsName, Map<String, FtlField> fields) {
        this(null, datetime, clsName, fields);
    }

    public DomainObject(String version, String datetime, String clsName, Map<String, FtlField> fields) {
        this.version = version;
        this.datetime = datetime;
        this.clsName = clsName;
        this.fields = fields;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDatetime() {
        return this.datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getClsName() {
        return this.clsName;
    }

    public void setClsName(String clsName) {
        this.clsName = clsName;
    }

    public Map<String, FtlField> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, FtlField> fields) {
        this.fields = fields;
    }

    public List<FtlMethod> getMethods() {
        if (this.fields != null && this.fields.size() > 0) {
            this.methods = new ArrayList<FtlMethod>();
            for (Map.Entry<String, FtlField> entry : this.fields.entrySet()) {
                this.methods.add(entry.getValue().getGetter());
                this.methods.add(entry.getValue().getSetter());
            }
        }
        return this.methods;
    }

    public void setMethods(List<FtlMethod> methods) {
        this.methods = methods;
    }

    public Map<String, String> getImpCls() {
        if (this.fields != null && this.fields.size() > 0) {
            this.impCls = new HashMap<String, String>();
            for (Map.Entry<String, FtlField> entry : this.fields.entrySet()) {
                Class<?> type = entry.getValue().getType();
                if (type != null) {
                    String packageName;
                    if (type.getCanonicalName().indexOf(".") < 0 || "java.lang".equals(packageName = type.getCanonicalName().substring(0, type.getCanonicalName().lastIndexOf(".")))) continue;
                    this.impCls.put(type.getCanonicalName(), type.getCanonicalName().replace("[", "").replace("]", ""));
                    if (type != List.class && type != Map.class || "java.lang".equals(entry.getValue().getSecType().substring(0, entry.getValue().getSecType().lastIndexOf(".")))) continue;
                    this.impCls.put(entry.getValue().getSecType(), entry.getValue().getSecType().replace("[", "").replace("]", ""));
                    continue;
                }
                this.impCls.put(entry.getValue().getSecType(), entry.getValue().getSecType().replace("[", "").replace("]", ""));
            }
        }
        return this.impCls;
    }

    public void setImpCls(Map<String, String> impCls) {
        this.impCls = impCls;
    }
}

