/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sdktool.ftl;

import com.yqbsoft.laser.service.sdktool.ftl.ConstantObject;
import com.yqbsoft.laser.service.sdktool.ftl.DomainObject;
import com.yqbsoft.laser.service.sdktool.ftl.FtlField;
import com.yqbsoft.laser.service.sdktool.ftl.RequestObject;
import com.yqbsoft.laser.service.sdktool.ftl.SerialUIDGenerator;
import com.yqbsoft.laser.service.sdktool.ftl.StringUtil;
import com.yqbsoft.laser.service.sdktool.main.LaserApiException;
import com.yqbsoft.laser.service.sdktool.main.SdkContants;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Freemarker {
    public static final String UTF_8 = "UTF-8";
    ClassTemplateLoader ctl = new ClassTemplateLoader(Freemarker.class, "");

    public boolean generateSDK(String sdkRootPath, List<DomainObject> domains, List<RequestObject> apis, ConstantObject constant, Map<String, String> domainClass) throws LaserApiException {
        return this.generateSDK(sdkRootPath, domains, apis, constant, 3, domainClass);
    }

    public boolean generateSDK(String sdkRootPath, List<DomainObject> domains, List<RequestObject> apis, ConstantObject constant, int type, Map<String, String> domainClass) throws LaserApiException {
        boolean b = true;
        if (sdkRootPath != null && !sdkRootPath.endsWith("/") && !sdkRootPath.endsWith(File.separator)) {
            sdkRootPath = sdkRootPath + File.separator;
        }
        String srcPath = sdkRootPath + SdkContants.SRC_TMP_PATH;
        String domainFolder = srcPath + SdkContants.PACKAGE_DOMAIN.replace('.', '/');
        String requestFolder = srcPath + SdkContants.PACKAGE_REQUEST.replace('.', '/');
        String responseFolder = srcPath + SdkContants.PACKAGE_RESPONSE.replace('.', '/');
        String requestNoticeFolder = srcPath + SdkContants.PACKAGE_NOTICE_REQ.replace('.', '/');
        String responseNoticeFolder = srcPath + SdkContants.PACKAGE_NOTICE_RES.replace('.', '/');
        StringUtil.clearFolder(domainFolder, requestFolder, responseFolder, requestNoticeFolder, responseNoticeFolder);
        if (type == 2) {
            this.generateClient(constant, srcPath);
        }
        for (DomainObject domain : domains) {
            b &= this.generateDomain(domain, srcPath, domainClass);
        }
        if (!b) {
            throw new LaserApiException("generate domain java file failed.");
        }
        ArrayList<RequestObject> noticesApis = new ArrayList<RequestObject>();
        for (RequestObject api : apis) {
            if (!domainClass.isEmpty()) {
                Map<String, FtlField> reqFields = api.getReqFields();
                for (Map.Entry<String, FtlField> entry : reqFields.entrySet()) {
                    String entryValue = entry.getValue().getSecType();
                    if (domainClass.get(entryValue) == "" || domainClass.get(entryValue) == null) continue;
                    entry.getValue().setSecType(domainClass.get(entryValue));
                }
                Map<String, FtlField> resFields = api.getResFields();
                for (Map.Entry<String, FtlField> entry : resFields.entrySet()) {
                    String entryValue = entry.getValue().getSecType();
                    if (domainClass.get(entryValue) == "" || domainClass.get(entryValue) == null) continue;
                    entry.getValue().setSecType(domainClass.get(entryValue));
                }
            }
            b &= this.generateResponse(api, srcPath);
            b &= this.generateRequest(api, srcPath);
            if (api.getCallType() != 1) continue;
            noticesApis.add(api);
        }
        if (!b) {
            throw new LaserApiException("generate request/response java file failed.");
        }
        if (!(b &= this.generateApiTest(apis, srcPath, noticesApis.size() > 0))) {
            throw new LaserApiException("generate api demo java file failed.");
        }
        if (noticesApis.size() > 0) {
            this.generateNoticeRequestUtils(noticesApis, srcPath, SdkContants.NOTICE_REQ_UTILS);
        } else {
            StringUtil.clearFolder(srcPath + SdkContants.PACKAGE_NOTICE.replace('.', '/'));
        }
        return b;
    }

    private boolean generateDomain(DomainObject domain, String srcPath, Map<String, String> domainClass) {
        Configuration cfg = new Configuration();
        cfg.setClassicCompatible(true);
        cfg.setTemplateLoader((TemplateLoader)this.ctl);
        try {
            Template tmp = cfg.getTemplate("domain.ftl", UTF_8);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("domain", domain);
            String resClsName = SdkContants.PACKAGE_DOMAIN + "." + domain.getClsName();
            Long serialUID = SerialUIDGenerator.getMySerialVersionUID(resClsName, domain.getFields(), domain.getMethods());
            map.put("serialUID", serialUID.toString());
            String filePath = srcPath + resClsName.replace('.', '/') + ".java";
            File javaFile = new File(filePath);
            javaFile.getParentFile().mkdirs();
            tmp.process(map, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(javaFile), UTF_8));
            if (!domainClass.isEmpty()) {
                for (String key : domainClass.keySet()) {
                    if (!domain.getClsName().equals(domainClass.get(key))) continue;
                    domainClass.put(key, resClsName);
                    break;
                }
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean generateResponse(RequestObject api, String srcPath) {
        Configuration cfg = new Configuration();
        cfg.setClassicCompatible(true);
        cfg.setTemplateLoader((TemplateLoader)this.ctl);
        try {
            String template_name = "response.ftl";
            String request_package = SdkContants.PACKAGE_RESPONSE;
            if (api.getCallType() == 1) {
                template_name = "nresponse.ftl";
                request_package = SdkContants.PACKAGE_NOTICE_RES;
            }
            Template tmp = cfg.getTemplate(template_name, UTF_8);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("api", api);
            String resClsName = api.getReqName() + "Response";
            String realPath = request_package + "." + resClsName;
            Long serialUID = SerialUIDGenerator.getMySerialVersionUID(realPath, api.getResFields(), api.getResMethods());
            map.put("serialUID", serialUID.toString());
            String filePath = srcPath + realPath.replace('.', '/') + ".java";
            File javaFile = new File(filePath);
            if (javaFile.getParentFile().exists()) {
                javaFile.getParentFile().delete();
            }
            javaFile.getParentFile().mkdirs();
            tmp.process(map, (Writer)new OutputStreamWriter(new FileOutputStream(javaFile)));
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean generateRequest(RequestObject api, String srcPath) {
        Configuration cfg = new Configuration();
        cfg.setClassicCompatible(true);
        cfg.setTemplateLoader((TemplateLoader)this.ctl);
        try {
            String template_name = "request.ftl";
            String request_package = SdkContants.PACKAGE_REQUEST;
            if (api.getCallType() == 1) {
                template_name = "nrequest.ftl";
                request_package = SdkContants.PACKAGE_NOTICE_REQ;
            }
            Template tmp = cfg.getTemplate(template_name, UTF_8);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("api", api);
            String resClsName = api.getReqName() + "Request";
            String realPath = request_package + "." + resClsName;
            String filePath = srcPath + realPath.replace('.', '/') + ".java";
            Long serialUID = SerialUIDGenerator.getMySerialVersionUID(realPath, api.getReqFields(), api.getReqMethods());
            map.put("serialUID", serialUID.toString());
            File javaFile = new File(filePath);
            if (javaFile.getParentFile().exists()) {
                javaFile.getParentFile().delete();
            }
            javaFile.getParentFile().mkdirs();
            tmp.process(map, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(javaFile), UTF_8));
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean generateNoticeRequestUtils(List<RequestObject> apis, String srcPath, String fileName) {
        Configuration cfg = new Configuration();
        cfg.setClassicCompatible(true);
        cfg.setTemplateLoader((TemplateLoader)this.ctl);
        try {
            String template_name = "noticeutils.ftl";
            String request_package = SdkContants.PACKAGE_NOTICE_REQ;
            Template tmp = cfg.getTemplate(template_name, UTF_8);
            HashMap<String, List<RequestObject>> map = new HashMap<String, List<RequestObject>>();
            map.put("apis", apis);
            String realPath = request_package + "." + fileName;
            String filePath = srcPath + realPath.replace('.', '/') + ".java";
            File javaFile = new File(filePath);
            if (javaFile.getParentFile().exists()) {
                javaFile.getParentFile().delete();
            }
            javaFile.getParentFile().mkdirs();
            tmp.process(map, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(javaFile), UTF_8));
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        return false;
    }

    boolean generateApiTest(List<RequestObject> apis, String srcPath, boolean hasNotice) {
        Configuration cfg = new Configuration();
        cfg.setClassicCompatible(true);
        cfg.setTemplateLoader((TemplateLoader)this.ctl);
        cfg.setDefaultEncoding(UTF_8);
        try {
            String template_name = "apitest.ftl";
            String request_package = SdkContants.PACKAGE_DEMO;
            Template tmp = cfg.getTemplate(template_name, UTF_8);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("apis", apis);
            map.put("notice", hasNotice);
            String resClsName = "ApiTest";
            String realPath = request_package + "." + resClsName;
            String filePath = srcPath + realPath.replace('.', '/') + ".java";
            File javaFile = new File(filePath);
            if (javaFile.getParentFile().exists()) {
                javaFile.getParentFile().delete();
            }
            javaFile.getParentFile().mkdirs();
            tmp.process(map, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(javaFile), UTF_8));
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        return false;
    }

    boolean generateClient(ConstantObject constants, String srcPath) {
        Configuration cfg = new Configuration();
        cfg.setClassicCompatible(true);
        cfg.setTemplateLoader((TemplateLoader)this.ctl);
        try {
            String template_name = "client.ftl";
            String request_package = SdkContants.PACKAGE_API;
            Template tmp = cfg.getTemplate(template_name, UTF_8);
            HashMap<String, ConstantObject> map = new HashMap<String, ConstantObject>();
            map.put("cons", constants);
            String resClsName = "DefaultInnerClient";
            String realPath = request_package + "." + resClsName;
            String filePath = srcPath + realPath.replace('.', '/') + ".java";
            File javaFile = new File(filePath);
            if (javaFile.getParentFile().exists()) {
                javaFile.getParentFile().delete();
            }
            javaFile.getParentFile().mkdirs();
            tmp.process(map, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(javaFile), UTF_8));
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        return false;
    }
}

