/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sdktool.ftl;

import com.yqbsoft.laser.service.sdktool.ftl.FtlMethod;
import com.yqbsoft.laser.service.sdktool.ftl.StringUtil;
import com.yqbsoft.laser.service.sdktool.main.SdkContants;
import java.util.List;
import java.util.Map;

public class FtlField {
    private String name;
    private Class<?> type;
    private String secType;
    private String commentInterface;
    private String desc;
    private String defaultValue;
    private String simpleName;
    private Integer dire;
    private Integer required;
    private Boolean isBase;

    public FtlField() {
    }

    public FtlField(String name, Class<?> type, Boolean isBase) {
        this(name, type, null, null, null, isBase);
    }

    public FtlField(String name, Class<?> type, String desc, Boolean isBase) {
        this(name, type, null, desc, null, isBase);
    }

    public FtlField(String name, String secType, String defaultValue, Boolean isBase) {
        this(name, null, secType, null, defaultValue, isBase);
    }

    public FtlField(String name, String secType, String desc, String defaultValue, Boolean isBase) {
        this(name, null, secType, desc, null, null, defaultValue, isBase);
    }

    public FtlField(String name, Class<?> type, String secType, String desc, String defaultValue, Boolean isBase) {
        this(name, type, secType, desc, null, null, defaultValue, isBase);
    }

    public FtlField(String name, Class<?> type, String secType, String desc, Integer dire, Integer required, String defaultValue, Boolean isBase) {
        if (type == null && secType != null && secType.indexOf(".") == -1) {
            secType = SdkContants.PACKAGE_DOMAIN + "." + secType;
        }
        this.name = name;
        this.type = type;
        this.secType = secType;
        this.desc = desc;
        this.dire = dire;
        this.required = required;
        this.defaultValue = defaultValue;
        this.isBase = isBase;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getSecType() {
        return this.secType;
    }

    public void setSecType(String secType) {
        this.secType = secType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getCommentInterface() {
        this.commentInterface = this.type != null && this.type == List.class ? "@ApiListField(\"\")" : "@ApiField(\"" + this.name + "\")";
        return this.commentInterface;
    }

    public void setCommentInterface(String commentInterface) {
        this.commentInterface = commentInterface;
    }

    public String getDesc() {
        return this.desc == null ? this.name : this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getDire() {
        return this.dire;
    }

    public void setDire(Integer dire) {
        this.dire = dire;
    }

    public Integer getRequired() {
        return this.required;
    }

    public void setRequired(Integer required) {
        this.required = required;
    }

    public Boolean getIsBase() {
        return this.isBase;
    }

    public void setIsBase(Boolean isBase) {
        this.isBase = isBase;
    }

    public FtlMethod getSetter() {
        if (this.name != null && !"".equals(this.name.trim())) {
            String setName = StringUtil.getSetter(this.name);
            String body = "this." + this.name + " = " + this.name;
            FtlMethod setter = null;
            setter = this.type != null ? new FtlMethod(setName, this.name, Void.TYPE.getSimpleName(), this.getSimpleName()) : new FtlMethod(setName, this.name, Void.TYPE.getSimpleName(), this.getSimpleName());
            setter.setBody(body);
            return setter;
        }
        return null;
    }

    public FtlMethod getGetter() {
        if (this.name != null && !"".equals(this.name.trim())) {
            String getName = StringUtil.getGetter(this.name, this.type);
            String body = "return this." + this.name;
            FtlMethod getter = null;
            getter = this.type != null ? new FtlMethod(getName, this.name, this.getSimpleName(), Void.TYPE.getSimpleName()) : new FtlMethod(getName, this.name, this.getSimpleName(), Void.TYPE.getSimpleName());
            getter.setBody(body);
            return getter;
        }
        return null;
    }

    public String getSimpleName() {
        if (this.simpleName == null) {
            if (this.type != null) {
                this.simpleName = this.type.getSimpleName();
                if (this.secType != null && (this.type == List.class || this.type == Map.class)) {
                    this.simpleName = this.simpleName + "<";
                    if (this.type == Map.class) {
                        this.simpleName = this.simpleName + "String, ";
                    }
                    this.simpleName = this.secType.indexOf(".") != -1 ? this.simpleName + this.secType.substring(this.secType.lastIndexOf(".") + 1) + ">" : this.simpleName + this.secType + ">";
                }
            } else {
                this.simpleName = this.secType.substring(this.secType.lastIndexOf(".") + 1);
            }
        }
        return this.simpleName == null ? Void.TYPE.getSimpleName() : this.simpleName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }
}

