/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sdktool.ftl;

import com.yqbsoft.laser.service.sdktool.ftl.FtlField;
import com.yqbsoft.laser.service.sdktool.ftl.FtlMethod;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class SerialUIDGenerator {
    public static long getMySerialVersionUID(final String className, final Map<String, FtlField> fields, final List<FtlMethod> methods) {
        return (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return SerialUIDGenerator.computeDefaultSUID(className, fields, methods);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 1L;
                }
            }
        });
    }

    private static long computeDefaultSUID(String className, Map<String, FtlField> fields, List<FtlMethod> methods) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeUTF(className);
        int classMods = 1;
        if ((classMods & 0x200) != 0) {
            classMods = methods.size() > 0 ? classMods | 0x400 : classMods & 0xFFFFFBFF;
        }
        dout.writeInt(classMods);
        MemberInfo[] fieldSigs = new MemberInfo[fields.size()];
        int index = 0;
        for (Map.Entry<String, FtlField> entry : fields.entrySet()) {
            fieldSigs[index++] = new MemberInfo(entry.getValue());
        }
        Arrays.sort(fieldSigs, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = ((MemberInfo)o1).name;
                String name2 = ((MemberInfo)o2).name;
                return name1.compareTo(name2);
            }
        });
        for (int i = 0; i < fieldSigs.length; ++i) {
            MemberInfo sig = fieldSigs[i];
            int mods = 2;
            if ((mods & 2) != 0 && (mods & 0x88) != 0) continue;
            dout.writeUTF(sig.name);
            dout.writeInt(mods);
            dout.writeUTF(sig.signature);
        }
        if (className != null) {
            MemberInfo sig = new MemberInfo(className);
            int mods = 1;
            if ((mods & 2) == 0) {
                dout.writeUTF("<init>");
                dout.writeInt(mods);
                dout.writeUTF(sig.signature.replace('/', '.'));
            }
        }
        if (methods != null && methods.size() > 0) {
            int i;
            MemberInfo[] methSigs = new MemberInfo[methods.size()];
            for (i = 0; i < methods.size(); ++i) {
                methSigs[i] = new MemberInfo(methods.get(i));
            }
            Arrays.sort(methSigs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    MemberInfo ms1 = (MemberInfo)o1;
                    MemberInfo ms2 = (MemberInfo)o2;
                    int comp = ms1.name.compareTo(ms2.name);
                    if (comp == 0) {
                        comp = ms1.signature.compareTo(ms2.signature);
                    }
                    return comp;
                }
            });
            for (i = 0; i < methSigs.length; ++i) {
                MemberInfo sig = methSigs[i];
                int mods = 1;
                if ((mods & 2) != 0) continue;
                dout.writeUTF(sig.name);
                dout.writeInt(mods);
                dout.writeUTF(sig.signature.replace('/', '.'));
            }
        }
        dout.flush();
        MessageDigest md = MessageDigest.getInstance("SHA");
        byte[] hashBytes = md.digest(bout.toByteArray());
        long hash = 0L;
        for (int i = Math.min(hashBytes.length, 8) - 1; i >= 0; --i) {
            hash = hash << 8 | (long)(hashBytes[i] & 0xFF);
        }
        return hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getClassSignature(Class<?> cl) {
        if (cl == null) {
            return "";
        }
        StringBuilder sbuf = new StringBuilder();
        while (cl.isArray()) {
            sbuf.append('[');
            cl = cl.getComponentType();
        }
        if (cl.isPrimitive()) {
            if (cl == Integer.TYPE) {
                sbuf.append('I');
                return sbuf.toString();
            } else if (cl == Byte.TYPE) {
                sbuf.append('B');
                return sbuf.toString();
            } else if (cl == Long.TYPE) {
                sbuf.append('J');
                return sbuf.toString();
            } else if (cl == Float.TYPE) {
                sbuf.append('F');
                return sbuf.toString();
            } else if (cl == Double.TYPE) {
                sbuf.append('D');
                return sbuf.toString();
            } else if (cl == Short.TYPE) {
                sbuf.append('S');
                return sbuf.toString();
            } else if (cl == Character.TYPE) {
                sbuf.append('C');
                return sbuf.toString();
            } else if (cl == Boolean.TYPE) {
                sbuf.append('Z');
                return sbuf.toString();
            } else {
                if (cl != Void.TYPE) throw new InternalError();
                sbuf.append('V');
            }
            return sbuf.toString();
        } else {
            sbuf.append('L' + cl.getName().replace('.', '/') + ';');
        }
        return sbuf.toString();
    }

    static String getClassSignature(String clsName) {
        if (clsName == null || "".equals(clsName)) {
            return "";
        }
        StringBuilder sbuf = new StringBuilder();
        sbuf.append('L' + clsName.replace('.', '/') + ';');
        return sbuf.toString();
    }

    private static String getMethodSignature(Class<?>[] paramTypes, Class<?> retType) {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append('(');
        if (paramTypes != null) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramTypes[i] == null) continue;
                sbuf.append(SerialUIDGenerator.getClassSignature(paramTypes[i]));
            }
        }
        sbuf.append(')');
        sbuf.append(SerialUIDGenerator.getClassSignature(retType));
        return sbuf.toString();
    }

    private static String getMethodSignature(String[] paramTypes, Class<?> retType) {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append('(');
        if (paramTypes != null) {
            for (int i = 0; i < paramTypes.length; ++i) {
                sbuf.append(SerialUIDGenerator.getClassSignature(paramTypes[i]));
            }
        }
        sbuf.append(')');
        sbuf.append(SerialUIDGenerator.getClassSignature(retType));
        return sbuf.toString();
    }

    private static String getMethodSignature(Class<?>[] paramTypes, String retType) {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append('(');
        if (paramTypes != null) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramTypes[i] == null) continue;
                sbuf.append(SerialUIDGenerator.getClassSignature(paramTypes[i]));
            }
        }
        sbuf.append(')');
        sbuf.append(SerialUIDGenerator.getClassSignature(retType));
        return sbuf.toString();
    }

    private static class MemberInfo {
        public final String name;
        public final String signature;

        public MemberInfo(FtlField field) {
            this.name = field.getName();
            this.signature = field.getType() != null ? SerialUIDGenerator.getClassSignature(field.getType()) : SerialUIDGenerator.getClassSignature(field.getSecType());
        }

        public MemberInfo(String constructorName) {
            this.name = constructorName;
            this.signature = SerialUIDGenerator.getMethodSignature(new Class[]{null}, Void.TYPE);
        }

        public MemberInfo(FtlMethod meth) {
            this.name = meth.getName();
            this.signature = meth.getParameterTypes() == null ? SerialUIDGenerator.getMethodSignature(meth.getSecParameterTypes(), meth.getReturnType()) : (meth.getReturnType() == null ? SerialUIDGenerator.getMethodSignature(meth.getParameterTypes(), meth.getSecReturnType()) : SerialUIDGenerator.getMethodSignature(meth.getParameterTypes(), meth.getReturnType()));
        }
    }
}

