/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sdktool.ftl;

import com.yqbsoft.laser.service.sdktool.ftl.FtlField;
import com.yqbsoft.laser.service.sdktool.ftl.FtlMethod;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class StringUtil {
    private static String default_pattern = "yyyy-MM-dd HH:mm:ss";
    private static SimpleDateFormat sdf = new SimpleDateFormat(default_pattern);

    public static String getSetter(String fieldName) {
        if (fieldName == null || "".equals(fieldName.trim())) {
            return null;
        }
        return "set" + fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(1);
    }

    public static String getGetter(String fieldName, Class<?> cls) {
        if (fieldName == null || "".equals(fieldName.trim())) {
            return null;
        }
        String prevStr = "get";
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            prevStr = "is";
        }
        return prevStr + fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(1);
    }

    public static String getRequestNameByApi(String apiMethodName) {
        if (apiMethodName == null || apiMethodName.trim().equals("")) {
            return null;
        }
        String name = apiMethodName.substring(apiMethodName.lastIndexOf(".") + 1);
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    public static List<FtlMethod> getMethodsByFieldsMap(Map<String, FtlField> fields) {
        ArrayList<FtlMethod> methods = null;
        if (fields != null && fields.size() > 0) {
            methods = new ArrayList<FtlMethod>();
            for (Map.Entry<String, FtlField> entry : fields.entrySet()) {
                methods.add(entry.getValue().getGetter());
                methods.add(entry.getValue().getSetter());
            }
            return methods;
        }
        return null;
    }

    public static Class<?> getClassByType(String type, String secType) {
        if (type.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (type.equals("byte")) {
            return Byte.TYPE;
        }
        if (type.equals("char")) {
            return Character.TYPE;
        }
        if (type.equals("short")) {
            return Short.TYPE;
        }
        if (type.equals("int")) {
            return Integer.TYPE;
        }
        if (type.equals("long")) {
            return Long.TYPE;
        }
        if (type.equals("float")) {
            return Float.TYPE;
        }
        if (type.equals("[B")) {
            return byte[].class;
        }
        if (type.equals("String")) {
            return String.class;
        }
        if (type.equals("Byte")) {
            return Byte.class;
        }
        if (type.equals("Short")) {
            return Short.class;
        }
        if (type.equals("Integer")) {
            return Integer.class;
        }
        if (type.equals("Long")) {
            return Long.class;
        }
        if (type.equals("Float")) {
            return Float.class;
        }
        if (type.equals("Double")) {
            return Double.class;
        }
        if (type.equals("Character")) {
            return Character.class;
        }
        if (type.equals("Boolean")) {
            return Boolean.class;
        }
        if (type.equals("Number")) {
            return Number.class;
        }
        if (type.equals("Object") || type.equals("java.lang.Object")) {
            return Object.class;
        }
        if (type.toLowerCase().indexOf("date") != -1) {
            return Date.class;
        }
        if (type.equals("[L") && secType != null) {
            if (secType.equals("String")) {
                return String[].class;
            }
            if (secType.equals("Byte")) {
                return Byte[].class;
            }
            if (secType.equals("Short")) {
                return Short[].class;
            }
            if (secType.equals("Integer")) {
                return Integer[].class;
            }
            if (secType.equals("Long")) {
                return Long[].class;
            }
            if (secType.equals("Float")) {
                return Float[].class;
            }
            if (secType.equals("Double")) {
                return Double[].class;
            }
            if (secType.equals("Character")) {
                return Character[].class;
            }
            if (secType.equals("Boolean")) {
                return Boolean[].class;
            }
            if (secType.equals("Number")) {
                return Number[].class;
            }
            if (secType.equals("java.lang.Object")) {
                return Object[].class;
            }
            if (secType.equals("java.util.Date")) {
                return Date[].class;
            }
        } else {
            if (type.toLowerCase().indexOf("list") != -1) {
                return List.class;
            }
            if (type.toLowerCase().indexOf("map") != -1) {
                return Map.class;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String src, String des) {
        File srcFile = new File(src);
        File desFile = new File(des);
        byte[] b = new byte[1024];
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            boolean i;
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(desFile, false);
            while (!(i = fis.read(b))) {
                fos.write(b, 0, i ? 1 : 0);
            }
            i = true;
            return i;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean copyFolder(File srcFile, File desFile) {
        if (!srcFile.exists()) {
            return false;
        }
        File[] files = srcFile.listFiles();
        boolean flag = true;
        if (!desFile.exists()) {
            flag &= desFile.mkdirs();
        }
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String path = files[i].getAbsolutePath();
                if (files[i].isDirectory()) {
                    File newFile = new File(desFile.getAbsolutePath() + File.separator + files[i].getName());
                    if (!newFile.exists()) {
                        newFile.mkdirs();
                    }
                    flag &= StringUtil.copyFolder(path, desFile.getAbsolutePath() + File.separator + files[i].getName());
                    continue;
                }
                flag &= StringUtil.copyFile(path, desFile.getAbsolutePath() + File.separator + files[i].getName());
            }
        }
        return flag;
    }

    public static boolean copyFolder(String src, String des) {
        return StringUtil.copyFolder(new File(src), new File(des));
    }

    public static boolean clearFolder(String ... paths) {
        boolean isSuccess = true;
        for (String path : paths) {
            File file = new File(path);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                File[] files;
                for (File f : files = file.listFiles()) {
                    if (f.isDirectory()) {
                        StringUtil.clearFolder(f.getAbsolutePath());
                        continue;
                    }
                    f.delete();
                }
                file.delete();
                continue;
            }
            isSuccess &= file.delete();
        }
        return isSuccess;
    }

    public static String getLibString(String libStr) {
        File[] files;
        if (libStr == null || "".equals(libStr.trim())) {
            return null;
        }
        File file = new File(libStr);
        if (file.exists() && (files = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        })) != null && files.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (File f : files) {
                sb.append(f.getAbsolutePath()).append(";");
            }
            return sb.toString();
        }
        return null;
    }

    public static String getCurrentTime() {
        sdf.applyPattern(default_pattern);
        return sdf.format(new Date());
    }

    public static String getCurrentTime(String pattern) {
        sdf.applyPattern(pattern);
        return sdf.format(new Date());
    }
}

