/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.sdktool.main;

import com.yqbsoft.laser.service.sdktool.compile.CompileTool;
import com.yqbsoft.laser.service.sdktool.compile.ZipTool;
import com.yqbsoft.laser.service.sdktool.ftl.ConstantObject;
import com.yqbsoft.laser.service.sdktool.ftl.DomainObject;
import com.yqbsoft.laser.service.sdktool.ftl.Freemarker;
import com.yqbsoft.laser.service.sdktool.ftl.RequestObject;
import com.yqbsoft.laser.service.sdktool.ftl.StringUtil;
import com.yqbsoft.laser.service.sdktool.main.LaserApiException;
import java.io.File;
import java.util.List;
import java.util.Map;

public class SdkTool {
    private static SdkTool sdkTool;

    private SdkTool() {
    }

    public static SdkTool getInstance() {
        if (sdkTool == null) {
            sdkTool = new SdkTool();
        }
        return sdkTool;
    }

    public String generateSDK(String sdkRootPath, String destRootPath, List<DomainObject> domains, List<RequestObject> apis, ConstantObject constant, int type, Map<String, String> domainClass) throws LaserApiException {
        File srcFile = new File(sdkRootPath);
        File destFile = new File(destRootPath);
        return this.generateSDK(srcFile, destFile, domains, apis, constant, type, domainClass);
    }

    public String generateSDK(String sdkRootPath, String destRootPath, List<DomainObject> domains, List<RequestObject> apis, ConstantObject constant, Map<String, String> domainClass) throws LaserApiException {
        File srcFile = new File(sdkRootPath);
        File destFile = new File(destRootPath);
        return this.generateSDK(srcFile, destFile, domains, apis, constant, domainClass);
    }

    public String generateSDK(File srcFile, File destFile, List<DomainObject> domains, List<RequestObject> apis, ConstantObject constant, Map<String, String> domainClass) throws LaserApiException {
        return this.generateSDK(srcFile, destFile, domains, apis, constant, 3, domainClass);
    }

    public String generateSDK(File srcFile, File destFile, List<DomainObject> domains, List<RequestObject> apis, ConstantObject constant, int type, Map<String, String> domainClass) throws LaserApiException {
        boolean b = true;
        if (!srcFile.exists()) {
            throw new LaserApiException("can't find source folder. path:" + srcFile.getAbsolutePath());
        }
        if (!destFile.exists()) {
            destFile.mkdirs();
            if (!destFile.exists()) {
                throw new LaserApiException("can't mkdir for dest folder. path:" + destFile.getAbsolutePath());
            }
        }
        if (!(b &= StringUtil.copyFolder(srcFile, destFile))) {
            throw new LaserApiException("copy source folder to dest folder failed.");
        }
        Freemarker fmk = new Freemarker();
        fmk.generateSDK(destFile.getAbsolutePath(), domains, apis, constant, domainClass);
        if (!(b &= this.compileJavaFiles(destFile.getAbsolutePath()))) {
            throw new LaserApiException("compile java file failed.");
        }
        return this.zipJavaFiles(destFile.getAbsolutePath(), type);
    }

    private boolean compileJavaFiles(String sdkRootPath) throws LaserApiException {
        return CompileTool.compileAndJar(sdkRootPath);
    }

    private String zipJavaFiles(String sdkRootPath, int type) throws LaserApiException {
        return ZipTool.zipFile(sdkRootPath, type);
    }
}

