/**
 * VFinance.cn Inc.
 * Copyright (c) 2014 All Rights Reserved.
 */
package com.yqbsoft.laser.api.request;

import java.util.Map;
import com.yqbsoft.laser.api.LaserRequest;
import com.yqbsoft.laser.api.internal.util.LaserHashMap;
import com.yqbsoft.laser.api.response.${api.reqName}Response;
<#list api.reqImpCls?keys as cls>
import ${cls};
</#list>

/**
 * <p>${api.apiMethodName} request</p>
 * @author auto create
 * @version $Id: ${api.reqName}Request.java, v ${api.version} ${api.datetime} auto Exp $
 */
public class ${api.reqName}Request extends LaserRequest<${api.reqName}Response> {

    public String apiVersion = "${api.version}";
    private String apiMethodName = "${api.apiMethodName}";
    
    <#list api.reqFields?keys as field>
    /**
     * ${api.reqFields[field].desc}
     */
    private ${api.reqFields[field].simpleName} ${field};
    </#list>
    
    <#list api.reqMethods as method>
    public ${method.returnName} ${method.name}(<#if method.parameterNames != "void">${method.parameterNames} ${method.fieldName}</#if>){
        ${method.body};
    }
    
    </#list>
    /* (non-Javadoc)
     * @see com.laser.api.LaserRequest#getApiMethodName()
     */
    @Override
    public String getApiMethodName() {
        return this.apiMethodName;
    }
    
    /* (non-Javadoc)
     * @see com.laser.api.LaserRequest#getApiVersion()
     */
    @Override
    public String getApiVersion(){
        return this.apiVersion;
    };
    
    /* (non-Javadoc)
     * @see com.laser.api.LaserRequest#getTextParams()
     */
    @Override
    public Map<String, String> getTextParams() {
        LaserHashMap txtParams = new LaserHashMap();
		<#list api.reqFields?keys as field>
		txtParams.put("${field}", ${field});
		</#list>
        if(udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }
    
}
