#!/bin/bash

cd $1
CUR=$(pwd)

## reset dest folder
OUTPUT_PATH=${CUR}/dest
rm -rf $OUTPUT_PATH
mkdir -p ${OUTPUT_PATH}/bin
mkdir -p ${OUTPUT_PATH}/libs

export jfiles=`find src -name "*.java" |xargs|sed "s/ / /g"`

opt="-d $OUTPUT_PATH/bin -encoding utf-8"

javac $opt ${jfiles}
cd ${OUTPUT_PATH}/bin
jar -cvf ${CUR}/dest/$2.jar *
cd ${CUR}/src
jar -cvf ${CUR}/dest/$2-source.jar *
