/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.searchengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.searchengine.domain.AccurateQueryDomain;
import com.yqbsoft.laser.service.searchengine.domain.HighLightFieldDomain;
import com.yqbsoft.laser.service.searchengine.domain.RangeDomain;
import com.yqbsoft.laser.service.searchengine.domain.SearchDomain;
import com.yqbsoft.laser.service.searchengine.domain.SortDomain;
import com.yqbsoft.laser.service.searchengine.domain.StoreDomain;
import com.yqbsoft.laser.service.searchengine.entities.CmsDoclist;
import com.yqbsoft.laser.service.searchengine.entities.EsSku;
import com.yqbsoft.laser.service.searchengine.entities.MmMerber;
import com.yqbsoft.laser.service.searchengine.entities.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.searchengine.enums.BizType;
import com.yqbsoft.laser.service.searchengine.service.SearchengineService;
import com.yqbsoft.laser.service.searchengine.util.EsUtil;
import com.yqbsoft.laser.service.searchengine.util.ObjTools;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.stereotype.Service;

@Service
public class SearchengineServiceImpl
extends BaseServiceImpl
implements SearchengineService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(StoreDomain storeDomain) throws ApiException {
        Client client = null;
        try {
            client = EsUtil.getTransportClient();
            if (storeDomain.getRequestType() != null && !storeDomain.getRequestType().equals("")) {
                String requestType = storeDomain.getRequestType();
                Map<String, String> resultMap = BizType.getInfo(storeDomain.getBizType());
                if (resultMap != null) {
                    if ("insert".equals(requestType)) {
                        BulkRequestBuilder bulkRequest = client.prepareBulk();
                        List list = (List)JsonUtil.buildNonNullBinder().getJsonToList(storeDomain.getStoreObj().toString(), Object.class);
                        for (Map map : list) {
                            XContentBuilder xb = XContentFactory.jsonBuilder().startObject();
                            for (Object key : map.keySet()) {
                                if (map.get(key) == null || map.get(key).equals("")) continue;
                                xb.field((String)key, map.get(key).toString());
                            }
                            xb.endObject();
                            bulkRequest.add(client.prepareIndex(resultMap.get("index"), resultMap.get("indexType"), map.get(resultMap.get("id")).toString()).setSource(xb));
                        }
                        BulkResponse bulkResponse = (BulkResponse)bulkRequest.execute().get();
                        if (bulkResponse.hasFailures()) {
                            System.err.println("");
                        }
                    }
                    if (requestType.equals("update")) {
                        // empty if block
                    }
                    if (requestType.equals("delete")) {
                        if (storeDomain.getStoreObj() instanceof List) {
                            List objList = (List)storeDomain.getStoreObj();
                            for (Object object : objList) {
                                client.prepareDelete(resultMap.get("index"), resultMap.get("indexType"), object.toString()).execute().get();
                            }
                        } else {
                            client.prepareDelete(resultMap.get("index"), resultMap.get("indexType"), storeDomain.getStoreObj().toString()).execute().get();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            EsUtil.close(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Object find(SearchDomain searchDomain) throws ApiException {
        block34: {
            Client client;
            block32: {
                HashMap<String, Cloneable> hashMap;
                HashMap<String, Cloneable> resmap;
                block33: {
                    client = null;
                    if (searchDomain.getBizType() == null || searchDomain.equals("")) break block32;
                    resmap = new HashMap<String, Cloneable>();
                    if (!searchDomain.getBizType().equals("0")) break block33;
                    client = EsUtil.getTransportClient();
                    ArrayList<String> querylist = new ArrayList<String>();
                    querylist.add("sku");
                    querylist.add("Goods");
                    querylist.add("Demand");
                    querylist.add("Merber");
                    querylist.add("Doc");
                    for (String entity : querylist) {
                        Object object = null;
                        ArrayList<Map> resultlist = new ArrayList<Map>();
                        if (entity.equals("Goods")) {
                            object = new RsResourceGoodsDomain();
                        }
                        if (entity.equals("Demand")) {
                            object = new RsResourceGoodsDomain();
                        }
                        if (entity.equals("Merber")) {
                            object = new MmMerber();
                        }
                        if (entity.equals("Doc")) {
                            object = new CmsDoclist();
                        }
                        if (entity.equals("sku")) {
                            object = new EsSku();
                        }
                        Map<Object, Object> fullTextQueryMaps = ObjTools.getFiledsInfo(object).get(0);
                        Map<String, String> resultMap = BizType.getInfo(entity);
                        BoolQueryBuilder bb = QueryBuilders.boolQuery();
                        SearchRequestBuilder searchRequestBuilder = null;
                        for (Object key : fullTextQueryMaps.keySet()) {
                            if (key.toString().indexOf("id") > 0) continue;
                            bb = bb.should((QueryBuilder)QueryBuilders.matchQuery((String)key.toString(), (Object)searchDomain.getSearchObj().toString()));
                        }
                        searchRequestBuilder = client.prepareSearch(new String[]{resultMap.get("index")}).setTypes(new String[]{resultMap.get("indexType")}).setSearchType(SearchType.DFS_QUERY_AND_FETCH).setQuery((QueryBuilder)bb).setFrom(0).setSize(10).setExplain(true);
                        if (fullTextQueryMaps != null && fullTextQueryMaps.size() > 0) {
                            for (Object key : fullTextQueryMaps.keySet()) {
                                searchRequestBuilder.addHighlightedField(key.toString());
                            }
                            searchRequestBuilder.setHighlighterEncoder("UTF-8").setHighlighterPreTags(new String[]{"<font style=\"color:red\">"}).setHighlighterPostTags(new String[]{"</font>"});
                        }
                        SearchResponse response = (SearchResponse)searchRequestBuilder.execute().actionGet();
                        SearchHits hits = response.getHits();
                        for (SearchHit hit : hits) {
                            Map result = hit.highlightFields();
                            for (Object key : fullTextQueryMaps.keySet()) {
                                HighlightField titleField = (HighlightField)result.get(key);
                                if (titleField == null) continue;
                                Text[] titleTexts = titleField.fragments();
                                String value = "";
                                for (Text text : titleTexts) {
                                    value = value + text;
                                }
                                hit.getSource().put(key.toString(), value);
                            }
                            resultlist.add(hit.getSource());
                        }
                        long count = ((CountResponse)client.prepareCount(new String[]{resultMap.get("index")}).setTypes(new String[]{resultMap.get("indexType")}).setQuery((QueryBuilder)bb).execute().actionGet()).getCount();
                        HashMap<String, ArrayList<Map>> serachMap = new HashMap<String, ArrayList<Map>>();
                        serachMap.put(String.valueOf(count), resultlist);
                        resmap.put(entity, serachMap);
                    }
                    HashMap<String, Cloneable> i$ = resmap;
                    EsUtil.close(client);
                    return i$;
                }
                try {
                    Map<String, String> resultMap = BizType.getInfo(searchDomain.getBizType());
                    if (resultMap == null || resultMap.size() <= 0) break block32;
                    client = EsUtil.getTransportClient();
                    BoolQueryBuilder bb = QueryBuilders.boolQuery();
                    if (searchDomain.getSearchObj() != null && !searchDomain.getSearchObj().equals("") && !searchDomain.getSearchObj().equals("null")) {
                        EsSku object = null;
                        if (searchDomain.getBizType().equals("sku")) {
                            object = new EsSku();
                        }
                        Map<Object, Object> fullTextQueryMaps = ObjTools.getFiledsInfo(object).get(0);
                        for (Object key : fullTextQueryMaps.keySet()) {
                            bb = bb.should((QueryBuilder)QueryBuilders.matchQuery((String)((String)key), (Object)searchDomain.getSearchObj()));
                        }
                    }
                    BoolQueryBuilder bb1 = QueryBuilders.boolQuery();
                    if (searchDomain.getAccurateQueryList() != null && searchDomain.getAccurateQueryList().size() > 0) {
                        bb1 = bb1.must((QueryBuilder)bb);
                        List<AccurateQueryDomain> accurateQueryList = searchDomain.getAccurateQueryList();
                        for (AccurateQueryDomain accurateQueryDomain : accurateQueryList) {
                            bb1 = bb1.must((QueryBuilder)QueryBuilders.termQuery((String)accurateQueryDomain.getAccurateField(), (String)accurateQueryDomain.getAccurateFieldValue()));
                        }
                        bb = bb1;
                    }
                    if (searchDomain.getRangeList() != null && searchDomain.getRangeList().size() > 0) {
                        List<RangeDomain> rangeList = searchDomain.getRangeList();
                        for (RangeDomain rangeDomain : rangeList) {
                            bb.must((QueryBuilder)QueryBuilders.rangeQuery((String)StringUtils.trim((String)rangeDomain.getRangeField())).from(StringUtils.trim((String)rangeDomain.getStartIndex())).to(StringUtils.trim((String)rangeDomain.getEndIndex())));
                        }
                    }
                    FieldSortBuilder sortBuilder = null;
                    if (searchDomain.getSortDomain() != null) {
                        SortDomain sortDomain = searchDomain.getSortDomain();
                        sortBuilder = SortBuilders.fieldSort((String)sortDomain.getSortField()).order(StringUtils.trim((String)sortDomain.getOrder()).equalsIgnoreCase("ASC") ? SortOrder.ASC : SortOrder.DESC);
                    }
                    SearchRequestBuilder searchRequestBuilder = null;
                    Map<String, Object> pageMap = searchDomain.getPageMap();
                    if (MapUtil.isEmpty(pageMap)) {
                        pageMap.put("startRow", 0);
                        pageMap.put("endRow", 10);
                    }
                    searchRequestBuilder = sortBuilder == null ? client.prepareSearch(new String[]{resultMap.get("index")}).setTypes(new String[]{resultMap.get("indexType")}).setQuery((QueryBuilder)bb).setFrom(Integer.parseInt(pageMap.get("startRow").toString())).setSize(Integer.parseInt(pageMap.get("endRow").toString())).setExplain(true) : client.prepareSearch(new String[]{resultMap.get("index")}).setTypes(new String[]{resultMap.get("indexType")}).setQuery((QueryBuilder)bb).addSort((SortBuilder)sortBuilder).setFrom(Integer.parseInt(pageMap.get("startRow").toString())).setSize(Integer.parseInt(pageMap.get("endRow").toString())).setExplain(true);
                    List<HighLightFieldDomain> highLightFieldList = null;
                    if (searchDomain.getHighLightFieldList() != null && searchDomain.getHighLightFieldList().size() > 0) {
                        highLightFieldList = searchDomain.getHighLightFieldList();
                        for (HighLightFieldDomain highLightFieldDomain : highLightFieldList) {
                            searchRequestBuilder.addHighlightedField(highLightFieldDomain.getHighLightField());
                        }
                        searchRequestBuilder.setHighlighterEncoder("UTF-8").setHighlighterPreTags(new String[]{"<span style=\"color:red\">"}).setHighlighterPostTags(new String[]{"</span>"});
                    }
                    SearchResponse response = (SearchResponse)searchRequestBuilder.execute().actionGet();
                    ArrayList<Map> resultlist = new ArrayList<Map>();
                    SearchHits hits = response.getHits();
                    for (SearchHit hit : hits) {
                        Map result = hit.highlightFields();
                        if (highLightFieldList != null && highLightFieldList.size() > 0) {
                            for (HighLightFieldDomain highLightFieldDomain : highLightFieldList) {
                                HighlightField titleField = (HighlightField)result.get(highLightFieldDomain.getHighLightField());
                                if (titleField == null) continue;
                                Text[] titleTexts = titleField.fragments();
                                String value = "";
                                for (Text text : titleTexts) {
                                    value = value + text;
                                }
                                hit.getSource().put(highLightFieldDomain.getHighLightField(), value);
                            }
                        }
                        resultlist.add(hit.getSource());
                    }
                    long count = ((CountResponse)client.prepareCount(new String[]{resultMap.get("index")}).setTypes(new String[]{resultMap.get("indexType")}).setQuery((QueryBuilder)bb).execute().actionGet()).getCount();
                    resmap.put(String.valueOf(count), resultlist);
                    hashMap = resmap;
                }
                catch (Exception exception) {
                    EsUtil.close(client);
                    break block34;
                    catch (Throwable throwable) {
                        EsUtil.close(client);
                        throw throwable;
                    }
                }
                EsUtil.close(client);
                return hashMap;
            }
            EsUtil.close(client);
        }
        return null;
    }

    @Override
    public void refresh(SearchDomain searchDomain) throws ApiException {
        if (StringUtils.isNotBlank((CharSequence)searchDomain.getBizType())) {
            this.deleteAll(searchDomain.getBizType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll(String type) {
        Client client = null;
        try {
            client = EsUtil.getTransportClient();
            DeleteIndexResponse deleteIndexResponse = (DeleteIndexResponse)client.admin().indices().prepareDelete(new String[]{type}).execute().actionGet();
            System.out.println(deleteIndexResponse.getHeaders());
        }
        catch (UnknownHostException unknownHostException) {
        }
        finally {
            EsUtil.close(client);
        }
    }
}

