/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.searchengine.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.searchengine.domain.AccurateQueryDomain;
import com.yqbsoft.laser.service.searchengine.domain.DataHits;
import com.yqbsoft.laser.service.searchengine.domain.RestBean;
import com.yqbsoft.laser.service.searchengine.domain.ReturnBean;
import com.yqbsoft.laser.service.searchengine.domain.SearchDomain;
import com.yqbsoft.laser.service.searchengine.domain.StoreDomain;
import com.yqbsoft.laser.service.searchengine.index.StoreEnum;
import com.yqbsoft.laser.service.searchengine.service.SearchengineService;
import com.yqbsoft.laser.service.searchengine.util.EsUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class SearchengineServiceImpl
extends BaseServiceImpl
implements SearchengineService {
    public static final String SYS_CODE = "es.SearchengineServiceImpl";

    @Override
    public boolean store(StoreDomain storeDomain) throws ApiException {
        if (null == storeDomain || StringUtils.isBlank((String)storeDomain.getTenantCode()) || StringUtils.isBlank((String)storeDomain.getRequestType())) {
            return false;
        }
        String id = storeDomain.getBizId();
        if (StringUtils.isBlank((String)id)) {
            return false;
        }
        String type = storeDomain.getBizType();
        if (StringUtils.isBlank((String)type)) {
            return false;
        }
        String requestType = storeDomain.getRequestType();
        String method = "";
        String data = storeDomain.getTenantCode();
        if (StoreEnum.INSERT.getType().equals(requestType)) {
            method = "POST";
        } else if (StoreEnum.UPDATE.getType().equals(requestType)) {
            method = "POST";
        } else if (StoreEnum.DELETE.getType().equals(requestType)) {
            method = "DELETE";
        }
        String queryParamJson = "";
        if (null != storeDomain.getStoreObj()) {
            queryParamJson = storeDomain.getStoreObj().toString();
        }
        try {
            EsUtil.httpUrlInsert(queryParamJson, method, data, type, id);
            return true;
        }
        catch (Exception e) {
            this.logger.error("es.SearchengineServiceImpl.store", (Throwable)e);
            return false;
        }
    }

    @Override
    public ReturnBean find(SearchDomain searchDomain) throws ApiException {
        if (null == searchDomain || StringUtils.isBlank((String)searchDomain.getBizType())) {
            this.logger.error("es.SearchengineServiceImpl.find.null", (Object)"null");
            return null;
        }
        String data = searchDomain.getTenantCode();
        if (StringUtils.isBlank((String)data)) {
            this.logger.error("es.SearchengineServiceImpl.find.data", (Object)"data");
            return null;
        }
        Map<String, Object> pageMap = searchDomain.getPageMap();
        Integer rows = 10;
        Integer page = 0;
        if (null != pageMap && !pageMap.isEmpty()) {
            rows = Integer.parseInt(pageMap.get("rows").toString());
            page = Integer.parseInt(pageMap.get("page").toString());
        }
        if (null == rows || rows == 0) {
            rows = 10;
        }
        if (null == page) {
            page = 0;
        }
        int from = Integer.valueOf(page) * Integer.valueOf(rows);
        String queryStr = "";
        String queryJson = "";
        String sortStr = "";
        sortStr = null != searchDomain.getSortDomain() ? "\"sort\": { \"" + searchDomain.getSortDomain().getSortField() + "\": { \"order\": \"" + searchDomain.getSortDomain().getOrder() + "\" }}" : "\"sort\": { \"skuId\": { \"order\": \"desc\" }}";
        if (null != searchDomain.getBoolMap() && !searchDomain.getBoolMap().isEmpty()) {
            for (String key : searchDomain.getBoolMap().keySet()) {
                if (StringUtils.isNotBlank((String)queryStr)) {
                    queryStr = queryStr + ",";
                }
                queryStr = queryStr + "{\"match\": { \"" + key + "\":\"" + searchDomain.getBoolMap().get(key) + "\"}}";
            }
            queryJson = "{\"query\":{\"bool\":{\"should\":[" + queryStr + "]}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + "}";
        }
        String accqueryStr = "";
        if (null != searchDomain.getAccurateQueryList() && !searchDomain.getAccurateQueryList().isEmpty()) {
            for (AccurateQueryDomain accurateQueryDomain : searchDomain.getAccurateQueryList()) {
                if (StringUtils.isNotBlank((String)accqueryStr)) {
                    accqueryStr = accqueryStr + ",";
                }
                accqueryStr = accqueryStr + "\"" + accurateQueryDomain.getAccurateField() + "\":\"" + accurateQueryDomain.getAccurateFieldValue() + "\"";
            }
            queryJson = "{\"query\":{\"term\":{" + accqueryStr + "}},\"from\":\"" + from + "\",\"size\":\"" + rows + "\"," + sortStr + "}";
        }
        this.logger.info("queryJson========", (Object)queryJson);
        try {
            String str = EsUtil.httpUrlGet(data, searchDomain.getBizType(), queryJson);
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            RestBean restBean = (RestBean)JsonUtil.buildNormalBinder().getJsonToObject(str, RestBean.class);
            if (null == restBean || null == restBean.getHits() || null == restBean.getHits().getHits()) {
                return null;
            }
            ReturnBean returnBean = new ReturnBean();
            List<DataHits> list = restBean.getHits().getHits();
            if (null == list || list.isEmpty()) {
                return null;
            }
            ArrayList<Map<String, Object>> sourcelist = new ArrayList<Map<String, Object>>();
            for (DataHits dataHits : list) {
                sourcelist.add(dataHits.get_source());
            }
            returnBean.setSourcelist(sourcelist);
            returnBean.setCount(restBean.getHits().getTotal());
            returnBean.setPage(page);
            returnBean.setRow(rows);
            return returnBean;
        }
        catch (IOException e) {
            this.logger.error("es.SearchengineServiceImpl.find.e", (Throwable)e);
            return null;
        }
    }

    @Override
    public void refresh(SearchDomain searchDomain) throws ApiException {
    }

    public void deleteAll(String type) {
    }
}

